/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.net;

import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UErrorCode;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UTimedDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class BrokerHandler {
    private static int TIMEOUT_UNIT = 1000;
    private static byte[] PING_INFO = new byte[]{80, 73, 78, 71, 0, 0, 0, 0, 0, 0};
    private static byte[] CANCEL_INFO = new byte[]{67, 65, 78, 67, 69, 76};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Socket connectBroker(String string, int n, int n2) throws IOException, UJciException {
        Socket socket = null;
        UTimedDataInputStream uTimedDataInputStream = null;
        DataOutputStream dataOutputStream = null;
        long l = System.currentTimeMillis();
        try {
            socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (n2 <= 0) {
                socket.connect(inetSocketAddress);
            } else {
                socket.connect(inetSocketAddress, n2);
                n2 = (int)((long)n2 - (System.currentTimeMillis() - l));
                if (n2 <= 0) {
                    socket.close();
                    throw new UJciException(24);
                }
            }
            socket.setSoTimeout(TIMEOUT_UNIT);
            uTimedDataInputStream = new UTimedDataInputStream(socket.getInputStream(), string, n, n2);
            dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.write(UConnection.driverInfo);
            dataOutputStream.flush();
            int n3 = uTimedDataInputStream.readInt();
            if (n3 < 0) {
                int n4 = uTimedDataInputStream.readInt();
                throw new UJciException(2, n3, n4, null);
            }
            if (n3 == 0) {
                return socket;
            }
            socket.setSoLinger(true, 0);
            socket.close();
            socket = new Socket();
            inetSocketAddress = new InetSocketAddress(string, n3);
            if (n2 <= 0) {
                socket.connect(inetSocketAddress);
                return socket;
            } else {
                if ((n2 = (int)((long)n2 - (System.currentTimeMillis() - l))) <= 0) {
                    throw new UJciException(24);
                }
                socket.connect(inetSocketAddress, n2);
            }
            return socket;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (socket == null) throw new UJciException(24, (Throwable)socketTimeoutException);
            socket.close();
            throw new UJciException(24, (Throwable)socketTimeoutException);
        }
        catch (IOException iOException) {
            if (socket == null) throw new UJciException(13, (Throwable)iOException);
            socket.close();
            throw new UJciException(13, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pingBroker(String string, int n, int n2) throws IOException {
        Socket socket = null;
        FilterInputStream filterInputStream = null;
        FilterOutputStream filterOutputStream = null;
        long l = System.currentTimeMillis();
        try {
            socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (n2 <= 0) {
                socket.connect(inetSocketAddress);
            } else {
                socket.connect(inetSocketAddress, n2);
                n2 = (int)((long)n2 - (System.currentTimeMillis() - l));
                if (n2 <= 0) {
                    String string2 = UErrorCode.codeToMessage(24);
                    throw new SocketTimeoutException(string2);
                }
                socket.setSoTimeout(n2);
            }
            filterInputStream = new DataInputStream(socket.getInputStream());
            filterOutputStream = new DataOutputStream(socket.getOutputStream());
            filterOutputStream.write(PING_INFO);
            ((DataOutputStream)filterOutputStream).flush();
            ((DataInputStream)filterInputStream).readInt();
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static void cancelBroker(String string, int n, int n2, int n3) throws IOException, UJciException {
        Socket socket = null;
        FilterInputStream filterInputStream = null;
        FilterOutputStream filterOutputStream = null;
        long l = System.currentTimeMillis();
        try {
            socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (n3 <= 0) {
                socket.connect(inetSocketAddress);
            } else {
                socket.connect(inetSocketAddress, n3);
                n3 = (int)((long)n3 - (System.currentTimeMillis() - l));
                if (n3 <= 0) {
                    throw new UJciException(24);
                }
                socket.setSoTimeout(n3);
            }
            filterInputStream = new DataInputStream(socket.getInputStream());
            filterOutputStream = new DataOutputStream(socket.getOutputStream());
            filterOutputStream.write(CANCEL_INFO);
            ((DataOutputStream)filterOutputStream).writeInt(n2);
            ((DataOutputStream)filterOutputStream).flush();
            int n4 = ((DataInputStream)filterInputStream).readInt();
            if (n4 < 0) {
                throw new UJciException(-1019);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new UJciException(24);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }
}

