/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UJCIUtil;

public class UColumnInfo {
    private byte type;
    private byte collectionBaseType;
    private short scale;
    private int precision;
    private String name;
    private String className;
    private String attributeName;
    private boolean isNullable;
    private String defaultValue;
    private byte is_auto_increment;
    private byte is_unique_key;
    private byte is_primary_key;
    private byte is_foreign_key;
    private byte is_reverse_index;
    private byte is_reverse_unique;
    private byte is_shared;

    UColumnInfo(byte by, short s, int n, String string) {
        byte[] byArray = UColumnInfo.confirmType(by);
        this.type = byArray[0];
        this.collectionBaseType = byArray[1];
        this.scale = s;
        this.precision = n;
        this.name = string;
        this.className = null;
        this.attributeName = null;
        this.isNullable = false;
        this.defaultValue = null;
        this.is_auto_increment = 0;
        this.is_unique_key = 0;
        this.is_primary_key = 0;
        this.is_foreign_key = 0;
        this.is_reverse_index = 0;
        this.is_reverse_unique = 0;
        this.is_shared = 0;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public byte getIsAutoIncrement() {
        return this.is_auto_increment;
    }

    public byte getIsUniqueKey() {
        return this.is_unique_key;
    }

    public byte getIsPrimaryKey() {
        return this.is_primary_key;
    }

    public byte getIsForeignKey() {
        return this.is_foreign_key;
    }

    public byte getIsReverseIndex() {
        return this.is_reverse_index;
    }

    public byte getIsReverseUnique() {
        return this.is_reverse_unique;
    }

    public byte getIsShared() {
        return this.is_shared;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getClassName() {
        return this.className;
    }

    public int getCollectionBaseType() {
        return this.collectionBaseType;
    }

    public String getColumnName() {
        return this.name;
    }

    public int getColumnPrecision() {
        return this.precision;
    }

    public int getColumnScale() {
        return this.scale;
    }

    public byte getColumnType() {
        return this.type;
    }

    public String getFQDN() {
        return this.findFQDN(this.type, this.precision, this.collectionBaseType);
    }

    public String getRealColumnName() {
        return this.attributeName;
    }

    static byte[] confirmType(byte by) {
        int n = 0;
        byte[] byArray = new byte[2];
        n = by & 0x60;
        switch (n) {
            case 0: {
                byArray[0] = by;
                byArray[1] = -1;
                return byArray;
            }
            case 32: {
                byArray[0] = 16;
                byArray[1] = (byte)(by & 0x1F);
                return byArray;
            }
            case 64: {
                byArray[0] = 17;
                byArray[1] = (byte)(by & 0x1F);
                return byArray;
            }
            case 96: {
                byArray[0] = 18;
                byArray[1] = (byte)(by & 0x1F);
                return byArray;
            }
        }
        byArray[0] = 0;
        byArray[1] = -1;
        return byArray;
    }

    synchronized void setRemainedData(String string, String string2, boolean bl) {
        this.attributeName = string;
        this.className = string2;
        this.isNullable = bl;
    }

    synchronized void setExtraData(String string, byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7) {
        this.defaultValue = string;
        this.is_auto_increment = by;
        this.is_unique_key = by2;
        this.is_primary_key = by3;
        this.is_foreign_key = by4;
        this.is_reverse_index = by5;
        this.is_reverse_unique = by6;
        this.is_shared = by7;
    }

    private String findFQDN(byte by, int n, byte by2) {
        switch (by) {
            case 0: {
                return "null";
            }
            case 5: {
                return n == 8 ? "java.lang.Boolean" : "byte[]";
            }
            case 6: {
                return "byte[]";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "java.lang.String";
            }
            case 7: {
                if (UJCIUtil.isMysqlMode(this.getClass())) {
                    return "java.math.BigDecimal";
                }
                return "java.lang.Double";
            }
            case 9: {
                return "java.lang.Short";
            }
            case 8: {
                return "java.lang.Integer";
            }
            case 21: {
                return "java.lang.Long";
            }
            case 11: {
                return "java.lang.Float";
            }
            case 10: 
            case 12: {
                return "java.lang.Double";
            }
            case 13: {
                return "java.sql.Date";
            }
            case 14: {
                return "java.sql.Time";
            }
            case 15: 
            case 22: {
                return "java.sql.Timestamp";
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                return "cubrid.sql.CUBRIDOID";
            }
            case 23: {
                return "java.sql.Blob";
            }
            case 24: {
                return "java.sql.Clob";
            }
            default: {
                return "";
            }
        }
        switch (by2) {
            case 0: {
                return "null";
            }
            case 5: {
                return n == 8 ? "java.lang.Boolean[]" : "byte[][]";
            }
            case 6: {
                return "byte[][]";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "java.lang.String[]";
            }
            case 7: {
                return "java.lang.Double[]";
            }
            case 9: {
                return "java.lang.Short[]";
            }
            case 8: {
                return "java.lang.Integer[]";
            }
            case 21: {
                return "java.lang.Long[]";
            }
            case 11: {
                return "java.lang.Float[]";
            }
            case 10: 
            case 12: {
                return "java.lang.Double[]";
            }
            case 13: {
                return "java.sql.Date[]";
            }
            case 14: {
                return "java.sql.Time[]";
            }
            case 15: 
            case 22: {
                return "java.sql.Timestamp[]";
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                return "cubrid.sql.CUBRIDOID[]";
            }
            case 23: {
                return "java.sql.Blob[]";
            }
            case 24: {
                return "java.sql.Clob[]";
            }
        }
        return null;
    }
}

