/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UErrorCode;
import cubrid.jdbc.net.BrokerHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class UTimedDataInputStream {
    public static final int PING_TIMEOUT = 5000;
    private DataInputStream stream = null;
    private String ip = null;
    private int port = 0;
    private int timeout = 0;

    public UTimedDataInputStream(InputStream inputStream, String string, int n) {
        this(inputStream, string, n, 0);
    }

    public UTimedDataInputStream(InputStream inputStream, String string, int n, int n2) {
        this.stream = new DataInputStream(inputStream);
        this.ip = string;
        this.port = n;
        this.timeout = n2;
    }

    public int readInt(int n) throws IOException {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                return this.stream.readInt();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                if (n <= 0 || (long)n - (System.currentTimeMillis() - l) > 0L) continue;
                String string = UErrorCode.codeToMessage(24);
                throw new SocketTimeoutException(string);
            }
            break;
        }
    }

    public int readInt() throws IOException {
        return this.readInt(this.timeout);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, this.timeout);
    }

    public void readFully(byte[] byArray, int n) throws IOException {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                this.stream.readFully(byArray);
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                if (n <= 0 || (long)n - (System.currentTimeMillis() - l) > 0L) continue;
                String string = UErrorCode.codeToMessage(24);
                throw new SocketTimeoutException(string);
            }
            break;
        }
    }

    public int readByte(byte[] byArray, int n) throws IOException {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                return this.stream.read(byArray);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                if (n <= 0 || (long)n - (System.currentTimeMillis() - l) > 0L) continue;
                String string = UErrorCode.codeToMessage(24);
                throw new SocketTimeoutException(string);
            }
            break;
        }
    }

    public int readByte(byte[] byArray) throws IOException {
        return this.readByte(byArray, this.timeout);
    }

    public int read(byte[] byArray, int n, int n2, int n3) throws IOException {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                return this.stream.read(byArray, n, n2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                if (n3 <= 0 || (long)n3 - (System.currentTimeMillis() - l) > 0L) continue;
                String string = UErrorCode.codeToMessage(24);
                throw new SocketTimeoutException(string);
            }
            break;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, n2, this.timeout);
    }
}

