/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetWithoutQuery;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UJCIUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDResultSetMetaData
implements ResultSetMetaData {
    private String[] col_name;
    private int[] col_type;
    private int[] ele_type;
    private String[] col_type_name;
    private String[] ele_type_name;
    private int[] col_prec;
    private int[] col_disp_size;
    private int[] col_scale;
    private String[] col_table;
    private int[] col_null;
    private String[] col_class_name;

    protected CUBRIDResultSetMetaData(UColumnInfo[] uColumnInfoArray) {
        this.col_name = new String[uColumnInfoArray.length];
        this.col_type = new int[uColumnInfoArray.length];
        this.ele_type = new int[uColumnInfoArray.length];
        this.col_type_name = new String[uColumnInfoArray.length];
        this.ele_type_name = new String[uColumnInfoArray.length];
        this.col_prec = new int[uColumnInfoArray.length];
        this.col_disp_size = new int[uColumnInfoArray.length];
        this.col_scale = new int[uColumnInfoArray.length];
        this.col_table = new String[uColumnInfoArray.length];
        this.col_null = new int[uColumnInfoArray.length];
        this.col_class_name = new String[uColumnInfoArray.length];
        block50: for (int i = 0; i < uColumnInfoArray.length; ++i) {
            this.col_disp_size[i] = this.getDefaultColumnDisplaySize(uColumnInfoArray[i].getColumnType());
            this.col_name[i] = uColumnInfoArray[i].getColumnName();
            this.col_prec[i] = uColumnInfoArray[i].getColumnPrecision();
            this.col_scale[i] = uColumnInfoArray[i].getColumnScale();
            this.col_table[i] = uColumnInfoArray[i].getClassName();
            this.col_type_name[i] = null;
            this.col_class_name[i] = uColumnInfoArray[i].getFQDN();
            this.col_null[i] = uColumnInfoArray[i].isNullable() ? 1 : 0;
            switch (uColumnInfoArray[i].getColumnType()) {
                case 1: {
                    this.col_type_name[i] = "CHAR";
                    this.col_type[i] = 1;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block50;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block50;
                }
                case 2: {
                    this.col_type_name[i] = "VARCHAR";
                    this.col_type[i] = 12;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block50;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block50;
                }
                case 5: {
                    if (this.col_prec[i] == 8) {
                        this.col_type_name[i] = "BIT";
                        this.col_type[i] = -7;
                        this.ele_type[i] = -1;
                    } else {
                        this.col_type_name[i] = "BIT";
                        this.col_type[i] = -2;
                        this.ele_type[i] = -1;
                    }
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block50;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block50;
                }
                case 6: {
                    this.col_type_name[i] = "BIT VARYING";
                    this.col_type[i] = -3;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block50;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block50;
                }
                case 9: {
                    if (UJCIUtil.isMysqlMode(this.getClass())) {
                        this.col_disp_size[i] = this.col_prec[i];
                    }
                    this.col_type_name[i] = "SMALLINT";
                    this.col_type[i] = 5;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 8: {
                    if (UJCIUtil.isMysqlMode(this.getClass())) {
                        this.col_type_name[i] = "INT";
                        this.col_disp_size[i] = this.col_prec[i];
                    } else {
                        this.col_type_name[i] = "INTEGER";
                    }
                    this.col_type[i] = 4;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 21: {
                    this.col_type_name[i] = "BIGINT";
                    this.col_type[i] = -5;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 11: {
                    this.col_type_name[i] = "FLOAT";
                    this.col_type[i] = 7;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 12: {
                    this.col_type_name[i] = "DOUBLE";
                    this.col_type[i] = 8;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 7: {
                    if (UJCIUtil.isMysqlMode(this.getClass())) {
                        this.col_type_name[i] = "DECIMAL";
                        this.col_type[i] = 3;
                        this.col_disp_size[i] = this.col_prec[i] + 1;
                        if (this.col_scale[i] > 0) {
                            int n = i;
                            this.col_disp_size[n] = this.col_disp_size[n] + 1;
                        }
                        this.ele_type[i] = -1;
                        continue block50;
                    }
                    this.col_type_name[i] = "NUMERIC";
                    this.col_type[i] = 2;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 10: {
                    this.col_type_name[i] = "MONETARY";
                    this.col_type[i] = 8;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 13: {
                    this.col_type_name[i] = "DATE";
                    this.col_type[i] = 91;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 14: {
                    this.col_type_name[i] = "TIME";
                    this.col_type[i] = 92;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 15: {
                    this.col_type_name[i] = "TIMESTAMP";
                    this.col_type[i] = 93;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 22: {
                    this.col_type_name[i] = "DATETIME";
                    this.col_type[i] = 93;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 0: {
                    this.col_type_name[i] = "";
                    this.col_type[i] = 1111;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 19: {
                    this.col_type_name[i] = "CLASS";
                    this.col_type[i] = 1111;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 16: {
                    this.col_type_name[i] = "SET";
                }
                case 17: {
                    if (this.col_type_name[i] == null) {
                        this.col_type_name[i] = "MULTISET";
                    }
                }
                case 18: {
                    if (this.col_type_name[i] == null) {
                        this.col_type_name[i] = "SEQUENCE";
                    }
                    this.col_type[i] = 1111;
                    switch (uColumnInfoArray[i].getCollectionBaseType()) {
                        case 1: {
                            this.ele_type[i] = 1;
                            this.ele_type_name[i] = "CHAR";
                            continue block50;
                        }
                        case 2: {
                            this.ele_type[i] = 12;
                            this.ele_type_name[i] = "VARCHAR";
                            continue block50;
                        }
                        case 5: {
                            if (uColumnInfoArray[i].getColumnPrecision() == 8) {
                                this.ele_type[i] = -7;
                                this.ele_type_name[i] = "BIT";
                                continue block50;
                            }
                            this.ele_type[i] = -2;
                            this.ele_type_name[i] = "BIT";
                            continue block50;
                        }
                        case 6: {
                            this.ele_type[i] = -3;
                            this.ele_type_name[i] = "BIT VARYING";
                            continue block50;
                        }
                        case 9: {
                            this.ele_type[i] = 5;
                            this.ele_type_name[i] = "SMALLINT";
                            continue block50;
                        }
                        case 8: {
                            this.ele_type[i] = 4;
                            this.ele_type_name[i] = "INTEGER";
                            continue block50;
                        }
                        case 21: {
                            this.ele_type[i] = -5;
                            this.ele_type_name[i] = "BIGINT";
                            continue block50;
                        }
                        case 11: {
                            this.ele_type[i] = 7;
                            this.ele_type_name[i] = "FLOAT";
                            continue block50;
                        }
                        case 12: {
                            this.ele_type[i] = 8;
                            this.ele_type_name[i] = "DOUBLE";
                            continue block50;
                        }
                        case 7: {
                            this.ele_type[i] = 2;
                            this.ele_type_name[i] = "NUMERIC";
                            continue block50;
                        }
                        case 10: {
                            this.ele_type[i] = 8;
                            this.ele_type_name[i] = "MONETARY";
                            continue block50;
                        }
                        case 13: {
                            this.ele_type[i] = 91;
                            this.ele_type_name[i] = "DATE";
                            continue block50;
                        }
                        case 14: {
                            this.ele_type[i] = 92;
                            this.ele_type_name[i] = "TIME";
                            continue block50;
                        }
                        case 15: {
                            this.ele_type[i] = 93;
                            this.ele_type_name[i] = "TIMESTAMP";
                            continue block50;
                        }
                        case 22: {
                            this.ele_type[i] = 93;
                            this.ele_type_name[i] = "DATETIME";
                            continue block50;
                        }
                        case 0: {
                            this.ele_type[i] = 0;
                            this.ele_type_name[i] = "";
                            continue block50;
                        }
                        case 19: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "CLASS";
                            continue block50;
                        }
                        case 16: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "SET";
                            continue block50;
                        }
                        case 17: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "MULTISET";
                            continue block50;
                        }
                        case 18: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "SEQUENCE";
                            continue block50;
                        }
                        case 3: {
                            this.ele_type[i] = 1;
                            this.ele_type_name[i] = "NCHAR";
                            continue block50;
                        }
                        case 4: {
                            this.ele_type[i] = 12;
                            this.ele_type_name[i] = "NCHAR VARYING";
                            continue block50;
                        }
                    }
                    continue block50;
                }
                case 3: {
                    this.col_type_name[i] = "NCHAR";
                    this.col_type[i] = 1;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block50;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block50;
                }
                case 4: {
                    this.col_type_name[i] = "NCHAR VARYING";
                    this.col_type[i] = 12;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block50;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block50;
                }
                case 23: {
                    this.col_type_name[i] = "BLOB";
                    this.col_type[i] = 2004;
                    this.ele_type[i] = -1;
                    continue block50;
                }
                case 24: {
                    this.col_type_name[i] = "CLOB";
                    this.col_type[i] = 2005;
                    this.ele_type[i] = -1;
                    continue block50;
                }
            }
        }
    }

    CUBRIDResultSetMetaData(CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery) {
        this.col_name = cUBRIDResultSetWithoutQuery.column_name;
        this.col_type = new int[this.col_name.length];
        this.ele_type = new int[this.col_name.length];
        this.col_type_name = new String[this.col_name.length];
        this.col_prec = new int[this.col_name.length];
        this.col_disp_size = new int[this.col_name.length];
        this.col_scale = new int[this.col_name.length];
        this.col_table = new String[this.col_name.length];
        this.col_null = new int[this.col_name.length];
        this.col_class_name = new String[this.col_name.length];
        for (int i = 0; i < this.col_name.length; ++i) {
            this.col_disp_size[i] = this.getDefaultColumnDisplaySize((byte)cUBRIDResultSetWithoutQuery.type[i]);
            if (cUBRIDResultSetWithoutQuery.type[i] == 5) {
                this.col_type[i] = -7;
                this.col_type_name[i] = "BIT";
                this.col_prec[i] = 1;
                this.col_class_name[i] = "byte[]";
            }
            if (cUBRIDResultSetWithoutQuery.type[i] == 8) {
                this.col_type[i] = 4;
                this.col_type_name[i] = "INTEGER";
                this.col_prec[i] = 10;
                this.col_class_name[i] = "java.lang.Integer";
            }
            if (cUBRIDResultSetWithoutQuery.type[i] == 9) {
                this.col_type[i] = 5;
                this.col_type_name[i] = "SMALLINT";
                this.col_prec[i] = 5;
                this.col_class_name[i] = "java.lang.Short";
            }
            if (cUBRIDResultSetWithoutQuery.type[i] == 2) {
                this.col_type[i] = 12;
                this.col_type_name[i] = "VARCHAR";
                this.col_prec[i] = cUBRIDResultSetWithoutQuery.precision[i];
                if (this.col_prec[i] > this.col_disp_size[i]) {
                    this.col_disp_size[i] = this.col_prec[i];
                }
                this.col_class_name[i] = "java.lang.String";
            }
            if (cUBRIDResultSetWithoutQuery.type[i] == 0) {
                this.col_type[i] = 0;
                this.col_type_name[i] = "";
                this.col_prec[i] = 0;
                this.col_class_name[i] = "";
            }
            this.col_scale[i] = 0;
            this.ele_type[i] = -1;
            this.col_table[i] = "";
            this.col_null[i] = cUBRIDResultSetWithoutQuery.nullable[i] ? 1 : 0;
        }
    }

    private int getDefaultColumnDisplaySize(byte by) {
        int n = -1;
        switch (by) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 5: {
                n = 1;
                break;
            }
            case 6: {
                n = 1;
                break;
            }
            case 9: {
                n = 6;
                break;
            }
            case 8: {
                n = 11;
                break;
            }
            case 21: {
                n = 20;
                break;
            }
            case 11: {
                n = 13;
                break;
            }
            case 12: {
                n = 23;
                break;
            }
            case 7: {
                n = 40;
                break;
            }
            case 10: {
                n = 23;
                break;
            }
            case 13: {
                n = 10;
                break;
            }
            case 14: {
                n = 8;
                break;
            }
            case 15: {
                n = 19;
                break;
            }
            case 22: {
                n = 19;
                break;
            }
            case 0: {
                n = 4;
                break;
            }
            case 19: {
                n = 256;
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                n = -1;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
        }
        return n;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.col_name.length;
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type[n - 1] == 1 || this.col_type[n - 1] == 12 || this.col_type[n - 1] == -1;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (UJCIUtil.isMysqlMode(this.getClass())) {
            return false;
        }
        return this.col_type[n - 1] == 8 || this.col_type[n - 1] == 7 || this.col_type[n - 1] == 2;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_null[n - 1];
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type[n - 1] == 5 || this.col_type[n - 1] == 4 || this.col_type[n - 1] == 2 || this.col_type[n - 1] == 3 || this.col_type[n - 1] == 7 || this.col_type[n - 1] == 8;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_disp_size[n - 1];
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_name[n - 1];
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_prec[n - 1];
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_scale[n - 1];
    }

    @Override
    public String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_table[n - 1];
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type[n - 1];
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type_name[n - 1];
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_class_name[n - 1];
    }

    public int getElementType(int n) throws SQLException {
        this.checkColumnIndex(n);
        String string = this.getColumnTypeName(n);
        if (!(string.equals("SET") || string.equals("MULTISET") || string.equals("SEQUENCE"))) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.not_collection);
        }
        return this.ele_type[n - 1];
    }

    public String getElementTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        String string = this.getColumnTypeName(n);
        if (!(string.equals("SET") || string.equals("MULTISET") || string.equals("SEQUENCE"))) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.not_collection);
        }
        return this.ele_type_name[n - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.col_name.length) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
        }
    }
}

