/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.ConnectionProperties;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJCIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class CUBRIDDriver
implements Driver {
    static final String version_string = "8.4.1.2032";
    public static final int major_version;
    public static final int minor_version;
    public static final int patch_version;
    public static final String default_hostname = "localhost";
    public static final int default_port = 30000;
    public static final String default_user = "public";
    public static final String default_password = "";
    private static final String CUBRID_JDBC_URL_HEADER = "jdbc:cubrid";
    private static final String JDBC_DEFAULT_CONNECTION = "jdbc:default:connection";
    private static PrintStream debugOutput;
    private static Hashtable<String, String> connInfoTable;

    public static void printDebug(String string) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd hh:mm:ss.SSS");
        String string2 = String.format("%s %s", simpleDateFormat.format(timestamp), string);
        debugOutput.println(string2);
    }

    public static void setLastConnectInfo(String string, String string2) {
        if (string != null) {
            connInfoTable.put(string, string2);
            if (UJCIUtil.isConsoleDebug()) {
                CUBRIDDriver.printDebug(String.format("S[K,V]=(%s,%s)", string, string2));
            }
        }
    }

    public static String getLastConnectInfo(String string) {
        String string2 = connInfoTable.get(string);
        if (UJCIUtil.isConsoleDebug()) {
            CUBRIDDriver.printDebug(String.format("G[K,V]=(%s,%s)", string, string2));
        }
        return string2;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        UConnection uConnection;
        String string2;
        int n;
        String string3;
        String string4;
        Object object;
        String string5;
        String string6 = null;
        String string7 = null;
        int n2 = 0;
        if (!this.acceptsURL(string)) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, string);
        }
        if (string.toLowerCase().startsWith(JDBC_DEFAULT_CONNECTION)) {
            return this.defaultConnection();
        }
        try {
            String string8;
            n2 = string.indexOf(63);
            if (n2 != -1) {
                string8 = string.substring(0, n2);
                string5 = string.substring(n2, string.length());
            } else {
                string8 = string;
                string5 = null;
            }
            object = new StringTokenizer(string8, ":", true);
            string4 = ((StringTokenizer)object).nextToken();
            if (string4.equals(":")) {
                throw new Exception("Invalid URL");
            }
            ((StringTokenizer)object).nextToken();
            String string9 = ((StringTokenizer)object).nextToken();
            if (string9.equals(":")) {
                throw new Exception("Invalid URL");
            }
            ((StringTokenizer)object).nextToken();
            string3 = ((StringTokenizer)object).nextToken();
            if (string3.equals(":")) {
                string3 = default_hostname;
            } else {
                ((StringTokenizer)object).nextToken();
            }
            string4 = ((StringTokenizer)object).nextToken();
            if (string4.equals(":")) {
                n = 30000;
            } else {
                n = Integer.parseInt(string4);
                ((StringTokenizer)object).nextToken();
            }
            string2 = ((StringTokenizer)object).nextToken();
            if (string2.equals(":")) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.no_dbname);
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).hasMoreTokens() && (string6 = ((StringTokenizer)object).nextToken()).equals(":")) {
                    string6 = null;
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).hasMoreTokens() && (string7 = ((StringTokenizer)object).nextToken()).equals(":")) {
                    string7 = null;
                }
            }
        }
        catch (CUBRIDException cUBRIDException) {
            throw cUBRIDException;
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, string);
        }
        ConnectionProperties connectionProperties = new ConnectionProperties();
        connectionProperties.setProperties(string5);
        string4 = properties.getProperty("user");
        if (string4 != null) {
            string6 = string4;
        }
        if ((string4 = properties.getProperty("password")) != null) {
            string7 = string4;
        }
        if (string6 == null) {
            string6 = default_user;
        }
        if (string7 == null) {
            string7 = default_password;
        }
        String string10 = "jdbc:cubrid:" + string3 + ":" + n + ":" + string2 + ":" + string6 + "::";
        if (string5 != null) {
            string10 = string10 + "?" + string5;
        }
        connectionProperties.setProperties(properties);
        string4 = connectionProperties.getAltHosts();
        if (string4 != null) {
            object = new ArrayList();
            ((ArrayList)object).add(string3 + ":" + n);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                ((ArrayList)object).add(stringTokenizer.nextToken());
            }
            uConnection = UJCIManager.connect((ArrayList)object, string2, string6, string7, string10);
        }
        uConnection = UJCIManager.connect(string3, n, string2, string6, string7, string10);
        uConnection.setCharset(connectionProperties.getCharSet());
        uConnection.setZeroDateTimeBehavior(connectionProperties.getZeroDateTimeBehavior());
        uConnection.setConnectionProperties(connectionProperties);
        uConnection.tryConnect();
        return new CUBRIDConnection(uConnection, string, string6);
    }

    public Connection defaultConnection() throws SQLException {
        if (UJCIUtil.isServerSide()) {
            Thread thread = Thread.currentThread();
            Connection connection = (Connection)UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "getJdbcConnection", null, thread, null);
            if (connection != null) {
                return connection;
            }
            UConnection uConnection = UJCIManager.connectDefault();
            CUBRIDConnection cUBRIDConnection = new CUBRIDConnection(uConnection, "jdbc:default:connection:", "default", true);
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setJdbcConnection", new Class[]{Connection.class}, thread, new Object[]{cUBRIDConnection});
            return cUBRIDConnection;
        }
        return null;
    }

    public boolean acceptsURL(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        String string2 = CUBRID_JDBC_URL_HEADER;
        String string3 = CUBRIDDriver.class.getName();
        if (string3.matches(".*oracle.*")) {
            string2 = string2 + "-oracle";
        } else if (string3.matches(".*mysql.*")) {
            string2 = string2 + "-mysql";
        }
        return string.toLowerCase().startsWith(string2) || string.toLowerCase().startsWith(JDBC_DEFAULT_CONNECTION);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return major_version;
    }

    public int getMinorVersion() {
        return minor_version;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    static {
        StringTokenizer stringTokenizer = new StringTokenizer(version_string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new RuntimeException("Could not parse version_string: 8.4.1.2032");
        }
        major_version = Integer.parseInt(stringTokenizer.nextToken());
        minor_version = Integer.parseInt(stringTokenizer.nextToken());
        patch_version = Integer.parseInt(stringTokenizer.nextToken());
        try {
            DriverManager.registerDriver(new CUBRIDDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (UJCIUtil.isConsoleDebug()) {
            try {
                debugOutput = new PrintStream(new File("cubrid.log"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                debugOutput = System.out;
            }
        }
        connInfoTable = new Hashtable();
    }
}

