/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

class CUBRIDBlobOutputStream
extends OutputStream {
    private CUBRIDBlob blob;
    private long lob_pos;

    CUBRIDBlobOutputStream(CUBRIDBlob cUBRIDBlob, long l) {
        this.blob = cUBRIDBlob;
        this.lob_pos = l;
    }

    public synchronized void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.blob == null) {
            throw new IOException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.lob_pos += (long)this.blob.setBytes(this.lob_pos, byArray, n, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.blob.removeFlushableStream(this);
        this.blob = null;
    }
}

