/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ByteArrayBuffer {
    private static final int UnitSize = 102400;
    private ArrayList<byte[]> byteArrayList;
    private byte[] baseByteArray;
    private byte[] buffer;
    private int pos;
    private int dataSize;
    private byte[] writeBuffer = new byte[8];

    public ByteArrayBuffer() {
        this.baseByteArray = new byte[102400];
        this.reset();
    }

    public void writeByte(byte by) {
        this.write(by);
    }

    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeInt(int n) {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeLong(long l) {
        this.writeBuffer[0] = (byte)(l >>> 56);
        this.writeBuffer[1] = (byte)(l >>> 48);
        this.writeBuffer[2] = (byte)(l >>> 40);
        this.writeBuffer[3] = (byte)(l >>> 32);
        this.writeBuffer[4] = (byte)(l >>> 24);
        this.writeBuffer[5] = (byte)(l >>> 16);
        this.writeBuffer[6] = (byte)(l >>> 8);
        this.writeBuffer[7] = (byte)(l >>> 0);
        this.write(this.writeBuffer, 0, 8);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    private void write(int n) {
        if (this.pos == 102400) {
            this.byteArrayList.add(this.buffer);
            this.buffer = new byte[102400];
            this.pos = 0;
        }
        this.buffer[this.pos] = (byte)n;
        ++this.pos;
        ++this.dataSize;
    }

    public void merge(int n, ByteArrayBuffer byteArrayBuffer) {
        this.writeInt(n);
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.buffer, 0, byArray, 0, this.pos);
        this.byteArrayList.add(byArray);
        for (byte[] byArray2 : byteArrayBuffer.byteArrayList) {
            this.byteArrayList.add(byArray2);
        }
        this.buffer = new byte[102400];
        this.pos = 0;
        this.dataSize += n;
    }

    public void writeToStream(byte[] byArray, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.dataSize);
        dataOutputStream.write(byArray);
        for (byte[] byArray2 : this.byteArrayList) {
            if (byArray2 == null) continue;
            dataOutputStream.write(byArray2);
        }
        dataOutputStream.write(this.buffer, 0, this.pos);
        dataOutputStream.flush();
    }

    public void reset() {
        this.byteArrayList = new ArrayList();
        this.buffer = this.baseByteArray;
        this.pos = 0;
        this.dataSize = 0;
    }
}

