/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDLobHandle;
import cubrid.jdbc.jci.CUBRIDArray;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UGetTypeConvertedValue;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UStatementCacheData;
import cubrid.jdbc.util.ByteArrayBuffer;
import cubrid.sql.CUBRIDOID;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.transaction.xa.Xid;

class UOutputBuffer {
    private UConnection u_con;
    private OutputStream output;
    private ByteArrayBuffer dataBuffer;
    private Calendar c = Calendar.getInstance();

    UOutputBuffer(UConnection uConnection) throws IOException {
        this.u_con = uConnection;
        this.output = this.u_con.getOutputStream();
        this.dataBuffer = new ByteArrayBuffer();
    }

    private void initBuffer() throws IOException {
        this.dataBuffer.reset();
    }

    void sendData() throws IOException {
        this.dataBuffer.writeToStream(this.u_con.getCASInfo(), this.output);
        this.initBuffer();
    }

    void newRequest(OutputStream outputStream, byte by) throws IOException {
        this.output = outputStream;
        this.initBuffer();
        this.dataBuffer.writeByte(by);
    }

    void newRequest(byte by) throws IOException {
        this.output = this.u_con.getOutputStream();
        this.initBuffer();
        this.dataBuffer.writeByte(by);
    }

    int addInt(int n) throws IOException {
        this.dataBuffer.writeInt(4);
        this.dataBuffer.writeInt(n);
        return 8;
    }

    int addLong(long l) throws IOException {
        this.dataBuffer.writeInt(8);
        this.dataBuffer.writeLong(l);
        return 12;
    }

    int addByte(byte by) throws IOException {
        this.dataBuffer.writeInt(1);
        this.dataBuffer.writeByte(by);
        return 5;
    }

    int addBytes(byte[] byArray) throws IOException {
        return this.addBytes(byArray, 0, byArray.length);
    }

    int addBytes(byte[] byArray, int n, int n2) throws IOException {
        this.dataBuffer.writeInt(n2);
        this.dataBuffer.write(byArray, n, n2);
        return n2 + 4;
    }

    int addNull() throws IOException {
        this.dataBuffer.writeInt(0);
        return 4;
    }

    int addStringWithNull(String string) throws IOException {
        byte[] byArray;
        try {
            byArray = string.getBytes(this.u_con.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        this.dataBuffer.writeInt(byArray.length + 1);
        this.dataBuffer.write(byArray, 0, byArray.length);
        this.dataBuffer.writeByte((byte)0);
        return byArray.length + 5;
    }

    int addDouble(double d) throws IOException {
        this.dataBuffer.writeInt(8);
        this.dataBuffer.writeDouble(d);
        return 12;
    }

    int addShort(short s) throws IOException {
        this.dataBuffer.writeInt(2);
        this.dataBuffer.writeShort(s);
        return 6;
    }

    int addFloat(float f) throws IOException {
        this.dataBuffer.writeInt(4);
        this.dataBuffer.writeFloat(f);
        return 8;
    }

    int addDate(Date date) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeDate(date);
        return 18;
    }

    private void writeDate(Date date) throws IOException {
        this.c.setTime(date);
        this.dataBuffer.writeShort(this.c.get(1));
        this.dataBuffer.writeShort(this.c.get(2) + 1);
        this.dataBuffer.writeShort(this.c.get(5));
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
    }

    int addTime(Time time) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeTime(time);
        return 18;
    }

    private void writeTime(Time time) throws IOException {
        this.c.setTime(time);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(this.c.get(11));
        this.dataBuffer.writeShort(this.c.get(12));
        this.dataBuffer.writeShort(this.c.get(13));
        this.dataBuffer.writeShort(0);
    }

    int addTimestamp(Timestamp timestamp) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeTimestamp(timestamp, false);
        return 18;
    }

    private void writeTimestamp(Timestamp timestamp, boolean bl) throws IOException {
        this.c.setTime(timestamp);
        this.dataBuffer.writeShort(this.c.get(1));
        this.dataBuffer.writeShort(this.c.get(2) + 1);
        this.dataBuffer.writeShort(this.c.get(5));
        this.dataBuffer.writeShort(this.c.get(11));
        this.dataBuffer.writeShort(this.c.get(12));
        this.dataBuffer.writeShort(this.c.get(13));
        if (bl) {
            this.dataBuffer.writeShort(this.c.get(14));
        } else {
            this.dataBuffer.writeShort(0);
        }
    }

    int addDatetime(Timestamp timestamp) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeTimestamp(timestamp, true);
        return 18;
    }

    int addOID(CUBRIDOID cUBRIDOID) throws IOException {
        byte[] byArray = cUBRIDOID.getOID();
        if (byArray == null || byArray.length != 8) {
            byArray = new byte[8];
        }
        this.dataBuffer.writeInt(8);
        this.dataBuffer.write(byArray, 0, byArray.length);
        return 12;
    }

    int addXid(Xid xid) throws IOException {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n = 12 + byArray.length + byArray2.length;
        this.dataBuffer.writeInt(n);
        this.dataBuffer.writeInt(xid.getFormatId());
        this.dataBuffer.writeInt(byArray.length);
        this.dataBuffer.writeInt(byArray2.length);
        this.dataBuffer.write(byArray, 0, byArray.length);
        this.dataBuffer.write(byArray2, 0, byArray2.length);
        return n + 4;
    }

    int addCacheTime(UStatementCacheData uStatementCacheData) throws IOException {
        int n;
        int n2;
        if (uStatementCacheData == null) {
            n2 = 0;
            n = 0;
        } else {
            n = (int)(uStatementCacheData.srvCacheTime >>> 32);
            n2 = (int)uStatementCacheData.srvCacheTime;
        }
        this.dataBuffer.writeInt(8);
        this.dataBuffer.writeInt(n);
        this.dataBuffer.writeInt(n2);
        return 12;
    }

    int addBlob(CUBRIDBlob cUBRIDBlob) throws IOException {
        return this.addLob(cUBRIDBlob.getLobHandle());
    }

    int addClob(CUBRIDClob cUBRIDClob) throws IOException {
        return this.addLob(cUBRIDClob.getLobHandle());
    }

    private int addLob(CUBRIDLobHandle cUBRIDLobHandle) throws IOException {
        byte[] byArray = cUBRIDLobHandle.getPackedLobHandle();
        this.dataBuffer.writeInt(byArray.length);
        this.dataBuffer.write(byArray, 0, byArray.length);
        return byArray.length + 4;
    }

    int writeParameter(byte by, Object object) throws UJciException, IOException {
        if (object == null) {
            return this.addNull();
        }
        switch (by) {
            case 0: {
                return this.addNull();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                String string = UGetTypeConvertedValue.getString(object);
                return this.addStringWithNull(string);
            }
            case 7: {
                String string = UGetTypeConvertedValue.getString(object);
                return this.addStringWithNull(string);
            }
            case 5: 
            case 6: {
                if (object instanceof byte[] && ((byte[])object).length > 1) {
                    return this.addBytes(UGetTypeConvertedValue.getBytes(object));
                }
                return this.addByte(UGetTypeConvertedValue.getByte(object));
            }
            case 10: 
            case 12: {
                return this.addDouble(UGetTypeConvertedValue.getDouble(object));
            }
            case 13: {
                return this.addDate(UGetTypeConvertedValue.getDate(object));
            }
            case 14: {
                return this.addTime(UGetTypeConvertedValue.getTime(object));
            }
            case 15: {
                return this.addTimestamp(UGetTypeConvertedValue.getTimestamp(object));
            }
            case 22: {
                return this.addDatetime(UGetTypeConvertedValue.getTimestamp(object));
            }
            case 11: {
                return this.addFloat(UGetTypeConvertedValue.getFloat(object));
            }
            case 9: {
                return this.addShort(UGetTypeConvertedValue.getShort(object));
            }
            case 8: {
                return this.addInt(UGetTypeConvertedValue.getInt(object));
            }
            case 21: {
                return this.addLong(UGetTypeConvertedValue.getLong(object));
            }
            case 16: 
            case 17: 
            case 18: {
                if (!(object instanceof CUBRIDArray)) {
                    new UJciException(5);
                }
                return this.writeCollection((CUBRIDArray)object);
            }
            case 19: {
                if (!(object instanceof CUBRIDOID)) {
                    new UJciException(5);
                }
                return this.addOID((CUBRIDOID)object);
            }
            case 23: {
                if (!(object instanceof CUBRIDBlob)) {
                    new UJciException(5);
                }
                return this.addBlob((CUBRIDBlob)object);
            }
            case 24: {
                if (!(object instanceof CUBRIDClob)) {
                    new UJciException(5);
                }
                return this.addClob((CUBRIDClob)object);
            }
        }
        return 0;
    }

    private int writeCollection(CUBRIDArray cUBRIDArray) throws UJciException, IOException {
        int n = 1;
        ByteArrayBuffer byteArrayBuffer = this.dataBuffer;
        this.dataBuffer = new ByteArrayBuffer();
        this.dataBuffer.writeByte((byte)cUBRIDArray.getBaseType());
        Object[] objectArray = (Object[])cUBRIDArray.getArray();
        if (objectArray == null) {
            return n;
        }
        switch (cUBRIDArray.getBaseType()) {
            case 5: 
            case 6: {
                int n2;
                Object object = null;
                if (objectArray instanceof byte[][]) {
                    object = (byte[][])objectArray;
                } else if (objectArray instanceof Boolean[]) {
                    object = new byte[objectArray.length][];
                    for (n2 = 0; n2 < ((byte[][])object).length; ++n2) {
                        if (((Boolean[])objectArray)[n2] != null) {
                            object[n2] = new byte[1];
                            object[n2][0] = ((Boolean[])objectArray)[n2] == true ? (byte)1 : 0;
                            continue;
                        }
                        object[n2] = null;
                    }
                }
                for (n2 = 0; object != null && n2 < ((byte[][])object).length; ++n2) {
                    if (object[n2] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addBytes(object[n2]);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addStringWithNull(objectArray[i].toString());
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.writeParameter((byte)cUBRIDArray.getBaseType(), objectArray[i]);
                }
                break;
            }
            default: {
                for (int i = 0; i < objectArray.length; ++i) {
                    n += this.addNull();
                }
            }
        }
        byteArrayBuffer.merge(n, this.dataBuffer);
        this.dataBuffer = byteArrayBuffer;
        return n + 4;
    }
}

