/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class UJCIUtil {
    private static boolean bServerSide;
    private static boolean bConsoleDebug;
    private static boolean bMMDB;
    private static boolean bSendAppInfo;
    private static boolean bJDBC4;

    public static int bytes2int(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n + 4;
        for (int i = n; i < n3; ++i) {
            n2 <<= 8;
            n2 |= byArray[i] & 0xFF;
        }
        return n2;
    }

    public static short bytes2short(byte[] byArray, int n) {
        short s = 0;
        int n2 = n + 2;
        for (int i = n; i < n2; ++i) {
            s = (short)(s << 8);
            s = (short)(s | byArray[i] & 0xFF);
        }
        return s;
    }

    public static void copy_byte(byte[] byArray, int n, int n2, String string) {
        if (string == null) {
            return;
        }
        byte[] byArray2 = string.getBytes();
        n2 = n2 > byArray2.length ? byArray2.length : n2;
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    public static boolean isMysqlMode(Class clazz) {
        String[] stringArray = clazz.getName().split("\\.");
        return stringArray.length > 2 && stringArray[2].equals("mysql");
    }

    public static boolean isOracleMode(Class clazz) {
        String[] stringArray = clazz.getName().split("\\.");
        return stringArray.length > 2 && stringArray[2].equals("oracle");
    }

    public static boolean isServerSide() {
        return bServerSide;
    }

    public static boolean isConsoleDebug() {
        return bConsoleDebug;
    }

    public static boolean isMMDB() {
        return bMMDB;
    }

    public static boolean isSendAppInfo() {
        return bSendAppInfo;
    }

    public static boolean isJDBC4() {
        return bJDBC4;
    }

    public static Object invoke(String string, String string2, Class[] classArray, Object object, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, classArray);
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Constructor getConstructor(String string, Class[] classArray) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        String string = System.getProperty("ConsoleDebug");
        bConsoleDebug = string != null && string.equals("true");
        string = System.getProperty("MMDB");
        bMMDB = string != null && string.equals("true");
        string = System.getProperty("SendAppInfo");
        bSendAppInfo = string != null && string.equals("true");
        try {
            Class.forName("com.cubrid.jsp.Server");
            bServerSide = true;
        }
        catch (Throwable throwable) {
            bServerSide = false;
        }
        try {
            Class.forName("java.sql.NClob");
            bJDBC4 = true;
        }
        catch (Throwable throwable) {
            bJDBC4 = false;
        }
    }
}

