/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDXAConnection;
import cubrid.jdbc.driver.CUBRIDXidInfo;
import cubrid.jdbc.driver.CUBRIDXidTable;
import cubrid.jdbc.jci.UConnection;
import java.io.PrintStream;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CUBRIDXAResource
implements XAResource {
    private CUBRIDXAConnection xacon;
    private PrintStream debug_out;
    private String xacon_key;

    protected CUBRIDXAResource(CUBRIDXAConnection cUBRIDXAConnection, String string) {
        this.xacon = cUBRIDXAConnection;
        this.xacon_key = string;
        this.debug_out = null;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource(" + string + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        CUBRIDXidInfo cUBRIDXidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.commit(" + xid + "," + bl + ")");
        }
        if ((cUBRIDXidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo2 = cUBRIDXidInfo;
        synchronized (cUBRIDXidInfo2) {
            if (bl ? cUBRIDXidInfo.status != 0 : cUBRIDXidInfo.status != 3 && cUBRIDXidInfo.status != 4) {
                throw new XAException(-6);
            }
            this.end_tran(cUBRIDXidInfo.ucon, xid, cUBRIDXidInfo.status, true);
            cUBRIDXidInfo.status = 5;
        }
        CUBRIDXidTable.removeXid(this.xacon_key, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.end(" + xid + "," + n + ")");
        }
        if (n != 0x4000000 && n != 0x20000000 && n != 0x2000000) {
            throw new XAException(-5);
        }
        CUBRIDXidInfo cUBRIDXidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid);
        if (cUBRIDXidInfo == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo2 = cUBRIDXidInfo;
        synchronized (cUBRIDXidInfo2) {
            if (cUBRIDXidInfo.status != 1 && cUBRIDXidInfo.status != 2 && cUBRIDXidInfo.status != 0) {
                throw new XAException(-6);
            }
            if (!this.xacon.xa_end()) {
                throw new XAException(-3);
            }
            cUBRIDXidInfo.status = n == 0x2000000 ? 2 : 0;
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.forget()");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.getTransactionTimeout()");
        }
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.isSameRM()");
        }
        return xAResource instanceof CUBRIDXAResource && this.xacon_key.compareTo(((CUBRIDXAResource)xAResource).xacon_key) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        CUBRIDXidInfo cUBRIDXidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.prepare()");
        }
        if ((cUBRIDXidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo2 = cUBRIDXidInfo;
        synchronized (cUBRIDXidInfo2) {
            if (cUBRIDXidInfo.status != 0) {
                throw new XAException(-6);
            }
            UConnection uConnection = cUBRIDXidInfo.ucon;
            if (uConnection == null) {
                throw new XAException(-3);
            }
            UConnection uConnection2 = uConnection;
            synchronized (uConnection2) {
                uConnection.xa_prepare(xid);
                if (uConnection.getRecentError().getErrorCode() != 0) {
                    throw new XAException(-3);
                }
            }
            cUBRIDXidInfo.status = 3;
        }
        return 0;
    }

    public Xid[] recover(int n) throws XAException {
        UConnection uConnection;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.recover()");
        }
        try {
            uConnection = this.xacon.createUConnection();
        }
        catch (Exception exception) {
            throw new XAException(-3);
        }
        Xid[] xidArray = uConnection.xa_recover();
        if (uConnection.getRecentError().getErrorCode() != 0) {
            throw new XAException(-3);
        }
        for (int i = 0; i < xidArray.length; ++i) {
            CUBRIDXidInfo cUBRIDXidInfo = new CUBRIDXidInfo(xidArray[i], null, 4);
            CUBRIDXidTable.putXidInfo(this.xacon_key, cUBRIDXidInfo);
        }
        uConnection.close();
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        CUBRIDXidInfo cUBRIDXidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.rollback()");
        }
        if ((cUBRIDXidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo2 = cUBRIDXidInfo;
        synchronized (cUBRIDXidInfo2) {
            this.end_tran(cUBRIDXidInfo.ucon, xid, cUBRIDXidInfo.status, false);
            cUBRIDXidInfo.status = 5;
        }
        CUBRIDXidTable.removeXid(this.xacon_key, xid);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.setTransactionTimeout()");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int n) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.start(" + xid + "," + n + ")");
        }
        if (!this.checkXid(xid)) {
            throw new XAException(-5);
        }
        CUBRIDXidInfo cUBRIDXidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid);
        if (n == 0) {
            if (cUBRIDXidInfo != null) {
                throw new XAException(-8);
            }
            UConnection uConnection = this.xacon.xa_start(n, null);
            if (uConnection == null) {
                throw new XAException(-3);
            }
            cUBRIDXidInfo = new CUBRIDXidInfo(xid, uConnection, 1);
            CUBRIDXidTable.putXidInfo(this.xacon_key, cUBRIDXidInfo);
        } else if (n == 0x200000 || n == 0x8000000) {
            if (cUBRIDXidInfo == null) {
                throw new XAException(-4);
            }
            CUBRIDXidInfo cUBRIDXidInfo2 = cUBRIDXidInfo;
            synchronized (cUBRIDXidInfo2) {
                if (cUBRIDXidInfo.status != 0 && cUBRIDXidInfo.status != 2) {
                    throw new XAException(-6);
                }
                if (this.xacon.xa_start(n, cUBRIDXidInfo.ucon) == null) {
                    throw new XAException(-3);
                }
                cUBRIDXidInfo.status = 1;
            }
        } else {
            throw new XAException(-5);
        }
    }

    private boolean checkXid(Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        if (byArray == null || byArray.length == 0 || byArray.length > 64) {
            return false;
        }
        return byArray2 != null && byArray2.length != 0 && byArray2.length <= 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end_tran(UConnection uConnection, Xid xid, int n, boolean bl) throws XAException {
        if (uConnection == null) {
            try {
                uConnection = this.xacon.createUConnection();
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
        }
        UConnection uConnection2 = uConnection;
        synchronized (uConnection2) {
            if (n == 4) {
                uConnection.xa_endTransaction(xid, bl);
            } else {
                uConnection.endTransaction(bl);
            }
            if (uConnection.getRecentError().getErrorCode() != 0) {
                throw new XAException(-7);
            }
        }
        uConnection = this.xacon.xa_end_tran(uConnection);
        if (uConnection != null) {
            uConnection2 = uConnection;
            synchronized (uConnection2) {
                uConnection.close();
            }
        }
    }
}

