/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnectionWrapperXA;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDPooledConnection;
import cubrid.jdbc.driver.CUBRIDXADataSource;
import cubrid.jdbc.driver.CUBRIDXAResource;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class CUBRIDXAConnection
extends CUBRIDPooledConnection
implements XAConnection {
    private String serverName;
    private int portNumber;
    private String databaseName;
    private String username;
    private String passwd;
    private CUBRIDXAResource xares;
    private CUBRIDXADataSource xads;
    private boolean xa_started;
    private String xacon_key;

    protected CUBRIDXAConnection(CUBRIDXADataSource cUBRIDXADataSource, String string, int n, String string2, String string3, String string4) throws SQLException {
        super(null);
        this.serverName = string;
        this.portNumber = n;
        this.databaseName = string2;
        this.username = string3;
        this.passwd = string4;
        this.u_con = this.createUConnection();
        this.xads = cUBRIDXADataSource;
        this.xares = null;
        this.xa_started = false;
        this.xacon_key = cUBRIDXADataSource.getDataSourceID(string3);
    }

    public synchronized XAResource getXAResource() throws SQLException {
        if (this.isClosed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_connection_closed);
        }
        if (this.xares == null) {
            this.xares = new CUBRIDXAResource(this, this.xacon_key);
        }
        return this.xares;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_connection_closed);
        }
        if (this.curConnection != null) {
            this.curConnection.closeConnection();
        }
        if (this.u_con == null) {
            this.u_con = this.createUConnection();
        }
        this.curConnection = new CUBRIDConnectionWrapperXA(this.u_con, null, null, this, this.xa_started);
        return this.curConnection;
    }

    synchronized void notifyConnectionClosed() {
        super.notifyConnectionClosed();
        if (this.xa_started) {
            this.u_con = null;
        }
    }

    synchronized UConnection xa_end_tran(UConnection uConnection) {
        if (this.u_con == null) {
            this.u_con = uConnection;
            return null;
        }
        return uConnection;
    }

    synchronized UConnection xa_start(int n, UConnection uConnection) {
        if (this.xa_started) {
            return null;
        }
        this.xa_started = true;
        if (n == 0x200000 || n == 0x8000000) {
            if (this.u_con != null) {
                this.u_con.close();
            }
            this.u_con = uConnection;
        }
        if (this.curConnection != null) {
            if (n == 0) {
                try {
                    this.curConnection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            ((CUBRIDConnectionWrapperXA)this.curConnection).xa_start(this.u_con);
        }
        return this.u_con;
    }

    synchronized boolean xa_end() {
        if (!this.xa_started) {
            return true;
        }
        try {
            if (this.u_con != null) {
                this.u_con = this.createUConnection();
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (this.curConnection != null) {
            ((CUBRIDConnectionWrapperXA)this.curConnection).xa_end(this.u_con);
        }
        this.xa_started = false;
        return true;
    }

    UConnection createUConnection() throws SQLException {
        return UJCIManager.connect(this.serverName, this.portNumber, this.databaseName, this.username, this.passwd, "xa");
    }
}

