/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJCIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class CUBRIDDriver
implements Driver {
    static final String version_string = "8.4.1.0564";
    public static final int major_version;
    public static final int minor_version;
    public static final int patch_version;
    public static final String default_hostname = "localhost";
    public static final int default_port = 30000;
    public static final String default_user = "public";
    public static final String default_password = "";
    private static final String CUBRID_JDBC_URL_HEADER = "jdbc:cubrid";
    private static final String JDBC_DEFAULT_CONNECTION = "jdbc:default:connection";
    private static final String CONNECTION_PROPERTY_CHARSET = "charset";
    private static final String CONNECTION_PROPERTY_ALTERNATIVE_HOSTS = "althosts";
    private static final String CONNECTION_PROPERTY_RECONNECTION_TIME = "rctime";
    private static final String CONNECTION_PROPERTY_QUERY_TIMEOUT = "queryTimeout";
    private static final String CONNECTION_PROPERTY_CONNECT_TIMEOUT = "connectTimeout";
    private static final String CONNECTION_PROPERTY_ZERODATETIME_BEHAVIOR = "zeroDateTimeBehavior";
    private static final String[] params;
    private static PrintStream debugOutput;
    private static Hashtable<String, String> connInfoTable;

    public static void printDebug(String string) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd hh:mm:ss.SSS");
        String string2 = String.format("%s %s", simpleDateFormat.format(timestamp), string);
        debugOutput.println(string2);
    }

    public static void setLastConnectInfo(String string, String string2) {
        if (string != null) {
            connInfoTable.put(string, string2);
            if (UJCIUtil.isConsoleDebug()) {
                CUBRIDDriver.printDebug(String.format("S[K,V]=(%s,%s)", string, string2));
            }
        }
    }

    public static String getLastConnectInfo(String string) {
        String string2 = connInfoTable.get(string);
        if (UJCIUtil.isConsoleDebug()) {
            CUBRIDDriver.printDebug(String.format("G[K,V]=(%s,%s)", string, string2));
        }
        return string2;
    }

    private boolean exValidKey(String string) throws Exception {
        String[] stringArray;
        String string2 = CUBRIDDriver.class.getName();
        String[] stringArray2 = string2.split("\\.");
        if (!stringArray2[0].equals((stringArray = string.split("\\-"))[0].toLowerCase())) {
            throw new Exception("Invalid URL");
        }
        if (stringArray2[2].equals("oracle") || stringArray2[2].equals("mysql") ? stringArray[1] != null && !stringArray2[2].equals(stringArray[1].toLowerCase()) : stringArray.length != 1) {
            throw new Exception("Invalid URL");
        }
        return true;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        UConnection uConnection;
        Properties properties2;
        String string2;
        int n;
        String string3;
        String string4;
        Object object;
        String string5;
        String string6 = null;
        String string7 = null;
        int n2 = 0;
        if (!this.acceptsURL(string)) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, string);
        }
        if (string.toLowerCase().startsWith(JDBC_DEFAULT_CONNECTION)) {
            return this.defaultConnection();
        }
        try {
            String string8;
            n2 = string.indexOf(63);
            if (n2 != -1) {
                string8 = string.substring(0, n2);
                string5 = string.substring(n2, string.length());
            } else {
                string8 = string;
                string5 = null;
            }
            object = new StringTokenizer(string8, ":", true);
            string4 = ((StringTokenizer)object).nextToken();
            if (string4.equals(":")) {
                throw new Exception("Invalid URL");
            }
            ((StringTokenizer)object).nextToken();
            String string9 = ((StringTokenizer)object).nextToken();
            if (string9.equals(":")) {
                throw new Exception("Invalid URL");
            }
            ((StringTokenizer)object).nextToken();
            this.exValidKey(string9);
            string3 = ((StringTokenizer)object).nextToken();
            if (string3.equals(":")) {
                string3 = default_hostname;
            } else {
                ((StringTokenizer)object).nextToken();
            }
            string4 = ((StringTokenizer)object).nextToken();
            if (string4.equals(":")) {
                n = 30000;
            } else {
                n = Integer.parseInt(string4);
                ((StringTokenizer)object).nextToken();
            }
            string2 = ((StringTokenizer)object).nextToken();
            if (string2.equals(":")) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.no_dbname);
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).hasMoreTokens() && (string6 = ((StringTokenizer)object).nextToken()).equals(":")) {
                    string6 = null;
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).hasMoreTokens() && (string7 = ((StringTokenizer)object).nextToken()).equals(":")) {
                    string7 = null;
                }
            }
            properties2 = this.make_param_info(string5);
        }
        catch (CUBRIDException cUBRIDException) {
            throw cUBRIDException;
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, string);
        }
        string4 = properties.getProperty("user");
        if (string4 != null) {
            string6 = string4;
        }
        if ((string4 = properties.getProperty("password")) != null) {
            string7 = string4;
        }
        if (string6 == null) {
            string6 = default_user;
        }
        if (string7 == null) {
            string7 = default_password;
        }
        String string10 = "jdbc:cubrid:" + string3 + ":" + n + ":" + string2 + ":" + string6 + "::";
        if (string5 != null) {
            string10 = string10 + "?" + string5;
        }
        if ((string4 = properties.getProperty(CONNECTION_PROPERTY_ALTERNATIVE_HOSTS)) == null) {
            string4 = properties2.getProperty(CONNECTION_PROPERTY_ALTERNATIVE_HOSTS);
        }
        if (string4 != null) {
            object = new ArrayList();
            ((ArrayList)object).add(string3 + ":" + n);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                ((ArrayList)object).add(stringTokenizer.nextToken());
            }
            uConnection = UJCIManager.connect((ArrayList)object, string2, string6, string7, string10);
        }
        uConnection = UJCIManager.connect(string3, n, string2, string6, string7, string10);
        string4 = properties.getProperty(CONNECTION_PROPERTY_RECONNECTION_TIME);
        if (string4 == null) {
            string4 = properties2.getProperty(CONNECTION_PROPERTY_RECONNECTION_TIME);
        }
        if (string4 != null) {
            uConnection.setReconnectionTime(Integer.valueOf(string4));
        }
        if ((string4 = properties.getProperty(CONNECTION_PROPERTY_QUERY_TIMEOUT)) == null) {
            string4 = properties2.getProperty(CONNECTION_PROPERTY_QUERY_TIMEOUT);
        }
        if (string4 != null) {
            uConnection.setQueryTimeout(Integer.valueOf(string4));
        }
        if ((string4 = properties.getProperty(CONNECTION_PROPERTY_CONNECT_TIMEOUT)) == null) {
            string4 = properties2.getProperty(CONNECTION_PROPERTY_CONNECT_TIMEOUT);
        }
        if (string4 != null) {
            uConnection.setConnectTimeout(Integer.valueOf(string4));
        } else {
            int n3 = DriverManager.getLoginTimeout();
            if (n3 > 0) {
                uConnection.setConnectTimeout(n3);
            }
        }
        string4 = properties.getProperty(CONNECTION_PROPERTY_CHARSET);
        if (string4 == null) {
            string4 = properties2.getProperty(CONNECTION_PROPERTY_CHARSET);
        }
        if (string4 != null) {
            try {
                uConnection.setCharset(string4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("UnsupportedEncodingException : " + string4);
            }
        }
        if ((string4 = properties.getProperty(CONNECTION_PROPERTY_ZERODATETIME_BEHAVIOR)) == null) {
            string4 = properties2.getProperty(CONNECTION_PROPERTY_ZERODATETIME_BEHAVIOR);
        }
        if (string4 != null) {
            uConnection.setZeroDateTimeBehavior(string4);
        }
        uConnection.tryConnect();
        return new CUBRIDConnection(uConnection, string, string6);
    }

    public Connection defaultConnection() throws SQLException {
        if (UJCIUtil.isServerSide()) {
            Thread thread = Thread.currentThread();
            Connection connection = (Connection)UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "getJdbcConnection", null, thread, null);
            if (connection != null) {
                return connection;
            }
            UConnection uConnection = UJCIManager.connectDefault();
            CUBRIDConnection cUBRIDConnection = new CUBRIDConnection(uConnection, "jdbc:default:connection:", "default", true);
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setJdbcConnection", new Class[]{Connection.class}, thread, new Object[]{cUBRIDConnection});
            return cUBRIDConnection;
        }
        return null;
    }

    public boolean acceptsURL(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith(CUBRID_JDBC_URL_HEADER) || string.toLowerCase().startsWith(JDBC_DEFAULT_CONNECTION);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return major_version;
    }

    public int getMinorVersion() {
        return minor_version;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private Properties make_param_info(String string) throws CUBRIDException {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        int n = string.indexOf(63);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        do {
            String string2;
            if ((n = string.indexOf(38)) < 0) {
                n = string.indexOf(59);
            }
            if (n < 0) {
                string2 = string;
                string = null;
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            n = string2.indexOf(61);
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            boolean bl = false;
            for (int i = 0; i < params.length; ++i) {
                if (!string3.equals(params[i])) continue;
                bl = true;
            }
            if (!bl || string3.length() <= 0) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, " unknown property " + string2);
            }
            properties.setProperty(string3, string4);
        } while (string != null);
        return properties;
    }

    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    static {
        StringTokenizer stringTokenizer = new StringTokenizer(version_string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new RuntimeException("Could not parse version_string: 8.4.1.0564");
        }
        major_version = Integer.parseInt(stringTokenizer.nextToken());
        minor_version = Integer.parseInt(stringTokenizer.nextToken());
        patch_version = Integer.parseInt(stringTokenizer.nextToken());
        params = new String[]{CONNECTION_PROPERTY_CHARSET, CONNECTION_PROPERTY_ALTERNATIVE_HOSTS, CONNECTION_PROPERTY_RECONNECTION_TIME, CONNECTION_PROPERTY_QUERY_TIMEOUT, CONNECTION_PROPERTY_CONNECT_TIMEOUT, CONNECTION_PROPERTY_ZERODATETIME_BEHAVIOR};
        try {
            DriverManager.registerDriver(new CUBRIDDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (UJCIUtil.isConsoleDebug()) {
            try {
                debugOutput = new PrintStream(new File("cubrid.log"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                debugOutput = System.out;
            }
        }
        connInfoTable = new Hashtable();
    }
}

