/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDClob;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

class CUBRIDClobWriter
extends Writer {
    private CUBRIDClob clob;
    private long char_pos;

    CUBRIDClobWriter(CUBRIDClob cUBRIDClob, long l) {
        this.clob = cUBRIDClob;
        this.char_pos = l;
    }

    public synchronized void write(String string, int n, int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.char_pos += (long)this.clob.setString(this.char_pos, string, n, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public synchronized void write(char[] cArray, int n, int n2) throws IOException {
        this.write(new String(cArray, n, n2));
    }

    public synchronized void flush() throws IOException {
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.clob.removeFlushableStream(this);
        this.clob = null;
    }
}

