/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlobInputStream;
import cubrid.jdbc.driver.CUBRIDBlobOutputStream;
import cubrid.jdbc.driver.CUBRIDBufferedInputStream;
import cubrid.jdbc.driver.CUBRIDBufferedOutputStream;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDLobHandle;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;

public class CUBRIDBlob
implements Blob {
    private static final int BLOB_MAX_IO_LENGTH = 131072;
    private CUBRIDConnection conn;
    private boolean isWritable;
    private CUBRIDLobHandle lobHandle;
    private ArrayList<Flushable> streamList = new ArrayList();

    public CUBRIDBlob(CUBRIDConnection cUBRIDConnection) throws SQLException {
        if (cUBRIDConnection == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        byte[] byArray = cUBRIDConnection.lobNew(23);
        this.conn = cUBRIDConnection;
        this.isWritable = true;
        this.lobHandle = new CUBRIDLobHandle(23, byArray);
    }

    public CUBRIDBlob(CUBRIDConnection cUBRIDConnection, byte[] byArray) throws SQLException {
        if (cUBRIDConnection == null || byArray == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        this.conn = cUBRIDConnection;
        this.isWritable = false;
        this.lobHandle = new CUBRIDLobHandle(23, byArray);
    }

    public long length() throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        return this.lobHandle.getLobSize();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L || n < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (n == 0) {
            return new byte[0];
        }
        int n2 = 0;
        if (--l + (long)n > this.length()) {
            n = (int)(this.length() - l);
        }
        if (n <= 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        while (n > 0) {
            int n3 = Math.min(n, 131072);
            int n4 = this.conn.lobRead(this.lobHandle.getPackedLobHandle(), l, byArray, n2, n3);
            l += (long)n4;
            n -= n4;
            n2 += n4;
            if (n4 != 0) continue;
        }
        if (n2 < byArray.length) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown);
        }
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, this.length());
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L || l2 < 0L) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        return new CUBRIDBufferedInputStream(new CUBRIDBlobInputStream(this, l, l2), 131072);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(Blob blob, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L || n < 0 || n2 < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isWritable) {
            if (this.length() + 1L != l) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid);
            }
            --l;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 131072);
                int n5 = this.conn.lobWrite(this.lobHandle.getPackedLobHandle(), l, byArray, n, n4);
                l += (long)n5;
                n2 -= n5;
                n += n5;
                n3 += n5;
            }
            if (l > this.length()) {
                this.lobHandle.setLobSize(l);
            }
            return n3;
        }
        throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (this.isWritable) {
            if (this.length() + 1L != l) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid);
            }
            CUBRIDBufferedOutputStream cUBRIDBufferedOutputStream = new CUBRIDBufferedOutputStream(new CUBRIDBlobOutputStream(this, l), 131072);
            this.addFlushableStream(cUBRIDBufferedOutputStream);
            return cUBRIDBufferedOutputStream;
        }
        throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable);
    }

    public void truncate(long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void free() throws SQLException {
        this.conn = null;
        this.lobHandle = null;
        this.streamList = null;
        this.isWritable = false;
    }

    public CUBRIDLobHandle getLobHandle() {
        return this.lobHandle;
    }

    private void addFlushableStream(Flushable flushable) {
        this.streamList.add(flushable);
    }

    public void removeFlushableStream(Flushable flushable) {
        this.streamList.remove(flushable);
    }

    public void flushFlushableStreams() {
        if (!this.streamList.isEmpty()) {
            for (Flushable flushable : this.streamList) {
                try {
                    flushable.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.lobHandle.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof CUBRIDBlob) {
            CUBRIDBlob cUBRIDBlob = (CUBRIDBlob)object;
            return this.lobHandle.equals(cUBRIDBlob.lobHandle);
        }
        return false;
    }
}

