/*
 * Decompiled with CFR 0.152.
 */
package cubrid.sql;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSet;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UJCIUtil;
import cubrid.jdbc.jci.UStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CUBRIDOID {
    private CUBRIDConnection cur_con;
    private byte[] oid;
    private boolean is_closed;
    private UError error;

    public CUBRIDOID(CUBRIDConnection cUBRIDConnection, byte[] byArray) {
        this.cur_con = cUBRIDConnection;
        this.oid = byArray;
        this.is_closed = false;
    }

    public CUBRIDOID(CUBRIDOID cUBRIDOID) {
        this.cur_con = cUBRIDOID.cur_con;
        this.oid = cUBRIDOID.oid;
        this.is_closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getValues(String[] stringArray) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UStatement uStatement = null;
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uStatement = uConnection.getByOID(this, stringArray);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
        return new CUBRIDResultSet(uStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValues(String[] stringArray, Object[] objectArray) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (stringArray == null || objectArray == null) {
            throw new IllegalArgumentException();
        }
        if (stringArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.putByOID(this, stringArray, objectArray);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove() throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.oidCmd(this, (byte)1);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
        if (uConnection.getAutoCommit()) {
            uConnection.turnOnAutoCommitBySelf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isInstance() throws SQLException {
        Object object;
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            object = uConnection.oidCmd(this, (byte)2);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setReadLock() throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.oidCmd(this, (byte)3);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setWriteLock() throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.oidCmd(this, (byte)4);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToSet(String string, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.addElementToSet(this, string, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromSet(String string, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.dropElementInSet(this, string, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToSequence(String string, int n, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.insertElementIntoSequence(this, string, n, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putIntoSequence(String string, int n, Object object) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.putElementInSequence(this, string, n, object);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromSequence(String string, int n) throws SQLException {
        UConnection uConnection;
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            uConnection.dropElementInSequence(this, string, n);
            this.error = uConnection.getRecentError();
        }
        this.checkError();
    }

    public synchronized String getOidString() throws SQLException {
        this.checkIsOpen();
        if (this.oid == null || this.oid.length != 8) {
            return "";
        }
        return "@" + UJCIUtil.bytes2int(this.oid, 0) + "|" + UJCIUtil.bytes2short(this.oid, 4) + "|" + UJCIUtil.bytes2short(this.oid, 6);
    }

    public byte[] getOID() {
        return this.oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getTableName() throws SQLException {
        String string;
        UConnection uConnection;
        this.checkIsOpen();
        UConnection uConnection2 = uConnection = this.cur_con.getUConnection();
        synchronized (uConnection2) {
            string = (String)uConnection.oidCmd(this, (byte)5);
        }
        return string;
    }

    public static CUBRIDOID getNewInstance(CUBRIDConnection cUBRIDConnection, String string) throws SQLException {
        if (cUBRIDConnection == null || string == null) {
            throw new IllegalArgumentException();
        }
        if (string.charAt(0) != '@') {
            throw new IllegalArgumentException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken().substring(1));
            short s = Short.parseShort(stringTokenizer.nextToken());
            short s2 = Short.parseShort(stringTokenizer.nextToken());
            byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF), (byte)(s >>> 8 & 0xFF), (byte)(s >>> 0 & 0xFF), (byte)(s2 >>> 8 & 0xFF), (byte)(s2 >>> 0 & 0xFF)};
            return new CUBRIDOID(cUBRIDConnection, byArray);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException();
        }
    }

    private void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.is_closed = true;
        this.cur_con = null;
        this.oid = null;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.oid_closed);
        }
    }

    private void checkError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case 17: {
                this.close();
                throw new CUBRIDException(CUBRIDJDBCErrorCode.oid_closed);
            }
            case 16: {
                throw new IllegalArgumentException();
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }
}

