/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class UTimedInputStream {
    public static final int PING_TIMEOUT = 5000;
    private InputStream stream = null;
    private String ip = null;
    private int port = 0;

    UTimedInputStream() {
    }

    public UTimedInputStream(InputStream inputStream, String string, int n) {
        this.stream = inputStream;
        this.ip = string;
        this.port = n;
    }

    public int read() throws IOException {
        while (true) {
            try {
                return this.stream.read();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    UConnection.ping(this.ip, this.port, 5000);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
        }
    }

    public int read(byte[] byArray) throws IOException {
        while (true) {
            try {
                return this.stream.read(byArray);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    UConnection.ping(this.ip, this.port, 5000);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        while (true) {
            try {
                return this.stream.read(byArray, n, n2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    UConnection.ping(this.ip, this.port, 5000);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
        }
    }
}

