/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UConnection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

class UTimedDataInputStream {
    public static final int PING_TIMEOUT = 5000;
    private DataInputStream stream = null;
    private String ip = null;
    private int port = 0;

    UTimedDataInputStream() {
    }

    public UTimedDataInputStream(InputStream inputStream, String string, int n) {
        this.stream = new DataInputStream(inputStream);
        this.ip = string;
        this.port = n;
    }

    public int readInt() throws IOException {
        while (true) {
            try {
                return this.stream.readInt();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    UConnection.ping(this.ip, this.port, 5000);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
        }
    }

    public int readByte(byte[] byArray) throws IOException {
        while (true) {
            try {
                return this.stream.read(byArray);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    UConnection.ping(this.ip, this.port, 5000);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
        }
    }
}

