/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDOutResultSet;
import cubrid.jdbc.jci.CUBRIDArray;
import cubrid.jdbc.jci.UBatchResult;
import cubrid.jdbc.jci.UBindKey;
import cubrid.jdbc.jci.UBindParameter;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UGetTypeConvertedValue;
import cubrid.jdbc.jci.UInputBuffer;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UOutputBuffer;
import cubrid.jdbc.jci.UResCache;
import cubrid.jdbc.jci.UResultInfo;
import cubrid.jdbc.jci.UResultTuple;
import cubrid.jdbc.jci.UStatementCacheData;
import cubrid.jdbc.jci.UStmtCache;
import cubrid.jdbc.jci.UUType;
import cubrid.jdbc.jci.UUpdateParameter;
import cubrid.jdbc.jci.UUrlCache;
import cubrid.sql.CUBRIDOID;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UStatement {
    public static final int CURSOR_SET = 0;
    public static final int CURSOR_CUR = 1;
    public static final int CURSOR_END = 2;
    public static final byte QUERY_INFO_PLAN = 1;
    private static final byte ASYNC_EXECUTE = 1;
    private static final byte NORMAL = 0;
    private static final byte GET_BY_OID = 1;
    private static final byte GET_SCHEMA_INFO = 2;
    private static final byte GET_AUTOINCREMENT_KEYS = 3;
    private static final byte TRUE = -128;
    private static final byte FALSE = 0;
    private static final int DEFAULT_FETCH_SIZE = 100;
    private static final byte EXEC_FLAG_ASYNC = 1;
    private static final byte EXEC_FLAG_QUERY_ALL = 2;
    private static final byte EXEC_FLAG_QUERY_INFO = 4;
    private static final byte EXEC_FLAG_ONLY_QUERY_PLAN = 8;
    private byte statementType;
    private UConnection relatedConnection;
    private boolean isClosed;
    private boolean realFetched;
    private boolean isUpdatable;
    private boolean isSensitive;
    private int serverHandler;
    private int parameterNumber;
    private int columnNumber;
    private UBindParameter bindParameter;
    private ArrayList batchParameter;
    private UColumnInfo[] columnInfo;
    private HashMap<String, Integer> colNameToIndex;
    private UResultInfo[] resultInfo;
    private byte commandTypeIs;
    private byte executeFlag;
    private String className;
    private int fetchDirection;
    private int fetchSize;
    private int maxFetchSize;
    private int fetchedTupleNumber;
    private int totalTupleNumber;
    private int currentFirstCursor;
    private int cursorPosition;
    private int executeResult;
    private UResultTuple[] tuples;
    private int numQueriesExecuted;
    private UError errorHandler;
    private UOutputBuffer outBuffer;
    private int schemaType;
    private boolean isReturnable = false;
    private String sql_stmt;
    private byte prepare_flag;
    private UInputBuffer tmp_inbuffer;
    private boolean isAutoCommit = false;
    private boolean isGeneratedKeys = false;
    public int result_cache_lifetime;
    private boolean result_cacheable = false;
    private UStmtCache stmt_cache;

    UStatement(UConnection uConnection, UInputBuffer uInputBuffer, boolean bl, String string, byte by) throws IOException, UJciException {
        this.errorHandler = new UError();
        if (bl) {
            this.relatedConnection = uConnection;
            this.tmp_inbuffer = uInputBuffer;
            this.sql_stmt = string;
            this.prepare_flag = by;
        } else {
            this.init(uConnection, uInputBuffer, string, by, true);
        }
        if (this.result_cacheable && (this.prepare_flag & 1) == 0 && (this.prepare_flag & 2) == 0) {
            UUrlCache uUrlCache = uConnection.getUrlCache();
            this.stmt_cache = uUrlCache.getStmtCache(string);
        }
    }

    private void init(UConnection uConnection, UInputBuffer uInputBuffer, String string, byte by, boolean bl) throws IOException, UJciException {
        this.sql_stmt = string;
        this.prepare_flag = by;
        this.outBuffer = uConnection.outBuffer;
        this.statementType = 0;
        this.relatedConnection = uConnection;
        this.serverHandler = uInputBuffer.getResCode();
        this.result_cache_lifetime = uInputBuffer.readInt();
        if (this.result_cache_lifetime >= 0 && UJCIManager.result_cache_enable) {
            this.result_cacheable = true;
        }
        this.commandTypeIs = uInputBuffer.readByte();
        this.parameterNumber = uInputBuffer.readInt();
        this.isUpdatable = uInputBuffer.readByte() == 1;
        this.columnNumber = uInputBuffer.readInt();
        this.readColumnInfo(uInputBuffer);
        if (bl) {
            this.bindParameter = this.parameterNumber > 0 ? new UBindParameter(this.parameterNumber) : null;
            this.batchParameter = null;
        }
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
        if (this.commandTypeIs == 126) {
            this.columnNumber = this.parameterNumber + 1;
        }
    }

    UStatement(UConnection uConnection, CUBRIDOID cUBRIDOID, String[] stringArray, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.outBuffer = uConnection.outBuffer;
        this.statementType = 1;
        this.relatedConnection = uConnection;
        this.errorHandler = new UError();
        this.serverHandler = -1;
        this.className = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
        this.columnNumber = uInputBuffer.readInt();
        this.readColumnInfo(uInputBuffer);
        this.fetchSize = 1;
        this.tuples = new UResultTuple[this.fetchSize];
        this.readATupleByOid(cUBRIDOID, uInputBuffer);
        this.bindParameter = null;
        this.batchParameter = null;
        this.fetchedTupleNumber = 1;
        this.totalTupleNumber = 1;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isUpdatable = false;
        this.isClosed = false;
    }

    UStatement(UConnection uConnection, String string, String string2, int n, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.outBuffer = uConnection.outBuffer;
        this.statementType = (byte)2;
        this.relatedConnection = uConnection;
        this.className = string;
        this.schemaType = n;
        this.errorHandler = new UError();
        this.serverHandler = uInputBuffer.getResCode();
        this.totalTupleNumber = uInputBuffer.readInt();
        this.columnNumber = uInputBuffer.readInt();
        this.readColumnInfo(uInputBuffer);
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.bindParameter = null;
        this.batchParameter = null;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isUpdatable = false;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UStatement(UConnection uConnection, int n) throws Exception {
        UInputBuffer uInputBuffer;
        this.relatedConnection = uConnection;
        this.outBuffer = uConnection.outBuffer;
        this.statementType = 0;
        this.errorHandler = new UError();
        this.bindParameter = null;
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
        UConnection uConnection2 = uConnection;
        synchronized (uConnection2) {
            this.outBuffer.newRequest((byte)33);
            this.outBuffer.addInt(n);
            uInputBuffer = uConnection.send_recv_msg();
        }
        this.serverHandler = uInputBuffer.readInt();
        this.commandTypeIs = uInputBuffer.readByte();
        this.totalTupleNumber = uInputBuffer.readInt();
        this.isUpdatable = uInputBuffer.readByte() == 1;
        this.columnNumber = uInputBuffer.readInt();
        this.readColumnInfo(uInputBuffer);
        this.executeResult = this.totalTupleNumber;
    }

    public UStatement(UStatement uStatement) {
        this.serverHandler = uStatement.serverHandler;
        this.relatedConnection = uStatement.relatedConnection;
        this.outBuffer = uStatement.outBuffer;
        this.statementType = 0;
        this.errorHandler = new UError();
        this.bindParameter = null;
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
    }

    public UResCache getResCache() {
        UBindKey uBindKey = this.bindParameter == null ? new UBindKey(null) : new UBindKey(this.bindParameter.values);
        return this.stmt_cache.get(uBindKey);
    }

    public int getParameterCount() {
        return this.parameterNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n < 0 || n >= this.parameterNumber) {
            this.errorHandler.setErrorCode(6);
            return;
        }
        UBindParameter uBindParameter = this.bindParameter;
        synchronized (uBindParameter) {
            try {
                this.bindParameter.setOutParam(n);
            }
            catch (UJciException uJciException) {
                uJciException.toUError(this.errorHandler);
            }
        }
    }

    public void bind(int n, boolean bl) {
        Byte by = new Byte(bl ? (byte)-128 : 0);
        this.bindValue(n, (byte)5, by);
    }

    public void bind(int n, byte by) {
        Short s = new Short(by);
        this.bindValue(n, (byte)9, s);
    }

    public void bind(int n, short s) {
        Short s2 = new Short(s);
        this.bindValue(n, (byte)9, s2);
    }

    public void bind(int n, int n2) {
        Integer n3 = new Integer(n2);
        this.bindValue(n, (byte)8, n3);
    }

    public void bind(int n, long l) {
        Long l2 = new Long(l);
        this.bindValue(n, (byte)21, l2);
    }

    public void bind(int n, float f) {
        Float f2 = new Float(f);
        this.bindValue(n, (byte)11, f2);
    }

    public void bind(int n, double d) {
        Double d2 = new Double(d);
        this.bindValue(n, (byte)12, d2);
    }

    public void bind(int n, BigDecimal bigDecimal) {
        this.bindValue(n, (byte)7, bigDecimal);
    }

    public void bind(int n, String string) {
        this.bindValue(n, (byte)2, string);
    }

    public void bind(int n, byte[] byArray) {
        byte[] byArray2 = byArray == null ? null : (byte[])byArray.clone();
        this.bindValue(n, (byte)6, byArray2);
    }

    public void bind(int n, Date date) {
        this.bindValue(n, (byte)13, date);
    }

    public void bind(int n, Time time) {
        this.bindValue(n, (byte)14, time);
    }

    public void bind(int n, Timestamp timestamp) {
        byte by = UUType.getObjectDBtype(timestamp);
        this.bindValue(n, by, timestamp);
    }

    public void bind(int n, Object object) {
        byte by = UUType.getObjectDBtype(object);
        if (by == 18) {
            this.bindCollection(n, (Object[])object);
            return;
        }
        if (by == 0 && object != null) {
            this.errorHandler = new UError();
            this.errorHandler.setErrorCode(16);
            return;
        }
        this.bindValue(n, by, object);
    }

    public void bindCollection(int n, Object[] objectArray) {
        CUBRIDArray cUBRIDArray;
        if (objectArray == null) {
            cUBRIDArray = null;
        } else {
            try {
                cUBRIDArray = new CUBRIDArray(objectArray);
            }
            catch (UJciException uJciException) {
                this.errorHandler = new UError();
                uJciException.toUError(this.errorHandler);
                return;
            }
        }
        this.bindValue(n, (byte)18, cUBRIDArray);
    }

    public void bindOID(int n, CUBRIDOID cUBRIDOID) {
        this.bindValue(n, (byte)19, cUBRIDOID);
    }

    public void bindBlob(int n, Blob blob) {
        this.bindValue(n, (byte)23, blob);
    }

    public void bindClob(int n, Clob clob) {
        this.bindValue(n, (byte)24, clob);
    }

    public void addBatch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.bindParameter == null) {
            return;
        }
        if (!this.bindParameter.checkAllBinded()) {
            this.errorHandler.setErrorCode(7);
            return;
        }
        if (this.batchParameter == null) {
            this.batchParameter = new ArrayList();
        }
        this.batchParameter.add(this.bindParameter);
        this.bindParameter = new UBindParameter(this.parameterNumber);
    }

    public void bindNull(int n) {
        this.bindValue(n, (byte)0, null);
    }

    public UError cancel() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            return uError;
        }
        if (this.statementType == 1) {
            return uError;
        }
        try {
            this.relatedConnection.cancel();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(uError);
        }
        catch (IOException iOException) {
            uError.setErrorCode(3);
        }
        return uError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.batchParameter == null) {
            return;
        }
        ArrayList arrayList = this.batchParameter;
        synchronized (arrayList) {
            this.batchParameter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearBind() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.bindParameter == null) {
            return;
        }
        UBindParameter uBindParameter = this.bindParameter;
        synchronized (uBindParameter) {
            this.bindParameter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean bl) {
        try {
            this.errorHandler = new UError();
            if (this.isClosed) {
                this.errorHandler.setErrorCode(17);
                return;
            }
            this.relatedConnection.pooled_ustmts.remove(this);
            if (!this.isReturnable && bl && (!this.relatedConnection.getAutoCommit() || this.relatedConnection.brokerInfoStatementPooling())) {
                this.relatedConnection.deferred_close_handle.add(new Integer(this.serverHandler));
            }
        }
        finally {
            this.fetchedTupleNumber = 0;
            this.totalTupleNumber = 0;
            this.cursorPosition = 0;
            this.currentFirstCursor = 0;
            this.isClosed = true;
            if (this.stmt_cache != null) {
                this.stmt_cache.decr_ref_count();
            }
        }
    }

    public synchronized void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cursorIsInstance(int n) {
        Object object;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return false;
        }
        if (this.currentFirstCursor < 0 || n < 0 || n >= 0 && (n < this.currentFirstCursor || n > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.errorHandler.setErrorCode(16);
            return false;
        }
        if (!this.tuples[this.cursorPosition - this.currentFirstCursor].oidIsIncluded()) {
            this.errorHandler.setErrorCode(21);
            return false;
        }
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            object = this.relatedConnection.oidCmd(this.tuples[this.cursorPosition - this.currentFirstCursor].getOid(), (byte)2);
        }
        this.errorHandler.copyValue(this.relatedConnection.getRecentError());
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteCursor(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.currentFirstCursor < 0 || n < 0 || n >= 0 && (n < this.currentFirstCursor || n > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        if (!this.tuples[this.cursorPosition - this.currentFirstCursor].oidIsIncluded()) {
            this.errorHandler.setErrorCode(21);
            return;
        }
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            this.relatedConnection.oidCmd(this.tuples[this.cursorPosition - this.currentFirstCursor].getOid(), (byte)1);
        }
        this.errorHandler.copyValue(this.relatedConnection.getRecentError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(boolean bl, int n, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, UStatementCacheData uStatementCacheData) {
        Object object;
        Object object2;
        this.flushLobStreams();
        UInputBuffer uInputBuffer = null;
        this.errorHandler = new UError();
        boolean bl7 = true;
        if (this.isClosed) {
            if (this.relatedConnection.brokerInfoStatementPooling()) {
                bl7 = false;
                object2 = this.relatedConnection.prepare(this.sql_stmt, this.prepare_flag, true);
                this.relatedConnection.pooled_ustmts.remove(object2);
                this.relatedConnection.pooled_ustmts.add(this);
                object = this.relatedConnection.getRecentError();
                if (((UError)object).getErrorCode() != 0) {
                    this.errorHandler.copyValue((UError)object);
                    return;
                }
                try {
                    this.init(this.relatedConnection, ((UStatement)object2).tmp_inbuffer, this.sql_stmt, this.prepare_flag, false);
                }
                catch (UJciException uJciException) {
                    uJciException.toUError(this.errorHandler);
                    return;
                }
                catch (IOException iOException) {
                    if (this.errorHandler.getErrorCode() != 13) {
                        this.errorHandler.setErrorCode(3);
                    }
                    return;
                }
            } else {
                this.errorHandler.setErrorCode(17);
                return;
            }
        }
        if (this.statementType == 2) {
            return;
        }
        if (this.bindParameter != null && !this.bindParameter.checkAllBinded()) {
            this.errorHandler.setErrorCode(7);
            return;
        }
        this.executeFlag = 0;
        if (bl2) {
            this.executeFlag = (byte)(this.executeFlag | 2);
        }
        if (bl) {
            this.executeFlag = (byte)(this.executeFlag | 1);
        }
        if (bl5) {
            this.executeFlag = (byte)(this.executeFlag | 4);
        }
        if (bl6) {
            this.executeFlag = (byte)(this.executeFlag | 0xC);
        }
        this.currentFirstCursor = -1;
        this.fetchedTupleNumber = 0;
        this.maxFetchSize = n;
        try {
            object2 = this.relatedConnection;
            synchronized (object2) {
                if (this.relatedConnection.brokerInfoStatementPooling()) {
                    this.relatedConnection.skip_checkcas = true;
                    this.relatedConnection.need_checkcas = false;
                    this.relatedConnection.checkReconnect();
                }
                this.outBuffer.newRequest((byte)3);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addByte(this.executeFlag);
                this.outBuffer.addInt(n2 < 0 ? 0 : n2);
                this.outBuffer.addInt(0);
                if (this.commandTypeIs == 126 && this.bindParameter != null) {
                    this.outBuffer.addBytes(this.bindParameter.paramMode);
                } else {
                    this.outBuffer.addNull();
                }
                if (this.commandTypeIs == 21) {
                    this.outBuffer.addByte((byte)1);
                } else {
                    this.outBuffer.addByte((byte)0);
                }
                this.outBuffer.addByte(this.relatedConnection.getAutoCommit() && !this.isGeneratedKeys ? (byte)1 : 0);
                this.outBuffer.addByte(!bl4 ? (byte)1 : 0);
                this.outBuffer.addCacheTime(uStatementCacheData);
                if (this.bindParameter != null) {
                    object = this.bindParameter;
                    synchronized (object) {
                        this.bindParameter.writeParameter(this.outBuffer);
                    }
                }
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            byte by = uInputBuffer.readByte();
            if (uStatementCacheData != null && by == 1) {
                this.setCacheData(uStatementCacheData);
                return;
            }
            this.readResultInfo(uInputBuffer);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        finally {
            this.relatedConnection.skip_checkcas = false;
        }
        if (this.errorHandler.getErrorCode() != 0) {
            if (this.errorHandler.getJdbcErrorCode() == -111) {
                this.relatedConnection.need_checkcas = true;
            }
            if (this.relatedConnection.brokerInfoStatementPooling() && bl7) {
                if (this.errorHandler.getJdbcErrorCode() == -1024) {
                    this.close();
                } else if (this.relatedConnection.need_checkcas && !this.relatedConnection.check_cas()) {
                    try {
                        this.relatedConnection.clientSocketClose();
                    }
                    catch (Exception exception) {}
                } else {
                    return;
                }
                this.errorHandler.clear();
                this.execute(bl, n, n2, bl2, bl3, bl4, bl5, bl6, uStatementCacheData);
                return;
            }
            if (this.relatedConnection.need_checkcas && !this.relatedConnection.check_cas()) {
                try {
                    this.relatedConnection.clientSocketClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.errorHandler.clear();
                this.execute(bl, n, n2, bl2, bl3, bl4, bl5, bl6, uStatementCacheData);
            }
            return;
        }
        this.cursorPosition = -1;
        if (this.commandTypeIs == 126) {
            this.cursorPosition = 0;
        }
        this.executeResult = uInputBuffer.getResCode();
        this.errorHandler.setErrorCode(0);
        this.executeResult = this.maxFetchSize > 0 && this.executeResult > this.maxFetchSize ? this.maxFetchSize : this.executeResult;
        this.totalTupleNumber = this.executeResult;
        this.batchParameter = null;
        this.isSensitive = bl3;
        try {
            if (this.commandTypeIs == 21 && this.totalTupleNumber > 0) {
                int n3 = uInputBuffer.readInt();
                this.read_fetch_data(uInputBuffer);
            }
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        for (int i = 0; i < this.resultInfo.length; ++i) {
            if (this.resultInfo[i].statementType == 21) continue;
            this.relatedConnection.update_executed = true;
            break;
        }
        if (uStatementCacheData != null && this.fetchedTupleNumber == this.totalTupleNumber && this.resultInfo.length == 1) {
            uStatementCacheData.setCacheData(this.totalTupleNumber, this.tuples, this.resultInfo);
        } else if (this.resultInfo.length > 1) {
            this.result_cacheable = false;
        }
    }

    public synchronized CUBRIDOID executeInsert(boolean bl) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (this.commandTypeIs != 20) {
            this.errorHandler.setErrorCode(22);
            return null;
        }
        this.execute(bl, 0, 0, false, false, false, false, false, null);
        if (this.errorHandler.getErrorCode() != 0) {
            return null;
        }
        if (this.resultInfo != null && this.resultInfo[0] != null) {
            return this.resultInfo[0].getCUBRIDOID();
        }
        this.errorHandler.setErrorCode(21);
        return null;
    }

    public synchronized void setAutoCommit(boolean bl) {
        this.isAutoCommit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UBatchResult executeBatch() {
        this.errorHandler = new UError();
        try {
            UInputBuffer uInputBuffer;
            Object object = this.relatedConnection;
            synchronized (object) {
                Object object2;
                this.relatedConnection.checkReconnect();
                if (this.isClosed) {
                    if (this.relatedConnection.brokerInfoStatementPooling()) {
                        object2 = this.relatedConnection.prepare(this.sql_stmt, this.prepare_flag, true);
                        this.relatedConnection.pooled_ustmts.remove(object2);
                        this.relatedConnection.pooled_ustmts.add(this);
                        UError uError = this.relatedConnection.getRecentError();
                        if (uError.getErrorCode() != 0) {
                            this.errorHandler.copyValue(uError);
                            return null;
                        }
                        try {
                            this.init(this.relatedConnection, ((UStatement)object2).tmp_inbuffer, this.sql_stmt, this.prepare_flag, false);
                        }
                        catch (UJciException uJciException) {
                            uJciException.toUError(this.errorHandler);
                            return null;
                        }
                        catch (IOException iOException) {
                            if (this.errorHandler.getErrorCode() != 13) {
                                this.errorHandler.setErrorCode(3);
                            }
                            return null;
                        }
                    } else {
                        this.errorHandler.setErrorCode(17);
                        return null;
                    }
                }
                this.outBuffer.newRequest(this.relatedConnection.getOutputStream(), (byte)21);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addByte(this.isAutoCommit ? (byte)1 : 0);
                if (this.batchParameter != null) {
                    object2 = this.batchParameter;
                    synchronized (object2) {
                        for (int i = 0; i < this.batchParameter.size(); ++i) {
                            UBindParameter uBindParameter = (UBindParameter)this.batchParameter.get(i);
                            uBindParameter.writeParameter(this.outBuffer);
                        }
                    }
                }
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.batchParameter = null;
            object = new UBatchResult(uInputBuffer.readInt());
            for (int i = 0; i < ((UBatchResult)object).getResultNumber(); ++i) {
                ((UBatchResult)object).setStatementType(i, this.statementType);
                int n = uInputBuffer.readInt();
                if (n < 0) {
                    ((UBatchResult)object).setResultError(i, n, uInputBuffer.readString(uInputBuffer.readInt(), UJCIManager.sysCharsetName));
                    continue;
                }
                ((UBatchResult)object).setResult(i, n);
                uInputBuffer.readInt();
                uInputBuffer.readShort();
                uInputBuffer.readShort();
            }
            return object;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return null;
        }
    }

    public synchronized void fetch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        this.realFetched = false;
        if (this.statementType == 1) {
            return;
        }
        if (this.cursorPosition < 0 || this.executeFlag != 1 && this.totalTupleNumber <= 0) {
            this.errorHandler.setErrorCode(4);
            return;
        }
        if (this.currentFirstCursor >= 0 && this.currentFirstCursor <= this.cursorPosition && this.cursorPosition <= this.currentFirstCursor + this.fetchedTupleNumber - 1) {
            return;
        }
        this.reFetch();
    }

    public synchronized BigDecimal getBigDecimal(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getBigDecimal(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized boolean getBoolean(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return false;
        }
        try {
            return UGetTypeConvertedValue.getBoolean(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return false;
        }
    }

    public synchronized byte getByte(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getByte(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0;
        }
    }

    public synchronized byte[] getBytes(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getBytes(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Object getCollection(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        if (!(object instanceof CUBRIDArray)) {
            this.errorHandler.setErrorCode(5);
            return null;
        }
        return ((CUBRIDArray)object).getArrayClone();
    }

    public UColumnInfo[] getColumnInfo() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return null;
        }
        this.errorHandler = uError;
        return this.columnInfo;
    }

    public HashMap<String, Integer> getColumnNameToIndexMap() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return null;
        }
        this.errorHandler = uError;
        return this.colNameToIndex;
    }

    public synchronized CUBRIDOID getColumnOID(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        if (!(object instanceof CUBRIDOID)) {
            this.errorHandler.setErrorCode(1);
            return null;
        }
        return (CUBRIDOID)object;
    }

    public synchronized CUBRIDOID getCursorOID() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (!this.checkReFetch()) {
            return null;
        }
        return this.tuples[this.cursorPosition - this.currentFirstCursor].getOid();
    }

    public synchronized CUBRIDBlob getBlob(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        if (object instanceof CUBRIDBlob) {
            return (CUBRIDBlob)object;
        }
        this.errorHandler.setErrorCode(5);
        return null;
    }

    public synchronized CUBRIDClob getClob(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        if (object instanceof CUBRIDClob) {
            return (CUBRIDClob)object;
        }
        this.errorHandler.setErrorCode(5);
        return null;
    }

    public synchronized Date getDate(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getDate(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized double getDouble(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0.0;
        }
        try {
            return UGetTypeConvertedValue.getDouble(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0.0;
        }
    }

    public int getExecuteResult() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return 0;
        }
        this.errorHandler = uError;
        return this.executeResult;
    }

    public int getFetchDirection() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return 0;
        }
        this.errorHandler = uError;
        return this.fetchDirection;
    }

    public int getFetchSize() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return 0;
        }
        this.errorHandler = uError;
        return this.fetchSize;
    }

    public synchronized float getFloat(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0.0f;
        }
        try {
            return UGetTypeConvertedValue.getFloat(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0.0f;
        }
    }

    public synchronized int getInt(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getInt(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0;
        }
    }

    public synchronized long getLong(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0L;
        }
        try {
            return UGetTypeConvertedValue.getLong(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0L;
        }
    }

    public synchronized Object getObject(int n) {
        Object object;
        this.errorHandler = new UError();
        Object object2 = this.beforeGetXXX(n);
        if (object2 == null) {
            return null;
        }
        try {
            if (this.commandTypeIs != 126 && this.columnInfo[n].getColumnType() == 5 && this.columnInfo[n].getColumnPrecision() == 8) {
                object = new Boolean(UGetTypeConvertedValue.getBoolean(object2));
            } else if (object2 instanceof CUBRIDArray) {
                object = ((CUBRIDArray)object2).getArrayClone();
            } else if (object2 instanceof byte[]) {
                object = ((byte[])object2).clone();
            } else if (object2 instanceof Date) {
                object = ((Date)object2).clone();
            } else if (object2 instanceof Time) {
                object = ((Time)object2).clone();
            } else if (object2 instanceof Timestamp) {
                object = ((Timestamp)object2).clone();
            } else if (object2 instanceof CUBRIDOutResultSet) {
                try {
                    ((CUBRIDOutResultSet)object2).createInstance();
                    object = object2;
                }
                catch (Exception exception) {
                    object = null;
                }
            } else {
                object = object2;
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        return object;
    }

    public UError getRecentError() {
        return this.errorHandler;
    }

    public UResultInfo[] getResultInfo() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return null;
        }
        this.errorHandler = uError;
        return this.resultInfo;
    }

    public synchronized short getShort(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getShort(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0;
        }
    }

    public boolean getSqlType() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return false;
        }
        if (this.commandTypeIs == 21 || this.commandTypeIs == 24 || this.commandTypeIs == 41 || this.commandTypeIs == 14) {
            this.errorHandler = uError;
            return true;
        }
        this.errorHandler = uError;
        return false;
    }

    public synchronized String getString(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getString(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Time getTime(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getTime(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Timestamp getTimestamp(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getTimestamp(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isOIDIncluded() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return false;
        }
        this.errorHandler = uError;
        return this.isUpdatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveCursor(int n, int n2) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n2 != 0 && n2 != 1 && n2 != 2 || this.executeFlag != 1 && this.totalTupleNumber == 0) {
            this.errorHandler.setErrorCode(4);
            return;
        }
        int n3 = this.cursorPosition;
        if (n2 == 0) {
            this.cursorPosition = n;
        } else if (n2 == 1) {
            this.cursorPosition += n;
        }
        if (n2 == 0 || n2 == 1) {
            if (this.executeFlag == 1) {
                if (this.cursorPosition <= this.currentFirstCursor + this.fetchedTupleNumber - 1 || this.totalTupleNumber != 0 && this.cursorPosition < this.totalTupleNumber) {
                    return;
                }
            } else {
                if (this.cursorPosition < this.totalTupleNumber) {
                    return;
                }
                this.errorHandler.setErrorCode(4);
                this.cursorPosition = n3;
                return;
            }
        }
        if (n2 == 2 && this.totalTupleNumber != 0) {
            this.cursorPosition = this.totalTupleNumber - n - 1;
            if (this.cursorPosition >= 0) {
                return;
            }
            this.errorHandler.setErrorCode(4);
            this.cursorPosition = n3;
            return;
        }
        if (n2 == 1) {
            n2 = 0;
            n += n3;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)7);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(n);
                this.outBuffer.addInt(n2);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.totalTupleNumber = uInputBuffer.readInt();
        }
        catch (UJciException uJciException) {
            this.cursorPosition = n3;
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            this.cursorPosition = n3;
            this.errorHandler.setErrorCode(3);
            return;
        }
        if (this.totalTupleNumber < 0) {
            this.totalTupleNumber = 0;
        } else if (this.totalTupleNumber <= this.cursorPosition) {
            this.errorHandler.setErrorCode(4);
            this.cursorPosition = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean nextResult() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return false;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)19);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(0);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.closeInternal();
            this.executeResult = uInputBuffer.readInt();
            this.commandTypeIs = uInputBuffer.readByte();
            this.isUpdatable = uInputBuffer.readByte() == 1;
            this.columnNumber = uInputBuffer.readInt();
            this.readColumnInfo(uInputBuffer);
        }
        catch (UJciException uJciException) {
            this.closeInternal();
            uJciException.toUError(this.errorHandler);
            return false;
        }
        catch (IOException iOException) {
            this.closeInternal();
            this.errorHandler.setErrorCode(3);
            return false;
        }
        this.fetchedTupleNumber = 0;
        this.cursorPosition = -1;
        this.currentFirstCursor = -1;
        this.executeResult = this.maxFetchSize > 0 && this.executeResult > this.maxFetchSize ? this.maxFetchSize : this.executeResult;
        this.totalTupleNumber = this.executeResult;
        this.realFetched = false;
        return true;
    }

    public boolean realFetched() {
        return this.realFetched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reFetch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.statementType == 1) {
            return;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)8);
                this.outBuffer.addInt(this.serverHandler);
                if (this.fetchDirection == 1001) {
                    int n = this.cursorPosition - this.fetchSize + 2;
                    if (n < 1) {
                        n = 1;
                    }
                    this.outBuffer.addInt(n);
                } else {
                    this.outBuffer.addInt(this.cursorPosition + 1);
                }
                this.outBuffer.addInt(this.fetchSize);
                this.outBuffer.addByte(this.isSensitive ? (byte)1 : 0);
                this.outBuffer.addInt(0);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.read_fetch_data(uInputBuffer);
            this.realFetched = true;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized void setFetchDirection(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n != 1000 && n != 1001 && n != 1002) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        this.fetchDirection = n;
    }

    public synchronized void setFetchSize(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n < 0) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        this.fetchSize = n == 0 ? 100 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRows(int n, int[] nArray, Object[] objectArray) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            UUpdateParameter uUpdateParameter = new UUpdateParameter(this.columnInfo, nArray, objectArray);
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)22);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(n + 1);
                uUpdateParameter.writeParameter(this.outBuffer);
                UInputBuffer uInputBuffer = this.relatedConnection.send_recv_msg();
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized byte getCommandType() {
        return this.commandTypeIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getQueryplan() {
        String string = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)24);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addByte((byte)1);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            string = uInputBuffer.readString(uInputBuffer.remainedCapacity(), this.relatedConnection.conCharsetName);
        }
        catch (UJciException uJciException) {
            this.closeInternal();
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            this.closeInternal();
            this.errorHandler.setErrorCode(3);
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getGeneratedKeys() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return false;
        }
        try {
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)34);
                this.outBuffer.addInt(this.serverHandler);
                UInputBuffer uInputBuffer = this.relatedConnection.send_recv_msg();
                this.commandTypeIs = uInputBuffer.readByte();
                this.totalTupleNumber = uInputBuffer.readInt();
                this.isUpdatable = uInputBuffer.readByte() == 1;
                this.columnNumber = uInputBuffer.readInt();
                this.statementType = (byte)3;
                this.readColumnInfo(uInputBuffer);
                this.executeResult = this.totalTupleNumber;
                this.read_fetch_data(uInputBuffer);
            }
        }
        catch (UJciException uJciException) {
            this.closeInternal();
            uJciException.toUError(this.errorHandler);
            return false;
        }
        catch (IOException iOException) {
            this.closeInternal();
            this.errorHandler.setErrorCode(3);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindValue(int n, byte by, Object object) {
        UError uError = new UError();
        if (this.bindParameter == null || n < 0 || n >= this.parameterNumber) {
            uError.setErrorCode(6);
            this.errorHandler = uError;
            return;
        }
        try {
            UBindParameter uBindParameter = this.bindParameter;
            synchronized (uBindParameter) {
                this.bindParameter.setParameter(n, by, object);
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(uError);
        }
        this.errorHandler = uError;
    }

    private Object beforeGetXXX(int n) {
        Object object;
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (n < 0 || n >= this.columnNumber) {
            this.errorHandler.setErrorCode(9);
            return null;
        }
        if (!this.checkReFetch()) {
            return null;
        }
        if (this.fetchedTupleNumber <= 0) {
            this.errorHandler.setErrorCode(4);
            return null;
        }
        if (this.tuples == null || this.tuples[this.cursorPosition - this.currentFirstCursor] == null || (object = this.tuples[this.cursorPosition - this.currentFirstCursor].getAttribute(n)) == null) {
            this.errorHandler.setErrorCode(8);
            return null;
        }
        return object;
    }

    private boolean checkReFetch() {
        if (this.currentFirstCursor < 0 || this.cursorPosition >= 0 && (this.cursorPosition < this.currentFirstCursor || this.cursorPosition > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.fetch();
            if (this.errorHandler.getErrorCode() != 0) {
                return false;
            }
        }
        return true;
    }

    private byte readTypeFromData(int n, UInputBuffer uInputBuffer) throws UJciException {
        if (this.commandTypeIs == 24 || this.commandTypeIs == 14 || this.commandTypeIs == 126 || this.columnInfo[n].getColumnType() == 0) {
            return uInputBuffer.readByte();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeInternal() {
        int n;
        Object object;
        if (this.columnInfo != null) {
            object = this.columnInfo;
            // MONITORENTER : this.columnInfo
            for (n = 0; n < this.columnInfo.length; ++n) {
                this.columnInfo[n] = null;
            }
            // MONITOREXIT : object
            this.columnInfo = null;
            this.colNameToIndex.clear();
            this.colNameToIndex = null;
        }
        if (this.bindParameter != null) {
            object = this.bindParameter;
            // MONITORENTER : object
            this.bindParameter.close();
            // MONITOREXIT : object
            this.bindParameter = null;
        }
        if (this.tuples == null) return;
        object = this.tuples;
        // MONITORENTER : this.tuples
        n = 0;
        while (true) {
            if (n >= this.tuples.length) {
                // MONITOREXIT : object
                this.tuples = null;
                return;
            }
            if (this.tuples[n] != null) {
                this.tuples[n].close();
                this.tuples[n] = null;
            }
            ++n;
        }
    }

    private void confirmSchemaTypeInfo(int n) {
        if (this.statementType != 2) {
            return;
        }
        switch (this.schemaType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Short s = (Short)this.tuples[n].getAttribute(1);
                byte[] byArray = UColumnInfo.confirmType(s.byteValue());
                this.tuples[n].setAttribute(1, new Short(byArray[0]));
            }
        }
    }

    private Object readAAttribute(int n, UInputBuffer uInputBuffer) throws IOException, UJciException {
        int n2 = uInputBuffer.readInt();
        if (n2 <= 0) {
            return null;
        }
        byte by = this.readTypeFromData(n, uInputBuffer);
        if (by == 0) {
            by = this.columnInfo[n].getColumnType();
        } else {
            --n2;
        }
        return this.readData(uInputBuffer, by, n2);
    }

    private Object readData(UInputBuffer uInputBuffer, int n, int n2) throws IOException, UJciException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return uInputBuffer.readString(n2, this.relatedConnection.conCharsetName);
            }
            case 7: {
                return new BigDecimal(uInputBuffer.readString(n2, UJCIManager.sysCharsetName));
            }
            case 21: {
                return new Long(uInputBuffer.readLong());
            }
            case 8: {
                return new Integer(uInputBuffer.readInt());
            }
            case 9: {
                return new Short(uInputBuffer.readShort());
            }
            case 13: {
                return uInputBuffer.readDate();
            }
            case 14: {
                return uInputBuffer.readTime();
            }
            case 15: {
                return uInputBuffer.readTimestamp();
            }
            case 22: {
                return uInputBuffer.readDatetime();
            }
            case 19: {
                return uInputBuffer.readOID(this.relatedConnection.cubridcon);
            }
            case 16: 
            case 17: 
            case 18: {
                CUBRIDArray cUBRIDArray = new CUBRIDArray(uInputBuffer.readByte(), uInputBuffer.readInt());
                int n3 = cUBRIDArray.getBaseType();
                for (int i = 0; i < cUBRIDArray.getLength(); ++i) {
                    int n4 = uInputBuffer.readInt();
                    if (n4 <= 0) {
                        cUBRIDArray.setElement(i, null);
                        continue;
                    }
                    cUBRIDArray.setElement(i, this.readData(uInputBuffer, n3, n4));
                }
                return cUBRIDArray;
            }
            case 10: 
            case 12: {
                return new Double(uInputBuffer.readDouble());
            }
            case 11: {
                return new Float(uInputBuffer.readFloat());
            }
            case 5: 
            case 6: {
                return uInputBuffer.readBytes(n2);
            }
            case 20: {
                return new CUBRIDOutResultSet(this.relatedConnection, uInputBuffer.readInt());
            }
            case 23: {
                return uInputBuffer.readBlob(n2, this.relatedConnection.cubridcon);
            }
            case 24: {
                return uInputBuffer.readClob(n2, this.relatedConnection.cubridcon);
            }
        }
        return null;
    }

    private void read_fetch_data(UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.fetchedTupleNumber = uInputBuffer.readInt();
        if (this.fetchedTupleNumber < 0) {
            this.fetchedTupleNumber = 0;
        }
        this.tuples = new UResultTuple[this.fetchedTupleNumber];
        for (int i = 0; i < this.fetchedTupleNumber; ++i) {
            this.readATuple(i, uInputBuffer);
        }
    }

    private void readATupleByOid(CUBRIDOID cUBRIDOID, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.tuples[0] = new UResultTuple(1, this.columnNumber);
        this.tuples[0].setOid(cUBRIDOID);
        for (int i = 0; i < this.columnNumber; ++i) {
            this.tuples[0].setAttribute(i, this.readAAttribute(i, uInputBuffer));
        }
        this.currentFirstCursor = 0;
    }

    private void readATuple(int n, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.tuples[n] = new UResultTuple(uInputBuffer.readInt(), this.columnNumber);
        this.tuples[n].setOid(uInputBuffer.readOID(this.relatedConnection.cubridcon));
        for (int i = 0; i < this.columnNumber; ++i) {
            this.tuples[n].setAttribute(i, this.readAAttribute(i, uInputBuffer));
        }
        this.confirmSchemaTypeInfo(n);
        if (n == 0) {
            this.currentFirstCursor = this.tuples[n].tupleNumber() - 1;
        }
    }

    private void readColumnInfo(UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.columnInfo = new UColumnInfo[this.columnNumber];
        this.colNameToIndex = new HashMap(this.columnNumber);
        for (int i = 0; i < this.columnNumber; ++i) {
            byte by = uInputBuffer.readByte();
            short s = uInputBuffer.readShort();
            int n = uInputBuffer.readInt();
            String string = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
            this.columnInfo[i] = new UColumnInfo(by, s, n, string);
            if (this.statementType == 0) {
                String string2 = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
                String string3 = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
                byte by2 = uInputBuffer.readByte();
                this.columnInfo[i].setRemainedData(string2, string3, by2 == 0);
                String string4 = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
                byte by3 = uInputBuffer.readByte();
                byte by4 = uInputBuffer.readByte();
                byte by5 = uInputBuffer.readByte();
                byte by6 = uInputBuffer.readByte();
                byte by7 = uInputBuffer.readByte();
                byte by8 = uInputBuffer.readByte();
                byte by9 = uInputBuffer.readByte();
                this.columnInfo[i].setExtraData(string4, by3, by4, by5, by8, by6, by7, by9);
            }
            this.colNameToIndex.put(string.toLowerCase(), i);
        }
    }

    private void readResultInfo(UInputBuffer uInputBuffer) throws UJciException {
        this.numQueriesExecuted = uInputBuffer.readInt();
        this.resultInfo = new UResultInfo[this.numQueriesExecuted];
        for (int i = 0; i < this.resultInfo.length; ++i) {
            this.resultInfo[i] = new UResultInfo(uInputBuffer.readByte(), uInputBuffer.readInt());
            this.resultInfo[i].setResultOid(uInputBuffer.readOID(this.relatedConnection.cubridcon));
            this.resultInfo[i].setSrvCacheTime(uInputBuffer.readInt(), uInputBuffer.readInt());
        }
    }

    public int getNumQueriesExecuted() {
        return this.numQueriesExecuted;
    }

    public int getServerHandle() {
        return this.serverHandler;
    }

    public void setReturnable() {
        this.isReturnable = true;
    }

    public boolean isReturnable() {
        return this.isReturnable;
    }

    public void setCacheData(UStatementCacheData uStatementCacheData) {
        this.totalTupleNumber = uStatementCacheData.tuple_count;
        this.tuples = uStatementCacheData.tuples;
        this.resultInfo = uStatementCacheData.resultInfo;
        this.currentFirstCursor = 0;
        this.cursorPosition = 0;
        this.fetchedTupleNumber = this.totalTupleNumber;
        this.executeResult = this.totalTupleNumber;
        this.realFetched = true;
    }

    public boolean is_result_cacheable() {
        return this.result_cacheable && !this.relatedConnection.update_executed;
    }

    public void setAutoGeneratedKeys(boolean bl) {
        this.isGeneratedKeys = bl;
    }

    protected void finalize() {
        if (this.stmt_cache != null) {
            this.stmt_cache.decr_ref_count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLobStreams() {
        if (this.bindParameter != null) {
            UBindParameter uBindParameter = this.bindParameter;
            synchronized (uBindParameter) {
                this.bindParameter.flushLobStreams();
            }
        }
    }
}

