/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UErrorCode;

class UJciException
extends Exception {
    private int jciErrCode;
    private int serverErrCode;
    private int serverErrIndicator;

    UJciException(int n) {
        this.jciErrCode = n;
    }

    UJciException(int n, int n2, int n3, String string) {
        super(string);
        this.jciErrCode = n;
        this.serverErrCode = n3;
        if (this.serverErrCode <= -10000) {
            this.serverErrCode = -10000 - this.serverErrCode;
        }
        this.serverErrIndicator = n2;
    }

    void toUError(UError uError) {
        if (this.jciErrCode == 2) {
            String string = this.serverErrIndicator == -2 ? this.getMessage() : UErrorCode.codeToCASMessage(this.serverErrCode);
            uError.setDBError(this.serverErrCode, string);
        } else if (this.jciErrCode == 23) {
            uError.setErrorMessage(this.jciErrCode, this.getMessage());
        } else {
            uError.setErrorCode(this.jciErrCode);
        }
    }

    public int getJciError() {
        return this.jciErrCode;
    }
}

