/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDXid;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJCIUtil;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UTimedInputStream;
import cubrid.sql.CUBRIDOID;
import cubrid.sql.CUBRIDTimestamp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;

class UInputBuffer {
    private UTimedInputStream input;
    private int position;
    private int capacity;
    private byte[] casinfo;
    private byte[] buffer;
    private int resCode;
    private static final int CAS_INFO_SIZE = 4;

    UInputBuffer(UTimedInputStream uTimedInputStream, UConnection uConnection) throws IOException, UJciException {
        this.input = uTimedInputStream;
        this.position = 0;
        int n = 0;
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; i += n) {
            n = this.input.read(byArray, i, 8 - i);
            if (n != -1) continue;
            throw new UJciException(19);
        }
        this.capacity = UJCIUtil.bytes2int(byArray, 0);
        if (this.capacity < 0) {
            this.capacity = 0;
            return;
        }
        this.casinfo = new byte[4];
        System.arraycopy(byArray, 4, this.casinfo, 0, 4);
        this.buffer = new byte[this.capacity];
        this.readData();
        this.resCode = this.readInt();
        uConnection.setCASInfo(this.casinfo);
        if (this.resCode < 0) {
            int n2 = this.readInt();
            String string = this.readString(this.remainedCapacity(), UJCIManager.sysCharsetName);
            throw new UJciException(2, this.resCode, n2, string);
        }
    }

    byte[] getCasInfo() {
        return this.casinfo;
    }

    int getResCode() {
        return this.resCode;
    }

    byte readByte() throws UJciException {
        if (this.position >= this.capacity) {
            throw new UJciException(19);
        }
        return this.buffer[this.position++];
    }

    void readBytes(byte[] byArray, int n, int n2) throws UJciException {
        if (byArray == null) {
            return;
        }
        if (this.position + n2 > this.capacity) {
            throw new UJciException(19);
        }
        System.arraycopy(this.buffer, this.position, byArray, n, n2);
        this.position += n2;
    }

    void readBytes(byte[] byArray) throws UJciException {
        this.readBytes(byArray, 0, byArray.length);
    }

    byte[] readBytes(int n) throws UJciException {
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        return byArray;
    }

    double readDouble() throws UJciException {
        return Double.longBitsToDouble(this.readLong());
    }

    float readFloat() throws UJciException {
        return Float.intBitsToFloat(this.readInt());
    }

    int readInt() throws UJciException {
        if (this.position + 4 > this.capacity) {
            throw new UJciException(19);
        }
        int n = UJCIUtil.bytes2int(this.buffer, this.position);
        this.position += 4;
        return n;
    }

    long readLong() throws UJciException {
        long l = 0L;
        if (this.position + 8 > this.capacity) {
            throw new UJciException(19);
        }
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)(this.buffer[this.position++] & 0xFF);
        }
        return l;
    }

    short readShort() throws UJciException {
        if (this.position + 2 > this.capacity) {
            throw new UJciException(19);
        }
        short s = UJCIUtil.bytes2short(this.buffer, this.position);
        this.position += 2;
        return s;
    }

    String readString(int n, String string) throws UJciException {
        String string2;
        if (n <= 0) {
            return null;
        }
        if (this.position + n > this.capacity) {
            throw new UJciException(19);
        }
        try {
            string2 = new String(this.buffer, this.position, n - 1, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(this.buffer, this.position, n - 1);
        }
        this.position += n;
        return string2;
    }

    Date readDate() throws UJciException {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        Calendar calendar = Calendar.getInstance();
        calendar.set(s, s2 - 1, s3, 0, 0, 0);
        return new Date(calendar.getTimeInMillis());
    }

    Time readTime() throws UJciException {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, s, s2, s3);
        return new Time(calendar.getTimeInMillis());
    }

    CUBRIDTimestamp readTimestamp() throws UJciException {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        short s4 = this.readShort();
        short s5 = this.readShort();
        short s6 = this.readShort();
        Calendar calendar = Calendar.getInstance();
        calendar.set(s, s2 - 1, s3, s4, s5, s6);
        calendar.set(14, 0);
        return new CUBRIDTimestamp(calendar.getTimeInMillis(), false);
    }

    CUBRIDTimestamp readDatetime() throws UJciException {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        short s4 = this.readShort();
        short s5 = this.readShort();
        short s6 = this.readShort();
        short s7 = this.readShort();
        Calendar calendar = Calendar.getInstance();
        calendar.set(s, s2 - 1, s3, s4, s5, s6);
        calendar.set(14, s7);
        return new CUBRIDTimestamp(calendar.getTimeInMillis(), true);
    }

    CUBRIDOID readOID(CUBRIDConnection cUBRIDConnection) throws UJciException {
        byte[] byArray = this.readBytes(8);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return new CUBRIDOID(cUBRIDConnection, byArray);
        }
        return null;
    }

    CUBRIDBlob readBlob(int n, CUBRIDConnection cUBRIDConnection) throws UJciException {
        try {
            byte[] byArray = this.readBytes(n);
            return new CUBRIDBlob(cUBRIDConnection, byArray);
        }
        catch (Exception exception) {
            throw new UJciException(23);
        }
    }

    CUBRIDClob readClob(int n, CUBRIDConnection cUBRIDConnection) throws UJciException {
        try {
            byte[] byArray = this.readBytes(n);
            return new CUBRIDClob(cUBRIDConnection, byArray, cUBRIDConnection.getUConnection().getCharset());
        }
        catch (Exception exception) {
            throw new UJciException(23);
        }
    }

    int remainedCapacity() {
        return this.capacity - this.position;
    }

    CUBRIDXid readXid() throws UJciException {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        byte[] byArray = this.readBytes(n3);
        byte[] byArray2 = this.readBytes(n4);
        return new CUBRIDXid(n2, byArray, byArray2);
    }

    private void readData() throws IOException {
        int n = 0;
        for (int i = 0; i < this.capacity; i += n) {
            n = this.input.read(this.buffer, i, this.capacity - i);
            if (n >= 0) continue;
            this.capacity = i;
            break;
        }
    }
}

