/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UOutputBuffer;
import cubrid.jdbc.jci.UParameter;

class UBindParameter
extends UParameter {
    private static final byte PARAM_MODE_UNKNOWN = 0;
    private static final byte PARAM_MODE_IN = 1;
    private static final byte PARAM_MODE_OUT = 2;
    private static final byte PARAM_MODE_INOUT = 3;
    byte[] paramMode;
    private boolean[] isBinded;

    UBindParameter(int n) {
        super(n);
        this.isBinded = new boolean[this.number];
        this.paramMode = new byte[this.number];
        this.clear();
    }

    boolean checkAllBinded() {
        for (int i = 0; i < this.number; ++i) {
            if (this.isBinded[i] || this.paramMode[i] != 0) continue;
            return false;
        }
        return true;
    }

    void clear() {
        for (int i = 0; i < this.number; ++i) {
            this.isBinded[i] = false;
            this.paramMode[i] = 0;
            this.values[i] = null;
            this.types[i] = 0;
        }
    }

    synchronized void close() {
        for (int i = 0; i < this.number; ++i) {
            this.values[i] = null;
        }
        this.isBinded = null;
        this.paramMode = null;
        this.values = null;
        this.types = null;
    }

    synchronized void setParameter(int n, byte by, Object object) throws UJciException {
        if (n < 0 || n >= this.number) {
            throw new UJciException(16);
        }
        this.types[n] = by;
        this.values[n] = object;
        this.isBinded[n] = true;
        int n2 = n;
        this.paramMode[n2] = (byte)(this.paramMode[n2] | 1);
    }

    void setOutParam(int n) throws UJciException {
        if (n < 0 || n >= this.number) {
            throw new UJciException(16);
        }
        int n2 = n;
        this.paramMode[n2] = (byte)(this.paramMode[n2] | 2);
    }

    synchronized void writeParameter(UOutputBuffer uOutputBuffer) throws UJciException {
        for (int i = 0; i < this.number; ++i) {
            if (this.values[i] == null) {
                uOutputBuffer.addByte((byte)0);
                uOutputBuffer.addNull();
                continue;
            }
            uOutputBuffer.addByte(this.types[i]);
            uOutputBuffer.writeParameter(this.types[i], this.values[i]);
        }
    }

    synchronized void flushLobStreams() {
        for (int i = 0; i < this.number; ++i) {
            if (this.values[i] == null) continue;
            if (this.values[i] instanceof CUBRIDBlob) {
                ((CUBRIDBlob)this.values[i]).flushFlushableStreams();
                continue;
            }
            if (!(this.values[i] instanceof CUBRIDClob)) continue;
            ((CUBRIDClob)this.values[i]).flushFlushableStreams();
        }
    }
}

