/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDCancelQueryThread;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSet;
import cubrid.jdbc.jci.UBatchResult;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UResCache;
import cubrid.jdbc.jci.UResultInfo;
import cubrid.jdbc.jci.UStatement;
import cubrid.jdbc.jci.UStatementCacheData;
import cubrid.sql.CUBRIDOID;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDStatement
implements Statement {
    protected CUBRIDConnection con;
    protected UConnection u_con;
    protected UStatement u_stmt;
    protected UStatement auto_generatedkeys_stmt;
    protected UError error;
    protected boolean completed;
    protected UResultInfo[] result_info;
    protected CUBRIDResultSet current_result_set;
    protected CUBRIDResultSet auto_generatedkeys_result_set;
    protected boolean is_closed;
    protected int update_count;
    protected boolean query_info_flag;
    protected boolean only_query_plan;
    protected int autoGeneratedKeys = 0;
    private int max_field_size;
    private int max_rows;
    private int query_timeout;
    private int type;
    private int concurrency;
    private boolean is_scrollable;
    private boolean is_updatable;
    private boolean is_sensitive;
    private int fetch_direction;
    private int fetch_size;
    private ArrayList batchs;
    private int result_index;

    protected CUBRIDStatement(CUBRIDConnection cUBRIDConnection, int n, int n2) {
        this.con = cUBRIDConnection;
        this.u_con = this.con.u_con;
        this.u_stmt = null;
        this.is_closed = false;
        this.max_field_size = 0;
        this.max_rows = 0;
        this.update_count = -1;
        this.current_result_set = null;
        this.auto_generatedkeys_result_set = null;
        this.auto_generatedkeys_stmt = null;
        this.query_timeout = 0;
        this.error = null;
        this.type = n;
        this.concurrency = n2;
        this.is_scrollable = n != 1003;
        this.is_updatable = n2 == 1008;
        this.is_sensitive = n == 1005;
        this.fetch_direction = 1000;
        this.fetch_size = 0;
        this.batchs = new ArrayList();
        this.completed = true;
        this.result_info = null;
        this.query_info_flag = false;
        this.only_query_plan = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    if (!this.u_stmt.getSqlType()) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeQuery);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    this.current_result_set.complete_on_close = true;
                    return this.current_result_set;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        int n = this.executeUpdate(string, 2);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    if (this.is_closed) {
                        return;
                    }
                    this.is_closed = true;
                    this.complete();
                    this.con.removeStatement(this);
                    this.con = null;
                    this.u_con = null;
                    this.error = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkIsOpen();
        return this.max_field_size;
    }

    @Override
    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.max_field_size = n;
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        this.checkIsOpen();
        return this.max_rows;
    }

    @Override
    public synchronized void setMaxRows(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.max_rows = n;
    }

    @Override
    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        this.checkIsOpen();
        return this.query_timeout;
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.query_timeout = n;
    }

    @Override
    public void cancel() throws SQLException {
        try {
            UError uError = this.u_stmt.cancel();
            switch (uError.getErrorCode()) {
                case 0: 
                case 17: {
                    break;
                }
                default: {
                    throw new CUBRIDException(uError);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized void setCursorName(String string) throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        boolean bl = this.execute(string, 2);
        return bl;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkIsOpen();
        return this.current_result_set;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return this.update_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    boolean bl;
                    this.checkIsOpen();
                    if (this.current_result_set != null) {
                        this.current_result_set.close();
                        this.current_result_set = null;
                    }
                    if (this.completed) {
                        this.update_count = -1;
                        return false;
                    }
                    if (this.result_index == this.result_info.length) {
                        if (this.u_stmt.getCommandType() != 126) {
                            this.complete();
                        }
                        this.update_count = -1;
                        return false;
                    }
                    if (this.result_index != 0) {
                        this.u_stmt.nextResult();
                        this.error = this.u_stmt.getRecentError();
                        switch (this.error.getErrorCode()) {
                            case 0: {
                                break;
                            }
                            default: {
                                throw new CUBRIDException(this.error);
                            }
                        }
                    }
                    if (bl = this.result_info[this.result_index].isResultSet()) {
                        int n = this.type;
                        int n2 = this.concurrency;
                        if (this.type == 1005 && !this.u_stmt.isOIDIncluded()) {
                            n = 1004;
                        }
                        if (this.concurrency == 1008 && !this.u_stmt.isOIDIncluded()) {
                            n2 = 1007;
                        }
                        this.current_result_set = new CUBRIDResultSet(this.con, this, n, n2);
                    } else {
                        this.update_count = this.result_info[this.result_index].getResultCount();
                    }
                    ++this.result_index;
                    return bl;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        this.checkIsOpen();
        if (!this.is_scrollable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable_statement);
        }
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetch_direction = n;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        this.checkIsOpen();
        return this.fetch_direction;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkIsOpen();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.fetch_size = n;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkIsOpen();
        return this.fetch_size;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkIsOpen();
        return this.concurrency;
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        this.checkIsOpen();
        return this.type;
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        this.checkIsOpen();
        this.batchs.add(string);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.checkIsOpen();
        this.batchs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    String[] stringArray = new String[this.batchs.size()];
                    for (int i = 0; i < this.batchs.size(); ++i) {
                        stringArray[i] = (String)this.batchs.get(i);
                    }
                    UBatchResult uBatchResult = this.u_con.batchExecute(stringArray);
                    this.error = this.u_con.getRecentError();
                    switch (this.error.getErrorCode()) {
                        case 0: {
                            break;
                        }
                        default: {
                            throw new CUBRIDException(this.error);
                        }
                    }
                    this.con.autoCommit();
                    return this.checkBatchResult(uBatchResult);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkIsOpen();
        return this.con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    this.autoGeneratedKeys = n;
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.u_stmt.setAutoGeneratedKeys(true);
                    }
                    this.executeCore(true);
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.MakeAutoGeneratedKeysResultSet();
                    } else {
                        this.resetGeneratedKeysResultSet();
                    }
                    return this.getMoreResults();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl = this.execute(string, 2);
        return bl;
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl = this.execute(string, 2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    if (this.u_stmt.getSqlType()) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeUpdate);
                    }
                    this.executeCore(false);
                    if (n == 1 && this.u_stmt.getCommandType() == 20) {
                        this.MakeAutoGeneratedKeysResultSet();
                    } else {
                        this.resetGeneratedKeysResultSet();
                    }
                    this.getMoreResults();
                    this.complete();
                    return this.update_count;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        int n = this.executeUpdate(string, 2);
        return n;
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        int n = this.executeUpdate(string, 2);
        return n;
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        if (this.auto_generatedkeys_result_set == null) {
            this.auto_generatedkeys_result_set = new CUBRIDResultSet(null);
        }
        return this.auto_generatedkeys_result_set;
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CUBRIDOID executeInsert(String string) throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(string);
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.u_stmt.setAutoGeneratedKeys(true);
                    }
                    CUBRIDOID cUBRIDOID = this.executeInsertCore();
                    this.complete();
                    return cUBRIDOID;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    public byte getStatementType() {
        if (this.u_stmt != null) {
            return this.u_stmt.getCommandType();
        }
        return 127;
    }

    public String getQueryplan(String string) throws SQLException {
        this.checkIsOpen();
        int n = 0;
        if (string == null) {
            return "";
        }
        String string2 = this.u_con.getQueryplanOnly(string);
        this.error = this.u_con.getRecentError();
        n = this.error.getErrorCode();
        this.con.autoRollback();
        if (n != 0) {
            throw new CUBRIDException(this.error);
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String getQueryplan() throws SQLException {
        this.checkIsOpen();
        int n = 0;
        if (this.u_stmt == null) {
            return "";
        }
        String string = this.u_stmt.getQueryplan();
        this.error = this.u_stmt.getRecentError();
        n = this.error.getErrorCode();
        this.con.autoRollback();
        if (n != 0) {
            throw new CUBRIDException(this.error);
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setQueryInfo(boolean bl) {
        this.query_info_flag = bl;
    }

    @Deprecated
    public void setOnlyQueryPlan(boolean bl) {
        this.only_query_plan = bl;
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected CUBRIDOID executeInsertCore() throws SQLException {
        CUBRIDCancelQueryThread cUBRIDCancelQueryThread = null;
        if (this.query_timeout > 0) {
            cUBRIDCancelQueryThread = new CUBRIDCancelQueryThread(this, this.query_timeout);
            cUBRIDCancelQueryThread.start();
        }
        CUBRIDOID cUBRIDOID = this.u_stmt.executeInsert(false);
        if (this.query_timeout > 0) {
            cUBRIDCancelQueryThread.queryended();
        }
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case 22: {
                this.con.autoRollback();
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeInsert);
            }
            default: {
                UError uError = new UError(this.error);
                this.con.autoRollback();
                throw new CUBRIDException(uError);
            }
        }
        this.completed = false;
        return cUBRIDOID;
    }

    protected int[] checkBatchResult(UBatchResult uBatchResult) throws SQLException {
        int[] nArray = uBatchResult.getResult();
        if (!uBatchResult.getErrorFlag()) {
            return nArray;
        }
        int n = uBatchResult.getResultNumber();
        String[] stringArray = uBatchResult.getErrorMessage();
        int[] nArray2 = uBatchResult.getErrorCode();
        BatchUpdateException batchUpdateException = null;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 0) continue;
            if (batchUpdateException == null) {
                batchUpdateException = new BatchUpdateException(stringArray[i], null, nArray2[i], nArray);
                continue;
            }
            batchUpdateException.setNextException(new SQLException(stringArray[i], null, nArray2[i]));
        }
        throw batchUpdateException;
    }

    protected void executeCore(boolean bl) throws SQLException {
        if (this.u_stmt.is_result_cacheable()) {
            this.jdbc_cache_make(bl);
        } else {
            this.executeCoreInternal(bl, null);
        }
        this.result_info = this.u_stmt.getResultInfo();
        this.result_index = 0;
        if (this.con.getAutoCommit() && (this.result_info.length > 1 || this.u_stmt.getCommandType() == 126)) {
            this.u_con.turnOnAutoCommitBySelf();
        }
        this.completed = false;
    }

    protected void executeCoreInternal(boolean bl, UStatementCacheData uStatementCacheData) throws SQLException {
        CUBRIDCancelQueryThread cUBRIDCancelQueryThread = null;
        if (this.query_timeout > 0) {
            cUBRIDCancelQueryThread = new CUBRIDCancelQueryThread(this, this.query_timeout);
            cUBRIDCancelQueryThread.start();
        }
        this.u_stmt.execute(false, this.max_rows, this.max_field_size, bl, this.is_sensitive, this.is_scrollable, this.query_info_flag, this.only_query_plan, uStatementCacheData);
        if (this.query_timeout > 0) {
            cUBRIDCancelQueryThread.queryended();
        }
        this.error = this.u_stmt.getRecentError();
        this.checkExecuteError();
    }

    protected void jdbc_cache_make(boolean bl) throws SQLException {
        UStatementCacheData uStatementCacheData = null;
        Thread thread = Thread.currentThread();
        UResCache uResCache = this.u_stmt.getResCache();
        uStatementCacheData = uResCache.getCacheData();
        this.executeCoreInternal(bl, uStatementCacheData);
        uResCache.saveCacheData(uStatementCacheData);
    }

    void complete() throws SQLException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (this.current_result_set != null) {
            this.current_result_set.close();
            this.current_result_set = null;
        }
        if (this.u_stmt != null) {
            this.u_stmt.close();
            if (!this.u_stmt.isReturnable()) {
                this.u_stmt = null;
            }
        }
        this.result_info = null;
        if (this.autoGeneratedKeys == 1) {
            this.con.setAutoGeneratedKeys(true);
        } else {
            this.con.setAutoGeneratedKeys(false);
        }
        this.con.autoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetGeneratedKeysResultSet() {
        try {
            if (this.auto_generatedkeys_result_set != null) {
                this.auto_generatedkeys_result_set.close();
                this.auto_generatedkeys_result_set = null;
            }
            if (this.auto_generatedkeys_stmt != null) {
                this.auto_generatedkeys_stmt.close(false);
                this.auto_generatedkeys_stmt = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.auto_generatedkeys_result_set = null;
            this.auto_generatedkeys_stmt = null;
        }
    }

    synchronized boolean MakeAutoGeneratedKeysResultSet() throws SQLException {
        this.checkIsOpen();
        if (this.auto_generatedkeys_result_set != null) {
            this.auto_generatedkeys_result_set.close();
            this.auto_generatedkeys_result_set = null;
        }
        this.auto_generatedkeys_stmt = new UStatement(this.u_stmt);
        if (!this.auto_generatedkeys_stmt.getGeneratedKeys()) {
            return false;
        }
        this.error = this.auto_generatedkeys_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
        this.auto_generatedkeys_result_set = new CUBRIDResultSet(this.auto_generatedkeys_stmt);
        return true;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed);
        }
    }

    private void prepare(String string) throws SQLException {
        byte by = 0;
        if (this.is_updatable || this.is_sensitive) {
            by = (byte)(by | 2);
        }
        if (this.query_info_flag || this.only_query_plan) {
            by = (byte)(by | 4);
        }
        this.u_stmt = this.con.prepare(string, by);
    }

    private void checkExecuteError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                UError uError = new UError(this.error);
                this.con.autoRollback();
                throw new CUBRIDException(uError);
            }
        }
    }
}

