/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDInputStream;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetMetaData;
import cubrid.jdbc.jci.UGetTypeConvertedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CUBRIDResultSetWithoutQuery
implements ResultSet {
    int[] type;
    int[] precision;
    boolean[] nullable;
    String[] column_name;
    private int num_of_columns;
    private int num_of_rows;
    private int current_row;
    private boolean was_null;
    private boolean is_closed;
    private ArrayList rows;
    private CUBRIDResultSetMetaData meta_data;
    private ArrayList streams;
    private int fetch_size;

    protected CUBRIDResultSetWithoutQuery(int n, int[] nArray, String[] stringArray, boolean[] blArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[n];
            Arrays.fill(nArray2, 0);
        }
        this.initialize(n, nArray, stringArray, blArray, nArray2);
    }

    private void initialize(int n, int[] nArray, String[] stringArray, boolean[] blArray, int[] nArray2) {
        this.num_of_columns = n;
        this.type = nArray;
        this.precision = nArray2;
        this.nullable = blArray;
        this.column_name = stringArray;
        this.current_row = -1;
        this.num_of_rows = 0;
        this.was_null = false;
        this.is_closed = false;
        this.rows = new ArrayList(10);
        this.meta_data = null;
        this.streams = new ArrayList();
        this.fetch_size = 0;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.checkIsOpen();
        this.clearAllStreams();
        ++this.current_row;
        if (this.current_row == this.num_of_rows) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.is_closed = true;
        this.clearAllStreams();
        this.type = null;
        this.precision = null;
        this.column_name = null;
        this.rows.clear();
        this.rows = null;
        this.meta_data = null;
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this.checkIsOpen();
        return this.was_null;
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getString(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getBoolean(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getByte(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getShort(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getInt(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getLong(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getFloat(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getDouble(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getBytes(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getDate(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getTime(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getTimestamp(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.checkIsOpen();
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        CUBRIDInputStream cUBRIDInputStream = new CUBRIDInputStream(string.getBytes());
        this.addStream(cUBRIDInputStream);
        return cUBRIDInputStream;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.checkIsOpen();
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        CUBRIDInputStream cUBRIDInputStream = new CUBRIDInputStream(byArray);
        this.addStream(cUBRIDInputStream);
        return cUBRIDInputStream;
    }

    @Override
    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        if (this.meta_data == null) {
            this.meta_data = new CUBRIDResultSetMetaData(this);
        }
        return this.meta_data;
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        return ((Object[])this.rows.get(this.current_row))[n - 1];
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public synchronized int findColumn(String string) throws SQLException {
        this.checkIsOpen();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.column_name.length; ++i) {
            if (!this.column_name[i].equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_column_name);
    }

    @Override
    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.checkIsOpen();
        throw new UnsupportedOperationException("Method getCharacterStream() not yet implemented.");
    }

    @Override
    public synchronized Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(n);
        try {
            return UGetTypeConvertedValue.getBigDecimal(((Object[])this.rows.get(this.current_row))[n - 1]);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.checkIsOpen();
        if (this.current_row < this.num_of_rows && this.current_row >= 0) {
            return this.current_row + 1;
        }
        return 0;
    }

    @Override
    public synchronized boolean absolute(int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean relative(int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        this.checkIsOpen();
        return 1000;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkIsOpen();
        if (n < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        this.fetch_size = n;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkIsOpen();
        return this.fetch_size;
    }

    @Override
    public synchronized int getType() throws SQLException {
        this.checkIsOpen();
        return 1003;
    }

    @Override
    public synchronized int getConcurrency() throws SQLException {
        this.checkIsOpen();
        return 1007;
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized void updateNull(int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateShort(int n, short s) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateLong(int n, long l) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateString(int n, String string) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateNull(String string) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateShort(String string, short s) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateInt(String string, int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateLong(String string, long l) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateString(String string, String string2) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    public synchronized Object getObject(String string, Map map) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkIsOpen();
        return this.getDate(n);
    }

    @Override
    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        this.checkIsOpen();
        return this.getDate(string);
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkIsOpen();
        return this.getTime(n);
    }

    @Override
    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        this.checkIsOpen();
        return this.getTime(string);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkIsOpen();
        return this.getTimestamp(n);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.checkIsOpen();
        return this.getTimestamp(string);
    }

    @Override
    public synchronized URL getURL(int n) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized URL getURL(String string) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateArray(int n, Array array) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateArray(String string, Array array) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateBlob(int n, Blob blob) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateBlob(String string, Blob blob) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateClob(int n, Clob clob) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateClob(String string, Clob clob) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateRef(int n, Ref ref) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateRef(String string, Ref ref) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    synchronized void sortTuples(Comparator comparator) {
        Object[] objectArray = this.rows.toArray();
        Arrays.sort(objectArray, comparator);
        for (int i = 0; i < objectArray.length; ++i) {
            this.rows.set(i, objectArray[i]);
        }
    }

    synchronized void addTuple(Object[] objectArray) throws SQLException {
        if (objectArray.length != this.num_of_columns) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_tuple);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        this.rows.add(objectArray2);
        ++this.num_of_rows;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.result_set_closed);
        }
    }

    private void beforeGetValue(int n) throws SQLException {
        if (this.current_row < 0 || this.current_row >= this.num_of_rows) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_row);
        }
        if (n < 1 || n > this.num_of_columns) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
        }
        this.was_null = ((Object[])this.rows.get(this.current_row))[n - 1] == null;
    }

    private void addStream(InputStream inputStream) throws SQLException {
        this.streams.add(inputStream);
    }

    private void clearAllStreams() throws SQLException {
        Iterator iterator = this.streams.iterator();
        try {
            while (iterator.hasNext()) {
                ((InputStream)iterator.next()).close();
                iterator.remove();
            }
            this.streams.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

