/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDComparator;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetWithoutQuery;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDDatabaseMetaData
implements DatabaseMetaData {
    CUBRIDConnection con;
    UConnection u_con;
    UError error;
    boolean is_closed;

    protected CUBRIDDatabaseMetaData(CUBRIDConnection cUBRIDConnection) {
        this.con = cUBRIDConnection;
        this.u_con = this.con.u_con;
        this.error = null;
        this.is_closed = false;
    }

    @Override
    public synchronized boolean allProceduresAreCallable() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean allTablesAreSelectable() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getURL() throws SQLException {
        this.checkIsOpen();
        return this.con.url;
    }

    @Override
    public synchronized String getUserName() throws SQLException {
        this.checkIsOpen();
        return this.con.user;
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullsAreSortedHigh() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullsAreSortedLow() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean nullsAreSortedAtStart() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getDatabaseProductName() throws SQLException {
        this.checkIsOpen();
        return "CUBRID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getDatabaseProductVersion() throws SQLException {
        this.checkIsOpen();
        String string = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            string = this.u_con.getDatabaseProductVersion();
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                return string;
            }
        }
        throw new CUBRIDException(this.error);
    }

    @Override
    public synchronized String getDriverName() throws SQLException {
        this.checkIsOpen();
        return "CUBRID JDBC Driver";
    }

    @Override
    public synchronized String getDriverVersion() throws SQLException {
        this.checkIsOpen();
        return "8.4.0.0243";
    }

    @Override
    public int getDriverMajorVersion() {
        return CUBRIDDriver.major_version;
    }

    @Override
    public int getDriverMinorVersion() {
        return CUBRIDDriver.minor_version;
    }

    @Override
    public synchronized boolean usesLocalFiles() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean usesLocalFilePerTable() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesUpperCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesLowerCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean storesMixedCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getIdentifierQuoteString() throws SQLException {
        this.checkIsOpen();
        return "\"";
    }

    @Override
    public synchronized String getSQLKeywords() throws SQLException {
        this.checkIsOpen();
        return "ADD, ADD_MONTHS, AFTER, ALIAS, ASYNC, ATTACH, ATTRIBUTE, BEFORE, BOOLEAN, BREADTH, CALL, CHANGE, CLASS, CLASSES, CLUSTER, COMPLETION, CYCLE, DATA, DATA_TYPE___, DEPTH, DICTIONARY, DIFFERENCE, EACH, ELSEIF, EQUALS, EVALUATE, EXCLUDE, FILE, FUNCTION, GENERAL, IF, IGNORE, INCREMENT, INDEX, INHERIT, INOUT, INTERSECTION, LAST_DAY, LDB, LEAVE, LESS, LIMIT, LIST, LOOP, LPAD, LTRIM, MAXVALUE, METHOD, MINVALUE, MODIFY, MONETARY, MONTHS_BETWEEN, MULTISET, MULTISET_OF, NA, NOCYCLE, NOMAXVALUE, NOMINVALUE, NONE, OBJECT, OFF, OID, OLD, OPERATION, OPERATORS, OPTIMIZATION, OTHERS, OUT, PARAMETERS, PENDANT, PREORDER, PRIVATE, PROXY, PROTECTED, QUERY, RECURSIVE, REF, REFERENCING, REGISTER, RENAME, REPLACE, RESIGNAL, RETURN, RETURNS, ROLE, ROUTINE, ROW, RPAD, RTRIM, SAVEPOINT, SCOPE___, SEARCH, SENSITIVE, SEQUENCE, SEQUENCE_OF, SERIAL, SERIALIZABLE, SETEQ, SETNEQ, SET_OF, SHARED, SHORT, SIGNAL, SIMILAR, SQLEXCEPTION, SQLWARNING, START, TATISTICS, STDDEV, STRING, STRUCTURE, SUBCLASS, SUBSET, SUBSETEQ, SUPERCLASS, SUPERSET, SUPERSETEQ, SYS_DATE, SYS_TIME, SYS_TIMESTAMP, SYS_USER, TEST, THERE, TO_CHAR, TO_DATE, TO_NUMBER, TO_TIME, TO_TIMESTAMP, TRIGGER, TYPE, UNDER, USE, UTIME, VARIABLE, VARIANCE, VCLASS, VIRTUAL, VISIBLE, WAIT, WHILE, WITHOUT, SYS_DATETIME, TO_DATETIME";
    }

    @Override
    public synchronized String getNumericFunctions() throws SQLException {
        this.checkIsOpen();
        return "AVG, COUNT, MAX, MIN, STDDEV, SUM, VARIANCE";
    }

    @Override
    public synchronized String getStringFunctions() throws SQLException {
        this.checkIsOpen();
        return "BIT_LENGTH, CHAR_LENGTH, LOWER, LTRIM, OCTET_LENGTH, POSITION, REPLACE, RPAD, RTRIM, SUBSTRING, TRANSLATE, TRIM, TO_CHAR, TO_DATE, TO_NUMBER, TO_TIME, TO_TIMESTAMP, TO_DATETIME, UPPER";
    }

    @Override
    public synchronized String getSystemFunctions() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    @Override
    public synchronized String getTimeDateFunctions() throws SQLException {
        this.checkIsOpen();
        return "ADD_MONTHS, LAST_DAY, MONTH_BETWEEN, SYS_DATE, SYS_TIME, SYS_TIMESTMAP, TO_DATE, TO_TIME, TO_TIMESTAMP, TO_DATETIME";
    }

    @Override
    public synchronized String getSearchStringEscape() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized String getExtraNameCharacters() throws SQLException {
        this.checkIsOpen();
        return "%#";
    }

    @Override
    public synchronized boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsColumnAliasing() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullPlusNonNullIsNull() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsConvert() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsConvert(int n, int n2) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsTableCorrelationNames() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsExpressionsInOrderBy() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOrderByUnrelated() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsGroupBy() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsGroupByUnrelated() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsGroupByBeyondSelect() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsLikeEscapeClause() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsMultipleResultSets() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsMultipleTransactions() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsNonNullableColumns() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsMinimumSQLGrammar() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsCoreSQLGrammar() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsExtendedSQLGrammar() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsANSI92FullSQL() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOuterJoins() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsFullOuterJoins() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsLimitedOuterJoins() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getSchemaTerm() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    @Override
    public synchronized String getProcedureTerm() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    @Override
    public synchronized String getCatalogTerm() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized boolean isCatalogAtStart() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized String getCatalogSeparator() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized boolean supportsSchemasInDataManipulation() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsPositionedDelete() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsPositionedUpdate() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSelectForUpdate() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsStoredProcedures() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSubqueriesInComparisons() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsSubqueriesInExists() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsSubqueriesInIns() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsCorrelatedSubqueries() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsUnion() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsUnionAll() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized int getMaxBinaryLiteralLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxCharLiteralLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnNameLength() throws SQLException {
        this.checkIsOpen();
        return 254;
    }

    @Override
    public synchronized int getMaxColumnsInGroupBy() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInIndex() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInOrderBy() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInSelect() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInTable() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxConnections() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxCursorNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxIndexLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxSchemaNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxProcedureNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxCatalogNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxRowSize() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized int getMaxStatementLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxStatements() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxTableNameLength() throws SQLException {
        this.checkIsOpen();
        return 254;
    }

    @Override
    public synchronized int getMaxTablesInSelect() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxUserNameLength() throws SQLException {
        this.checkIsOpen();
        return 254;
    }

    @Override
    public synchronized int getDefaultTransactionIsolation() throws SQLException {
        this.checkIsOpen();
        return 2;
    }

    @Override
    public synchronized boolean supportsTransactions() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        this.checkIsOpen();
        if (n == 2) {
            return true;
        }
        if (n == 1) {
            return true;
        }
        if (n == 4) {
            return true;
        }
        if (n == 8) {
            return true;
        }
        if (n == 16) {
            return true;
        }
        return n == 32;
    }

    @Override
    public synchronized boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "", "", "", "REMARKS", "PROCEDURE_TYPE"};
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2, 2, 9};
        boolean[] blArray = new boolean[]{true, true, false, true, true, true, false, false};
        return new CUBRIDResultSetWithoutQuery(8, nArray, stringArray, blArray, null);
    }

    @Override
    public synchronized ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"};
        int[] nArray = new int[]{2, 2, 2, 2, 9, 9, 2, 8, 8, 9, 9, 9, 2};
        boolean[] blArray = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false};
        return new CUBRIDResultSetWithoutQuery(13, nArray, stringArray, blArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.checkIsOpen();
        String[] stringArray2 = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
        int[] nArray = new int[]{2, 2, 2, 2, 2};
        boolean[] blArray = new boolean[]{true, true, false, false, false};
        UStatement uStatement = null;
        UColumnInfo[] uColumnInfoArray = this.u_con;
        synchronized (this.u_con) {
            int n;
            uStatement = this.u_con.getSchemaInfo(1, string3, null, (byte)3);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            uColumnInfoArray = uStatement.getColumnInfo();
            int[] nArray2 = new int[]{0, 0, uColumnInfoArray[0].getColumnPrecision(), 12, 0};
            CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(5, nArray, stringArray2, blArray, nArray2);
            Object[] objectArray = new Object[5];
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[4] = null;
            int n2 = 0;
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equalsIgnoreCase("TABLE"); ++n2) {
                }
            }
            if (stringArray == null || n2 < stringArray.length) {
                objectArray[3] = "TABLE";
                n = 0;
                while (true) {
                    int n3 = n++;
                    uStatement.moveCursor(n3, 0);
                    if (uStatement.getRecentError().getErrorCode() != 0) break;
                    uStatement.fetch();
                    if (uStatement.getInt(1) != 2) continue;
                    objectArray[2] = uStatement.getString(0);
                    cUBRIDResultSetWithoutQuery.addTuple(objectArray);
                }
            }
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equalsIgnoreCase("VIEW"); ++n2) {
                }
            }
            if (stringArray == null || n2 < stringArray.length) {
                objectArray[3] = "VIEW";
                n = 0;
                while (true) {
                    int n4 = n++;
                    uStatement.moveCursor(n4, 0);
                    if (uStatement.getRecentError().getErrorCode() != 0) break;
                    uStatement.fetch();
                    if (uStatement.getInt(1) != 1) continue;
                    objectArray[2] = uStatement.getString(0);
                    cUBRIDResultSetWithoutQuery.addTuple(objectArray);
                }
            }
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equalsIgnoreCase("SYSTEM TABLE"); ++n2) {
                }
            }
            if (stringArray == null || n2 < stringArray.length) {
                objectArray[3] = "SYSTEM TABLE";
                n = 0;
                while (true) {
                    int n5 = n++;
                    uStatement.moveCursor(n5, 0);
                    if (uStatement.getRecentError().getErrorCode() != 0) break;
                    uStatement.fetch();
                    if (uStatement.getInt(1) != 0) continue;
                    objectArray[2] = uStatement.getString(0);
                    cUBRIDResultSetWithoutQuery.addTuple(objectArray);
                }
            }
            uStatement.close();
            this.endTransaction();
            cUBRIDResultSetWithoutQuery.sortTuples(new CUBRIDComparator("getTables"));
            return cUBRIDResultSetWithoutQuery;
        }
    }

    @Override
    public synchronized ResultSet getSchemas() throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_SCHEM"};
        int[] nArray = new int[]{2};
        boolean[] blArray = new boolean[]{false};
        return new CUBRIDResultSetWithoutQuery(1, nArray, stringArray, blArray, null);
    }

    @Override
    public synchronized ResultSet getCatalogs() throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_CAT"};
        int[] nArray = new int[]{2};
        boolean[] blArray = new boolean[]{false};
        return new CUBRIDResultSetWithoutQuery(1, nArray, stringArray, blArray, null);
    }

    @Override
    public synchronized ResultSet getTableTypes() throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_TYPE"};
        int[] nArray = new int[]{2};
        boolean[] blArray = new boolean[]{false};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(1, nArray, stringArray, blArray, null);
        Object[] objectArray = new Object[]{"SYSTEM TABLE"};
        cUBRIDResultSetWithoutQuery.addTuple(objectArray);
        objectArray[0] = "TABLE";
        cUBRIDResultSetWithoutQuery.addTuple(objectArray);
        objectArray[0] = "VIEW";
        cUBRIDResultSetWithoutQuery.addTuple(objectArray);
        return cUBRIDResultSetWithoutQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
        int[] nArray = new int[]{2, 2, 2, 2, 9, 2, 8, 0, 8, 8, 8, 2, 2, 8, 8, 8, 8, 2};
        boolean[] blArray = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, true, true, true, false, false, false};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(18, nArray, stringArray, blArray, null);
        UStatement uStatement = null;
        Object[] objectArray = this.u_con;
        synchronized (this.u_con) {
            uStatement = this.u_con.getSchemaInfo(4, string3, string4, (byte)3);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
            // ** MonitorExit[var10_10] (shouldn't be in output)
            objectArray = new Object[18];
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[7] = null;
            objectArray[9] = new Integer(10);
            objectArray[11] = null;
            objectArray[13] = null;
            objectArray[14] = null;
            int n = 0;
            while (true) {
                int n2 = n++;
                uStatement.moveCursor(n2, 0);
                if (uStatement.getRecentError().getErrorCode() != 0) break;
                uStatement.fetch();
                int n3 = uStatement.getRecentError().getErrorCode();
                if (n3 != 0 && n3 != 8) {
                    throw new CUBRIDException(uStatement.getRecentError());
                }
                objectArray[2] = uStatement.getString(10);
                objectArray[3] = uStatement.getString(0);
                objectArray[6] = objectArray[15] = new Integer(uStatement.getInt(3));
                objectArray[8] = new Integer(uStatement.getInt(2));
                objectArray[16] = new Integer(uStatement.getInt(9));
                if (uStatement.getInt(5) == 1) {
                    objectArray[10] = new Integer(0);
                    objectArray[17] = "NO";
                } else {
                    objectArray[10] = new Integer(1);
                    objectArray[17] = "YES";
                }
                objectArray[12] = uStatement.getObject(8);
                int n4 = uStatement.getInt(1);
                if (n4 == 5) {
                    objectArray[4] = new Short(-2);
                    objectArray[5] = "BIT";
                } else if (n4 == 6) {
                    objectArray[4] = new Short(-3);
                    objectArray[5] = "BIT VARYING";
                } else if (n4 == 1) {
                    objectArray[4] = new Short(1);
                    objectArray[5] = "CHAR";
                } else if (n4 == 2) {
                    objectArray[4] = new Short(12);
                    objectArray[5] = "VARCHAR";
                } else if (n4 == 3) {
                    objectArray[4] = new Short(1);
                    objectArray[5] = "NCHAR";
                } else if (n4 == 4) {
                    objectArray[4] = new Short(12);
                    objectArray[5] = "NCHAR VARYING";
                } else if (n4 == 9) {
                    objectArray[4] = new Short(5);
                    objectArray[5] = "SMALLINT";
                } else if (n4 == 21) {
                    objectArray[4] = new Short(-5);
                    objectArray[5] = "BIGINT";
                } else if (n4 == 8) {
                    objectArray[4] = new Short(4);
                    objectArray[5] = "INTEGER";
                } else if (n4 == 7) {
                    objectArray[4] = new Short(3);
                    objectArray[5] = "DECIMAL";
                } else if (n4 == 11) {
                    objectArray[4] = new Short(7);
                    objectArray[5] = "FLOAT";
                } else if (n4 == 12) {
                    objectArray[4] = new Short(8);
                    objectArray[5] = "DOUBLE PRECISION";
                } else if (n4 == 10) {
                    objectArray[4] = new Short(8);
                    objectArray[5] = "MONETARY";
                } else if (n4 == 14) {
                    objectArray[4] = new Short(92);
                    objectArray[5] = "TIME";
                } else if (n4 == 13) {
                    objectArray[4] = new Short(91);
                    objectArray[5] = "DATE";
                } else if (n4 == 15) {
                    objectArray[4] = new Short(93);
                    objectArray[5] = "TIMESTAMP";
                } else if (n4 == 22) {
                    objectArray[4] = new Short(93);
                    objectArray[5] = "DATETIME";
                } else if (n4 == 19) {
                    objectArray[4] = new Short(1111);
                    objectArray[5] = "CLASS";
                } else if (n4 == 16) {
                    objectArray[4] = new Short(1111);
                    objectArray[5] = "SET";
                } else if (n4 == 17) {
                    objectArray[4] = new Short(1111);
                    objectArray[5] = "MULTISET";
                } else if (n4 == 18) {
                    objectArray[4] = new Short(1111);
                    objectArray[5] = "SEQUENCE";
                } else if (n4 == 23) {
                    objectArray[4] = new Short(2004);
                    objectArray[5] = "BLOB";
                } else if (n4 == 24) {
                    objectArray[4] = new Short(2005);
                    objectArray[5] = "CLOB";
                }
                cUBRIDResultSetWithoutQuery.addTuple(objectArray);
            }
            uStatement.close();
            this.endTransaction();
            cUBRIDResultSetWithoutQuery.sortTuples(new CUBRIDComparator("getColumns"));
            return cUBRIDResultSetWithoutQuery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
        boolean[] blArray = new boolean[]{true, true, false, false, true, false, false, false};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(8, nArray, stringArray, blArray, null);
        UStatement uStatement = null;
        Object[] objectArray = this.u_con;
        synchronized (this.u_con) {
            uStatement = this.u_con.getSchemaInfo(14, string3, string4, (byte)2);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
            // ** MonitorExit[var10_10] (shouldn't be in output)
            objectArray = new Object[8];
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = string3;
            int n = 0;
            while (true) {
                int n2 = n++;
                uStatement.moveCursor(n2, 0);
                if (uStatement.getRecentError().getErrorCode() != 0) break;
                uStatement.fetch();
                objectArray[3] = uStatement.getString(0);
                objectArray[4] = null;
                objectArray[5] = this.con.user;
                objectArray[6] = uStatement.getString(1);
                objectArray[7] = uStatement.getString(2);
                cUBRIDResultSetWithoutQuery.addTuple(objectArray);
            }
            uStatement.close();
            this.endTransaction();
            cUBRIDResultSetWithoutQuery.sortTuples(new CUBRIDComparator("getColumnPrivileges"));
            return cUBRIDResultSetWithoutQuery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2, 2};
        boolean[] blArray = new boolean[]{true, true, false, true, false, false, false};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(7, nArray, stringArray, blArray, null);
        UStatement uStatement = null;
        Object[] objectArray = this.u_con;
        synchronized (this.u_con) {
            uStatement = this.u_con.getSchemaInfo(13, string3, null, (byte)3);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            objectArray = new Object[7];
            objectArray[0] = null;
            objectArray[1] = null;
            int n = 0;
            while (true) {
                int n2 = n++;
                uStatement.moveCursor(n2, 0);
                if (uStatement.getRecentError().getErrorCode() != 0) break;
                uStatement.fetch();
                objectArray[2] = uStatement.getString(0);
                objectArray[3] = null;
                objectArray[4] = this.con.user;
                objectArray[5] = uStatement.getString(1);
                objectArray[6] = uStatement.getString(2);
                cUBRIDResultSetWithoutQuery.addTuple(objectArray);
            }
            uStatement.close();
            this.endTransaction();
            cUBRIDResultSetWithoutQuery.sortTuples(new CUBRIDComparator("getTablePrivileges"));
            return cUBRIDResultSetWithoutQuery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        int n2;
        Object object;
        this.checkIsOpen();
        String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] nArray = new int[]{9, 2, 9, 2, 8, 8, 9, 9};
        boolean[] blArray = new boolean[]{false, false, false, false, false, true, false, false};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(8, nArray, stringArray, blArray, null);
        UStatement uStatement = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            uStatement = this.u_con.getSchemaInfo(11, string3, null, (byte)2);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
        }
        int n3 = 0;
        int n4 = 2100000000;
        int n5 = -1;
        while (true) {
            int n6 = n3++;
            uStatement.moveCursor(n6, 0);
            if (uStatement.getRecentError().getErrorCode() != 0) break;
            uStatement.fetch();
            if (uStatement.getInt(0) != 0) continue;
            object = uStatement.getString(1);
            int n7 = 0;
            n2 = -1;
            while ((n2 = ((String)object).indexOf(44, n2 + 1)) != -1) {
                ++n7;
            }
            if (n7 >= n4) continue;
            n4 = n7;
            n5 = n3;
        }
        if (n4 == 2100000000) {
            uStatement.close();
            this.endTransaction();
            return cUBRIDResultSetWithoutQuery;
        }
        object = null;
        Object[] objectArray = this.u_con;
        synchronized (this.u_con) {
            object = this.u_con.getSchemaInfo(4, string3, null, (byte)2);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
            // ** MonitorExit[var15_18] (shouldn't be in output)
            objectArray = new Object[8];
            objectArray[5] = null;
            objectArray[7] = new Short(1);
            for (n3 = 0; n3 <= n4; ++n3) {
                uStatement.moveCursor(n5 + n3, 0);
                uStatement.fetch();
                objectArray[1] = uStatement.getString(2);
                n2 = 0;
                while (true) {
                    ((UStatement)object).moveCursor(n2, 0);
                    ((UStatement)object).fetch();
                    if (((UStatement)object).getString(0).equals(objectArray[1])) break;
                    ++n2;
                }
                objectArray[6] = new Integer(((UStatement)object).getInt(2));
                switch (((UStatement)object).getInt(1)) {
                    case 1: {
                        objectArray[2] = new Integer(1);
                        objectArray[3] = "CHAR";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 2: {
                        objectArray[2] = new Integer(12);
                        objectArray[3] = "VARCHAR";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 9: {
                        objectArray[2] = new Integer(5);
                        objectArray[3] = "SMALLINT";
                        objectArray[4] = new Integer(((UStatement)object).getInt(3));
                        break;
                    }
                    case 8: {
                        objectArray[2] = new Integer(4);
                        objectArray[3] = "INTEGER";
                        objectArray[4] = new Integer(((UStatement)object).getInt(3));
                        break;
                    }
                    case 21: {
                        objectArray[2] = new Integer(-5);
                        objectArray[3] = "BIGINT";
                        objectArray[4] = new Integer(((UStatement)object).getInt(3));
                        break;
                    }
                    case 12: {
                        objectArray[2] = new Integer(8);
                        objectArray[3] = "DOUBLE";
                        objectArray[4] = new Integer(((UStatement)object).getInt(3));
                        break;
                    }
                    case 11: {
                        objectArray[2] = new Integer(7);
                        objectArray[3] = "FLOAT";
                        objectArray[4] = new Integer(((UStatement)object).getInt(3));
                        break;
                    }
                    case 7: {
                        objectArray[2] = new Integer(2);
                        objectArray[3] = "NUMERIC";
                        objectArray[4] = new Integer(((UStatement)object).getInt(3));
                        break;
                    }
                    case 13: {
                        objectArray[2] = new Integer(91);
                        objectArray[3] = "DATE";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 14: {
                        objectArray[2] = new Integer(92);
                        objectArray[3] = "TIME";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 15: {
                        objectArray[2] = new Integer(93);
                        objectArray[3] = "TIMESTAMP";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 22: {
                        objectArray[2] = new Integer(93);
                        objectArray[3] = "DATETIME";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 0: {
                        objectArray[2] = new Integer(0);
                        objectArray[3] = "";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 23: {
                        objectArray[2] = new Integer(2004);
                        objectArray[3] = "BLOB";
                        objectArray[4] = new Integer(0);
                        break;
                    }
                    case 24: {
                        objectArray[2] = new Integer(2005);
                        objectArray[3] = "CLOB";
                        objectArray[4] = new Integer(0);
                    }
                }
                cUBRIDResultSetWithoutQuery.addTuple(objectArray);
            }
            uStatement.close();
            ((UStatement)object).close();
            this.endTransaction();
            cUBRIDResultSetWithoutQuery.sortTuples(new CUBRIDComparator("getBestRowIdentifier"));
            return cUBRIDResultSetWithoutQuery;
        }
    }

    @Override
    public synchronized ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] nArray = new int[]{9, 2, 9, 2, 8, 8, 9, 9};
        boolean[] blArray = new boolean[]{true, false, false, false, false, false, false, false};
        return new CUBRIDResultSetWithoutQuery(8, nArray, stringArray, blArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] nArray = new int[]{2, 2, 2, 2, 9, 2};
        boolean[] blArray = new boolean[]{true, true, false, false, false, false};
        UStatement uStatement = null;
        Object object = this.u_con;
        synchronized (object) {
            uStatement = this.u_con.getSchemaInfo(16, string3, null, (byte)3);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
        }
        object = new CUBRIDResultSetWithoutQuery(6, nArray, stringArray, blArray, null);
        Object[] objectArray = new Object[6];
        objectArray[0] = null;
        objectArray[1] = null;
        int n = 0;
        while (true) {
            int n2 = n++;
            uStatement.moveCursor(n2, 0);
            if (uStatement.getRecentError().getErrorCode() != 0) break;
            uStatement.fetch();
            objectArray[2] = uStatement.getString(0);
            objectArray[3] = uStatement.getString(1);
            objectArray[4] = uStatement.getInt(2);
            objectArray[5] = uStatement.getString(3);
            ((CUBRIDResultSetWithoutQuery)object).addTuple(objectArray);
        }
        uStatement.close();
        this.endTransaction();
        return object;
    }

    private short convertForeignKeyAction(short s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResultSet getForeignKeys(int n, String string, String string2) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 9, 9, 9, 2, 2, 9};
        boolean[] blArray = new boolean[]{true, true, false, false, true, true, false, false, false, false, false, true, true, false};
        UStatement uStatement = null;
        Object object = this.u_con;
        synchronized (object) {
            uStatement = this.u_con.getSchemaInfo(n, string, string2, (byte)3);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
        }
        object = new CUBRIDResultSetWithoutQuery(14, nArray, stringArray, blArray, null);
        Object[] objectArray = new Object[14];
        objectArray[0] = null;
        objectArray[1] = null;
        objectArray[4] = null;
        objectArray[5] = null;
        objectArray[13] = 6;
        int n2 = 0;
        while (true) {
            int n3 = n2++;
            uStatement.moveCursor(n3, 0);
            if (uStatement.getRecentError().getErrorCode() != 0) break;
            uStatement.fetch();
            objectArray[2] = uStatement.getString(0);
            objectArray[3] = uStatement.getString(1);
            objectArray[6] = uStatement.getString(2);
            objectArray[7] = uStatement.getString(3);
            objectArray[8] = uStatement.getShort(4);
            objectArray[9] = this.convertForeignKeyAction(uStatement.getShort(5));
            objectArray[10] = this.convertForeignKeyAction(uStatement.getShort(6));
            objectArray[11] = uStatement.getString(7);
            objectArray[12] = uStatement.getString(8);
            ((CUBRIDResultSetWithoutQuery)object).addTuple(objectArray);
        }
        uStatement.close();
        this.endTransaction();
        return object;
    }

    @Override
    public synchronized ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_table_name);
        }
        return this.getForeignKeys(17, string3, null);
    }

    @Override
    public synchronized ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_table_name);
        }
        return this.getForeignKeys(18, string3, null);
    }

    @Override
    public synchronized ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string3 == null || string6 == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_table_name);
        }
        return this.getForeignKeys(19, string3, string6);
    }

    @Override
    public synchronized ResultSet getTypeInfo() throws SQLException {
        Object var20_20;
        this.checkIsOpen();
        String[] stringArray = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        int[] nArray = new int[]{2, 9, 8, 2, 2, 2, 9, 5, 9, 5, 5, 5, 2, 9, 9, 8, 8, 8};
        boolean[] blArray = new boolean[]{false, false, false, true, true, true, false, false, false, false, false, false, true, false, false, true, true, false};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(18, nArray, stringArray, blArray, null);
        Object[] objectArray = new Object[]{"BIT", "NUMERIC", "NUMERIC", "BIT VARYING", "BIT VARYING", "BIT", "VARCHAR", "CHAR", "NUMERIC", "INTEGER", "BIGINT", "SMALLINT", "DOUBLE", "FLOAT", "DOUBLE", "VARCHAR", "DATE", "TIME", "TIMESTAMP", "DATETIME"};
        Object[] objectArray2 = new Object[]{new Short(-7), new Short(-6), new Short(-5), new Short(-4), new Short(-3), new Short(-2), new Short(-1), new Short(1), new Short(2), new Short(4), new Short(-5), new Short(5), new Short(6), new Short(7), new Short(8), new Short(12), new Short(91), new Short(92), new Short(93), new Short(93)};
        Object[] objectArray3 = new Object[]{new Integer(8), new Integer(3), new Integer(38), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(38), new Integer(10), new Integer(19), new Integer(5), new Integer(38), new Integer(38), new Integer(38), new Integer(0x3FFFFFFF), new Integer(10), new Integer(11), new Integer(22), new Integer(26)};
        Object[] objectArray4 = new Object[]{"B'", null, null, "X'", "X'", "X'", "'", "'", null, null, null, null, null, null, null, "'", "DATE'", "TIME'", "TIMESTAMP'", "DATETIME'"};
        Object[] objectArray5 = new Object[]{"'", null, null, "'", "'", "'", "'", "'", null, null, null, null, null, null, null, "'", "'", "'", "'", "'"};
        Object[] objectArray6 = new Object[]{"(8)", "(3)", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        Short s = new Short(1);
        Object[] objectArray7 = new Object[]{new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false)};
        Object[] objectArray8 = new Object[]{new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(3), new Short(3), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(3), new Short(2), new Short(2), new Short(2), new Short(2)};
        Object[] objectArray9 = new Object[]{new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true)};
        Object[] objectArray10 = new Object[]{new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false)};
        Boolean bl = new Boolean(false);
        Object[] objectArray11 = objectArray;
        Object[] objectArray12 = new Object[]{new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
        Object[] objectArray13 = new Object[]{new Integer(0), new Integer(0), new Integer(38), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(38), new Integer(0), new Integer(0), new Integer(0), new Integer(38), new Integer(38), new Integer(38), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
        Object var21_21 = var20_20 = null;
        Integer n = new Integer(10);
        Object[] objectArray14 = new Object[18];
        objectArray14[6] = s;
        objectArray14[11] = bl;
        objectArray14[15] = var20_20;
        objectArray14[16] = var21_21;
        objectArray14[17] = n;
        for (int i = 0; i < 18; ++i) {
            objectArray14[0] = objectArray[i];
            objectArray14[1] = objectArray2[i];
            objectArray14[2] = objectArray3[i];
            objectArray14[3] = objectArray4[i];
            objectArray14[4] = objectArray5[i];
            objectArray14[5] = objectArray6[i];
            objectArray14[7] = objectArray7[i];
            objectArray14[8] = objectArray8[i];
            objectArray14[9] = objectArray9[i];
            objectArray14[10] = objectArray10[i];
            objectArray14[12] = objectArray11[i];
            objectArray14[13] = objectArray12[i];
            objectArray14[14] = objectArray13[i];
            cUBRIDResultSetWithoutQuery.addTuple(objectArray14);
        }
        return cUBRIDResultSetWithoutQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] nArray = new int[]{2, 2, 2, 5, 2, 2, 9, 9, 2, 2, 8, 8, 2};
        boolean[] blArray = new boolean[]{true, true, false, false, true, false, false, false, false, false, false, false, true};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(13, nArray, stringArray, blArray, null);
        UStatement uStatement = null;
        Object[] objectArray = this.u_con;
        synchronized (this.u_con) {
            uStatement = this.u_con.getSchemaInfo(11, string3, null, (byte)2);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            uStatement.moveCursor(0, 0);
            uStatement.fetch();
            objectArray = new Object[13];
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = string3;
            objectArray[4] = null;
            objectArray[3] = new Boolean(false);
            objectArray[5] = null;
            objectArray[6] = new Short(0);
            objectArray[7] = new Short(0);
            objectArray[8] = null;
            objectArray[9] = null;
            objectArray[10] = new Integer(uStatement.getInt(4));
            objectArray[11] = new Integer(uStatement.getInt(3));
            objectArray[12] = null;
            cUBRIDResultSetWithoutQuery.addTuple(objectArray);
            objectArray[6] = new Short(3);
            objectArray[9] = "A";
            int n = 0;
            int n2 = 1;
            String string4 = "";
            while (true) {
                int n3 = n++;
                uStatement.moveCursor(n3, 0);
                if (uStatement.getRecentError().getErrorCode() != 0) break;
                uStatement.fetch();
                if (bl && uStatement.getShort(0) == 1) continue;
                objectArray[3] = uStatement.getShort(0) == 1 ? new Boolean(true) : new Boolean(false);
                objectArray[5] = uStatement.getString(1);
                if (((String)objectArray[5]).equals(string4)) {
                    objectArray[7] = new Integer(n2++);
                } else {
                    objectArray[7] = new Integer(1);
                    n2 = 2;
                    string4 = (String)objectArray[5];
                }
                objectArray[8] = uStatement.getString(2);
                objectArray[10] = new Integer(uStatement.getInt(4));
                objectArray[11] = new Integer(uStatement.getInt(3));
                cUBRIDResultSetWithoutQuery.addTuple(objectArray);
            }
            uStatement.close();
            this.endTransaction();
            cUBRIDResultSetWithoutQuery.sortTuples(new CUBRIDComparator("getIndexInfo"));
            return cUBRIDResultSetWithoutQuery;
        }
    }

    @Override
    public synchronized boolean supportsResultSetType(int n) throws SQLException {
        this.checkIsOpen();
        if (n == 1003) {
            return true;
        }
        if (n == 1004) {
            return true;
        }
        return n == 1005;
    }

    @Override
    public synchronized boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        this.checkIsOpen();
        if (n == 1003 && n2 == 1007) {
            return true;
        }
        if (n == 1003 && n2 == 1008) {
            return true;
        }
        if (n == 1004 && n2 == 1007) {
            return true;
        }
        if (n == 1004 && n2 == 1008) {
            return true;
        }
        if (n == 1005 && n2 == 1007) {
            return true;
        }
        return n == 1005 && n2 == 1008;
    }

    @Override
    public synchronized boolean ownUpdatesAreVisible(int n) throws SQLException {
        this.checkIsOpen();
        return n == 1005;
    }

    @Override
    public synchronized boolean ownDeletesAreVisible(int n) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean ownInsertsAreVisible(int n) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean othersUpdatesAreVisible(int n) throws SQLException {
        this.checkIsOpen();
        return n == 1005;
    }

    @Override
    public synchronized boolean othersDeletesAreVisible(int n) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean othersInsertsAreVisible(int n) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean updatesAreDetected(int n) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean deletesAreDetected(int n) throws SQLException {
        this.checkIsOpen();
        return n == 1005;
    }

    @Override
    public synchronized boolean insertsAreDetected(int n) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsBatchUpdates() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkIsOpen();
        return this.con;
    }

    @Override
    public synchronized ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        int[] nArray = new int[]{2, 2, 2, 2, 8, 2, 8, 8, 8, 8, 2, 2, 8, 8, 8, 8, 2, 2, 2, 2, 9};
        boolean[] blArray = new boolean[]{true, true, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false};
        return new CUBRIDResultSetWithoutQuery(21, nArray, stringArray, blArray, null);
    }

    @Override
    public synchronized int getDatabaseMajorVersion() throws SQLException {
        this.checkIsOpen();
        return -1;
    }

    @Override
    public synchronized int getDatabaseMinorVersion() throws SQLException {
        this.checkIsOpen();
        return -1;
    }

    @Override
    public synchronized int getJDBCMajorVersion() throws SQLException {
        this.checkIsOpen();
        return 3;
    }

    @Override
    public synchronized int getJDBCMinorVersion() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        this.checkIsOpen();
        return -1;
    }

    @Override
    public synchronized int getSQLStateType() throws SQLException {
        this.checkIsOpen();
        return 2;
    }

    @Override
    public synchronized boolean locatorsUpdateCopy() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsGetGeneratedKeys() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsMultipleOpenResults() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsNamedParameters() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsResultSetHoldability(int n) throws SQLException {
        this.checkIsOpen();
        return n == 2;
    }

    @Override
    public synchronized boolean supportsSavepoints() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsStatementPooling() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        int[] nArray = new int[]{2, 2, 2, 2};
        boolean[] blArray = new boolean[]{true, true, false, false};
        CUBRIDResultSetWithoutQuery cUBRIDResultSetWithoutQuery = new CUBRIDResultSetWithoutQuery(4, nArray, stringArray, blArray, null);
        UStatement uStatement = null;
        Object[] objectArray = this.u_con;
        synchronized (this.u_con) {
            uStatement = this.u_con.getSchemaInfo(15, string3, null, (byte)3);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case 17: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw new CUBRIDException(this.error);
                }
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            objectArray = new Object[4];
            objectArray[0] = null;
            objectArray[1] = null;
            int n = 0;
            while (true) {
                int n2 = n++;
                uStatement.moveCursor(n2, 0);
                if (uStatement.getRecentError().getErrorCode() != 0) break;
                uStatement.fetch();
                objectArray[2] = uStatement.getString(0);
                objectArray[3] = uStatement.getString(1);
                cUBRIDResultSetWithoutQuery.addTuple(objectArray);
            }
            uStatement.close();
            this.endTransaction();
            cUBRIDResultSetWithoutQuery.sortTuples(new CUBRIDComparator("getSuperTables"));
            return cUBRIDResultSetWithoutQuery;
        }
    }

    @Override
    public synchronized ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        this.checkIsOpen();
        String[] stringArray = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2};
        boolean[] blArray = new boolean[]{true, true, false, true, true, false};
        return new CUBRIDResultSetWithoutQuery(6, nArray, stringArray, blArray, null);
    }

    synchronized void close() {
        this.is_closed = true;
        this.con = null;
        this.u_con = null;
        this.error = null;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
        }
    }

    private synchronized void endTransaction() {
        if (this.u_con.getAutoCommit()) {
            this.u_con.endTransaction(true);
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

