/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDClob;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class CUBRIDClobInputStream
extends InputStream {
    private CUBRIDClob clob;
    private long lob_pos;
    private long lob_length;

    CUBRIDClobInputStream(CUBRIDClob cUBRIDClob) throws SQLException {
        this.clob = cUBRIDClob;
        this.lob_pos = 1L;
        this.lob_length = cUBRIDClob.getLobHandle().getLobSize();
    }

    public synchronized int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == 1) {
            return 0xFF & byArray[0];
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.clob == null) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (this.lob_pos - 1L + (long)n2 > this.lob_length && (n2 = (int)(this.lob_length - this.lob_pos + 1L)) < 0) {
                n2 = 0;
            }
            byte[] byArray2 = this.clob.getBytes(this.lob_pos, n2);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n3 = byArray2.length;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        this.lob_pos += (long)n3;
        if (n3 < n2 || this.lob_pos > this.lob_length) {
            this.clob = null;
        }
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        if (this.clob == null) {
            return 0L;
        }
        long l2 = this.lob_length - this.lob_pos + 1L;
        if (l > l2) {
            l = l2;
            this.clob = null;
        }
        this.lob_pos += l;
        return l;
    }

    public synchronized void close() throws IOException {
        this.clob = null;
    }
}

