/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBufferedInputStream;
import cubrid.jdbc.driver.CUBRIDBufferedOutputStream;
import cubrid.jdbc.driver.CUBRIDBufferedReader;
import cubrid.jdbc.driver.CUBRIDBufferedWriter;
import cubrid.jdbc.driver.CUBRIDClobInputStream;
import cubrid.jdbc.driver.CUBRIDClobOutputStream;
import cubrid.jdbc.driver.CUBRIDClobReader;
import cubrid.jdbc.driver.CUBRIDClobWriter;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDLobHandle;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;

public class CUBRIDClob
implements Clob {
    private static final int CLOB_MAX_IO_LENGTH = 131072;
    private static final int CLOB_MAX_IO_CHARS = 65536;
    private CUBRIDConnection conn;
    private boolean isWritable;
    private CUBRIDLobHandle lobHandle;
    private String charsetName;
    private StringBuffer clobCharBuffer = new StringBuffer("");
    private long clobCharPos;
    private long clobCharLength;
    private byte[] clobByteBuffer = new byte[131072];
    private long clobBytePos;
    private long clobNextReadBytePos;
    private ArrayList<Flushable> streamList = new ArrayList();

    public CUBRIDClob(CUBRIDConnection cUBRIDConnection, String string) throws SQLException {
        if (cUBRIDConnection == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        byte[] byArray = cUBRIDConnection.lobNew(24);
        this.conn = cUBRIDConnection;
        this.isWritable = true;
        this.lobHandle = new CUBRIDLobHandle(24, byArray);
        this.charsetName = string;
        this.clobCharPos = 0L;
        this.clobCharLength = 0L;
        this.clobBytePos = 0L;
        this.clobNextReadBytePos = 0L;
    }

    public CUBRIDClob(CUBRIDConnection cUBRIDConnection, byte[] byArray, String string) throws SQLException {
        if (cUBRIDConnection == null || byArray == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        this.conn = cUBRIDConnection;
        this.isWritable = false;
        this.lobHandle = new CUBRIDLobHandle(24, byArray);
        this.charsetName = string;
        this.clobCharPos = 0L;
        this.clobCharLength = -1L;
        this.clobBytePos = 0L;
        this.clobNextReadBytePos = 0L;
    }

    public synchronized long length() throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (this.clobCharLength < 0L) {
            this.readClobPartially(Long.MAX_VALUE, 1);
        }
        return this.clobCharLength;
    }

    public synchronized String getSubString(long l, int n) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L || n < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (n == 0) {
            return "";
        }
        int n2 = this.readClobPartially(l, n);
        if (n2 <= 0) {
            return "";
        }
        return this.clobCharBuffer.substring(0, n2);
    }

    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L || l2 < 0L) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        return new CUBRIDBufferedReader(new CUBRIDClobReader(this, l, l2), 65536);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        return new CUBRIDBufferedInputStream(new CUBRIDClobInputStream(this), 131072);
    }

    public long position(String string, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(Clob clob, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized int setString(long l, String string) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (!this.isWritable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable);
        }
        if (string == null || string.length() <= 0) {
            return 0;
        }
        if (this.readClobPartially(l, 1) != 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid);
        }
        byte[] byArray = this.string2bytes(string);
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            int n3 = this.conn.lobWrite(this.lobHandle.getPackedLobHandle(), this.clobBytePos + (long)n2, byArray, n2, Math.min(n, 131072));
            n -= n3;
            n2 += n3;
        }
        this.lobHandle.setLobSize(this.clobBytePos + (long)n2);
        this.clobCharLength = this.length() + (long)string.length();
        return string.length();
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L || n < 0 || n2 < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (n + n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.isWritable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable);
        }
        if (string == null || n2 == 0) {
            return 0;
        }
        return this.setString(l, string.substring(n, n + n2));
    }

    public synchronized OutputStream setAsciiStream(long l) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (!this.isWritable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable);
        }
        if (this.readClobPartially(l, 1) != 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid);
        }
        CUBRIDBufferedOutputStream cUBRIDBufferedOutputStream = new CUBRIDBufferedOutputStream(new CUBRIDClobOutputStream(this, this.clobBytePos + 1L), 131072);
        this.addFlushableStream(cUBRIDBufferedOutputStream);
        return cUBRIDBufferedOutputStream;
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (this.lobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (l < 1L) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (!this.isWritable) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable);
        }
        if (this.readClobPartially(l, 1) != 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid);
        }
        CUBRIDBufferedWriter cUBRIDBufferedWriter = new CUBRIDBufferedWriter(new CUBRIDClobWriter(this, l), 65536);
        this.addFlushableStream(cUBRIDBufferedWriter);
        return cUBRIDBufferedWriter;
    }

    public void truncate(long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void free() throws SQLException {
        this.conn = null;
        this.lobHandle = null;
        this.streamList = null;
        this.clobCharBuffer = null;
        this.clobByteBuffer = null;
        this.isWritable = false;
    }

    private int readClobPartially(long l, int n) throws SQLException {
        if (this.clobCharLength != -1L && l > this.clobCharLength) {
            this.clobBytePos = this.clobNextReadBytePos = this.lobHandle.getLobSize();
            this.clobCharPos = this.clobCharLength;
            this.clobCharBuffer.setLength(0);
            if (l == this.clobCharLength + 1L) {
                return 0;
            }
            return -1;
        }
        if (--l < this.clobCharPos) {
            this.clobNextReadBytePos = 0L;
            this.clobBytePos = 0L;
            this.clobCharPos = 0L;
            this.clobCharBuffer.setLength(0);
            this.readClob();
        }
        while (l >= this.clobCharPos + (long)this.clobCharBuffer.length()) {
            this.clobBytePos = this.clobNextReadBytePos;
            this.clobCharPos += (long)this.clobCharBuffer.length();
            this.clobCharBuffer.setLength(0);
            if (this.clobNextReadBytePos >= this.lobHandle.getLobSize()) {
                return 0;
            }
            this.readClob();
        }
        int n2 = (int)(l - this.clobCharPos);
        if (n2 > 0) {
            this.clobCharPos = l;
            this.clobBytePos += (long)this.string2bytes(this.clobCharBuffer.substring(0, n2)).length;
            this.clobCharBuffer.delete(0, n2);
        }
        while (n > this.clobCharBuffer.length()) {
            if (this.clobNextReadBytePos >= this.lobHandle.getLobSize()) {
                return this.clobCharBuffer.length();
            }
            this.readClob();
        }
        return n;
    }

    private void readClob() throws SQLException {
        if (this.conn == null || this.lobHandle == null) {
            throw new NullPointerException();
        }
        int n = this.conn.lobRead(this.lobHandle.getPackedLobHandle(), this.clobNextReadBytePos, this.clobByteBuffer, 0, 131072);
        StringBuffer stringBuffer = new StringBuffer(this.bytes2string(this.clobByteBuffer, 0, n));
        if (this.clobNextReadBytePos + (long)n >= this.lobHandle.getLobSize()) {
            this.clobNextReadBytePos += (long)n;
            this.clobCharLength = this.clobCharPos + (long)this.clobCharBuffer.length() + (long)stringBuffer.length();
        } else {
            this.clobNextReadBytePos += (long)this.string2bytes(stringBuffer.substring(0, stringBuffer.length() - 1)).length;
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        this.clobCharBuffer.append(stringBuffer);
    }

    private byte[] string2bytes(String string) throws SQLException {
        try {
            return string.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown, unsupportedEncodingException.getMessage());
        }
    }

    private String bytes2string(byte[] byArray, int n, int n2) throws SQLException {
        try {
            return new String(byArray, n, n2, this.charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown, unsupportedEncodingException.getMessage());
        }
    }

    public CUBRIDLobHandle getLobHandle() {
        return this.lobHandle;
    }

    private void addFlushableStream(Flushable flushable) {
        this.streamList.add(flushable);
    }

    public void removeFlushableStream(Flushable flushable) {
        this.streamList.remove(flushable);
    }

    public void flushFlushableStreams() {
        if (!this.streamList.isEmpty()) {
            for (Flushable flushable : this.streamList) {
                try {
                    flushable.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.lobHandle.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof CUBRIDClob) {
            CUBRIDClob cUBRIDClob = (CUBRIDClob)object;
            return this.lobHandle.equals(cUBRIDClob.lobHandle);
        }
        return false;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.conn == null || this.lobHandle == null) {
            throw new NullPointerException();
        }
        if (l < 1L || n < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (n == 0) {
            return new byte[0];
        }
        int n2 = 0;
        if (--l + (long)n > this.lobHandle.getLobSize()) {
            n = (int)(this.lobHandle.getLobSize() - l);
        }
        byte[] byArray = new byte[n];
        while (n > 0) {
            int n3 = Math.min(n, 131072);
            int n4 = this.conn.lobRead(this.lobHandle.getPackedLobHandle(), l, byArray, n2, n3);
            l += (long)n4;
            n -= n4;
            n2 += n4;
            if (n4 != 0) continue;
        }
        if (n2 < byArray.length) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown);
        }
        return byArray;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.conn == null || this.lobHandle == null) {
            throw new NullPointerException();
        }
        if (l < 1L || n < 0 || n2 < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isWritable) {
            if (this.lobHandle.getLobSize() + 1L != l) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid);
            }
            --l;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 131072);
                int n5 = this.conn.lobWrite(this.lobHandle.getPackedLobHandle(), l, byArray, n, n4);
                l += (long)n5;
                n2 -= n5;
                n += n5;
                n3 += n5;
            }
            if (l > this.lobHandle.getLobSize()) {
                this.lobHandle.setLobSize(l);
                this.clobCharLength = -1L;
            }
            return n3;
        }
        throw new CUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable);
    }
}

