// Compiled by ClojureScript 1.7.228 {}
goog.provide('cublono.normalize');
goog.require('cljs.core');
goog.require('cublono.util');
goog.require('clojure.string');
/**
 * Removes all map entries where the value of the entry is empty.
 */
cublono.normalize.compact_map = (function cublono$normalize$compact_map(m){
return cljs.core.reduce.call(null,(function (m__$1,k){
var v = cljs.core.get.call(null,m__$1,k);
if(cljs.core.empty_QMARK_.call(null,v)){
return cljs.core.dissoc.call(null,m__$1,k);
} else {
return m__$1;
}
}),m,cljs.core.keys.call(null,m));
});
cublono.normalize.class_name = (function cublono$normalize$class_name(x){
if(typeof x === 'string'){
return x;
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name.call(null,x);
} else {
return x;

}
}
});
/**
 * Normalize `class` into a vector of classes.
 */
cublono.normalize.class$ = (function cublono$normalize$class(class$__$1){
if((class$__$1 == null)){
return null;
} else {
if(cljs.core.list_QMARK_.call(null,class$__$1)){
if((cljs.core.first.call(null,class$__$1) instanceof cljs.core.Symbol)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [class$__$1], null);
} else {
return cljs.core.map.call(null,cublono.normalize.class_name,class$__$1);
}
} else {
if((class$__$1 instanceof cljs.core.Symbol)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [class$__$1], null);
} else {
if(typeof class$__$1 === 'string'){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [class$__$1], null);
} else {
if((class$__$1 instanceof cljs.core.Keyword)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cublono.normalize.class_name.call(null,class$__$1)], null);
} else {
if(((cljs.core.set_QMARK_.call(null,class$__$1)) || (cljs.core.sequential_QMARK_.call(null,class$__$1))) && (cljs.core.every_QMARK_.call(null,(function (p1__10690_SHARP_){
return ((p1__10690_SHARP_ instanceof cljs.core.Keyword)) || (typeof p1__10690_SHARP_ === 'string');
}),class$__$1))){
return cljs.core.mapv.call(null,cublono.normalize.class_name,class$__$1);
} else {
if((cljs.core.set_QMARK_.call(null,class$__$1)) || (cljs.core.sequential_QMARK_.call(null,class$__$1))){
return cljs.core.mapv.call(null,cublono.normalize.class_name,class$__$1);
} else {
return class$__$1;

}
}
}
}
}
}
}
});
/**
 * Normalize the `attrs` of an element.
 */
cublono.normalize.attributes = (function cublono$normalize$attributes(attrs){
var G__10696 = attrs;
if(cljs.core.truth_(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(attrs))){
return cljs.core.update_in.call(null,G__10696,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"class","class",-2030961996)], null),cublono.normalize.class$);
} else {
return G__10696;
}
});
/**
 * Like clojure.core/merge but concatenate :class entries.
 */
cublono.normalize.merge_with_class = (function cublono$normalize$merge_with_class(var_args){
var args__7114__auto__ = [];
var len__7107__auto___10699 = arguments.length;
var i__7108__auto___10700 = (0);
while(true){
if((i__7108__auto___10700 < len__7107__auto___10699)){
args__7114__auto__.push((arguments[i__7108__auto___10700]));

var G__10701 = (i__7108__auto___10700 + (1));
i__7108__auto___10700 = G__10701;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((0) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((0)),(0))):null);
return cublono.normalize.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(argseq__7115__auto__);
});

cublono.normalize.merge_with_class.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
var maps__$1 = cljs.core.map.call(null,cublono.normalize.attributes,maps);
var classes = cljs.core.map.call(null,new cljs.core.Keyword(null,"class","class",-2030961996),maps__$1);
var classes__$1 = cljs.core.vec.call(null,cljs.core.apply.call(null,cljs.core.concat,classes));
var G__10698 = cljs.core.apply.call(null,cljs.core.merge,maps__$1);
if(!(cljs.core.empty_QMARK_.call(null,classes__$1))){
return cljs.core.assoc.call(null,G__10698,new cljs.core.Keyword(null,"class","class",-2030961996),classes__$1);
} else {
return G__10698;
}
});

cublono.normalize.merge_with_class.cljs$lang$maxFixedArity = (0);

cublono.normalize.merge_with_class.cljs$lang$applyTo = (function (seq10697){
return cublono.normalize.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10697));
});
/**
 * Strip the # and . characters from the beginning of `s`.
 */
cublono.normalize.strip_css = (function cublono$normalize$strip_css(s){
if(cljs.core.truth_(s)){
return clojure.string.replace.call(null,s,/^[.#]/,"");
} else {
return null;
}
});
/**
 * Match `s` as a CSS tag and return a vector of tag name, CSS id and
 *   CSS classes.
 */
cublono.normalize.match_tag = (function cublono$normalize$match_tag(s){
var matches = cljs.core.re_seq.call(null,/[#.]?[^#.]+/,cljs.core.name.call(null,s));
var vec__10709 = ((cljs.core.empty_QMARK_.call(null,matches))?(function(){throw cljs.core.ex_info.call(null,[cljs.core.str("Can't match CSS tag: "),cljs.core.str(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),s], null))})():((new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["#",null,".",null], null), null).call(null,cljs.core.ffirst.call(null,matches)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["div",matches], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,matches),cljs.core.rest.call(null,matches)], null)
));
var tag_name = cljs.core.nth.call(null,vec__10709,(0),null);
var names = cljs.core.nth.call(null,vec__10709,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,cljs.core.namespace.call(null,s),tag_name),cljs.core.first.call(null,cljs.core.map.call(null,cublono.normalize.strip_css,cljs.core.filter.call(null,((function (matches,vec__10709,tag_name,names){
return (function (p1__10702_SHARP_){
return cljs.core._EQ_.call(null,"#",cljs.core.first.call(null,p1__10702_SHARP_));
});})(matches,vec__10709,tag_name,names))
,names))),cljs.core.vec.call(null,cljs.core.map.call(null,cublono.normalize.strip_css,cljs.core.filter.call(null,((function (matches,vec__10709,tag_name,names){
return (function (p1__10703_SHARP_){
return cljs.core._EQ_.call(null,".",cljs.core.first.call(null,p1__10703_SHARP_));
});})(matches,vec__10709,tag_name,names))
,names)))], null);
});
/**
 * Normalize the children of a HTML element.
 */
cublono.normalize.children = (function cublono$normalize$children(x){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,((typeof x === 'string')?cljs.core._conj.call(null,cljs.core.List.EMPTY,x):((cublono.util.element_QMARK_.call(null,x))?cljs.core._conj.call(null,cljs.core.List.EMPTY,x):(((cljs.core.list_QMARK_.call(null,x)) && ((x instanceof cljs.core.Symbol)))?cljs.core._conj.call(null,cljs.core.List.EMPTY,x):((cljs.core.list_QMARK_.call(null,x))?x:(((cljs.core.sequential_QMARK_.call(null,x)) && (cljs.core.sequential_QMARK_.call(null,cljs.core.first.call(null,x))) && (!(typeof cljs.core.first.call(null,x) === 'string')) && (cljs.core.not.call(null,cublono.util.element_QMARK_.call(null,cljs.core.first.call(null,x)))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,x),(1))))?cublono$normalize$children.call(null,cljs.core.first.call(null,x)):((cljs.core.sequential_QMARK_.call(null,x))?x:cljs.core._conj.call(null,cljs.core.List.EMPTY,x)
)))))));
});
/**
 * Ensure an element vector is of the form [tag-name attrs content].
 */
cublono.normalize.element = (function cublono$normalize$element(p__10751){
var vec__10754 = p__10751;
var tag = cljs.core.nth.call(null,vec__10754,(0),null);
var content = cljs.core.nthnext.call(null,vec__10754,(1));
if(((tag instanceof cljs.core.Keyword)) || ((tag instanceof cljs.core.Symbol)) || (typeof tag === 'string')){
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str(tag),cljs.core.str(" is not a valid element name.")].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),tag,new cljs.core.Keyword(null,"content","content",15833224),content], null));
}

var vec__10755 = cublono.normalize.match_tag.call(null,tag);
var tag__$1 = cljs.core.nth.call(null,vec__10755,(0),null);
var id = cljs.core.nth.call(null,vec__10755,(1),null);
var class$ = cljs.core.nth.call(null,vec__10755,(2),null);
var tag_attrs = cublono.normalize.compact_map.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"class","class",-2030961996),class$], null));
var map_attrs = cljs.core.first.call(null,content);
if(cljs.core.map_QMARK_.call(null,map_attrs)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag__$1,cublono.normalize.merge_with_class.call(null,tag_attrs,map_attrs),cublono.normalize.children.call(null,cljs.core.next.call(null,content))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag__$1,cublono.normalize.attributes.call(null,tag_attrs),cublono.normalize.children.call(null,content)], null);
}
});

//# sourceMappingURL=normalize.js.map?rel=1472808703479