// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14407 = [];
var len__7107__auto___14417 = arguments.length;
var i__7108__auto___14418 = (0);
while(true){
if((i__7108__auto___14418 < len__7107__auto___14417)){
args14407.push((arguments[i__7108__auto___14418]));

var G__14419 = (i__7108__auto___14418 + (1));
i__7108__auto___14418 = G__14419;
continue;
} else {
}
break;
}

var G__14413 = args14407.length;
switch (G__14413) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14407.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14414 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14414 = (function (f,blockable,meta14415){
this.f = f;
this.blockable = blockable;
this.meta14415 = meta14415;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14414.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14416,meta14415__$1){
var self__ = this;
var _14416__$1 = this;
return (new cljs.core.async.t_cljs$core$async14414(self__.f,self__.blockable,meta14415__$1));
});

cljs.core.async.t_cljs$core$async14414.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14416){
var self__ = this;
var _14416__$1 = this;
return self__.meta14415;
});

cljs.core.async.t_cljs$core$async14414.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14414.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14414.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14414.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14414.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14415","meta14415",-217206662,null)], null);
});

cljs.core.async.t_cljs$core$async14414.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14414.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14414";

cljs.core.async.t_cljs$core$async14414.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14414");
});

cljs.core.async.__GT_t_cljs$core$async14414 = (function cljs$core$async$__GT_t_cljs$core$async14414(f__$1,blockable__$1,meta14415){
return (new cljs.core.async.t_cljs$core$async14414(f__$1,blockable__$1,meta14415));
});

}

return (new cljs.core.async.t_cljs$core$async14414(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14425 = [];
var len__7107__auto___14434 = arguments.length;
var i__7108__auto___14435 = (0);
while(true){
if((i__7108__auto___14435 < len__7107__auto___14434)){
args14425.push((arguments[i__7108__auto___14435]));

var G__14436 = (i__7108__auto___14435 + (1));
i__7108__auto___14435 = G__14436;
continue;
} else {
}
break;
}

var G__14430 = args14425.length;
switch (G__14430) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14425.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14442 = [];
var len__7107__auto___14446 = arguments.length;
var i__7108__auto___14448 = (0);
while(true){
if((i__7108__auto___14448 < len__7107__auto___14446)){
args14442.push((arguments[i__7108__auto___14448]));

var G__14450 = (i__7108__auto___14448 + (1));
i__7108__auto___14448 = G__14450;
continue;
} else {
}
break;
}

var G__14444 = args14442.length;
switch (G__14444) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14442.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14458 = [];
var len__7107__auto___14465 = arguments.length;
var i__7108__auto___14466 = (0);
while(true){
if((i__7108__auto___14466 < len__7107__auto___14465)){
args14458.push((arguments[i__7108__auto___14466]));

var G__14467 = (i__7108__auto___14466 + (1));
i__7108__auto___14466 = G__14467;
continue;
} else {
}
break;
}

var G__14460 = args14458.length;
switch (G__14460) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14458.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14478 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14478);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14478,ret){
return (function (){
return fn1.call(null,val_14478);
});})(val_14478,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14485 = [];
var len__7107__auto___14494 = arguments.length;
var i__7108__auto___14495 = (0);
while(true){
if((i__7108__auto___14495 < len__7107__auto___14494)){
args14485.push((arguments[i__7108__auto___14495]));

var G__14496 = (i__7108__auto___14495 + (1));
i__7108__auto___14495 = G__14496;
continue;
} else {
}
break;
}

var G__14487 = args14485.length;
switch (G__14487) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14485.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14499 = n;
var x_14500 = (0);
while(true){
if((x_14500 < n__6952__auto___14499)){
(a[x_14500] = (0));

var G__14501 = (x_14500 + (1));
x_14500 = G__14501;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14504 = (i + (1));
i = G__14504;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14512 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14512 = (function (alt_flag,flag,meta14513){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14513 = meta14513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14514,meta14513__$1){
var self__ = this;
var _14514__$1 = this;
return (new cljs.core.async.t_cljs$core$async14512(self__.alt_flag,self__.flag,meta14513__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14514){
var self__ = this;
var _14514__$1 = this;
return self__.meta14513;
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14513","meta14513",-446486442,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14512";

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14512");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14512 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14512(alt_flag__$1,flag__$1,meta14513){
return (new cljs.core.async.t_cljs$core$async14512(alt_flag__$1,flag__$1,meta14513));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14512(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14524 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14524 = (function (alt_handler,flag,cb,meta14525){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14525 = meta14525;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14526,meta14525__$1){
var self__ = this;
var _14526__$1 = this;
return (new cljs.core.async.t_cljs$core$async14524(self__.alt_handler,self__.flag,self__.cb,meta14525__$1));
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14526){
var self__ = this;
var _14526__$1 = this;
return self__.meta14525;
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14524.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14525","meta14525",581736544,null)], null);
});

cljs.core.async.t_cljs$core$async14524.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14524.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14524";

cljs.core.async.t_cljs$core$async14524.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14524");
});

cljs.core.async.__GT_t_cljs$core$async14524 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14524(alt_handler__$1,flag__$1,cb__$1,meta14525){
return (new cljs.core.async.t_cljs$core$async14524(alt_handler__$1,flag__$1,cb__$1,meta14525));
});

}

return (new cljs.core.async.t_cljs$core$async14524(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14527_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14527_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14528_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14528_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14531 = (i + (1));
i = G__14531;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14542 = arguments.length;
var i__7108__auto___14543 = (0);
while(true){
if((i__7108__auto___14543 < len__7107__auto___14542)){
args__7114__auto__.push((arguments[i__7108__auto___14543]));

var G__14544 = (i__7108__auto___14543 + (1));
i__7108__auto___14543 = G__14544;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14539){
var map__14540 = p__14539;
var map__14540__$1 = ((((!((map__14540 == null)))?((((map__14540.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14540.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14540):map__14540);
var opts = map__14540__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14537){
var G__14538 = cljs.core.first.call(null,seq14537);
var seq14537__$1 = cljs.core.next.call(null,seq14537);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14538,seq14537__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14550 = [];
var len__7107__auto___14618 = arguments.length;
var i__7108__auto___14619 = (0);
while(true){
if((i__7108__auto___14619 < len__7107__auto___14618)){
args14550.push((arguments[i__7108__auto___14619]));

var G__14620 = (i__7108__auto___14619 + (1));
i__7108__auto___14619 = G__14620;
continue;
} else {
}
break;
}

var G__14552 = args14550.length;
switch (G__14552) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14550.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14362__auto___14622 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___14622){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___14622){
return (function (state_14580){
var state_val_14592 = (state_14580[(1)]);
if((state_val_14592 === (7))){
var inst_14576 = (state_14580[(2)]);
var state_14580__$1 = state_14580;
var statearr_14593_14623 = state_14580__$1;
(statearr_14593_14623[(2)] = inst_14576);

(statearr_14593_14623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (1))){
var state_14580__$1 = state_14580;
var statearr_14594_14629 = state_14580__$1;
(statearr_14594_14629[(2)] = null);

(statearr_14594_14629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (4))){
var inst_14559 = (state_14580[(7)]);
var inst_14559__$1 = (state_14580[(2)]);
var inst_14560 = (inst_14559__$1 == null);
var state_14580__$1 = (function (){var statearr_14595 = state_14580;
(statearr_14595[(7)] = inst_14559__$1);

return statearr_14595;
})();
if(cljs.core.truth_(inst_14560)){
var statearr_14596_14630 = state_14580__$1;
(statearr_14596_14630[(1)] = (5));

} else {
var statearr_14597_14631 = state_14580__$1;
(statearr_14597_14631[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (13))){
var state_14580__$1 = state_14580;
var statearr_14598_14632 = state_14580__$1;
(statearr_14598_14632[(2)] = null);

(statearr_14598_14632[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (6))){
var inst_14559 = (state_14580[(7)]);
var state_14580__$1 = state_14580;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14580__$1,(11),to,inst_14559);
} else {
if((state_val_14592 === (3))){
var inst_14578 = (state_14580[(2)]);
var state_14580__$1 = state_14580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14580__$1,inst_14578);
} else {
if((state_val_14592 === (12))){
var state_14580__$1 = state_14580;
var statearr_14599_14633 = state_14580__$1;
(statearr_14599_14633[(2)] = null);

(statearr_14599_14633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (2))){
var state_14580__$1 = state_14580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14580__$1,(4),from);
} else {
if((state_val_14592 === (11))){
var inst_14569 = (state_14580[(2)]);
var state_14580__$1 = state_14580;
if(cljs.core.truth_(inst_14569)){
var statearr_14600_14639 = state_14580__$1;
(statearr_14600_14639[(1)] = (12));

} else {
var statearr_14601_14640 = state_14580__$1;
(statearr_14601_14640[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (9))){
var state_14580__$1 = state_14580;
var statearr_14602_14641 = state_14580__$1;
(statearr_14602_14641[(2)] = null);

(statearr_14602_14641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (5))){
var state_14580__$1 = state_14580;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14603_14642 = state_14580__$1;
(statearr_14603_14642[(1)] = (8));

} else {
var statearr_14604_14643 = state_14580__$1;
(statearr_14604_14643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (14))){
var inst_14574 = (state_14580[(2)]);
var state_14580__$1 = state_14580;
var statearr_14605_14644 = state_14580__$1;
(statearr_14605_14644[(2)] = inst_14574);

(statearr_14605_14644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (10))){
var inst_14566 = (state_14580[(2)]);
var state_14580__$1 = state_14580;
var statearr_14606_14645 = state_14580__$1;
(statearr_14606_14645[(2)] = inst_14566);

(statearr_14606_14645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14592 === (8))){
var inst_14563 = cljs.core.async.close_BANG_.call(null,to);
var state_14580__$1 = state_14580;
var statearr_14607_14646 = state_14580__$1;
(statearr_14607_14646[(2)] = inst_14563);

(statearr_14607_14646[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___14622))
;
return ((function (switch__14236__auto__,c__14362__auto___14622){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14614 = [null,null,null,null,null,null,null,null];
(statearr_14614[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14614[(1)] = (1));

return statearr_14614;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14580){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14615){if((e14615 instanceof Object)){
var ex__14240__auto__ = e14615;
var statearr_14616_14647 = state_14580;
(statearr_14616_14647[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14580);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14648 = state_14580;
state_14580 = G__14648;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14580){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___14622))
})();
var state__14364__auto__ = (function (){var statearr_14617 = f__14363__auto__.call(null);
(statearr_14617[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___14622);

return statearr_14617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___14622))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14842){
var vec__14843 = p__14842;
var v = cljs.core.nth.call(null,vec__14843,(0),null);
var p = cljs.core.nth.call(null,vec__14843,(1),null);
var job = vec__14843;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14362__auto___15025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___15025,res,vec__14843,v,p,job,jobs,results){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___15025,res,vec__14843,v,p,job,jobs,results){
return (function (state_14848){
var state_val_14849 = (state_14848[(1)]);
if((state_val_14849 === (1))){
var state_14848__$1 = state_14848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14848__$1,(2),res,v);
} else {
if((state_val_14849 === (2))){
var inst_14845 = (state_14848[(2)]);
var inst_14846 = cljs.core.async.close_BANG_.call(null,res);
var state_14848__$1 = (function (){var statearr_14850 = state_14848;
(statearr_14850[(7)] = inst_14845);

return statearr_14850;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14848__$1,inst_14846);
} else {
return null;
}
}
});})(c__14362__auto___15025,res,vec__14843,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14362__auto___15025,res,vec__14843,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14854 = [null,null,null,null,null,null,null,null];
(statearr_14854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14854[(1)] = (1));

return statearr_14854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14848){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14855){if((e14855 instanceof Object)){
var ex__14240__auto__ = e14855;
var statearr_14856_15026 = state_14848;
(statearr_14856_15026[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14855;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15027 = state_14848;
state_14848 = G__15027;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14848){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___15025,res,vec__14843,v,p,job,jobs,results))
})();
var state__14364__auto__ = (function (){var statearr_14857 = f__14363__auto__.call(null);
(statearr_14857[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___15025);

return statearr_14857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___15025,res,vec__14843,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14858){
var vec__14859 = p__14858;
var v = cljs.core.nth.call(null,vec__14859,(0),null);
var p = cljs.core.nth.call(null,vec__14859,(1),null);
var job = vec__14859;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15028 = n;
var __15029 = (0);
while(true){
if((__15029 < n__6952__auto___15028)){
var G__14860_15030 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14860_15030) {
case "compute":
var c__14362__auto___15032 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14362__auto___15032,G__14860_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14362__auto___15032,G__14860_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14873){
var state_val_14874 = (state_14873[(1)]);
if((state_val_14874 === (1))){
var state_14873__$1 = state_14873;
var statearr_14875_15033 = state_14873__$1;
(statearr_14875_15033[(2)] = null);

(statearr_14875_15033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (2))){
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14873__$1,(4),jobs);
} else {
if((state_val_14874 === (3))){
var inst_14871 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14873__$1,inst_14871);
} else {
if((state_val_14874 === (4))){
var inst_14863 = (state_14873[(2)]);
var inst_14864 = process.call(null,inst_14863);
var state_14873__$1 = state_14873;
if(cljs.core.truth_(inst_14864)){
var statearr_14876_15034 = state_14873__$1;
(statearr_14876_15034[(1)] = (5));

} else {
var statearr_14877_15035 = state_14873__$1;
(statearr_14877_15035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (5))){
var state_14873__$1 = state_14873;
var statearr_14878_15038 = state_14873__$1;
(statearr_14878_15038[(2)] = null);

(statearr_14878_15038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (6))){
var state_14873__$1 = state_14873;
var statearr_14879_15039 = state_14873__$1;
(statearr_14879_15039[(2)] = null);

(statearr_14879_15039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (7))){
var inst_14869 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
var statearr_14880_15040 = state_14873__$1;
(statearr_14880_15040[(2)] = inst_14869);

(statearr_14880_15040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14362__auto___15032,G__14860_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14362__auto___15032,G__14860_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14884 = [null,null,null,null,null,null,null];
(statearr_14884[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14884[(1)] = (1));

return statearr_14884;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14873){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14885){if((e14885 instanceof Object)){
var ex__14240__auto__ = e14885;
var statearr_14886_15041 = state_14873;
(statearr_14886_15041[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15042 = state_14873;
state_14873 = G__15042;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14362__auto___15032,G__14860_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14364__auto__ = (function (){var statearr_14887 = f__14363__auto__.call(null);
(statearr_14887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___15032);

return statearr_14887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(__15029,c__14362__auto___15032,G__14860_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
case "async":
var c__14362__auto___15043 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15029,c__14362__auto___15043,G__14860_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (__15029,c__14362__auto___15043,G__14860_15030,n__6952__auto___15028,jobs,results,process,async){
return (function (state_14900){
var state_val_14901 = (state_14900[(1)]);
if((state_val_14901 === (1))){
var state_14900__$1 = state_14900;
var statearr_14902_15044 = state_14900__$1;
(statearr_14902_15044[(2)] = null);

(statearr_14902_15044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (2))){
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14900__$1,(4),jobs);
} else {
if((state_val_14901 === (3))){
var inst_14898 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14900__$1,inst_14898);
} else {
if((state_val_14901 === (4))){
var inst_14890 = (state_14900[(2)]);
var inst_14891 = async.call(null,inst_14890);
var state_14900__$1 = state_14900;
if(cljs.core.truth_(inst_14891)){
var statearr_14903_15046 = state_14900__$1;
(statearr_14903_15046[(1)] = (5));

} else {
var statearr_14904_15047 = state_14900__$1;
(statearr_14904_15047[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (5))){
var state_14900__$1 = state_14900;
var statearr_14905_15049 = state_14900__$1;
(statearr_14905_15049[(2)] = null);

(statearr_14905_15049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (6))){
var state_14900__$1 = state_14900;
var statearr_14906_15050 = state_14900__$1;
(statearr_14906_15050[(2)] = null);

(statearr_14906_15050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (7))){
var inst_14896 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
var statearr_14907_15051 = state_14900__$1;
(statearr_14907_15051[(2)] = inst_14896);

(statearr_14907_15051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15029,c__14362__auto___15043,G__14860_15030,n__6952__auto___15028,jobs,results,process,async))
;
return ((function (__15029,switch__14236__auto__,c__14362__auto___15043,G__14860_15030,n__6952__auto___15028,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14911 = [null,null,null,null,null,null,null];
(statearr_14911[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14911[(1)] = (1));

return statearr_14911;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14900){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14912){if((e14912 instanceof Object)){
var ex__14240__auto__ = e14912;
var statearr_14913_15052 = state_14900;
(statearr_14913_15052[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15053 = state_14900;
state_14900 = G__15053;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14900){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15029,switch__14236__auto__,c__14362__auto___15043,G__14860_15030,n__6952__auto___15028,jobs,results,process,async))
})();
var state__14364__auto__ = (function (){var statearr_14914 = f__14363__auto__.call(null);
(statearr_14914[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___15043);

return statearr_14914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(__15029,c__14362__auto___15043,G__14860_15030,n__6952__auto___15028,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15054 = (__15029 + (1));
__15029 = G__15054;
continue;
} else {
}
break;
}

var c__14362__auto___15055 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___15055,jobs,results,process,async){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___15055,jobs,results,process,async){
return (function (state_14936){
var state_val_14937 = (state_14936[(1)]);
if((state_val_14937 === (1))){
var state_14936__$1 = state_14936;
var statearr_14938_15062 = state_14936__$1;
(statearr_14938_15062[(2)] = null);

(statearr_14938_15062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (2))){
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14936__$1,(4),from);
} else {
if((state_val_14937 === (3))){
var inst_14934 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14936__$1,inst_14934);
} else {
if((state_val_14937 === (4))){
var inst_14917 = (state_14936[(7)]);
var inst_14917__$1 = (state_14936[(2)]);
var inst_14918 = (inst_14917__$1 == null);
var state_14936__$1 = (function (){var statearr_14939 = state_14936;
(statearr_14939[(7)] = inst_14917__$1);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14918)){
var statearr_14940_15067 = state_14936__$1;
(statearr_14940_15067[(1)] = (5));

} else {
var statearr_14941_15068 = state_14936__$1;
(statearr_14941_15068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (5))){
var inst_14920 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14936__$1 = state_14936;
var statearr_14942_15069 = state_14936__$1;
(statearr_14942_15069[(2)] = inst_14920);

(statearr_14942_15069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (6))){
var inst_14917 = (state_14936[(7)]);
var inst_14922 = (state_14936[(8)]);
var inst_14922__$1 = cljs.core.async.chan.call(null,(1));
var inst_14923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14924 = [inst_14917,inst_14922__$1];
var inst_14925 = (new cljs.core.PersistentVector(null,2,(5),inst_14923,inst_14924,null));
var state_14936__$1 = (function (){var statearr_14943 = state_14936;
(statearr_14943[(8)] = inst_14922__$1);

return statearr_14943;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(8),jobs,inst_14925);
} else {
if((state_val_14937 === (7))){
var inst_14932 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14944_15070 = state_14936__$1;
(statearr_14944_15070[(2)] = inst_14932);

(statearr_14944_15070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (8))){
var inst_14922 = (state_14936[(8)]);
var inst_14927 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14945 = state_14936;
(statearr_14945[(9)] = inst_14927);

return statearr_14945;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(9),results,inst_14922);
} else {
if((state_val_14937 === (9))){
var inst_14929 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14946 = state_14936;
(statearr_14946[(10)] = inst_14929);

return statearr_14946;
})();
var statearr_14947_15071 = state_14936__$1;
(statearr_14947_15071[(2)] = null);

(statearr_14947_15071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___15055,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14362__auto___15055,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14951 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14951[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14951[(1)] = (1));

return statearr_14951;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14936){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14952){if((e14952 instanceof Object)){
var ex__14240__auto__ = e14952;
var statearr_14953_15072 = state_14936;
(statearr_14953_15072[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15073 = state_14936;
state_14936 = G__15073;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14936){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___15055,jobs,results,process,async))
})();
var state__14364__auto__ = (function (){var statearr_14954 = f__14363__auto__.call(null);
(statearr_14954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___15055);

return statearr_14954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___15055,jobs,results,process,async))
);


var c__14362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto__,jobs,results,process,async){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto__,jobs,results,process,async){
return (function (state_14992){
var state_val_14993 = (state_14992[(1)]);
if((state_val_14993 === (7))){
var inst_14988 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_14994_15074 = state_14992__$1;
(statearr_14994_15074[(2)] = inst_14988);

(statearr_14994_15074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (20))){
var state_14992__$1 = state_14992;
var statearr_14995_15075 = state_14992__$1;
(statearr_14995_15075[(2)] = null);

(statearr_14995_15075[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (1))){
var state_14992__$1 = state_14992;
var statearr_14996_15076 = state_14992__$1;
(statearr_14996_15076[(2)] = null);

(statearr_14996_15076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (4))){
var inst_14957 = (state_14992[(7)]);
var inst_14957__$1 = (state_14992[(2)]);
var inst_14958 = (inst_14957__$1 == null);
var state_14992__$1 = (function (){var statearr_14997 = state_14992;
(statearr_14997[(7)] = inst_14957__$1);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14958)){
var statearr_14998_15079 = state_14992__$1;
(statearr_14998_15079[(1)] = (5));

} else {
var statearr_14999_15080 = state_14992__$1;
(statearr_14999_15080[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (15))){
var inst_14970 = (state_14992[(8)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14992__$1,(18),to,inst_14970);
} else {
if((state_val_14993 === (21))){
var inst_14983 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15000_15081 = state_14992__$1;
(statearr_15000_15081[(2)] = inst_14983);

(statearr_15000_15081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (13))){
var inst_14985 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15001 = state_14992;
(statearr_15001[(9)] = inst_14985);

return statearr_15001;
})();
var statearr_15002_15082 = state_14992__$1;
(statearr_15002_15082[(2)] = null);

(statearr_15002_15082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (6))){
var inst_14957 = (state_14992[(7)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(11),inst_14957);
} else {
if((state_val_14993 === (17))){
var inst_14978 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
if(cljs.core.truth_(inst_14978)){
var statearr_15003_15085 = state_14992__$1;
(statearr_15003_15085[(1)] = (19));

} else {
var statearr_15004_15087 = state_14992__$1;
(statearr_15004_15087[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (3))){
var inst_14990 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14992__$1,inst_14990);
} else {
if((state_val_14993 === (12))){
var inst_14967 = (state_14992[(10)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(14),inst_14967);
} else {
if((state_val_14993 === (2))){
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(4),results);
} else {
if((state_val_14993 === (19))){
var state_14992__$1 = state_14992;
var statearr_15005_15089 = state_14992__$1;
(statearr_15005_15089[(2)] = null);

(statearr_15005_15089[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (11))){
var inst_14967 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15006 = state_14992;
(statearr_15006[(10)] = inst_14967);

return statearr_15006;
})();
var statearr_15007_15090 = state_14992__$1;
(statearr_15007_15090[(2)] = null);

(statearr_15007_15090[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (9))){
var state_14992__$1 = state_14992;
var statearr_15008_15091 = state_14992__$1;
(statearr_15008_15091[(2)] = null);

(statearr_15008_15091[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (5))){
var state_14992__$1 = state_14992;
if(close_QMARK_){
var statearr_15009_15092 = state_14992__$1;
(statearr_15009_15092[(1)] = (8));

} else {
var statearr_15010_15093 = state_14992__$1;
(statearr_15010_15093[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (14))){
var inst_14972 = (state_14992[(11)]);
var inst_14970 = (state_14992[(8)]);
var inst_14970__$1 = (state_14992[(2)]);
var inst_14971 = (inst_14970__$1 == null);
var inst_14972__$1 = cljs.core.not.call(null,inst_14971);
var state_14992__$1 = (function (){var statearr_15011 = state_14992;
(statearr_15011[(11)] = inst_14972__$1);

(statearr_15011[(8)] = inst_14970__$1);

return statearr_15011;
})();
if(inst_14972__$1){
var statearr_15012_15094 = state_14992__$1;
(statearr_15012_15094[(1)] = (15));

} else {
var statearr_15013_15095 = state_14992__$1;
(statearr_15013_15095[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (16))){
var inst_14972 = (state_14992[(11)]);
var state_14992__$1 = state_14992;
var statearr_15014_15099 = state_14992__$1;
(statearr_15014_15099[(2)] = inst_14972);

(statearr_15014_15099[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (10))){
var inst_14964 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15015_15100 = state_14992__$1;
(statearr_15015_15100[(2)] = inst_14964);

(statearr_15015_15100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (18))){
var inst_14975 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15016_15101 = state_14992__$1;
(statearr_15016_15101[(2)] = inst_14975);

(statearr_15016_15101[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (8))){
var inst_14961 = cljs.core.async.close_BANG_.call(null,to);
var state_14992__$1 = state_14992;
var statearr_15017_15102 = state_14992__$1;
(statearr_15017_15102[(2)] = inst_14961);

(statearr_15017_15102[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15021[(1)] = (1));

return statearr_15021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14992){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15022){if((e15022 instanceof Object)){
var ex__14240__auto__ = e15022;
var statearr_15023_15103 = state_14992;
(statearr_15023_15103[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15105 = state_14992;
state_14992 = G__15105;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14992){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto__,jobs,results,process,async))
})();
var state__14364__auto__ = (function (){var statearr_15024 = f__14363__auto__.call(null);
(statearr_15024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto__);

return statearr_15024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto__,jobs,results,process,async))
);

return c__14362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15106 = [];
var len__7107__auto___15109 = arguments.length;
var i__7108__auto___15110 = (0);
while(true){
if((i__7108__auto___15110 < len__7107__auto___15109)){
args15106.push((arguments[i__7108__auto___15110]));

var G__15111 = (i__7108__auto___15110 + (1));
i__7108__auto___15110 = G__15111;
continue;
} else {
}
break;
}

var G__15108 = args15106.length;
switch (G__15108) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15106.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15113 = [];
var len__7107__auto___15116 = arguments.length;
var i__7108__auto___15117 = (0);
while(true){
if((i__7108__auto___15117 < len__7107__auto___15116)){
args15113.push((arguments[i__7108__auto___15117]));

var G__15118 = (i__7108__auto___15117 + (1));
i__7108__auto___15117 = G__15118;
continue;
} else {
}
break;
}

var G__15115 = args15113.length;
switch (G__15115) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15113.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15120 = [];
var len__7107__auto___15173 = arguments.length;
var i__7108__auto___15174 = (0);
while(true){
if((i__7108__auto___15174 < len__7107__auto___15173)){
args15120.push((arguments[i__7108__auto___15174]));

var G__15175 = (i__7108__auto___15174 + (1));
i__7108__auto___15174 = G__15175;
continue;
} else {
}
break;
}

var G__15122 = args15120.length;
switch (G__15122) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15120.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14362__auto___15185 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___15185,tc,fc){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___15185,tc,fc){
return (function (state_15148){
var state_val_15149 = (state_15148[(1)]);
if((state_val_15149 === (7))){
var inst_15144 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15150_15191 = state_15148__$1;
(statearr_15150_15191[(2)] = inst_15144);

(statearr_15150_15191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (1))){
var state_15148__$1 = state_15148;
var statearr_15151_15197 = state_15148__$1;
(statearr_15151_15197[(2)] = null);

(statearr_15151_15197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (4))){
var inst_15125 = (state_15148[(7)]);
var inst_15125__$1 = (state_15148[(2)]);
var inst_15126 = (inst_15125__$1 == null);
var state_15148__$1 = (function (){var statearr_15152 = state_15148;
(statearr_15152[(7)] = inst_15125__$1);

return statearr_15152;
})();
if(cljs.core.truth_(inst_15126)){
var statearr_15153_15205 = state_15148__$1;
(statearr_15153_15205[(1)] = (5));

} else {
var statearr_15154_15210 = state_15148__$1;
(statearr_15154_15210[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (13))){
var state_15148__$1 = state_15148;
var statearr_15155_15211 = state_15148__$1;
(statearr_15155_15211[(2)] = null);

(statearr_15155_15211[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (6))){
var inst_15125 = (state_15148[(7)]);
var inst_15131 = p.call(null,inst_15125);
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15131)){
var statearr_15156_15212 = state_15148__$1;
(statearr_15156_15212[(1)] = (9));

} else {
var statearr_15157_15213 = state_15148__$1;
(statearr_15157_15213[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (3))){
var inst_15146 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15148__$1,inst_15146);
} else {
if((state_val_15149 === (12))){
var state_15148__$1 = state_15148;
var statearr_15158_15214 = state_15148__$1;
(statearr_15158_15214[(2)] = null);

(statearr_15158_15214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (2))){
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15148__$1,(4),ch);
} else {
if((state_val_15149 === (11))){
var inst_15125 = (state_15148[(7)]);
var inst_15135 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15148__$1,(8),inst_15135,inst_15125);
} else {
if((state_val_15149 === (9))){
var state_15148__$1 = state_15148;
var statearr_15159_15215 = state_15148__$1;
(statearr_15159_15215[(2)] = tc);

(statearr_15159_15215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (5))){
var inst_15128 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15129 = cljs.core.async.close_BANG_.call(null,fc);
var state_15148__$1 = (function (){var statearr_15160 = state_15148;
(statearr_15160[(8)] = inst_15128);

return statearr_15160;
})();
var statearr_15161_15216 = state_15148__$1;
(statearr_15161_15216[(2)] = inst_15129);

(statearr_15161_15216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (14))){
var inst_15142 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15162_15217 = state_15148__$1;
(statearr_15162_15217[(2)] = inst_15142);

(statearr_15162_15217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (10))){
var state_15148__$1 = state_15148;
var statearr_15163_15218 = state_15148__$1;
(statearr_15163_15218[(2)] = fc);

(statearr_15163_15218[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (8))){
var inst_15137 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15137)){
var statearr_15164_15219 = state_15148__$1;
(statearr_15164_15219[(1)] = (12));

} else {
var statearr_15165_15220 = state_15148__$1;
(statearr_15165_15220[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___15185,tc,fc))
;
return ((function (switch__14236__auto__,c__14362__auto___15185,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15169 = [null,null,null,null,null,null,null,null,null];
(statearr_15169[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15169[(1)] = (1));

return statearr_15169;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15148){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15170){if((e15170 instanceof Object)){
var ex__14240__auto__ = e15170;
var statearr_15171_15224 = state_15148;
(statearr_15171_15224[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15148);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15170;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15225 = state_15148;
state_15148 = G__15225;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15148){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___15185,tc,fc))
})();
var state__14364__auto__ = (function (){var statearr_15172 = f__14363__auto__.call(null);
(statearr_15172[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___15185);

return statearr_15172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___15185,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto__){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto__){
return (function (state_15292){
var state_val_15293 = (state_15292[(1)]);
if((state_val_15293 === (7))){
var inst_15288 = (state_15292[(2)]);
var state_15292__$1 = state_15292;
var statearr_15294_15317 = state_15292__$1;
(statearr_15294_15317[(2)] = inst_15288);

(statearr_15294_15317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15293 === (1))){
var inst_15272 = init;
var state_15292__$1 = (function (){var statearr_15296 = state_15292;
(statearr_15296[(7)] = inst_15272);

return statearr_15296;
})();
var statearr_15297_15318 = state_15292__$1;
(statearr_15297_15318[(2)] = null);

(statearr_15297_15318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15293 === (4))){
var inst_15275 = (state_15292[(8)]);
var inst_15275__$1 = (state_15292[(2)]);
var inst_15276 = (inst_15275__$1 == null);
var state_15292__$1 = (function (){var statearr_15298 = state_15292;
(statearr_15298[(8)] = inst_15275__$1);

return statearr_15298;
})();
if(cljs.core.truth_(inst_15276)){
var statearr_15299_15322 = state_15292__$1;
(statearr_15299_15322[(1)] = (5));

} else {
var statearr_15300_15323 = state_15292__$1;
(statearr_15300_15323[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15293 === (6))){
var inst_15272 = (state_15292[(7)]);
var inst_15275 = (state_15292[(8)]);
var inst_15279 = (state_15292[(9)]);
var inst_15279__$1 = f.call(null,inst_15272,inst_15275);
var inst_15280 = cljs.core.reduced_QMARK_.call(null,inst_15279__$1);
var state_15292__$1 = (function (){var statearr_15302 = state_15292;
(statearr_15302[(9)] = inst_15279__$1);

return statearr_15302;
})();
if(inst_15280){
var statearr_15303_15324 = state_15292__$1;
(statearr_15303_15324[(1)] = (8));

} else {
var statearr_15304_15325 = state_15292__$1;
(statearr_15304_15325[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15293 === (3))){
var inst_15290 = (state_15292[(2)]);
var state_15292__$1 = state_15292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15292__$1,inst_15290);
} else {
if((state_val_15293 === (2))){
var state_15292__$1 = state_15292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15292__$1,(4),ch);
} else {
if((state_val_15293 === (9))){
var inst_15279 = (state_15292[(9)]);
var inst_15272 = inst_15279;
var state_15292__$1 = (function (){var statearr_15305 = state_15292;
(statearr_15305[(7)] = inst_15272);

return statearr_15305;
})();
var statearr_15306_15326 = state_15292__$1;
(statearr_15306_15326[(2)] = null);

(statearr_15306_15326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15293 === (5))){
var inst_15272 = (state_15292[(7)]);
var state_15292__$1 = state_15292;
var statearr_15307_15327 = state_15292__$1;
(statearr_15307_15327[(2)] = inst_15272);

(statearr_15307_15327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15293 === (10))){
var inst_15286 = (state_15292[(2)]);
var state_15292__$1 = state_15292;
var statearr_15308_15328 = state_15292__$1;
(statearr_15308_15328[(2)] = inst_15286);

(statearr_15308_15328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15293 === (8))){
var inst_15279 = (state_15292[(9)]);
var inst_15282 = cljs.core.deref.call(null,inst_15279);
var state_15292__$1 = state_15292;
var statearr_15309_15330 = state_15292__$1;
(statearr_15309_15330[(2)] = inst_15282);

(statearr_15309_15330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto__))
;
return ((function (switch__14236__auto__,c__14362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15313 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15313[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15313[(1)] = (1));

return statearr_15313;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15292){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15314){if((e15314 instanceof Object)){
var ex__14240__auto__ = e15314;
var statearr_15315_15331 = state_15292;
(statearr_15315_15331[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15292);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15314;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15332 = state_15292;
state_15292 = G__15332;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15292){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto__))
})();
var state__14364__auto__ = (function (){var statearr_15316 = f__14363__auto__.call(null);
(statearr_15316[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto__);

return statearr_15316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto__))
);

return c__14362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15333 = [];
var len__7107__auto___15385 = arguments.length;
var i__7108__auto___15386 = (0);
while(true){
if((i__7108__auto___15386 < len__7107__auto___15385)){
args15333.push((arguments[i__7108__auto___15386]));

var G__15387 = (i__7108__auto___15386 + (1));
i__7108__auto___15386 = G__15387;
continue;
} else {
}
break;
}

var G__15335 = args15333.length;
switch (G__15335) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15333.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto__){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto__){
return (function (state_15360){
var state_val_15361 = (state_15360[(1)]);
if((state_val_15361 === (7))){
var inst_15342 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15362_15389 = state_15360__$1;
(statearr_15362_15389[(2)] = inst_15342);

(statearr_15362_15389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (1))){
var inst_15336 = cljs.core.seq.call(null,coll);
var inst_15337 = inst_15336;
var state_15360__$1 = (function (){var statearr_15363 = state_15360;
(statearr_15363[(7)] = inst_15337);

return statearr_15363;
})();
var statearr_15364_15390 = state_15360__$1;
(statearr_15364_15390[(2)] = null);

(statearr_15364_15390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (4))){
var inst_15337 = (state_15360[(7)]);
var inst_15340 = cljs.core.first.call(null,inst_15337);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15360__$1,(7),ch,inst_15340);
} else {
if((state_val_15361 === (13))){
var inst_15354 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15365_15391 = state_15360__$1;
(statearr_15365_15391[(2)] = inst_15354);

(statearr_15365_15391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (6))){
var inst_15345 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
if(cljs.core.truth_(inst_15345)){
var statearr_15366_15392 = state_15360__$1;
(statearr_15366_15392[(1)] = (8));

} else {
var statearr_15367_15393 = state_15360__$1;
(statearr_15367_15393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (3))){
var inst_15358 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15360__$1,inst_15358);
} else {
if((state_val_15361 === (12))){
var state_15360__$1 = state_15360;
var statearr_15368_15394 = state_15360__$1;
(statearr_15368_15394[(2)] = null);

(statearr_15368_15394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (2))){
var inst_15337 = (state_15360[(7)]);
var state_15360__$1 = state_15360;
if(cljs.core.truth_(inst_15337)){
var statearr_15369_15395 = state_15360__$1;
(statearr_15369_15395[(1)] = (4));

} else {
var statearr_15370_15396 = state_15360__$1;
(statearr_15370_15396[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (11))){
var inst_15351 = cljs.core.async.close_BANG_.call(null,ch);
var state_15360__$1 = state_15360;
var statearr_15371_15397 = state_15360__$1;
(statearr_15371_15397[(2)] = inst_15351);

(statearr_15371_15397[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (9))){
var state_15360__$1 = state_15360;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15372_15398 = state_15360__$1;
(statearr_15372_15398[(1)] = (11));

} else {
var statearr_15373_15399 = state_15360__$1;
(statearr_15373_15399[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (5))){
var inst_15337 = (state_15360[(7)]);
var state_15360__$1 = state_15360;
var statearr_15374_15400 = state_15360__$1;
(statearr_15374_15400[(2)] = inst_15337);

(statearr_15374_15400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (10))){
var inst_15356 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15375_15403 = state_15360__$1;
(statearr_15375_15403[(2)] = inst_15356);

(statearr_15375_15403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (8))){
var inst_15337 = (state_15360[(7)]);
var inst_15347 = cljs.core.next.call(null,inst_15337);
var inst_15337__$1 = inst_15347;
var state_15360__$1 = (function (){var statearr_15376 = state_15360;
(statearr_15376[(7)] = inst_15337__$1);

return statearr_15376;
})();
var statearr_15377_15404 = state_15360__$1;
(statearr_15377_15404[(2)] = null);

(statearr_15377_15404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto__))
;
return ((function (switch__14236__auto__,c__14362__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15381 = [null,null,null,null,null,null,null,null];
(statearr_15381[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15381[(1)] = (1));

return statearr_15381;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15360){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15382){if((e15382 instanceof Object)){
var ex__14240__auto__ = e15382;
var statearr_15383_15406 = state_15360;
(statearr_15383_15406[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15410 = state_15360;
state_15360 = G__15410;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto__))
})();
var state__14364__auto__ = (function (){var statearr_15384 = f__14363__auto__.call(null);
(statearr_15384[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto__);

return statearr_15384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto__))
);

return c__14362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15643 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15643 = (function (mult,ch,cs,meta15644){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15644 = meta15644;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15645,meta15644__$1){
var self__ = this;
var _15645__$1 = this;
return (new cljs.core.async.t_cljs$core$async15643(self__.mult,self__.ch,self__.cs,meta15644__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15645){
var self__ = this;
var _15645__$1 = this;
return self__.meta15644;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15644","meta15644",-632527378,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15643.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15643.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15643";

cljs.core.async.t_cljs$core$async15643.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15643");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15643 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15643(mult__$1,ch__$1,cs__$1,meta15644){
return (new cljs.core.async.t_cljs$core$async15643(mult__$1,ch__$1,cs__$1,meta15644));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15643(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14362__auto___15881 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___15881,cs,m,dchan,dctr,done){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___15881,cs,m,dchan,dctr,done){
return (function (state_15776){
var state_val_15777 = (state_15776[(1)]);
if((state_val_15777 === (7))){
var inst_15772 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15778_15882 = state_15776__$1;
(statearr_15778_15882[(2)] = inst_15772);

(statearr_15778_15882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (20))){
var inst_15677 = (state_15776[(7)]);
var inst_15687 = cljs.core.first.call(null,inst_15677);
var inst_15688 = cljs.core.nth.call(null,inst_15687,(0),null);
var inst_15689 = cljs.core.nth.call(null,inst_15687,(1),null);
var state_15776__$1 = (function (){var statearr_15779 = state_15776;
(statearr_15779[(8)] = inst_15688);

return statearr_15779;
})();
if(cljs.core.truth_(inst_15689)){
var statearr_15780_15883 = state_15776__$1;
(statearr_15780_15883[(1)] = (22));

} else {
var statearr_15781_15884 = state_15776__$1;
(statearr_15781_15884[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (27))){
var inst_15724 = (state_15776[(9)]);
var inst_15719 = (state_15776[(10)]);
var inst_15717 = (state_15776[(11)]);
var inst_15648 = (state_15776[(12)]);
var inst_15724__$1 = cljs.core._nth.call(null,inst_15717,inst_15719);
var inst_15725 = cljs.core.async.put_BANG_.call(null,inst_15724__$1,inst_15648,done);
var state_15776__$1 = (function (){var statearr_15782 = state_15776;
(statearr_15782[(9)] = inst_15724__$1);

return statearr_15782;
})();
if(cljs.core.truth_(inst_15725)){
var statearr_15783_15885 = state_15776__$1;
(statearr_15783_15885[(1)] = (30));

} else {
var statearr_15784_15886 = state_15776__$1;
(statearr_15784_15886[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (1))){
var state_15776__$1 = state_15776;
var statearr_15785_15887 = state_15776__$1;
(statearr_15785_15887[(2)] = null);

(statearr_15785_15887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (24))){
var inst_15677 = (state_15776[(7)]);
var inst_15694 = (state_15776[(2)]);
var inst_15695 = cljs.core.next.call(null,inst_15677);
var inst_15657 = inst_15695;
var inst_15658 = null;
var inst_15659 = (0);
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15786 = state_15776;
(statearr_15786[(13)] = inst_15660);

(statearr_15786[(14)] = inst_15658);

(statearr_15786[(15)] = inst_15694);

(statearr_15786[(16)] = inst_15659);

(statearr_15786[(17)] = inst_15657);

return statearr_15786;
})();
var statearr_15787_15888 = state_15776__$1;
(statearr_15787_15888[(2)] = null);

(statearr_15787_15888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (39))){
var state_15776__$1 = state_15776;
var statearr_15791_15889 = state_15776__$1;
(statearr_15791_15889[(2)] = null);

(statearr_15791_15889[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (4))){
var inst_15648 = (state_15776[(12)]);
var inst_15648__$1 = (state_15776[(2)]);
var inst_15649 = (inst_15648__$1 == null);
var state_15776__$1 = (function (){var statearr_15792 = state_15776;
(statearr_15792[(12)] = inst_15648__$1);

return statearr_15792;
})();
if(cljs.core.truth_(inst_15649)){
var statearr_15793_15890 = state_15776__$1;
(statearr_15793_15890[(1)] = (5));

} else {
var statearr_15794_15891 = state_15776__$1;
(statearr_15794_15891[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (15))){
var inst_15660 = (state_15776[(13)]);
var inst_15658 = (state_15776[(14)]);
var inst_15659 = (state_15776[(16)]);
var inst_15657 = (state_15776[(17)]);
var inst_15673 = (state_15776[(2)]);
var inst_15674 = (inst_15660 + (1));
var tmp15788 = inst_15658;
var tmp15789 = inst_15659;
var tmp15790 = inst_15657;
var inst_15657__$1 = tmp15790;
var inst_15658__$1 = tmp15788;
var inst_15659__$1 = tmp15789;
var inst_15660__$1 = inst_15674;
var state_15776__$1 = (function (){var statearr_15795 = state_15776;
(statearr_15795[(13)] = inst_15660__$1);

(statearr_15795[(14)] = inst_15658__$1);

(statearr_15795[(16)] = inst_15659__$1);

(statearr_15795[(18)] = inst_15673);

(statearr_15795[(17)] = inst_15657__$1);

return statearr_15795;
})();
var statearr_15796_15892 = state_15776__$1;
(statearr_15796_15892[(2)] = null);

(statearr_15796_15892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (21))){
var inst_15698 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15800_15898 = state_15776__$1;
(statearr_15800_15898[(2)] = inst_15698);

(statearr_15800_15898[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (31))){
var inst_15724 = (state_15776[(9)]);
var inst_15728 = done.call(null,null);
var inst_15729 = cljs.core.async.untap_STAR_.call(null,m,inst_15724);
var state_15776__$1 = (function (){var statearr_15803 = state_15776;
(statearr_15803[(19)] = inst_15728);

return statearr_15803;
})();
var statearr_15804_15899 = state_15776__$1;
(statearr_15804_15899[(2)] = inst_15729);

(statearr_15804_15899[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (32))){
var inst_15716 = (state_15776[(20)]);
var inst_15719 = (state_15776[(10)]);
var inst_15717 = (state_15776[(11)]);
var inst_15718 = (state_15776[(21)]);
var inst_15731 = (state_15776[(2)]);
var inst_15732 = (inst_15719 + (1));
var tmp15797 = inst_15716;
var tmp15798 = inst_15717;
var tmp15799 = inst_15718;
var inst_15716__$1 = tmp15797;
var inst_15717__$1 = tmp15798;
var inst_15718__$1 = tmp15799;
var inst_15719__$1 = inst_15732;
var state_15776__$1 = (function (){var statearr_15805 = state_15776;
(statearr_15805[(20)] = inst_15716__$1);

(statearr_15805[(10)] = inst_15719__$1);

(statearr_15805[(11)] = inst_15717__$1);

(statearr_15805[(22)] = inst_15731);

(statearr_15805[(21)] = inst_15718__$1);

return statearr_15805;
})();
var statearr_15806_15901 = state_15776__$1;
(statearr_15806_15901[(2)] = null);

(statearr_15806_15901[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (40))){
var inst_15744 = (state_15776[(23)]);
var inst_15748 = done.call(null,null);
var inst_15749 = cljs.core.async.untap_STAR_.call(null,m,inst_15744);
var state_15776__$1 = (function (){var statearr_15807 = state_15776;
(statearr_15807[(24)] = inst_15748);

return statearr_15807;
})();
var statearr_15808_15905 = state_15776__$1;
(statearr_15808_15905[(2)] = inst_15749);

(statearr_15808_15905[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (33))){
var inst_15735 = (state_15776[(25)]);
var inst_15737 = cljs.core.chunked_seq_QMARK_.call(null,inst_15735);
var state_15776__$1 = state_15776;
if(inst_15737){
var statearr_15809_15906 = state_15776__$1;
(statearr_15809_15906[(1)] = (36));

} else {
var statearr_15810_15907 = state_15776__$1;
(statearr_15810_15907[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (13))){
var inst_15667 = (state_15776[(26)]);
var inst_15670 = cljs.core.async.close_BANG_.call(null,inst_15667);
var state_15776__$1 = state_15776;
var statearr_15811_15908 = state_15776__$1;
(statearr_15811_15908[(2)] = inst_15670);

(statearr_15811_15908[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (22))){
var inst_15688 = (state_15776[(8)]);
var inst_15691 = cljs.core.async.close_BANG_.call(null,inst_15688);
var state_15776__$1 = state_15776;
var statearr_15812_15909 = state_15776__$1;
(statearr_15812_15909[(2)] = inst_15691);

(statearr_15812_15909[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (36))){
var inst_15735 = (state_15776[(25)]);
var inst_15739 = cljs.core.chunk_first.call(null,inst_15735);
var inst_15740 = cljs.core.chunk_rest.call(null,inst_15735);
var inst_15741 = cljs.core.count.call(null,inst_15739);
var inst_15716 = inst_15740;
var inst_15717 = inst_15739;
var inst_15718 = inst_15741;
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15813 = state_15776;
(statearr_15813[(20)] = inst_15716);

(statearr_15813[(10)] = inst_15719);

(statearr_15813[(11)] = inst_15717);

(statearr_15813[(21)] = inst_15718);

return statearr_15813;
})();
var statearr_15814_15911 = state_15776__$1;
(statearr_15814_15911[(2)] = null);

(statearr_15814_15911[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (41))){
var inst_15735 = (state_15776[(25)]);
var inst_15751 = (state_15776[(2)]);
var inst_15752 = cljs.core.next.call(null,inst_15735);
var inst_15716 = inst_15752;
var inst_15717 = null;
var inst_15718 = (0);
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15815 = state_15776;
(statearr_15815[(20)] = inst_15716);

(statearr_15815[(10)] = inst_15719);

(statearr_15815[(11)] = inst_15717);

(statearr_15815[(27)] = inst_15751);

(statearr_15815[(21)] = inst_15718);

return statearr_15815;
})();
var statearr_15816_15912 = state_15776__$1;
(statearr_15816_15912[(2)] = null);

(statearr_15816_15912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (43))){
var state_15776__$1 = state_15776;
var statearr_15817_15913 = state_15776__$1;
(statearr_15817_15913[(2)] = null);

(statearr_15817_15913[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (29))){
var inst_15760 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15818_15914 = state_15776__$1;
(statearr_15818_15914[(2)] = inst_15760);

(statearr_15818_15914[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (44))){
var inst_15769 = (state_15776[(2)]);
var state_15776__$1 = (function (){var statearr_15819 = state_15776;
(statearr_15819[(28)] = inst_15769);

return statearr_15819;
})();
var statearr_15820_15915 = state_15776__$1;
(statearr_15820_15915[(2)] = null);

(statearr_15820_15915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (6))){
var inst_15708 = (state_15776[(29)]);
var inst_15707 = cljs.core.deref.call(null,cs);
var inst_15708__$1 = cljs.core.keys.call(null,inst_15707);
var inst_15709 = cljs.core.count.call(null,inst_15708__$1);
var inst_15710 = cljs.core.reset_BANG_.call(null,dctr,inst_15709);
var inst_15715 = cljs.core.seq.call(null,inst_15708__$1);
var inst_15716 = inst_15715;
var inst_15717 = null;
var inst_15718 = (0);
var inst_15719 = (0);
var state_15776__$1 = (function (){var statearr_15821 = state_15776;
(statearr_15821[(20)] = inst_15716);

(statearr_15821[(10)] = inst_15719);

(statearr_15821[(29)] = inst_15708__$1);

(statearr_15821[(11)] = inst_15717);

(statearr_15821[(21)] = inst_15718);

(statearr_15821[(30)] = inst_15710);

return statearr_15821;
})();
var statearr_15822_15916 = state_15776__$1;
(statearr_15822_15916[(2)] = null);

(statearr_15822_15916[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (28))){
var inst_15716 = (state_15776[(20)]);
var inst_15735 = (state_15776[(25)]);
var inst_15735__$1 = cljs.core.seq.call(null,inst_15716);
var state_15776__$1 = (function (){var statearr_15823 = state_15776;
(statearr_15823[(25)] = inst_15735__$1);

return statearr_15823;
})();
if(inst_15735__$1){
var statearr_15824_15917 = state_15776__$1;
(statearr_15824_15917[(1)] = (33));

} else {
var statearr_15825_15918 = state_15776__$1;
(statearr_15825_15918[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (25))){
var inst_15719 = (state_15776[(10)]);
var inst_15718 = (state_15776[(21)]);
var inst_15721 = (inst_15719 < inst_15718);
var inst_15722 = inst_15721;
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15722)){
var statearr_15826_15919 = state_15776__$1;
(statearr_15826_15919[(1)] = (27));

} else {
var statearr_15827_15920 = state_15776__$1;
(statearr_15827_15920[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (34))){
var state_15776__$1 = state_15776;
var statearr_15828_15926 = state_15776__$1;
(statearr_15828_15926[(2)] = null);

(statearr_15828_15926[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (17))){
var state_15776__$1 = state_15776;
var statearr_15829_15927 = state_15776__$1;
(statearr_15829_15927[(2)] = null);

(statearr_15829_15927[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (3))){
var inst_15774 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15776__$1,inst_15774);
} else {
if((state_val_15777 === (12))){
var inst_15703 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15830_15929 = state_15776__$1;
(statearr_15830_15929[(2)] = inst_15703);

(statearr_15830_15929[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (2))){
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15776__$1,(4),ch);
} else {
if((state_val_15777 === (23))){
var state_15776__$1 = state_15776;
var statearr_15832_15930 = state_15776__$1;
(statearr_15832_15930[(2)] = null);

(statearr_15832_15930[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (35))){
var inst_15758 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15834_15931 = state_15776__$1;
(statearr_15834_15931[(2)] = inst_15758);

(statearr_15834_15931[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (19))){
var inst_15677 = (state_15776[(7)]);
var inst_15681 = cljs.core.chunk_first.call(null,inst_15677);
var inst_15682 = cljs.core.chunk_rest.call(null,inst_15677);
var inst_15683 = cljs.core.count.call(null,inst_15681);
var inst_15657 = inst_15682;
var inst_15658 = inst_15681;
var inst_15659 = inst_15683;
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15835 = state_15776;
(statearr_15835[(13)] = inst_15660);

(statearr_15835[(14)] = inst_15658);

(statearr_15835[(16)] = inst_15659);

(statearr_15835[(17)] = inst_15657);

return statearr_15835;
})();
var statearr_15836_15935 = state_15776__$1;
(statearr_15836_15935[(2)] = null);

(statearr_15836_15935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (11))){
var inst_15677 = (state_15776[(7)]);
var inst_15657 = (state_15776[(17)]);
var inst_15677__$1 = cljs.core.seq.call(null,inst_15657);
var state_15776__$1 = (function (){var statearr_15837 = state_15776;
(statearr_15837[(7)] = inst_15677__$1);

return statearr_15837;
})();
if(inst_15677__$1){
var statearr_15838_15936 = state_15776__$1;
(statearr_15838_15936[(1)] = (16));

} else {
var statearr_15839_15937 = state_15776__$1;
(statearr_15839_15937[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (9))){
var inst_15705 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15840_15939 = state_15776__$1;
(statearr_15840_15939[(2)] = inst_15705);

(statearr_15840_15939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (5))){
var inst_15655 = cljs.core.deref.call(null,cs);
var inst_15656 = cljs.core.seq.call(null,inst_15655);
var inst_15657 = inst_15656;
var inst_15658 = null;
var inst_15659 = (0);
var inst_15660 = (0);
var state_15776__$1 = (function (){var statearr_15841 = state_15776;
(statearr_15841[(13)] = inst_15660);

(statearr_15841[(14)] = inst_15658);

(statearr_15841[(16)] = inst_15659);

(statearr_15841[(17)] = inst_15657);

return statearr_15841;
})();
var statearr_15842_15940 = state_15776__$1;
(statearr_15842_15940[(2)] = null);

(statearr_15842_15940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (14))){
var state_15776__$1 = state_15776;
var statearr_15845_15941 = state_15776__$1;
(statearr_15845_15941[(2)] = null);

(statearr_15845_15941[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (45))){
var inst_15766 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15846_15942 = state_15776__$1;
(statearr_15846_15942[(2)] = inst_15766);

(statearr_15846_15942[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (26))){
var inst_15708 = (state_15776[(29)]);
var inst_15762 = (state_15776[(2)]);
var inst_15763 = cljs.core.seq.call(null,inst_15708);
var state_15776__$1 = (function (){var statearr_15847 = state_15776;
(statearr_15847[(31)] = inst_15762);

return statearr_15847;
})();
if(inst_15763){
var statearr_15848_15943 = state_15776__$1;
(statearr_15848_15943[(1)] = (42));

} else {
var statearr_15849_15944 = state_15776__$1;
(statearr_15849_15944[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (16))){
var inst_15677 = (state_15776[(7)]);
var inst_15679 = cljs.core.chunked_seq_QMARK_.call(null,inst_15677);
var state_15776__$1 = state_15776;
if(inst_15679){
var statearr_15850_15945 = state_15776__$1;
(statearr_15850_15945[(1)] = (19));

} else {
var statearr_15851_15946 = state_15776__$1;
(statearr_15851_15946[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (38))){
var inst_15755 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15852_15947 = state_15776__$1;
(statearr_15852_15947[(2)] = inst_15755);

(statearr_15852_15947[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (30))){
var state_15776__$1 = state_15776;
var statearr_15853_15948 = state_15776__$1;
(statearr_15853_15948[(2)] = null);

(statearr_15853_15948[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (10))){
var inst_15660 = (state_15776[(13)]);
var inst_15658 = (state_15776[(14)]);
var inst_15666 = cljs.core._nth.call(null,inst_15658,inst_15660);
var inst_15667 = cljs.core.nth.call(null,inst_15666,(0),null);
var inst_15668 = cljs.core.nth.call(null,inst_15666,(1),null);
var state_15776__$1 = (function (){var statearr_15854 = state_15776;
(statearr_15854[(26)] = inst_15667);

return statearr_15854;
})();
if(cljs.core.truth_(inst_15668)){
var statearr_15855_15949 = state_15776__$1;
(statearr_15855_15949[(1)] = (13));

} else {
var statearr_15856_15950 = state_15776__$1;
(statearr_15856_15950[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (18))){
var inst_15701 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15857_15951 = state_15776__$1;
(statearr_15857_15951[(2)] = inst_15701);

(statearr_15857_15951[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (42))){
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15776__$1,(45),dchan);
} else {
if((state_val_15777 === (37))){
var inst_15735 = (state_15776[(25)]);
var inst_15648 = (state_15776[(12)]);
var inst_15744 = (state_15776[(23)]);
var inst_15744__$1 = cljs.core.first.call(null,inst_15735);
var inst_15745 = cljs.core.async.put_BANG_.call(null,inst_15744__$1,inst_15648,done);
var state_15776__$1 = (function (){var statearr_15858 = state_15776;
(statearr_15858[(23)] = inst_15744__$1);

return statearr_15858;
})();
if(cljs.core.truth_(inst_15745)){
var statearr_15862_15952 = state_15776__$1;
(statearr_15862_15952[(1)] = (39));

} else {
var statearr_15863_15953 = state_15776__$1;
(statearr_15863_15953[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (8))){
var inst_15660 = (state_15776[(13)]);
var inst_15659 = (state_15776[(16)]);
var inst_15662 = (inst_15660 < inst_15659);
var inst_15663 = inst_15662;
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15663)){
var statearr_15864_15955 = state_15776__$1;
(statearr_15864_15955[(1)] = (10));

} else {
var statearr_15865_15956 = state_15776__$1;
(statearr_15865_15956[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___15881,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14362__auto___15881,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15869 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15869[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15869[(1)] = (1));

return statearr_15869;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15776){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15870){if((e15870 instanceof Object)){
var ex__14240__auto__ = e15870;
var statearr_15871_15961 = state_15776;
(statearr_15871_15961[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15776);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15870;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15964 = state_15776;
state_15776 = G__15964;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15776){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___15881,cs,m,dchan,dctr,done))
})();
var state__14364__auto__ = (function (){var statearr_15872 = f__14363__auto__.call(null);
(statearr_15872[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___15881);

return statearr_15872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___15881,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15969 = [];
var len__7107__auto___15974 = arguments.length;
var i__7108__auto___15975 = (0);
while(true){
if((i__7108__auto___15975 < len__7107__auto___15974)){
args15969.push((arguments[i__7108__auto___15975]));

var G__15976 = (i__7108__auto___15975 + (1));
i__7108__auto___15975 = G__15976;
continue;
} else {
}
break;
}

var G__15973 = args15969.length;
switch (G__15973) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15969.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___16004 = arguments.length;
var i__7108__auto___16005 = (0);
while(true){
if((i__7108__auto___16005 < len__7107__auto___16004)){
args__7114__auto__.push((arguments[i__7108__auto___16005]));

var G__16006 = (i__7108__auto___16005 + (1));
i__7108__auto___16005 = G__16006;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15995){
var map__15996 = p__15995;
var map__15996__$1 = ((((!((map__15996 == null)))?((((map__15996.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15996.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15996):map__15996);
var opts = map__15996__$1;
var statearr_15998_16007 = state;
(statearr_15998_16007[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15996,map__15996__$1,opts){
return (function (val){
var statearr_16002_16009 = state;
(statearr_16002_16009[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15996,map__15996__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_16003_16010 = state;
(statearr_16003_16010[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15990){
var G__15991 = cljs.core.first.call(null,seq15990);
var seq15990__$1 = cljs.core.next.call(null,seq15990);
var G__15992 = cljs.core.first.call(null,seq15990__$1);
var seq15990__$2 = cljs.core.next.call(null,seq15990__$1);
var G__15993 = cljs.core.first.call(null,seq15990__$2);
var seq15990__$3 = cljs.core.next.call(null,seq15990__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15991,G__15992,G__15993,seq15990__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16191 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16191 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16192){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16192 = meta16192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16193,meta16192__$1){
var self__ = this;
var _16193__$1 = this;
return (new cljs.core.async.t_cljs$core$async16191(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16192__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16193){
var self__ = this;
var _16193__$1 = this;
return self__.meta16192;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16192","meta16192",-224500958,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16191.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16191.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16191";

cljs.core.async.t_cljs$core$async16191.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16191");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16191 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16191(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16192){
return (new cljs.core.async.t_cljs$core$async16191(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16192));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16191(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14362__auto___16368 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___16368,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___16368,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16291){
var state_val_16292 = (state_16291[(1)]);
if((state_val_16292 === (7))){
var inst_16209 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16293_16370 = state_16291__$1;
(statearr_16293_16370[(2)] = inst_16209);

(statearr_16293_16370[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (20))){
var inst_16221 = (state_16291[(7)]);
var state_16291__$1 = state_16291;
var statearr_16294_16371 = state_16291__$1;
(statearr_16294_16371[(2)] = inst_16221);

(statearr_16294_16371[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (27))){
var state_16291__$1 = state_16291;
var statearr_16295_16372 = state_16291__$1;
(statearr_16295_16372[(2)] = null);

(statearr_16295_16372[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (1))){
var inst_16197 = (state_16291[(8)]);
var inst_16197__$1 = calc_state.call(null);
var inst_16199 = (inst_16197__$1 == null);
var inst_16200 = cljs.core.not.call(null,inst_16199);
var state_16291__$1 = (function (){var statearr_16296 = state_16291;
(statearr_16296[(8)] = inst_16197__$1);

return statearr_16296;
})();
if(inst_16200){
var statearr_16297_16373 = state_16291__$1;
(statearr_16297_16373[(1)] = (2));

} else {
var statearr_16298_16374 = state_16291__$1;
(statearr_16298_16374[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (24))){
var inst_16265 = (state_16291[(9)]);
var inst_16244 = (state_16291[(10)]);
var inst_16251 = (state_16291[(11)]);
var inst_16265__$1 = inst_16244.call(null,inst_16251);
var state_16291__$1 = (function (){var statearr_16299 = state_16291;
(statearr_16299[(9)] = inst_16265__$1);

return statearr_16299;
})();
if(cljs.core.truth_(inst_16265__$1)){
var statearr_16300_16375 = state_16291__$1;
(statearr_16300_16375[(1)] = (29));

} else {
var statearr_16301_16376 = state_16291__$1;
(statearr_16301_16376[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (4))){
var inst_16212 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16212)){
var statearr_16302_16377 = state_16291__$1;
(statearr_16302_16377[(1)] = (8));

} else {
var statearr_16303_16378 = state_16291__$1;
(statearr_16303_16378[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (15))){
var inst_16238 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16238)){
var statearr_16304_16379 = state_16291__$1;
(statearr_16304_16379[(1)] = (19));

} else {
var statearr_16305_16380 = state_16291__$1;
(statearr_16305_16380[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (21))){
var inst_16243 = (state_16291[(12)]);
var inst_16243__$1 = (state_16291[(2)]);
var inst_16244 = cljs.core.get.call(null,inst_16243__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16245 = cljs.core.get.call(null,inst_16243__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16246 = cljs.core.get.call(null,inst_16243__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16291__$1 = (function (){var statearr_16306 = state_16291;
(statearr_16306[(12)] = inst_16243__$1);

(statearr_16306[(10)] = inst_16244);

(statearr_16306[(13)] = inst_16245);

return statearr_16306;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16291__$1,(22),inst_16246);
} else {
if((state_val_16292 === (31))){
var inst_16273 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16273)){
var statearr_16307_16381 = state_16291__$1;
(statearr_16307_16381[(1)] = (32));

} else {
var statearr_16308_16382 = state_16291__$1;
(statearr_16308_16382[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (32))){
var inst_16250 = (state_16291[(14)]);
var state_16291__$1 = state_16291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16291__$1,(35),out,inst_16250);
} else {
if((state_val_16292 === (33))){
var inst_16243 = (state_16291[(12)]);
var inst_16221 = inst_16243;
var state_16291__$1 = (function (){var statearr_16309 = state_16291;
(statearr_16309[(7)] = inst_16221);

return statearr_16309;
})();
var statearr_16310_16383 = state_16291__$1;
(statearr_16310_16383[(2)] = null);

(statearr_16310_16383[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (13))){
var inst_16221 = (state_16291[(7)]);
var inst_16228 = inst_16221.cljs$lang$protocol_mask$partition0$;
var inst_16229 = (inst_16228 & (64));
var inst_16230 = inst_16221.cljs$core$ISeq$;
var inst_16231 = (inst_16229) || (inst_16230);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16231)){
var statearr_16311_16384 = state_16291__$1;
(statearr_16311_16384[(1)] = (16));

} else {
var statearr_16312_16385 = state_16291__$1;
(statearr_16312_16385[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (22))){
var inst_16251 = (state_16291[(11)]);
var inst_16250 = (state_16291[(14)]);
var inst_16249 = (state_16291[(2)]);
var inst_16250__$1 = cljs.core.nth.call(null,inst_16249,(0),null);
var inst_16251__$1 = cljs.core.nth.call(null,inst_16249,(1),null);
var inst_16252 = (inst_16250__$1 == null);
var inst_16253 = cljs.core._EQ_.call(null,inst_16251__$1,change);
var inst_16254 = (inst_16252) || (inst_16253);
var state_16291__$1 = (function (){var statearr_16313 = state_16291;
(statearr_16313[(11)] = inst_16251__$1);

(statearr_16313[(14)] = inst_16250__$1);

return statearr_16313;
})();
if(cljs.core.truth_(inst_16254)){
var statearr_16314_16386 = state_16291__$1;
(statearr_16314_16386[(1)] = (23));

} else {
var statearr_16315_16387 = state_16291__$1;
(statearr_16315_16387[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (36))){
var inst_16243 = (state_16291[(12)]);
var inst_16221 = inst_16243;
var state_16291__$1 = (function (){var statearr_16316 = state_16291;
(statearr_16316[(7)] = inst_16221);

return statearr_16316;
})();
var statearr_16317_16392 = state_16291__$1;
(statearr_16317_16392[(2)] = null);

(statearr_16317_16392[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (29))){
var inst_16265 = (state_16291[(9)]);
var state_16291__$1 = state_16291;
var statearr_16318_16394 = state_16291__$1;
(statearr_16318_16394[(2)] = inst_16265);

(statearr_16318_16394[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (6))){
var state_16291__$1 = state_16291;
var statearr_16319_16398 = state_16291__$1;
(statearr_16319_16398[(2)] = false);

(statearr_16319_16398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (28))){
var inst_16261 = (state_16291[(2)]);
var inst_16262 = calc_state.call(null);
var inst_16221 = inst_16262;
var state_16291__$1 = (function (){var statearr_16320 = state_16291;
(statearr_16320[(15)] = inst_16261);

(statearr_16320[(7)] = inst_16221);

return statearr_16320;
})();
var statearr_16321_16399 = state_16291__$1;
(statearr_16321_16399[(2)] = null);

(statearr_16321_16399[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (25))){
var inst_16287 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16322_16400 = state_16291__$1;
(statearr_16322_16400[(2)] = inst_16287);

(statearr_16322_16400[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (34))){
var inst_16285 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16323_16401 = state_16291__$1;
(statearr_16323_16401[(2)] = inst_16285);

(statearr_16323_16401[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (17))){
var state_16291__$1 = state_16291;
var statearr_16324_16402 = state_16291__$1;
(statearr_16324_16402[(2)] = false);

(statearr_16324_16402[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (3))){
var state_16291__$1 = state_16291;
var statearr_16325_16403 = state_16291__$1;
(statearr_16325_16403[(2)] = false);

(statearr_16325_16403[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (12))){
var inst_16289 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16291__$1,inst_16289);
} else {
if((state_val_16292 === (2))){
var inst_16197 = (state_16291[(8)]);
var inst_16202 = inst_16197.cljs$lang$protocol_mask$partition0$;
var inst_16203 = (inst_16202 & (64));
var inst_16204 = inst_16197.cljs$core$ISeq$;
var inst_16205 = (inst_16203) || (inst_16204);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16205)){
var statearr_16326_16405 = state_16291__$1;
(statearr_16326_16405[(1)] = (5));

} else {
var statearr_16327_16406 = state_16291__$1;
(statearr_16327_16406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (23))){
var inst_16250 = (state_16291[(14)]);
var inst_16256 = (inst_16250 == null);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16256)){
var statearr_16328_16407 = state_16291__$1;
(statearr_16328_16407[(1)] = (26));

} else {
var statearr_16329_16408 = state_16291__$1;
(statearr_16329_16408[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (35))){
var inst_16276 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16276)){
var statearr_16330_16409 = state_16291__$1;
(statearr_16330_16409[(1)] = (36));

} else {
var statearr_16331_16410 = state_16291__$1;
(statearr_16331_16410[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (19))){
var inst_16221 = (state_16291[(7)]);
var inst_16240 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16221);
var state_16291__$1 = state_16291;
var statearr_16332_16411 = state_16291__$1;
(statearr_16332_16411[(2)] = inst_16240);

(statearr_16332_16411[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (11))){
var inst_16221 = (state_16291[(7)]);
var inst_16225 = (inst_16221 == null);
var inst_16226 = cljs.core.not.call(null,inst_16225);
var state_16291__$1 = state_16291;
if(inst_16226){
var statearr_16333_16412 = state_16291__$1;
(statearr_16333_16412[(1)] = (13));

} else {
var statearr_16334_16413 = state_16291__$1;
(statearr_16334_16413[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (9))){
var inst_16197 = (state_16291[(8)]);
var state_16291__$1 = state_16291;
var statearr_16335_16414 = state_16291__$1;
(statearr_16335_16414[(2)] = inst_16197);

(statearr_16335_16414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (5))){
var state_16291__$1 = state_16291;
var statearr_16336_16415 = state_16291__$1;
(statearr_16336_16415[(2)] = true);

(statearr_16336_16415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (14))){
var state_16291__$1 = state_16291;
var statearr_16337_16416 = state_16291__$1;
(statearr_16337_16416[(2)] = false);

(statearr_16337_16416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (26))){
var inst_16251 = (state_16291[(11)]);
var inst_16258 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16251);
var state_16291__$1 = state_16291;
var statearr_16340_16417 = state_16291__$1;
(statearr_16340_16417[(2)] = inst_16258);

(statearr_16340_16417[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (16))){
var state_16291__$1 = state_16291;
var statearr_16341_16418 = state_16291__$1;
(statearr_16341_16418[(2)] = true);

(statearr_16341_16418[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (38))){
var inst_16281 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16342_16419 = state_16291__$1;
(statearr_16342_16419[(2)] = inst_16281);

(statearr_16342_16419[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (30))){
var inst_16244 = (state_16291[(10)]);
var inst_16245 = (state_16291[(13)]);
var inst_16251 = (state_16291[(11)]);
var inst_16268 = cljs.core.empty_QMARK_.call(null,inst_16244);
var inst_16269 = inst_16245.call(null,inst_16251);
var inst_16270 = cljs.core.not.call(null,inst_16269);
var inst_16271 = (inst_16268) && (inst_16270);
var state_16291__$1 = state_16291;
var statearr_16343_16423 = state_16291__$1;
(statearr_16343_16423[(2)] = inst_16271);

(statearr_16343_16423[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (10))){
var inst_16197 = (state_16291[(8)]);
var inst_16217 = (state_16291[(2)]);
var inst_16218 = cljs.core.get.call(null,inst_16217,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16219 = cljs.core.get.call(null,inst_16217,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16220 = cljs.core.get.call(null,inst_16217,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16221 = inst_16197;
var state_16291__$1 = (function (){var statearr_16344 = state_16291;
(statearr_16344[(16)] = inst_16219);

(statearr_16344[(7)] = inst_16221);

(statearr_16344[(17)] = inst_16220);

(statearr_16344[(18)] = inst_16218);

return statearr_16344;
})();
var statearr_16345_16429 = state_16291__$1;
(statearr_16345_16429[(2)] = null);

(statearr_16345_16429[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (18))){
var inst_16235 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16346_16434 = state_16291__$1;
(statearr_16346_16434[(2)] = inst_16235);

(statearr_16346_16434[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (37))){
var state_16291__$1 = state_16291;
var statearr_16347_16435 = state_16291__$1;
(statearr_16347_16435[(2)] = null);

(statearr_16347_16435[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (8))){
var inst_16197 = (state_16291[(8)]);
var inst_16214 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16197);
var state_16291__$1 = state_16291;
var statearr_16348_16436 = state_16291__$1;
(statearr_16348_16436[(2)] = inst_16214);

(statearr_16348_16436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___16368,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14362__auto___16368,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16352 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16352[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16352[(1)] = (1));

return statearr_16352;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16291){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16353){if((e16353 instanceof Object)){
var ex__14240__auto__ = e16353;
var statearr_16354_16438 = state_16291;
(statearr_16354_16438[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16353;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16439 = state_16291;
state_16291 = G__16439;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16291){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___16368,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14364__auto__ = (function (){var statearr_16355 = f__14363__auto__.call(null);
(statearr_16355[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___16368);

return statearr_16355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___16368,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16440 = [];
var len__7107__auto___16444 = arguments.length;
var i__7108__auto___16445 = (0);
while(true){
if((i__7108__auto___16445 < len__7107__auto___16444)){
args16440.push((arguments[i__7108__auto___16445]));

var G__16446 = (i__7108__auto___16445 + (1));
i__7108__auto___16445 = G__16446;
continue;
} else {
}
break;
}

var G__16442 = args16440.length;
switch (G__16442) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16440.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16458 = [];
var len__7107__auto___16597 = arguments.length;
var i__7108__auto___16598 = (0);
while(true){
if((i__7108__auto___16598 < len__7107__auto___16597)){
args16458.push((arguments[i__7108__auto___16598]));

var G__16599 = (i__7108__auto___16598 + (1));
i__7108__auto___16598 = G__16599;
continue;
} else {
}
break;
}

var G__16460 = args16458.length;
switch (G__16460) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16458.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16456_SHARP_){
if(cljs.core.truth_(p1__16456_SHARP_.call(null,topic))){
return p1__16456_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16456_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16461 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16461 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16462){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16462 = meta16462;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16463,meta16462__$1){
var self__ = this;
var _16463__$1 = this;
return (new cljs.core.async.t_cljs$core$async16461(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16462__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16463){
var self__ = this;
var _16463__$1 = this;
return self__.meta16462;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16462","meta16462",-724731518,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16461.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16461.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16461";

cljs.core.async.t_cljs$core$async16461.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16461");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16461 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16461(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16462){
return (new cljs.core.async.t_cljs$core$async16461(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16462));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16461(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14362__auto___16610 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___16610,mults,ensure_mult,p){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___16610,mults,ensure_mult,p){
return (function (state_16548){
var state_val_16550 = (state_16548[(1)]);
if((state_val_16550 === (7))){
var inst_16544 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
var statearr_16551_16615 = state_16548__$1;
(statearr_16551_16615[(2)] = inst_16544);

(statearr_16551_16615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (20))){
var state_16548__$1 = state_16548;
var statearr_16552_16616 = state_16548__$1;
(statearr_16552_16616[(2)] = null);

(statearr_16552_16616[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (1))){
var state_16548__$1 = state_16548;
var statearr_16553_16617 = state_16548__$1;
(statearr_16553_16617[(2)] = null);

(statearr_16553_16617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (24))){
var inst_16527 = (state_16548[(7)]);
var inst_16536 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16527);
var state_16548__$1 = state_16548;
var statearr_16554_16618 = state_16548__$1;
(statearr_16554_16618[(2)] = inst_16536);

(statearr_16554_16618[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (4))){
var inst_16479 = (state_16548[(8)]);
var inst_16479__$1 = (state_16548[(2)]);
var inst_16480 = (inst_16479__$1 == null);
var state_16548__$1 = (function (){var statearr_16555 = state_16548;
(statearr_16555[(8)] = inst_16479__$1);

return statearr_16555;
})();
if(cljs.core.truth_(inst_16480)){
var statearr_16556_16619 = state_16548__$1;
(statearr_16556_16619[(1)] = (5));

} else {
var statearr_16557_16620 = state_16548__$1;
(statearr_16557_16620[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (15))){
var inst_16521 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
var statearr_16558_16622 = state_16548__$1;
(statearr_16558_16622[(2)] = inst_16521);

(statearr_16558_16622[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (21))){
var inst_16541 = (state_16548[(2)]);
var state_16548__$1 = (function (){var statearr_16559 = state_16548;
(statearr_16559[(9)] = inst_16541);

return statearr_16559;
})();
var statearr_16560_16623 = state_16548__$1;
(statearr_16560_16623[(2)] = null);

(statearr_16560_16623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (13))){
var inst_16503 = (state_16548[(10)]);
var inst_16505 = cljs.core.chunked_seq_QMARK_.call(null,inst_16503);
var state_16548__$1 = state_16548;
if(inst_16505){
var statearr_16561_16624 = state_16548__$1;
(statearr_16561_16624[(1)] = (16));

} else {
var statearr_16562_16625 = state_16548__$1;
(statearr_16562_16625[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (22))){
var inst_16533 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
if(cljs.core.truth_(inst_16533)){
var statearr_16563_16626 = state_16548__$1;
(statearr_16563_16626[(1)] = (23));

} else {
var statearr_16564_16627 = state_16548__$1;
(statearr_16564_16627[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (6))){
var inst_16529 = (state_16548[(11)]);
var inst_16527 = (state_16548[(7)]);
var inst_16479 = (state_16548[(8)]);
var inst_16527__$1 = topic_fn.call(null,inst_16479);
var inst_16528 = cljs.core.deref.call(null,mults);
var inst_16529__$1 = cljs.core.get.call(null,inst_16528,inst_16527__$1);
var state_16548__$1 = (function (){var statearr_16565 = state_16548;
(statearr_16565[(11)] = inst_16529__$1);

(statearr_16565[(7)] = inst_16527__$1);

return statearr_16565;
})();
if(cljs.core.truth_(inst_16529__$1)){
var statearr_16566_16628 = state_16548__$1;
(statearr_16566_16628[(1)] = (19));

} else {
var statearr_16567_16629 = state_16548__$1;
(statearr_16567_16629[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (25))){
var inst_16538 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
var statearr_16568_16630 = state_16548__$1;
(statearr_16568_16630[(2)] = inst_16538);

(statearr_16568_16630[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (17))){
var inst_16503 = (state_16548[(10)]);
var inst_16512 = cljs.core.first.call(null,inst_16503);
var inst_16513 = cljs.core.async.muxch_STAR_.call(null,inst_16512);
var inst_16514 = cljs.core.async.close_BANG_.call(null,inst_16513);
var inst_16515 = cljs.core.next.call(null,inst_16503);
var inst_16489 = inst_16515;
var inst_16490 = null;
var inst_16491 = (0);
var inst_16492 = (0);
var state_16548__$1 = (function (){var statearr_16569 = state_16548;
(statearr_16569[(12)] = inst_16492);

(statearr_16569[(13)] = inst_16491);

(statearr_16569[(14)] = inst_16490);

(statearr_16569[(15)] = inst_16514);

(statearr_16569[(16)] = inst_16489);

return statearr_16569;
})();
var statearr_16570_16639 = state_16548__$1;
(statearr_16570_16639[(2)] = null);

(statearr_16570_16639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (3))){
var inst_16546 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16548__$1,inst_16546);
} else {
if((state_val_16550 === (12))){
var inst_16523 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
var statearr_16571_16640 = state_16548__$1;
(statearr_16571_16640[(2)] = inst_16523);

(statearr_16571_16640[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (2))){
var state_16548__$1 = state_16548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16548__$1,(4),ch);
} else {
if((state_val_16550 === (23))){
var state_16548__$1 = state_16548;
var statearr_16572_16641 = state_16548__$1;
(statearr_16572_16641[(2)] = null);

(statearr_16572_16641[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (19))){
var inst_16529 = (state_16548[(11)]);
var inst_16479 = (state_16548[(8)]);
var inst_16531 = cljs.core.async.muxch_STAR_.call(null,inst_16529);
var state_16548__$1 = state_16548;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16548__$1,(22),inst_16531,inst_16479);
} else {
if((state_val_16550 === (11))){
var inst_16489 = (state_16548[(16)]);
var inst_16503 = (state_16548[(10)]);
var inst_16503__$1 = cljs.core.seq.call(null,inst_16489);
var state_16548__$1 = (function (){var statearr_16573 = state_16548;
(statearr_16573[(10)] = inst_16503__$1);

return statearr_16573;
})();
if(inst_16503__$1){
var statearr_16574_16646 = state_16548__$1;
(statearr_16574_16646[(1)] = (13));

} else {
var statearr_16575_16647 = state_16548__$1;
(statearr_16575_16647[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (9))){
var inst_16525 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
var statearr_16576_16648 = state_16548__$1;
(statearr_16576_16648[(2)] = inst_16525);

(statearr_16576_16648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (5))){
var inst_16486 = cljs.core.deref.call(null,mults);
var inst_16487 = cljs.core.vals.call(null,inst_16486);
var inst_16488 = cljs.core.seq.call(null,inst_16487);
var inst_16489 = inst_16488;
var inst_16490 = null;
var inst_16491 = (0);
var inst_16492 = (0);
var state_16548__$1 = (function (){var statearr_16577 = state_16548;
(statearr_16577[(12)] = inst_16492);

(statearr_16577[(13)] = inst_16491);

(statearr_16577[(14)] = inst_16490);

(statearr_16577[(16)] = inst_16489);

return statearr_16577;
})();
var statearr_16578_16649 = state_16548__$1;
(statearr_16578_16649[(2)] = null);

(statearr_16578_16649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (14))){
var state_16548__$1 = state_16548;
var statearr_16582_16650 = state_16548__$1;
(statearr_16582_16650[(2)] = null);

(statearr_16582_16650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (16))){
var inst_16503 = (state_16548[(10)]);
var inst_16507 = cljs.core.chunk_first.call(null,inst_16503);
var inst_16508 = cljs.core.chunk_rest.call(null,inst_16503);
var inst_16509 = cljs.core.count.call(null,inst_16507);
var inst_16489 = inst_16508;
var inst_16490 = inst_16507;
var inst_16491 = inst_16509;
var inst_16492 = (0);
var state_16548__$1 = (function (){var statearr_16583 = state_16548;
(statearr_16583[(12)] = inst_16492);

(statearr_16583[(13)] = inst_16491);

(statearr_16583[(14)] = inst_16490);

(statearr_16583[(16)] = inst_16489);

return statearr_16583;
})();
var statearr_16584_16651 = state_16548__$1;
(statearr_16584_16651[(2)] = null);

(statearr_16584_16651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (10))){
var inst_16492 = (state_16548[(12)]);
var inst_16491 = (state_16548[(13)]);
var inst_16490 = (state_16548[(14)]);
var inst_16489 = (state_16548[(16)]);
var inst_16497 = cljs.core._nth.call(null,inst_16490,inst_16492);
var inst_16498 = cljs.core.async.muxch_STAR_.call(null,inst_16497);
var inst_16499 = cljs.core.async.close_BANG_.call(null,inst_16498);
var inst_16500 = (inst_16492 + (1));
var tmp16579 = inst_16491;
var tmp16580 = inst_16490;
var tmp16581 = inst_16489;
var inst_16489__$1 = tmp16581;
var inst_16490__$1 = tmp16580;
var inst_16491__$1 = tmp16579;
var inst_16492__$1 = inst_16500;
var state_16548__$1 = (function (){var statearr_16585 = state_16548;
(statearr_16585[(12)] = inst_16492__$1);

(statearr_16585[(13)] = inst_16491__$1);

(statearr_16585[(14)] = inst_16490__$1);

(statearr_16585[(17)] = inst_16499);

(statearr_16585[(16)] = inst_16489__$1);

return statearr_16585;
})();
var statearr_16586_16653 = state_16548__$1;
(statearr_16586_16653[(2)] = null);

(statearr_16586_16653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (18))){
var inst_16518 = (state_16548[(2)]);
var state_16548__$1 = state_16548;
var statearr_16587_16654 = state_16548__$1;
(statearr_16587_16654[(2)] = inst_16518);

(statearr_16587_16654[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16550 === (8))){
var inst_16492 = (state_16548[(12)]);
var inst_16491 = (state_16548[(13)]);
var inst_16494 = (inst_16492 < inst_16491);
var inst_16495 = inst_16494;
var state_16548__$1 = state_16548;
if(cljs.core.truth_(inst_16495)){
var statearr_16588_16655 = state_16548__$1;
(statearr_16588_16655[(1)] = (10));

} else {
var statearr_16589_16656 = state_16548__$1;
(statearr_16589_16656[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___16610,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14362__auto___16610,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16593 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16593[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16593[(1)] = (1));

return statearr_16593;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16548){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16594){if((e16594 instanceof Object)){
var ex__14240__auto__ = e16594;
var statearr_16595_16657 = state_16548;
(statearr_16595_16657[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16594;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16658 = state_16548;
state_16548 = G__16658;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16548){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___16610,mults,ensure_mult,p))
})();
var state__14364__auto__ = (function (){var statearr_16596 = f__14363__auto__.call(null);
(statearr_16596[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___16610);

return statearr_16596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___16610,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16664 = [];
var len__7107__auto___16674 = arguments.length;
var i__7108__auto___16675 = (0);
while(true){
if((i__7108__auto___16675 < len__7107__auto___16674)){
args16664.push((arguments[i__7108__auto___16675]));

var G__16676 = (i__7108__auto___16675 + (1));
i__7108__auto___16675 = G__16676;
continue;
} else {
}
break;
}

var G__16666 = args16664.length;
switch (G__16666) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16664.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16678 = [];
var len__7107__auto___16682 = arguments.length;
var i__7108__auto___16683 = (0);
while(true){
if((i__7108__auto___16683 < len__7107__auto___16682)){
args16678.push((arguments[i__7108__auto___16683]));

var G__16684 = (i__7108__auto___16683 + (1));
i__7108__auto___16683 = G__16684;
continue;
} else {
}
break;
}

var G__16681 = args16678.length;
switch (G__16681) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16678.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16686 = [];
var len__7107__auto___16767 = arguments.length;
var i__7108__auto___16768 = (0);
while(true){
if((i__7108__auto___16768 < len__7107__auto___16767)){
args16686.push((arguments[i__7108__auto___16768]));

var G__16769 = (i__7108__auto___16768 + (1));
i__7108__auto___16768 = G__16769;
continue;
} else {
}
break;
}

var G__16688 = args16686.length;
switch (G__16688) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16686.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14362__auto___16774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16727){
var state_val_16728 = (state_16727[(1)]);
if((state_val_16728 === (7))){
var state_16727__$1 = state_16727;
var statearr_16729_16776 = state_16727__$1;
(statearr_16729_16776[(2)] = null);

(statearr_16729_16776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (1))){
var state_16727__$1 = state_16727;
var statearr_16730_16777 = state_16727__$1;
(statearr_16730_16777[(2)] = null);

(statearr_16730_16777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (4))){
var inst_16691 = (state_16727[(7)]);
var inst_16693 = (inst_16691 < cnt);
var state_16727__$1 = state_16727;
if(cljs.core.truth_(inst_16693)){
var statearr_16731_16778 = state_16727__$1;
(statearr_16731_16778[(1)] = (6));

} else {
var statearr_16732_16779 = state_16727__$1;
(statearr_16732_16779[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (15))){
var inst_16723 = (state_16727[(2)]);
var state_16727__$1 = state_16727;
var statearr_16733_16780 = state_16727__$1;
(statearr_16733_16780[(2)] = inst_16723);

(statearr_16733_16780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (13))){
var inst_16716 = cljs.core.async.close_BANG_.call(null,out);
var state_16727__$1 = state_16727;
var statearr_16734_16781 = state_16727__$1;
(statearr_16734_16781[(2)] = inst_16716);

(statearr_16734_16781[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (6))){
var state_16727__$1 = state_16727;
var statearr_16735_16782 = state_16727__$1;
(statearr_16735_16782[(2)] = null);

(statearr_16735_16782[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (3))){
var inst_16725 = (state_16727[(2)]);
var state_16727__$1 = state_16727;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16727__$1,inst_16725);
} else {
if((state_val_16728 === (12))){
var inst_16713 = (state_16727[(8)]);
var inst_16713__$1 = (state_16727[(2)]);
var inst_16714 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16713__$1);
var state_16727__$1 = (function (){var statearr_16738 = state_16727;
(statearr_16738[(8)] = inst_16713__$1);

return statearr_16738;
})();
if(cljs.core.truth_(inst_16714)){
var statearr_16739_16783 = state_16727__$1;
(statearr_16739_16783[(1)] = (13));

} else {
var statearr_16740_16784 = state_16727__$1;
(statearr_16740_16784[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (2))){
var inst_16690 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16691 = (0);
var state_16727__$1 = (function (){var statearr_16744 = state_16727;
(statearr_16744[(9)] = inst_16690);

(statearr_16744[(7)] = inst_16691);

return statearr_16744;
})();
var statearr_16745_16785 = state_16727__$1;
(statearr_16745_16785[(2)] = null);

(statearr_16745_16785[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (11))){
var inst_16691 = (state_16727[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16727,(10),Object,null,(9));
var inst_16700 = chs__$1.call(null,inst_16691);
var inst_16701 = done.call(null,inst_16691);
var inst_16702 = cljs.core.async.take_BANG_.call(null,inst_16700,inst_16701);
var state_16727__$1 = state_16727;
var statearr_16746_16786 = state_16727__$1;
(statearr_16746_16786[(2)] = inst_16702);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16727__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (9))){
var inst_16691 = (state_16727[(7)]);
var inst_16704 = (state_16727[(2)]);
var inst_16705 = (inst_16691 + (1));
var inst_16691__$1 = inst_16705;
var state_16727__$1 = (function (){var statearr_16747 = state_16727;
(statearr_16747[(7)] = inst_16691__$1);

(statearr_16747[(10)] = inst_16704);

return statearr_16747;
})();
var statearr_16748_16787 = state_16727__$1;
(statearr_16748_16787[(2)] = null);

(statearr_16748_16787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (5))){
var inst_16711 = (state_16727[(2)]);
var state_16727__$1 = (function (){var statearr_16749 = state_16727;
(statearr_16749[(11)] = inst_16711);

return statearr_16749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16727__$1,(12),dchan);
} else {
if((state_val_16728 === (14))){
var inst_16713 = (state_16727[(8)]);
var inst_16718 = cljs.core.apply.call(null,f,inst_16713);
var state_16727__$1 = state_16727;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16727__$1,(16),out,inst_16718);
} else {
if((state_val_16728 === (16))){
var inst_16720 = (state_16727[(2)]);
var state_16727__$1 = (function (){var statearr_16754 = state_16727;
(statearr_16754[(12)] = inst_16720);

return statearr_16754;
})();
var statearr_16755_16788 = state_16727__$1;
(statearr_16755_16788[(2)] = null);

(statearr_16755_16788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (10))){
var inst_16695 = (state_16727[(2)]);
var inst_16696 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16727__$1 = (function (){var statearr_16757 = state_16727;
(statearr_16757[(13)] = inst_16695);

return statearr_16757;
})();
var statearr_16758_16789 = state_16727__$1;
(statearr_16758_16789[(2)] = inst_16696);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16727__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16728 === (8))){
var inst_16709 = (state_16727[(2)]);
var state_16727__$1 = state_16727;
var statearr_16759_16790 = state_16727__$1;
(statearr_16759_16790[(2)] = inst_16709);

(statearr_16759_16790[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14362__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16763 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16763[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16763[(1)] = (1));

return statearr_16763;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16727){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16727);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16764){if((e16764 instanceof Object)){
var ex__14240__auto__ = e16764;
var statearr_16765_16791 = state_16727;
(statearr_16765_16791[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16727);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16764;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16792 = state_16727;
state_16727 = G__16792;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16727){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14364__auto__ = (function (){var statearr_16766 = f__14363__auto__.call(null);
(statearr_16766[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___16774);

return statearr_16766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___16774,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16794 = [];
var len__7107__auto___16865 = arguments.length;
var i__7108__auto___16866 = (0);
while(true){
if((i__7108__auto___16866 < len__7107__auto___16865)){
args16794.push((arguments[i__7108__auto___16866]));

var G__16867 = (i__7108__auto___16866 + (1));
i__7108__auto___16866 = G__16867;
continue;
} else {
}
break;
}

var G__16796 = args16794.length;
switch (G__16796) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16794.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14362__auto___16869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___16869,out){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___16869,out){
return (function (state_16829){
var state_val_16830 = (state_16829[(1)]);
if((state_val_16830 === (7))){
var inst_16806 = (state_16829[(7)]);
var inst_16805 = (state_16829[(8)]);
var inst_16805__$1 = (state_16829[(2)]);
var inst_16806__$1 = cljs.core.nth.call(null,inst_16805__$1,(0),null);
var inst_16807 = cljs.core.nth.call(null,inst_16805__$1,(1),null);
var inst_16808 = (inst_16806__$1 == null);
var state_16829__$1 = (function (){var statearr_16835 = state_16829;
(statearr_16835[(7)] = inst_16806__$1);

(statearr_16835[(9)] = inst_16807);

(statearr_16835[(8)] = inst_16805__$1);

return statearr_16835;
})();
if(cljs.core.truth_(inst_16808)){
var statearr_16836_16870 = state_16829__$1;
(statearr_16836_16870[(1)] = (8));

} else {
var statearr_16841_16871 = state_16829__$1;
(statearr_16841_16871[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16830 === (1))){
var inst_16797 = cljs.core.vec.call(null,chs);
var inst_16798 = inst_16797;
var state_16829__$1 = (function (){var statearr_16842 = state_16829;
(statearr_16842[(10)] = inst_16798);

return statearr_16842;
})();
var statearr_16843_16873 = state_16829__$1;
(statearr_16843_16873[(2)] = null);

(statearr_16843_16873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16830 === (4))){
var inst_16798 = (state_16829[(10)]);
var state_16829__$1 = state_16829;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16829__$1,(7),inst_16798);
} else {
if((state_val_16830 === (6))){
var inst_16825 = (state_16829[(2)]);
var state_16829__$1 = state_16829;
var statearr_16845_16874 = state_16829__$1;
(statearr_16845_16874[(2)] = inst_16825);

(statearr_16845_16874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16830 === (3))){
var inst_16827 = (state_16829[(2)]);
var state_16829__$1 = state_16829;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16829__$1,inst_16827);
} else {
if((state_val_16830 === (2))){
var inst_16798 = (state_16829[(10)]);
var inst_16800 = cljs.core.count.call(null,inst_16798);
var inst_16801 = (inst_16800 > (0));
var state_16829__$1 = state_16829;
if(cljs.core.truth_(inst_16801)){
var statearr_16847_16875 = state_16829__$1;
(statearr_16847_16875[(1)] = (4));

} else {
var statearr_16848_16876 = state_16829__$1;
(statearr_16848_16876[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16830 === (11))){
var inst_16798 = (state_16829[(10)]);
var inst_16818 = (state_16829[(2)]);
var tmp16846 = inst_16798;
var inst_16798__$1 = tmp16846;
var state_16829__$1 = (function (){var statearr_16849 = state_16829;
(statearr_16849[(11)] = inst_16818);

(statearr_16849[(10)] = inst_16798__$1);

return statearr_16849;
})();
var statearr_16850_16877 = state_16829__$1;
(statearr_16850_16877[(2)] = null);

(statearr_16850_16877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16830 === (9))){
var inst_16806 = (state_16829[(7)]);
var state_16829__$1 = state_16829;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16829__$1,(11),out,inst_16806);
} else {
if((state_val_16830 === (5))){
var inst_16823 = cljs.core.async.close_BANG_.call(null,out);
var state_16829__$1 = state_16829;
var statearr_16851_16878 = state_16829__$1;
(statearr_16851_16878[(2)] = inst_16823);

(statearr_16851_16878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16830 === (10))){
var inst_16821 = (state_16829[(2)]);
var state_16829__$1 = state_16829;
var statearr_16852_16879 = state_16829__$1;
(statearr_16852_16879[(2)] = inst_16821);

(statearr_16852_16879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16830 === (8))){
var inst_16806 = (state_16829[(7)]);
var inst_16807 = (state_16829[(9)]);
var inst_16805 = (state_16829[(8)]);
var inst_16798 = (state_16829[(10)]);
var inst_16813 = (function (){var cs = inst_16798;
var vec__16803 = inst_16805;
var v = inst_16806;
var c = inst_16807;
return ((function (cs,vec__16803,v,c,inst_16806,inst_16807,inst_16805,inst_16798,state_val_16830,c__14362__auto___16869,out){
return (function (p1__16793_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16793_SHARP_);
});
;})(cs,vec__16803,v,c,inst_16806,inst_16807,inst_16805,inst_16798,state_val_16830,c__14362__auto___16869,out))
})();
var inst_16814 = cljs.core.filterv.call(null,inst_16813,inst_16798);
var inst_16798__$1 = inst_16814;
var state_16829__$1 = (function (){var statearr_16853 = state_16829;
(statearr_16853[(10)] = inst_16798__$1);

return statearr_16853;
})();
var statearr_16854_16880 = state_16829__$1;
(statearr_16854_16880[(2)] = null);

(statearr_16854_16880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___16869,out))
;
return ((function (switch__14236__auto__,c__14362__auto___16869,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16858 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16858[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16858[(1)] = (1));

return statearr_16858;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16829){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16829);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16862){if((e16862 instanceof Object)){
var ex__14240__auto__ = e16862;
var statearr_16863_16881 = state_16829;
(statearr_16863_16881[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16829);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16882 = state_16829;
state_16829 = G__16882;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16829){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___16869,out))
})();
var state__14364__auto__ = (function (){var statearr_16864 = f__14363__auto__.call(null);
(statearr_16864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___16869);

return statearr_16864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___16869,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16883 = [];
var len__7107__auto___16933 = arguments.length;
var i__7108__auto___16934 = (0);
while(true){
if((i__7108__auto___16934 < len__7107__auto___16933)){
args16883.push((arguments[i__7108__auto___16934]));

var G__16935 = (i__7108__auto___16934 + (1));
i__7108__auto___16934 = G__16935;
continue;
} else {
}
break;
}

var G__16885 = args16883.length;
switch (G__16885) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16883.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14362__auto___16940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___16940,out){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___16940,out){
return (function (state_16909){
var state_val_16910 = (state_16909[(1)]);
if((state_val_16910 === (7))){
var inst_16891 = (state_16909[(7)]);
var inst_16891__$1 = (state_16909[(2)]);
var inst_16892 = (inst_16891__$1 == null);
var inst_16893 = cljs.core.not.call(null,inst_16892);
var state_16909__$1 = (function (){var statearr_16911 = state_16909;
(statearr_16911[(7)] = inst_16891__$1);

return statearr_16911;
})();
if(inst_16893){
var statearr_16912_16941 = state_16909__$1;
(statearr_16912_16941[(1)] = (8));

} else {
var statearr_16913_16942 = state_16909__$1;
(statearr_16913_16942[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (1))){
var inst_16886 = (0);
var state_16909__$1 = (function (){var statearr_16914 = state_16909;
(statearr_16914[(8)] = inst_16886);

return statearr_16914;
})();
var statearr_16915_16943 = state_16909__$1;
(statearr_16915_16943[(2)] = null);

(statearr_16915_16943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (4))){
var state_16909__$1 = state_16909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16909__$1,(7),ch);
} else {
if((state_val_16910 === (6))){
var inst_16904 = (state_16909[(2)]);
var state_16909__$1 = state_16909;
var statearr_16916_16944 = state_16909__$1;
(statearr_16916_16944[(2)] = inst_16904);

(statearr_16916_16944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (3))){
var inst_16906 = (state_16909[(2)]);
var inst_16907 = cljs.core.async.close_BANG_.call(null,out);
var state_16909__$1 = (function (){var statearr_16918 = state_16909;
(statearr_16918[(9)] = inst_16906);

return statearr_16918;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16909__$1,inst_16907);
} else {
if((state_val_16910 === (2))){
var inst_16886 = (state_16909[(8)]);
var inst_16888 = (inst_16886 < n);
var state_16909__$1 = state_16909;
if(cljs.core.truth_(inst_16888)){
var statearr_16919_16945 = state_16909__$1;
(statearr_16919_16945[(1)] = (4));

} else {
var statearr_16920_16946 = state_16909__$1;
(statearr_16920_16946[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (11))){
var inst_16886 = (state_16909[(8)]);
var inst_16896 = (state_16909[(2)]);
var inst_16897 = (inst_16886 + (1));
var inst_16886__$1 = inst_16897;
var state_16909__$1 = (function (){var statearr_16921 = state_16909;
(statearr_16921[(8)] = inst_16886__$1);

(statearr_16921[(10)] = inst_16896);

return statearr_16921;
})();
var statearr_16922_16951 = state_16909__$1;
(statearr_16922_16951[(2)] = null);

(statearr_16922_16951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (9))){
var state_16909__$1 = state_16909;
var statearr_16923_16952 = state_16909__$1;
(statearr_16923_16952[(2)] = null);

(statearr_16923_16952[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (5))){
var state_16909__$1 = state_16909;
var statearr_16924_16956 = state_16909__$1;
(statearr_16924_16956[(2)] = null);

(statearr_16924_16956[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (10))){
var inst_16901 = (state_16909[(2)]);
var state_16909__$1 = state_16909;
var statearr_16925_16957 = state_16909__$1;
(statearr_16925_16957[(2)] = inst_16901);

(statearr_16925_16957[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16910 === (8))){
var inst_16891 = (state_16909[(7)]);
var state_16909__$1 = state_16909;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16909__$1,(11),out,inst_16891);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___16940,out))
;
return ((function (switch__14236__auto__,c__14362__auto___16940,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16929 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16929[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16929[(1)] = (1));

return statearr_16929;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16909){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16930){if((e16930 instanceof Object)){
var ex__14240__auto__ = e16930;
var statearr_16931_16962 = state_16909;
(statearr_16931_16962[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16930;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16963 = state_16909;
state_16909 = G__16963;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___16940,out))
})();
var state__14364__auto__ = (function (){var statearr_16932 = f__14363__auto__.call(null);
(statearr_16932[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___16940);

return statearr_16932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___16940,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16972 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16972 = (function (map_LT_,f,ch,meta16973){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16973 = meta16973;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16974,meta16973__$1){
var self__ = this;
var _16974__$1 = this;
return (new cljs.core.async.t_cljs$core$async16972(self__.map_LT_,self__.f,self__.ch,meta16973__$1));
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16974){
var self__ = this;
var _16974__$1 = this;
return self__.meta16973;
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16975 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16975 = (function (map_LT_,f,ch,meta16973,_,fn1,meta16976){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16973 = meta16973;
this._ = _;
this.fn1 = fn1;
this.meta16976 = meta16976;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16977,meta16976__$1){
var self__ = this;
var _16977__$1 = this;
return (new cljs.core.async.t_cljs$core$async16975(self__.map_LT_,self__.f,self__.ch,self__.meta16973,self__._,self__.fn1,meta16976__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16977){
var self__ = this;
var _16977__$1 = this;
return self__.meta16976;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16964_SHARP_){
return f1.call(null,(((p1__16964_SHARP_ == null))?null:self__.f.call(null,p1__16964_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16973","meta16973",101666770,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16972","cljs.core.async/t_cljs$core$async16972",1733444675,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16976","meta16976",163212366,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16975.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16975.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16975";

cljs.core.async.t_cljs$core$async16975.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16975");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16975 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16975(map_LT___$1,f__$1,ch__$1,meta16973__$1,___$2,fn1__$1,meta16976){
return (new cljs.core.async.t_cljs$core$async16975(map_LT___$1,f__$1,ch__$1,meta16973__$1,___$2,fn1__$1,meta16976));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16975(self__.map_LT_,self__.f,self__.ch,self__.meta16973,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16972.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16972.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16973","meta16973",101666770,null)], null);
});

cljs.core.async.t_cljs$core$async16972.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16972.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16972";

cljs.core.async.t_cljs$core$async16972.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16972");
});

cljs.core.async.__GT_t_cljs$core$async16972 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16972(map_LT___$1,f__$1,ch__$1,meta16973){
return (new cljs.core.async.t_cljs$core$async16972(map_LT___$1,f__$1,ch__$1,meta16973));
});

}

return (new cljs.core.async.t_cljs$core$async16972(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16988 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16988 = (function (map_GT_,f,ch,meta16989){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16989 = meta16989;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16990,meta16989__$1){
var self__ = this;
var _16990__$1 = this;
return (new cljs.core.async.t_cljs$core$async16988(self__.map_GT_,self__.f,self__.ch,meta16989__$1));
});

cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16990){
var self__ = this;
var _16990__$1 = this;
return self__.meta16989;
});

cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16988.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16988.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16989","meta16989",-1597821446,null)], null);
});

cljs.core.async.t_cljs$core$async16988.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16988.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16988";

cljs.core.async.t_cljs$core$async16988.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16988");
});

cljs.core.async.__GT_t_cljs$core$async16988 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16988(map_GT___$1,f__$1,ch__$1,meta16989){
return (new cljs.core.async.t_cljs$core$async16988(map_GT___$1,f__$1,ch__$1,meta16989));
});

}

return (new cljs.core.async.t_cljs$core$async16988(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16995 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16995 = (function (filter_GT_,p,ch,meta16996){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16996 = meta16996;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16997,meta16996__$1){
var self__ = this;
var _16997__$1 = this;
return (new cljs.core.async.t_cljs$core$async16995(self__.filter_GT_,self__.p,self__.ch,meta16996__$1));
});

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16997){
var self__ = this;
var _16997__$1 = this;
return self__.meta16996;
});

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16995.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16995.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16996","meta16996",-2111089523,null)], null);
});

cljs.core.async.t_cljs$core$async16995.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16995.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16995";

cljs.core.async.t_cljs$core$async16995.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16995");
});

cljs.core.async.__GT_t_cljs$core$async16995 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16995(filter_GT___$1,p__$1,ch__$1,meta16996){
return (new cljs.core.async.t_cljs$core$async16995(filter_GT___$1,p__$1,ch__$1,meta16996));
});

}

return (new cljs.core.async.t_cljs$core$async16995(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args17002 = [];
var len__7107__auto___17046 = arguments.length;
var i__7108__auto___17047 = (0);
while(true){
if((i__7108__auto___17047 < len__7107__auto___17046)){
args17002.push((arguments[i__7108__auto___17047]));

var G__17048 = (i__7108__auto___17047 + (1));
i__7108__auto___17047 = G__17048;
continue;
} else {
}
break;
}

var G__17004 = args17002.length;
switch (G__17004) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17002.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14362__auto___17053 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___17053,out){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___17053,out){
return (function (state_17025){
var state_val_17026 = (state_17025[(1)]);
if((state_val_17026 === (7))){
var inst_17021 = (state_17025[(2)]);
var state_17025__$1 = state_17025;
var statearr_17027_17054 = state_17025__$1;
(statearr_17027_17054[(2)] = inst_17021);

(statearr_17027_17054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (1))){
var state_17025__$1 = state_17025;
var statearr_17028_17055 = state_17025__$1;
(statearr_17028_17055[(2)] = null);

(statearr_17028_17055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (4))){
var inst_17007 = (state_17025[(7)]);
var inst_17007__$1 = (state_17025[(2)]);
var inst_17008 = (inst_17007__$1 == null);
var state_17025__$1 = (function (){var statearr_17029 = state_17025;
(statearr_17029[(7)] = inst_17007__$1);

return statearr_17029;
})();
if(cljs.core.truth_(inst_17008)){
var statearr_17030_17056 = state_17025__$1;
(statearr_17030_17056[(1)] = (5));

} else {
var statearr_17031_17058 = state_17025__$1;
(statearr_17031_17058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (6))){
var inst_17007 = (state_17025[(7)]);
var inst_17012 = p.call(null,inst_17007);
var state_17025__$1 = state_17025;
if(cljs.core.truth_(inst_17012)){
var statearr_17032_17059 = state_17025__$1;
(statearr_17032_17059[(1)] = (8));

} else {
var statearr_17033_17060 = state_17025__$1;
(statearr_17033_17060[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (3))){
var inst_17023 = (state_17025[(2)]);
var state_17025__$1 = state_17025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17025__$1,inst_17023);
} else {
if((state_val_17026 === (2))){
var state_17025__$1 = state_17025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17025__$1,(4),ch);
} else {
if((state_val_17026 === (11))){
var inst_17015 = (state_17025[(2)]);
var state_17025__$1 = state_17025;
var statearr_17034_17064 = state_17025__$1;
(statearr_17034_17064[(2)] = inst_17015);

(statearr_17034_17064[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (9))){
var state_17025__$1 = state_17025;
var statearr_17035_17065 = state_17025__$1;
(statearr_17035_17065[(2)] = null);

(statearr_17035_17065[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (5))){
var inst_17010 = cljs.core.async.close_BANG_.call(null,out);
var state_17025__$1 = state_17025;
var statearr_17036_17067 = state_17025__$1;
(statearr_17036_17067[(2)] = inst_17010);

(statearr_17036_17067[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (10))){
var inst_17018 = (state_17025[(2)]);
var state_17025__$1 = (function (){var statearr_17037 = state_17025;
(statearr_17037[(8)] = inst_17018);

return statearr_17037;
})();
var statearr_17038_17068 = state_17025__$1;
(statearr_17038_17068[(2)] = null);

(statearr_17038_17068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17026 === (8))){
var inst_17007 = (state_17025[(7)]);
var state_17025__$1 = state_17025;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17025__$1,(11),out,inst_17007);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___17053,out))
;
return ((function (switch__14236__auto__,c__14362__auto___17053,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17042 = [null,null,null,null,null,null,null,null,null];
(statearr_17042[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17042[(1)] = (1));

return statearr_17042;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17025){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17043){if((e17043 instanceof Object)){
var ex__14240__auto__ = e17043;
var statearr_17044_17069 = state_17025;
(statearr_17044_17069[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17025);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17043;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17070 = state_17025;
state_17025 = G__17070;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17025){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___17053,out))
})();
var state__14364__auto__ = (function (){var statearr_17045 = f__14363__auto__.call(null);
(statearr_17045[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___17053);

return statearr_17045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___17053,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17071 = [];
var len__7107__auto___17074 = arguments.length;
var i__7108__auto___17075 = (0);
while(true){
if((i__7108__auto___17075 < len__7107__auto___17074)){
args17071.push((arguments[i__7108__auto___17075]));

var G__17076 = (i__7108__auto___17075 + (1));
i__7108__auto___17075 = G__17076;
continue;
} else {
}
break;
}

var G__17073 = args17071.length;
switch (G__17073) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17071.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto__){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto__){
return (function (state_17250){
var state_val_17251 = (state_17250[(1)]);
if((state_val_17251 === (7))){
var inst_17246 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17252_17294 = state_17250__$1;
(statearr_17252_17294[(2)] = inst_17246);

(statearr_17252_17294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (20))){
var inst_17216 = (state_17250[(7)]);
var inst_17227 = (state_17250[(2)]);
var inst_17228 = cljs.core.next.call(null,inst_17216);
var inst_17202 = inst_17228;
var inst_17203 = null;
var inst_17204 = (0);
var inst_17205 = (0);
var state_17250__$1 = (function (){var statearr_17253 = state_17250;
(statearr_17253[(8)] = inst_17227);

(statearr_17253[(9)] = inst_17203);

(statearr_17253[(10)] = inst_17202);

(statearr_17253[(11)] = inst_17205);

(statearr_17253[(12)] = inst_17204);

return statearr_17253;
})();
var statearr_17254_17295 = state_17250__$1;
(statearr_17254_17295[(2)] = null);

(statearr_17254_17295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (1))){
var state_17250__$1 = state_17250;
var statearr_17255_17296 = state_17250__$1;
(statearr_17255_17296[(2)] = null);

(statearr_17255_17296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (4))){
var inst_17191 = (state_17250[(13)]);
var inst_17191__$1 = (state_17250[(2)]);
var inst_17192 = (inst_17191__$1 == null);
var state_17250__$1 = (function (){var statearr_17256 = state_17250;
(statearr_17256[(13)] = inst_17191__$1);

return statearr_17256;
})();
if(cljs.core.truth_(inst_17192)){
var statearr_17257_17297 = state_17250__$1;
(statearr_17257_17297[(1)] = (5));

} else {
var statearr_17258_17298 = state_17250__$1;
(statearr_17258_17298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (15))){
var state_17250__$1 = state_17250;
var statearr_17262_17299 = state_17250__$1;
(statearr_17262_17299[(2)] = null);

(statearr_17262_17299[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (21))){
var state_17250__$1 = state_17250;
var statearr_17263_17300 = state_17250__$1;
(statearr_17263_17300[(2)] = null);

(statearr_17263_17300[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (13))){
var inst_17203 = (state_17250[(9)]);
var inst_17202 = (state_17250[(10)]);
var inst_17205 = (state_17250[(11)]);
var inst_17204 = (state_17250[(12)]);
var inst_17212 = (state_17250[(2)]);
var inst_17213 = (inst_17205 + (1));
var tmp17259 = inst_17203;
var tmp17260 = inst_17202;
var tmp17261 = inst_17204;
var inst_17202__$1 = tmp17260;
var inst_17203__$1 = tmp17259;
var inst_17204__$1 = tmp17261;
var inst_17205__$1 = inst_17213;
var state_17250__$1 = (function (){var statearr_17264 = state_17250;
(statearr_17264[(9)] = inst_17203__$1);

(statearr_17264[(10)] = inst_17202__$1);

(statearr_17264[(11)] = inst_17205__$1);

(statearr_17264[(14)] = inst_17212);

(statearr_17264[(12)] = inst_17204__$1);

return statearr_17264;
})();
var statearr_17265_17301 = state_17250__$1;
(statearr_17265_17301[(2)] = null);

(statearr_17265_17301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (22))){
var state_17250__$1 = state_17250;
var statearr_17266_17302 = state_17250__$1;
(statearr_17266_17302[(2)] = null);

(statearr_17266_17302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (6))){
var inst_17191 = (state_17250[(13)]);
var inst_17200 = f.call(null,inst_17191);
var inst_17201 = cljs.core.seq.call(null,inst_17200);
var inst_17202 = inst_17201;
var inst_17203 = null;
var inst_17204 = (0);
var inst_17205 = (0);
var state_17250__$1 = (function (){var statearr_17268 = state_17250;
(statearr_17268[(9)] = inst_17203);

(statearr_17268[(10)] = inst_17202);

(statearr_17268[(11)] = inst_17205);

(statearr_17268[(12)] = inst_17204);

return statearr_17268;
})();
var statearr_17269_17303 = state_17250__$1;
(statearr_17269_17303[(2)] = null);

(statearr_17269_17303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (17))){
var inst_17216 = (state_17250[(7)]);
var inst_17220 = cljs.core.chunk_first.call(null,inst_17216);
var inst_17221 = cljs.core.chunk_rest.call(null,inst_17216);
var inst_17222 = cljs.core.count.call(null,inst_17220);
var inst_17202 = inst_17221;
var inst_17203 = inst_17220;
var inst_17204 = inst_17222;
var inst_17205 = (0);
var state_17250__$1 = (function (){var statearr_17270 = state_17250;
(statearr_17270[(9)] = inst_17203);

(statearr_17270[(10)] = inst_17202);

(statearr_17270[(11)] = inst_17205);

(statearr_17270[(12)] = inst_17204);

return statearr_17270;
})();
var statearr_17271_17304 = state_17250__$1;
(statearr_17271_17304[(2)] = null);

(statearr_17271_17304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (3))){
var inst_17248 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17250__$1,inst_17248);
} else {
if((state_val_17251 === (12))){
var inst_17236 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17272_17305 = state_17250__$1;
(statearr_17272_17305[(2)] = inst_17236);

(statearr_17272_17305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (2))){
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17250__$1,(4),in$);
} else {
if((state_val_17251 === (23))){
var inst_17244 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17273_17308 = state_17250__$1;
(statearr_17273_17308[(2)] = inst_17244);

(statearr_17273_17308[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (19))){
var inst_17231 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17274_17309 = state_17250__$1;
(statearr_17274_17309[(2)] = inst_17231);

(statearr_17274_17309[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (11))){
var inst_17202 = (state_17250[(10)]);
var inst_17216 = (state_17250[(7)]);
var inst_17216__$1 = cljs.core.seq.call(null,inst_17202);
var state_17250__$1 = (function (){var statearr_17275 = state_17250;
(statearr_17275[(7)] = inst_17216__$1);

return statearr_17275;
})();
if(inst_17216__$1){
var statearr_17276_17311 = state_17250__$1;
(statearr_17276_17311[(1)] = (14));

} else {
var statearr_17277_17312 = state_17250__$1;
(statearr_17277_17312[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (9))){
var inst_17238 = (state_17250[(2)]);
var inst_17239 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17250__$1 = (function (){var statearr_17278 = state_17250;
(statearr_17278[(15)] = inst_17238);

return statearr_17278;
})();
if(cljs.core.truth_(inst_17239)){
var statearr_17279_17314 = state_17250__$1;
(statearr_17279_17314[(1)] = (21));

} else {
var statearr_17280_17315 = state_17250__$1;
(statearr_17280_17315[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (5))){
var inst_17194 = cljs.core.async.close_BANG_.call(null,out);
var state_17250__$1 = state_17250;
var statearr_17281_17316 = state_17250__$1;
(statearr_17281_17316[(2)] = inst_17194);

(statearr_17281_17316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (14))){
var inst_17216 = (state_17250[(7)]);
var inst_17218 = cljs.core.chunked_seq_QMARK_.call(null,inst_17216);
var state_17250__$1 = state_17250;
if(inst_17218){
var statearr_17282_17317 = state_17250__$1;
(statearr_17282_17317[(1)] = (17));

} else {
var statearr_17283_17318 = state_17250__$1;
(statearr_17283_17318[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (16))){
var inst_17234 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17284_17322 = state_17250__$1;
(statearr_17284_17322[(2)] = inst_17234);

(statearr_17284_17322[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (10))){
var inst_17203 = (state_17250[(9)]);
var inst_17205 = (state_17250[(11)]);
var inst_17210 = cljs.core._nth.call(null,inst_17203,inst_17205);
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17250__$1,(13),out,inst_17210);
} else {
if((state_val_17251 === (18))){
var inst_17216 = (state_17250[(7)]);
var inst_17225 = cljs.core.first.call(null,inst_17216);
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17250__$1,(20),out,inst_17225);
} else {
if((state_val_17251 === (8))){
var inst_17205 = (state_17250[(11)]);
var inst_17204 = (state_17250[(12)]);
var inst_17207 = (inst_17205 < inst_17204);
var inst_17208 = inst_17207;
var state_17250__$1 = state_17250;
if(cljs.core.truth_(inst_17208)){
var statearr_17285_17327 = state_17250__$1;
(statearr_17285_17327[(1)] = (10));

} else {
var statearr_17286_17328 = state_17250__$1;
(statearr_17286_17328[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto__))
;
return ((function (switch__14236__auto__,c__14362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17290[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17290[(1)] = (1));

return statearr_17290;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17250){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17250);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17291){if((e17291 instanceof Object)){
var ex__14240__auto__ = e17291;
var statearr_17292_17329 = state_17250;
(statearr_17292_17329[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17250);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17291;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17331 = state_17250;
state_17250 = G__17331;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17250){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto__))
})();
var state__14364__auto__ = (function (){var statearr_17293 = f__14363__auto__.call(null);
(statearr_17293[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto__);

return statearr_17293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto__))
);

return c__14362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17332 = [];
var len__7107__auto___17335 = arguments.length;
var i__7108__auto___17336 = (0);
while(true){
if((i__7108__auto___17336 < len__7107__auto___17335)){
args17332.push((arguments[i__7108__auto___17336]));

var G__17337 = (i__7108__auto___17336 + (1));
i__7108__auto___17336 = G__17337;
continue;
} else {
}
break;
}

var G__17334 = args17332.length;
switch (G__17334) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17332.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17339 = [];
var len__7107__auto___17342 = arguments.length;
var i__7108__auto___17343 = (0);
while(true){
if((i__7108__auto___17343 < len__7107__auto___17342)){
args17339.push((arguments[i__7108__auto___17343]));

var G__17344 = (i__7108__auto___17343 + (1));
i__7108__auto___17343 = G__17344;
continue;
} else {
}
break;
}

var G__17341 = args17339.length;
switch (G__17341) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17339.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17346 = [];
var len__7107__auto___17397 = arguments.length;
var i__7108__auto___17398 = (0);
while(true){
if((i__7108__auto___17398 < len__7107__auto___17397)){
args17346.push((arguments[i__7108__auto___17398]));

var G__17399 = (i__7108__auto___17398 + (1));
i__7108__auto___17398 = G__17399;
continue;
} else {
}
break;
}

var G__17348 = args17346.length;
switch (G__17348) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17346.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14362__auto___17407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___17407,out){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___17407,out){
return (function (state_17372){
var state_val_17373 = (state_17372[(1)]);
if((state_val_17373 === (7))){
var inst_17367 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17374_17409 = state_17372__$1;
(statearr_17374_17409[(2)] = inst_17367);

(statearr_17374_17409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (1))){
var inst_17349 = null;
var state_17372__$1 = (function (){var statearr_17375 = state_17372;
(statearr_17375[(7)] = inst_17349);

return statearr_17375;
})();
var statearr_17376_17411 = state_17372__$1;
(statearr_17376_17411[(2)] = null);

(statearr_17376_17411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (4))){
var inst_17352 = (state_17372[(8)]);
var inst_17352__$1 = (state_17372[(2)]);
var inst_17353 = (inst_17352__$1 == null);
var inst_17354 = cljs.core.not.call(null,inst_17353);
var state_17372__$1 = (function (){var statearr_17377 = state_17372;
(statearr_17377[(8)] = inst_17352__$1);

return statearr_17377;
})();
if(inst_17354){
var statearr_17378_17413 = state_17372__$1;
(statearr_17378_17413[(1)] = (5));

} else {
var statearr_17379_17414 = state_17372__$1;
(statearr_17379_17414[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (6))){
var state_17372__$1 = state_17372;
var statearr_17380_17415 = state_17372__$1;
(statearr_17380_17415[(2)] = null);

(statearr_17380_17415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (3))){
var inst_17369 = (state_17372[(2)]);
var inst_17370 = cljs.core.async.close_BANG_.call(null,out);
var state_17372__$1 = (function (){var statearr_17381 = state_17372;
(statearr_17381[(9)] = inst_17369);

return statearr_17381;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17372__$1,inst_17370);
} else {
if((state_val_17373 === (2))){
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17372__$1,(4),ch);
} else {
if((state_val_17373 === (11))){
var inst_17352 = (state_17372[(8)]);
var inst_17361 = (state_17372[(2)]);
var inst_17349 = inst_17352;
var state_17372__$1 = (function (){var statearr_17382 = state_17372;
(statearr_17382[(7)] = inst_17349);

(statearr_17382[(10)] = inst_17361);

return statearr_17382;
})();
var statearr_17383_17420 = state_17372__$1;
(statearr_17383_17420[(2)] = null);

(statearr_17383_17420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (9))){
var inst_17352 = (state_17372[(8)]);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17372__$1,(11),out,inst_17352);
} else {
if((state_val_17373 === (5))){
var inst_17349 = (state_17372[(7)]);
var inst_17352 = (state_17372[(8)]);
var inst_17356 = cljs.core._EQ_.call(null,inst_17352,inst_17349);
var state_17372__$1 = state_17372;
if(inst_17356){
var statearr_17385_17422 = state_17372__$1;
(statearr_17385_17422[(1)] = (8));

} else {
var statearr_17386_17423 = state_17372__$1;
(statearr_17386_17423[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (10))){
var inst_17364 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17387_17424 = state_17372__$1;
(statearr_17387_17424[(2)] = inst_17364);

(statearr_17387_17424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (8))){
var inst_17349 = (state_17372[(7)]);
var tmp17384 = inst_17349;
var inst_17349__$1 = tmp17384;
var state_17372__$1 = (function (){var statearr_17388 = state_17372;
(statearr_17388[(7)] = inst_17349__$1);

return statearr_17388;
})();
var statearr_17389_17425 = state_17372__$1;
(statearr_17389_17425[(2)] = null);

(statearr_17389_17425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___17407,out))
;
return ((function (switch__14236__auto__,c__14362__auto___17407,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17393 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17393[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17393[(1)] = (1));

return statearr_17393;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17372){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17394){if((e17394 instanceof Object)){
var ex__14240__auto__ = e17394;
var statearr_17395_17428 = state_17372;
(statearr_17395_17428[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17430 = state_17372;
state_17372 = G__17430;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___17407,out))
})();
var state__14364__auto__ = (function (){var statearr_17396 = f__14363__auto__.call(null);
(statearr_17396[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___17407);

return statearr_17396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___17407,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17432 = [];
var len__7107__auto___17510 = arguments.length;
var i__7108__auto___17511 = (0);
while(true){
if((i__7108__auto___17511 < len__7107__auto___17510)){
args17432.push((arguments[i__7108__auto___17511]));

var G__17517 = (i__7108__auto___17511 + (1));
i__7108__auto___17511 = G__17517;
continue;
} else {
}
break;
}

var G__17434 = args17432.length;
switch (G__17434) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17432.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14362__auto___17522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___17522,out){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___17522,out){
return (function (state_17472){
var state_val_17473 = (state_17472[(1)]);
if((state_val_17473 === (7))){
var inst_17468 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17474_17524 = state_17472__$1;
(statearr_17474_17524[(2)] = inst_17468);

(statearr_17474_17524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (1))){
var inst_17435 = (new Array(n));
var inst_17436 = inst_17435;
var inst_17437 = (0);
var state_17472__$1 = (function (){var statearr_17476 = state_17472;
(statearr_17476[(7)] = inst_17437);

(statearr_17476[(8)] = inst_17436);

return statearr_17476;
})();
var statearr_17477_17525 = state_17472__$1;
(statearr_17477_17525[(2)] = null);

(statearr_17477_17525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (4))){
var inst_17440 = (state_17472[(9)]);
var inst_17440__$1 = (state_17472[(2)]);
var inst_17441 = (inst_17440__$1 == null);
var inst_17442 = cljs.core.not.call(null,inst_17441);
var state_17472__$1 = (function (){var statearr_17478 = state_17472;
(statearr_17478[(9)] = inst_17440__$1);

return statearr_17478;
})();
if(inst_17442){
var statearr_17479_17527 = state_17472__$1;
(statearr_17479_17527[(1)] = (5));

} else {
var statearr_17480_17528 = state_17472__$1;
(statearr_17480_17528[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (15))){
var inst_17462 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17481_17529 = state_17472__$1;
(statearr_17481_17529[(2)] = inst_17462);

(statearr_17481_17529[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (13))){
var state_17472__$1 = state_17472;
var statearr_17482_17531 = state_17472__$1;
(statearr_17482_17531[(2)] = null);

(statearr_17482_17531[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (6))){
var inst_17437 = (state_17472[(7)]);
var inst_17458 = (inst_17437 > (0));
var state_17472__$1 = state_17472;
if(cljs.core.truth_(inst_17458)){
var statearr_17483_17532 = state_17472__$1;
(statearr_17483_17532[(1)] = (12));

} else {
var statearr_17484_17533 = state_17472__$1;
(statearr_17484_17533[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (3))){
var inst_17470 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17472__$1,inst_17470);
} else {
if((state_val_17473 === (12))){
var inst_17436 = (state_17472[(8)]);
var inst_17460 = cljs.core.vec.call(null,inst_17436);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17472__$1,(15),out,inst_17460);
} else {
if((state_val_17473 === (2))){
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17472__$1,(4),ch);
} else {
if((state_val_17473 === (11))){
var inst_17452 = (state_17472[(2)]);
var inst_17453 = (new Array(n));
var inst_17436 = inst_17453;
var inst_17437 = (0);
var state_17472__$1 = (function (){var statearr_17485 = state_17472;
(statearr_17485[(10)] = inst_17452);

(statearr_17485[(7)] = inst_17437);

(statearr_17485[(8)] = inst_17436);

return statearr_17485;
})();
var statearr_17486_17539 = state_17472__$1;
(statearr_17486_17539[(2)] = null);

(statearr_17486_17539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (9))){
var inst_17436 = (state_17472[(8)]);
var inst_17450 = cljs.core.vec.call(null,inst_17436);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17472__$1,(11),out,inst_17450);
} else {
if((state_val_17473 === (5))){
var inst_17440 = (state_17472[(9)]);
var inst_17445 = (state_17472[(11)]);
var inst_17437 = (state_17472[(7)]);
var inst_17436 = (state_17472[(8)]);
var inst_17444 = (inst_17436[inst_17437] = inst_17440);
var inst_17445__$1 = (inst_17437 + (1));
var inst_17446 = (inst_17445__$1 < n);
var state_17472__$1 = (function (){var statearr_17487 = state_17472;
(statearr_17487[(11)] = inst_17445__$1);

(statearr_17487[(12)] = inst_17444);

return statearr_17487;
})();
if(cljs.core.truth_(inst_17446)){
var statearr_17488_17547 = state_17472__$1;
(statearr_17488_17547[(1)] = (8));

} else {
var statearr_17489_17548 = state_17472__$1;
(statearr_17489_17548[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (14))){
var inst_17465 = (state_17472[(2)]);
var inst_17466 = cljs.core.async.close_BANG_.call(null,out);
var state_17472__$1 = (function (){var statearr_17491 = state_17472;
(statearr_17491[(13)] = inst_17465);

return statearr_17491;
})();
var statearr_17492_17552 = state_17472__$1;
(statearr_17492_17552[(2)] = inst_17466);

(statearr_17492_17552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (10))){
var inst_17456 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17493_17554 = state_17472__$1;
(statearr_17493_17554[(2)] = inst_17456);

(statearr_17493_17554[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (8))){
var inst_17445 = (state_17472[(11)]);
var inst_17436 = (state_17472[(8)]);
var tmp17490 = inst_17436;
var inst_17436__$1 = tmp17490;
var inst_17437 = inst_17445;
var state_17472__$1 = (function (){var statearr_17494 = state_17472;
(statearr_17494[(7)] = inst_17437);

(statearr_17494[(8)] = inst_17436__$1);

return statearr_17494;
})();
var statearr_17495_17555 = state_17472__$1;
(statearr_17495_17555[(2)] = null);

(statearr_17495_17555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___17522,out))
;
return ((function (switch__14236__auto__,c__14362__auto___17522,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17499[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17499[(1)] = (1));

return statearr_17499;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17472){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17500){if((e17500 instanceof Object)){
var ex__14240__auto__ = e17500;
var statearr_17501_17557 = state_17472;
(statearr_17501_17557[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17500;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17558 = state_17472;
state_17472 = G__17558;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17472){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___17522,out))
})();
var state__14364__auto__ = (function (){var statearr_17508 = f__14363__auto__.call(null);
(statearr_17508[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___17522);

return statearr_17508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___17522,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17559 = [];
var len__7107__auto___17637 = arguments.length;
var i__7108__auto___17638 = (0);
while(true){
if((i__7108__auto___17638 < len__7107__auto___17637)){
args17559.push((arguments[i__7108__auto___17638]));

var G__17642 = (i__7108__auto___17638 + (1));
i__7108__auto___17638 = G__17642;
continue;
} else {
}
break;
}

var G__17561 = args17559.length;
switch (G__17561) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17559.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14362__auto___17644 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14362__auto___17644,out){
return (function (){
var f__14363__auto__ = (function (){var switch__14236__auto__ = ((function (c__14362__auto___17644,out){
return (function (state_17603){
var state_val_17604 = (state_17603[(1)]);
if((state_val_17604 === (7))){
var inst_17599 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17605_17645 = state_17603__$1;
(statearr_17605_17645[(2)] = inst_17599);

(statearr_17605_17645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (1))){
var inst_17562 = [];
var inst_17563 = inst_17562;
var inst_17564 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17603__$1 = (function (){var statearr_17606 = state_17603;
(statearr_17606[(7)] = inst_17563);

(statearr_17606[(8)] = inst_17564);

return statearr_17606;
})();
var statearr_17607_17647 = state_17603__$1;
(statearr_17607_17647[(2)] = null);

(statearr_17607_17647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (4))){
var inst_17567 = (state_17603[(9)]);
var inst_17567__$1 = (state_17603[(2)]);
var inst_17568 = (inst_17567__$1 == null);
var inst_17569 = cljs.core.not.call(null,inst_17568);
var state_17603__$1 = (function (){var statearr_17608 = state_17603;
(statearr_17608[(9)] = inst_17567__$1);

return statearr_17608;
})();
if(inst_17569){
var statearr_17609_17648 = state_17603__$1;
(statearr_17609_17648[(1)] = (5));

} else {
var statearr_17610_17649 = state_17603__$1;
(statearr_17610_17649[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (15))){
var inst_17593 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17611_17650 = state_17603__$1;
(statearr_17611_17650[(2)] = inst_17593);

(statearr_17611_17650[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (13))){
var state_17603__$1 = state_17603;
var statearr_17612_17651 = state_17603__$1;
(statearr_17612_17651[(2)] = null);

(statearr_17612_17651[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (6))){
var inst_17563 = (state_17603[(7)]);
var inst_17588 = inst_17563.length;
var inst_17589 = (inst_17588 > (0));
var state_17603__$1 = state_17603;
if(cljs.core.truth_(inst_17589)){
var statearr_17613_17652 = state_17603__$1;
(statearr_17613_17652[(1)] = (12));

} else {
var statearr_17614_17653 = state_17603__$1;
(statearr_17614_17653[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (3))){
var inst_17601 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17603__$1,inst_17601);
} else {
if((state_val_17604 === (12))){
var inst_17563 = (state_17603[(7)]);
var inst_17591 = cljs.core.vec.call(null,inst_17563);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17603__$1,(15),out,inst_17591);
} else {
if((state_val_17604 === (2))){
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17603__$1,(4),ch);
} else {
if((state_val_17604 === (11))){
var inst_17571 = (state_17603[(10)]);
var inst_17567 = (state_17603[(9)]);
var inst_17581 = (state_17603[(2)]);
var inst_17582 = [];
var inst_17583 = inst_17582.push(inst_17567);
var inst_17563 = inst_17582;
var inst_17564 = inst_17571;
var state_17603__$1 = (function (){var statearr_17617 = state_17603;
(statearr_17617[(7)] = inst_17563);

(statearr_17617[(8)] = inst_17564);

(statearr_17617[(11)] = inst_17583);

(statearr_17617[(12)] = inst_17581);

return statearr_17617;
})();
var statearr_17618_17654 = state_17603__$1;
(statearr_17618_17654[(2)] = null);

(statearr_17618_17654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (9))){
var inst_17563 = (state_17603[(7)]);
var inst_17579 = cljs.core.vec.call(null,inst_17563);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17603__$1,(11),out,inst_17579);
} else {
if((state_val_17604 === (5))){
var inst_17571 = (state_17603[(10)]);
var inst_17564 = (state_17603[(8)]);
var inst_17567 = (state_17603[(9)]);
var inst_17571__$1 = f.call(null,inst_17567);
var inst_17572 = cljs.core._EQ_.call(null,inst_17571__$1,inst_17564);
var inst_17573 = cljs.core.keyword_identical_QMARK_.call(null,inst_17564,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17574 = (inst_17572) || (inst_17573);
var state_17603__$1 = (function (){var statearr_17620 = state_17603;
(statearr_17620[(10)] = inst_17571__$1);

return statearr_17620;
})();
if(cljs.core.truth_(inst_17574)){
var statearr_17621_17655 = state_17603__$1;
(statearr_17621_17655[(1)] = (8));

} else {
var statearr_17622_17656 = state_17603__$1;
(statearr_17622_17656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (14))){
var inst_17596 = (state_17603[(2)]);
var inst_17597 = cljs.core.async.close_BANG_.call(null,out);
var state_17603__$1 = (function (){var statearr_17624 = state_17603;
(statearr_17624[(13)] = inst_17596);

return statearr_17624;
})();
var statearr_17625_17657 = state_17603__$1;
(statearr_17625_17657[(2)] = inst_17597);

(statearr_17625_17657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (10))){
var inst_17586 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17627_17658 = state_17603__$1;
(statearr_17627_17658[(2)] = inst_17586);

(statearr_17627_17658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (8))){
var inst_17563 = (state_17603[(7)]);
var inst_17571 = (state_17603[(10)]);
var inst_17567 = (state_17603[(9)]);
var inst_17576 = inst_17563.push(inst_17567);
var tmp17623 = inst_17563;
var inst_17563__$1 = tmp17623;
var inst_17564 = inst_17571;
var state_17603__$1 = (function (){var statearr_17628 = state_17603;
(statearr_17628[(7)] = inst_17563__$1);

(statearr_17628[(14)] = inst_17576);

(statearr_17628[(8)] = inst_17564);

return statearr_17628;
})();
var statearr_17629_17659 = state_17603__$1;
(statearr_17629_17659[(2)] = null);

(statearr_17629_17659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14362__auto___17644,out))
;
return ((function (switch__14236__auto__,c__14362__auto___17644,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17633 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17633[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17633[(1)] = (1));

return statearr_17633;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17603){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17634){if((e17634 instanceof Object)){
var ex__14240__auto__ = e17634;
var statearr_17635_17660 = state_17603;
(statearr_17635_17660[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17603);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17661 = state_17603;
state_17603 = G__17661;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17603){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14362__auto___17644,out))
})();
var state__14364__auto__ = (function (){var statearr_17636 = f__14363__auto__.call(null);
(statearr_17636[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14362__auto___17644);

return statearr_17636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14364__auto__);
});})(c__14362__auto___17644,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472741566909