// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14423 = [];
var len__7107__auto___14433 = arguments.length;
var i__7108__auto___14434 = (0);
while(true){
if((i__7108__auto___14434 < len__7107__auto___14433)){
args14423.push((arguments[i__7108__auto___14434]));

var G__14435 = (i__7108__auto___14434 + (1));
i__7108__auto___14434 = G__14435;
continue;
} else {
}
break;
}

var G__14425 = args14423.length;
switch (G__14425) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14423.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14426 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14426 = (function (f,blockable,meta14427){
this.f = f;
this.blockable = blockable;
this.meta14427 = meta14427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14428,meta14427__$1){
var self__ = this;
var _14428__$1 = this;
return (new cljs.core.async.t_cljs$core$async14426(self__.f,self__.blockable,meta14427__$1));
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14428){
var self__ = this;
var _14428__$1 = this;
return self__.meta14427;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14426.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14427","meta14427",-969928677,null)], null);
});

cljs.core.async.t_cljs$core$async14426.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14426.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14426";

cljs.core.async.t_cljs$core$async14426.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14426");
});

cljs.core.async.__GT_t_cljs$core$async14426 = (function cljs$core$async$__GT_t_cljs$core$async14426(f__$1,blockable__$1,meta14427){
return (new cljs.core.async.t_cljs$core$async14426(f__$1,blockable__$1,meta14427));
});

}

return (new cljs.core.async.t_cljs$core$async14426(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14448 = [];
var len__7107__auto___14459 = arguments.length;
var i__7108__auto___14461 = (0);
while(true){
if((i__7108__auto___14461 < len__7107__auto___14459)){
args14448.push((arguments[i__7108__auto___14461]));

var G__14462 = (i__7108__auto___14461 + (1));
i__7108__auto___14461 = G__14462;
continue;
} else {
}
break;
}

var G__14456 = args14448.length;
switch (G__14456) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14448.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14464 = [];
var len__7107__auto___14472 = arguments.length;
var i__7108__auto___14473 = (0);
while(true){
if((i__7108__auto___14473 < len__7107__auto___14472)){
args14464.push((arguments[i__7108__auto___14473]));

var G__14475 = (i__7108__auto___14473 + (1));
i__7108__auto___14473 = G__14475;
continue;
} else {
}
break;
}

var G__14468 = args14464.length;
switch (G__14468) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14464.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14483 = [];
var len__7107__auto___14487 = arguments.length;
var i__7108__auto___14488 = (0);
while(true){
if((i__7108__auto___14488 < len__7107__auto___14487)){
args14483.push((arguments[i__7108__auto___14488]));

var G__14489 = (i__7108__auto___14488 + (1));
i__7108__auto___14488 = G__14489;
continue;
} else {
}
break;
}

var G__14486 = args14483.length;
switch (G__14486) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14483.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14491 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14491);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14491,ret){
return (function (){
return fn1.call(null,val_14491);
});})(val_14491,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14492 = [];
var len__7107__auto___14495 = arguments.length;
var i__7108__auto___14496 = (0);
while(true){
if((i__7108__auto___14496 < len__7107__auto___14495)){
args14492.push((arguments[i__7108__auto___14496]));

var G__14499 = (i__7108__auto___14496 + (1));
i__7108__auto___14496 = G__14499;
continue;
} else {
}
break;
}

var G__14494 = args14492.length;
switch (G__14494) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14492.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14508 = n;
var x_14509 = (0);
while(true){
if((x_14509 < n__6952__auto___14508)){
(a[x_14509] = (0));

var G__14510 = (x_14509 + (1));
x_14509 = G__14510;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14511 = (i + (1));
i = G__14511;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14518 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14518 = (function (alt_flag,flag,meta14519){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14519 = meta14519;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14520,meta14519__$1){
var self__ = this;
var _14520__$1 = this;
return (new cljs.core.async.t_cljs$core$async14518(self__.alt_flag,self__.flag,meta14519__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14520){
var self__ = this;
var _14520__$1 = this;
return self__.meta14519;
});})(flag))
;

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14518.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14518.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14519","meta14519",-316517557,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14518.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14518.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14518";

cljs.core.async.t_cljs$core$async14518.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14518");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14518 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14518(alt_flag__$1,flag__$1,meta14519){
return (new cljs.core.async.t_cljs$core$async14518(alt_flag__$1,flag__$1,meta14519));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14518(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14524 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14524 = (function (alt_handler,flag,cb,meta14525){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14525 = meta14525;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14526,meta14525__$1){
var self__ = this;
var _14526__$1 = this;
return (new cljs.core.async.t_cljs$core$async14524(self__.alt_handler,self__.flag,self__.cb,meta14525__$1));
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14526){
var self__ = this;
var _14526__$1 = this;
return self__.meta14525;
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14524.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14525","meta14525",581736544,null)], null);
});

cljs.core.async.t_cljs$core$async14524.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14524.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14524";

cljs.core.async.t_cljs$core$async14524.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14524");
});

cljs.core.async.__GT_t_cljs$core$async14524 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14524(alt_handler__$1,flag__$1,cb__$1,meta14525){
return (new cljs.core.async.t_cljs$core$async14524(alt_handler__$1,flag__$1,cb__$1,meta14525));
});

}

return (new cljs.core.async.t_cljs$core$async14524(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14527_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14527_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14528_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14528_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14536 = (i + (1));
i = G__14536;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14544 = arguments.length;
var i__7108__auto___14545 = (0);
while(true){
if((i__7108__auto___14545 < len__7107__auto___14544)){
args__7114__auto__.push((arguments[i__7108__auto___14545]));

var G__14546 = (i__7108__auto___14545 + (1));
i__7108__auto___14545 = G__14546;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14539){
var map__14540 = p__14539;
var map__14540__$1 = ((((!((map__14540 == null)))?((((map__14540.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14540.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14540):map__14540);
var opts = map__14540__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14537){
var G__14538 = cljs.core.first.call(null,seq14537);
var seq14537__$1 = cljs.core.next.call(null,seq14537);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14538,seq14537__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14550 = [];
var len__7107__auto___14620 = arguments.length;
var i__7108__auto___14621 = (0);
while(true){
if((i__7108__auto___14621 < len__7107__auto___14620)){
args14550.push((arguments[i__7108__auto___14621]));

var G__14622 = (i__7108__auto___14621 + (1));
i__7108__auto___14621 = G__14622;
continue;
} else {
}
break;
}

var G__14552 = args14550.length;
switch (G__14552) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14550.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14375__auto___14624 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___14624){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___14624){
return (function (state_14590){
var state_val_14591 = (state_14590[(1)]);
if((state_val_14591 === (7))){
var inst_14584 = (state_14590[(2)]);
var state_14590__$1 = state_14590;
var statearr_14593_14625 = state_14590__$1;
(statearr_14593_14625[(2)] = inst_14584);

(statearr_14593_14625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (1))){
var state_14590__$1 = state_14590;
var statearr_14594_14626 = state_14590__$1;
(statearr_14594_14626[(2)] = null);

(statearr_14594_14626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (4))){
var inst_14563 = (state_14590[(7)]);
var inst_14563__$1 = (state_14590[(2)]);
var inst_14565 = (inst_14563__$1 == null);
var state_14590__$1 = (function (){var statearr_14595 = state_14590;
(statearr_14595[(7)] = inst_14563__$1);

return statearr_14595;
})();
if(cljs.core.truth_(inst_14565)){
var statearr_14596_14629 = state_14590__$1;
(statearr_14596_14629[(1)] = (5));

} else {
var statearr_14597_14631 = state_14590__$1;
(statearr_14597_14631[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (13))){
var state_14590__$1 = state_14590;
var statearr_14600_14632 = state_14590__$1;
(statearr_14600_14632[(2)] = null);

(statearr_14600_14632[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (6))){
var inst_14563 = (state_14590[(7)]);
var state_14590__$1 = state_14590;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14590__$1,(11),to,inst_14563);
} else {
if((state_val_14591 === (3))){
var inst_14588 = (state_14590[(2)]);
var state_14590__$1 = state_14590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14590__$1,inst_14588);
} else {
if((state_val_14591 === (12))){
var state_14590__$1 = state_14590;
var statearr_14601_14633 = state_14590__$1;
(statearr_14601_14633[(2)] = null);

(statearr_14601_14633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (2))){
var state_14590__$1 = state_14590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14590__$1,(4),from);
} else {
if((state_val_14591 === (11))){
var inst_14577 = (state_14590[(2)]);
var state_14590__$1 = state_14590;
if(cljs.core.truth_(inst_14577)){
var statearr_14602_14634 = state_14590__$1;
(statearr_14602_14634[(1)] = (12));

} else {
var statearr_14603_14636 = state_14590__$1;
(statearr_14603_14636[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (9))){
var state_14590__$1 = state_14590;
var statearr_14604_14639 = state_14590__$1;
(statearr_14604_14639[(2)] = null);

(statearr_14604_14639[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (5))){
var state_14590__$1 = state_14590;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14606_14642 = state_14590__$1;
(statearr_14606_14642[(1)] = (8));

} else {
var statearr_14607_14643 = state_14590__$1;
(statearr_14607_14643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (14))){
var inst_14582 = (state_14590[(2)]);
var state_14590__$1 = state_14590;
var statearr_14608_14644 = state_14590__$1;
(statearr_14608_14644[(2)] = inst_14582);

(statearr_14608_14644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (10))){
var inst_14573 = (state_14590[(2)]);
var state_14590__$1 = state_14590;
var statearr_14609_14645 = state_14590__$1;
(statearr_14609_14645[(2)] = inst_14573);

(statearr_14609_14645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14591 === (8))){
var inst_14569 = cljs.core.async.close_BANG_.call(null,to);
var state_14590__$1 = state_14590;
var statearr_14610_14646 = state_14590__$1;
(statearr_14610_14646[(2)] = inst_14569);

(statearr_14610_14646[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___14624))
;
return ((function (switch__14236__auto__,c__14375__auto___14624){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14614 = [null,null,null,null,null,null,null,null];
(statearr_14614[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14614[(1)] = (1));

return statearr_14614;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14590){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14615){if((e14615 instanceof Object)){
var ex__14240__auto__ = e14615;
var statearr_14616_14647 = state_14590;
(statearr_14616_14647[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14590);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14648 = state_14590;
state_14590 = G__14648;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14590){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___14624))
})();
var state__14377__auto__ = (function (){var statearr_14617 = f__14376__auto__.call(null);
(statearr_14617[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___14624);

return statearr_14617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___14624))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14842){
var vec__14843 = p__14842;
var v = cljs.core.nth.call(null,vec__14843,(0),null);
var p = cljs.core.nth.call(null,vec__14843,(1),null);
var job = vec__14843;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14375__auto___15027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15027,res,vec__14843,v,p,job,jobs,results){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15027,res,vec__14843,v,p,job,jobs,results){
return (function (state_14848){
var state_val_14849 = (state_14848[(1)]);
if((state_val_14849 === (1))){
var state_14848__$1 = state_14848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14848__$1,(2),res,v);
} else {
if((state_val_14849 === (2))){
var inst_14845 = (state_14848[(2)]);
var inst_14846 = cljs.core.async.close_BANG_.call(null,res);
var state_14848__$1 = (function (){var statearr_14850 = state_14848;
(statearr_14850[(7)] = inst_14845);

return statearr_14850;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14848__$1,inst_14846);
} else {
return null;
}
}
});})(c__14375__auto___15027,res,vec__14843,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14375__auto___15027,res,vec__14843,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14854 = [null,null,null,null,null,null,null,null];
(statearr_14854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14854[(1)] = (1));

return statearr_14854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14848){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14855){if((e14855 instanceof Object)){
var ex__14240__auto__ = e14855;
var statearr_14856_15028 = state_14848;
(statearr_14856_15028[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14855;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15029 = state_14848;
state_14848 = G__15029;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14848){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15027,res,vec__14843,v,p,job,jobs,results))
})();
var state__14377__auto__ = (function (){var statearr_14857 = f__14376__auto__.call(null);
(statearr_14857[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15027);

return statearr_14857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15027,res,vec__14843,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14858){
var vec__14859 = p__14858;
var v = cljs.core.nth.call(null,vec__14859,(0),null);
var p = cljs.core.nth.call(null,vec__14859,(1),null);
var job = vec__14859;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15031 = n;
var __15032 = (0);
while(true){
if((__15032 < n__6952__auto___15031)){
var G__14860_15033 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14860_15033) {
case "compute":
var c__14375__auto___15035 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15032,c__14375__auto___15035,G__14860_15033,n__6952__auto___15031,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (__15032,c__14375__auto___15035,G__14860_15033,n__6952__auto___15031,jobs,results,process,async){
return (function (state_14873){
var state_val_14874 = (state_14873[(1)]);
if((state_val_14874 === (1))){
var state_14873__$1 = state_14873;
var statearr_14875_15037 = state_14873__$1;
(statearr_14875_15037[(2)] = null);

(statearr_14875_15037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (2))){
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14873__$1,(4),jobs);
} else {
if((state_val_14874 === (3))){
var inst_14871 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14873__$1,inst_14871);
} else {
if((state_val_14874 === (4))){
var inst_14863 = (state_14873[(2)]);
var inst_14864 = process.call(null,inst_14863);
var state_14873__$1 = state_14873;
if(cljs.core.truth_(inst_14864)){
var statearr_14876_15038 = state_14873__$1;
(statearr_14876_15038[(1)] = (5));

} else {
var statearr_14877_15039 = state_14873__$1;
(statearr_14877_15039[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (5))){
var state_14873__$1 = state_14873;
var statearr_14878_15040 = state_14873__$1;
(statearr_14878_15040[(2)] = null);

(statearr_14878_15040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (6))){
var state_14873__$1 = state_14873;
var statearr_14879_15041 = state_14873__$1;
(statearr_14879_15041[(2)] = null);

(statearr_14879_15041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (7))){
var inst_14869 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
var statearr_14880_15042 = state_14873__$1;
(statearr_14880_15042[(2)] = inst_14869);

(statearr_14880_15042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15032,c__14375__auto___15035,G__14860_15033,n__6952__auto___15031,jobs,results,process,async))
;
return ((function (__15032,switch__14236__auto__,c__14375__auto___15035,G__14860_15033,n__6952__auto___15031,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14884 = [null,null,null,null,null,null,null];
(statearr_14884[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14884[(1)] = (1));

return statearr_14884;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14873){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14885){if((e14885 instanceof Object)){
var ex__14240__auto__ = e14885;
var statearr_14886_15043 = state_14873;
(statearr_14886_15043[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15044 = state_14873;
state_14873 = G__15044;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15032,switch__14236__auto__,c__14375__auto___15035,G__14860_15033,n__6952__auto___15031,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_14887 = f__14376__auto__.call(null);
(statearr_14887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15035);

return statearr_14887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(__15032,c__14375__auto___15035,G__14860_15033,n__6952__auto___15031,jobs,results,process,async))
);


break;
case "async":
var c__14375__auto___15049 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15032,c__14375__auto___15049,G__14860_15033,n__6952__auto___15031,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (__15032,c__14375__auto___15049,G__14860_15033,n__6952__auto___15031,jobs,results,process,async){
return (function (state_14900){
var state_val_14901 = (state_14900[(1)]);
if((state_val_14901 === (1))){
var state_14900__$1 = state_14900;
var statearr_14902_15051 = state_14900__$1;
(statearr_14902_15051[(2)] = null);

(statearr_14902_15051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (2))){
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14900__$1,(4),jobs);
} else {
if((state_val_14901 === (3))){
var inst_14898 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14900__$1,inst_14898);
} else {
if((state_val_14901 === (4))){
var inst_14890 = (state_14900[(2)]);
var inst_14891 = async.call(null,inst_14890);
var state_14900__$1 = state_14900;
if(inst_14891){
var statearr_14903_15057 = state_14900__$1;
(statearr_14903_15057[(1)] = (5));

} else {
var statearr_14904_15058 = state_14900__$1;
(statearr_14904_15058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (5))){
var state_14900__$1 = state_14900;
var statearr_14905_15059 = state_14900__$1;
(statearr_14905_15059[(2)] = null);

(statearr_14905_15059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (6))){
var state_14900__$1 = state_14900;
var statearr_14906_15060 = state_14900__$1;
(statearr_14906_15060[(2)] = null);

(statearr_14906_15060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (7))){
var inst_14896 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
var statearr_14907_15061 = state_14900__$1;
(statearr_14907_15061[(2)] = inst_14896);

(statearr_14907_15061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15032,c__14375__auto___15049,G__14860_15033,n__6952__auto___15031,jobs,results,process,async))
;
return ((function (__15032,switch__14236__auto__,c__14375__auto___15049,G__14860_15033,n__6952__auto___15031,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14911 = [null,null,null,null,null,null,null];
(statearr_14911[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14911[(1)] = (1));

return statearr_14911;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14900){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14912){if((e14912 instanceof Object)){
var ex__14240__auto__ = e14912;
var statearr_14913_15062 = state_14900;
(statearr_14913_15062[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15063 = state_14900;
state_14900 = G__15063;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14900){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15032,switch__14236__auto__,c__14375__auto___15049,G__14860_15033,n__6952__auto___15031,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_14914 = f__14376__auto__.call(null);
(statearr_14914[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15049);

return statearr_14914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(__15032,c__14375__auto___15049,G__14860_15033,n__6952__auto___15031,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15064 = (__15032 + (1));
__15032 = G__15064;
continue;
} else {
}
break;
}

var c__14375__auto___15065 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15065,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15065,jobs,results,process,async){
return (function (state_14936){
var state_val_14937 = (state_14936[(1)]);
if((state_val_14937 === (1))){
var state_14936__$1 = state_14936;
var statearr_14938_15066 = state_14936__$1;
(statearr_14938_15066[(2)] = null);

(statearr_14938_15066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (2))){
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14936__$1,(4),from);
} else {
if((state_val_14937 === (3))){
var inst_14934 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14936__$1,inst_14934);
} else {
if((state_val_14937 === (4))){
var inst_14917 = (state_14936[(7)]);
var inst_14917__$1 = (state_14936[(2)]);
var inst_14918 = (inst_14917__$1 == null);
var state_14936__$1 = (function (){var statearr_14939 = state_14936;
(statearr_14939[(7)] = inst_14917__$1);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14918)){
var statearr_14940_15067 = state_14936__$1;
(statearr_14940_15067[(1)] = (5));

} else {
var statearr_14941_15068 = state_14936__$1;
(statearr_14941_15068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (5))){
var inst_14920 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14936__$1 = state_14936;
var statearr_14942_15069 = state_14936__$1;
(statearr_14942_15069[(2)] = inst_14920);

(statearr_14942_15069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (6))){
var inst_14917 = (state_14936[(7)]);
var inst_14922 = (state_14936[(8)]);
var inst_14922__$1 = cljs.core.async.chan.call(null,(1));
var inst_14923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14924 = [inst_14917,inst_14922__$1];
var inst_14925 = (new cljs.core.PersistentVector(null,2,(5),inst_14923,inst_14924,null));
var state_14936__$1 = (function (){var statearr_14943 = state_14936;
(statearr_14943[(8)] = inst_14922__$1);

return statearr_14943;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(8),jobs,inst_14925);
} else {
if((state_val_14937 === (7))){
var inst_14932 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14944_15070 = state_14936__$1;
(statearr_14944_15070[(2)] = inst_14932);

(statearr_14944_15070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (8))){
var inst_14922 = (state_14936[(8)]);
var inst_14927 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14945 = state_14936;
(statearr_14945[(9)] = inst_14927);

return statearr_14945;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(9),results,inst_14922);
} else {
if((state_val_14937 === (9))){
var inst_14929 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14946 = state_14936;
(statearr_14946[(10)] = inst_14929);

return statearr_14946;
})();
var statearr_14947_15073 = state_14936__$1;
(statearr_14947_15073[(2)] = null);

(statearr_14947_15073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___15065,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14375__auto___15065,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14951 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14951[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14951[(1)] = (1));

return statearr_14951;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14936){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14952){if((e14952 instanceof Object)){
var ex__14240__auto__ = e14952;
var statearr_14953_15076 = state_14936;
(statearr_14953_15076[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15078 = state_14936;
state_14936 = G__15078;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14936){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15065,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_14954 = f__14376__auto__.call(null);
(statearr_14954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15065);

return statearr_14954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15065,jobs,results,process,async))
);


var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__,jobs,results,process,async){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__,jobs,results,process,async){
return (function (state_14992){
var state_val_14993 = (state_14992[(1)]);
if((state_val_14993 === (7))){
var inst_14988 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_14994_15080 = state_14992__$1;
(statearr_14994_15080[(2)] = inst_14988);

(statearr_14994_15080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (20))){
var state_14992__$1 = state_14992;
var statearr_14995_15081 = state_14992__$1;
(statearr_14995_15081[(2)] = null);

(statearr_14995_15081[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (1))){
var state_14992__$1 = state_14992;
var statearr_14996_15082 = state_14992__$1;
(statearr_14996_15082[(2)] = null);

(statearr_14996_15082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (4))){
var inst_14957 = (state_14992[(7)]);
var inst_14957__$1 = (state_14992[(2)]);
var inst_14958 = (inst_14957__$1 == null);
var state_14992__$1 = (function (){var statearr_14997 = state_14992;
(statearr_14997[(7)] = inst_14957__$1);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14958)){
var statearr_14998_15083 = state_14992__$1;
(statearr_14998_15083[(1)] = (5));

} else {
var statearr_14999_15087 = state_14992__$1;
(statearr_14999_15087[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (15))){
var inst_14970 = (state_14992[(8)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14992__$1,(18),to,inst_14970);
} else {
if((state_val_14993 === (21))){
var inst_14983 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15000_15088 = state_14992__$1;
(statearr_15000_15088[(2)] = inst_14983);

(statearr_15000_15088[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (13))){
var inst_14985 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15001 = state_14992;
(statearr_15001[(9)] = inst_14985);

return statearr_15001;
})();
var statearr_15002_15089 = state_14992__$1;
(statearr_15002_15089[(2)] = null);

(statearr_15002_15089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (6))){
var inst_14957 = (state_14992[(7)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(11),inst_14957);
} else {
if((state_val_14993 === (17))){
var inst_14978 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
if(cljs.core.truth_(inst_14978)){
var statearr_15003_15090 = state_14992__$1;
(statearr_15003_15090[(1)] = (19));

} else {
var statearr_15004_15091 = state_14992__$1;
(statearr_15004_15091[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (3))){
var inst_14990 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14992__$1,inst_14990);
} else {
if((state_val_14993 === (12))){
var inst_14967 = (state_14992[(10)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(14),inst_14967);
} else {
if((state_val_14993 === (2))){
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(4),results);
} else {
if((state_val_14993 === (19))){
var state_14992__$1 = state_14992;
var statearr_15005_15093 = state_14992__$1;
(statearr_15005_15093[(2)] = null);

(statearr_15005_15093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (11))){
var inst_14967 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15006 = state_14992;
(statearr_15006[(10)] = inst_14967);

return statearr_15006;
})();
var statearr_15007_15094 = state_14992__$1;
(statearr_15007_15094[(2)] = null);

(statearr_15007_15094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (9))){
var state_14992__$1 = state_14992;
var statearr_15008_15095 = state_14992__$1;
(statearr_15008_15095[(2)] = null);

(statearr_15008_15095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (5))){
var state_14992__$1 = state_14992;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15009_15096 = state_14992__$1;
(statearr_15009_15096[(1)] = (8));

} else {
var statearr_15010_15097 = state_14992__$1;
(statearr_15010_15097[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (14))){
var inst_14972 = (state_14992[(11)]);
var inst_14970 = (state_14992[(8)]);
var inst_14970__$1 = (state_14992[(2)]);
var inst_14971 = (inst_14970__$1 == null);
var inst_14972__$1 = cljs.core.not.call(null,inst_14971);
var state_14992__$1 = (function (){var statearr_15011 = state_14992;
(statearr_15011[(11)] = inst_14972__$1);

(statearr_15011[(8)] = inst_14970__$1);

return statearr_15011;
})();
if(inst_14972__$1){
var statearr_15012_15098 = state_14992__$1;
(statearr_15012_15098[(1)] = (15));

} else {
var statearr_15013_15099 = state_14992__$1;
(statearr_15013_15099[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (16))){
var inst_14972 = (state_14992[(11)]);
var state_14992__$1 = state_14992;
var statearr_15014_15100 = state_14992__$1;
(statearr_15014_15100[(2)] = inst_14972);

(statearr_15014_15100[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (10))){
var inst_14964 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15015_15101 = state_14992__$1;
(statearr_15015_15101[(2)] = inst_14964);

(statearr_15015_15101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (18))){
var inst_14975 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15016_15102 = state_14992__$1;
(statearr_15016_15102[(2)] = inst_14975);

(statearr_15016_15102[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (8))){
var inst_14961 = cljs.core.async.close_BANG_.call(null,to);
var state_14992__$1 = state_14992;
var statearr_15017_15103 = state_14992__$1;
(statearr_15017_15103[(2)] = inst_14961);

(statearr_15017_15103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14375__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15021[(1)] = (1));

return statearr_15021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14992){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15022){if((e15022 instanceof Object)){
var ex__14240__auto__ = e15022;
var statearr_15023_15104 = state_14992;
(statearr_15023_15104[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15105 = state_14992;
state_14992 = G__15105;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14992){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__,jobs,results,process,async))
})();
var state__14377__auto__ = (function (){var statearr_15024 = f__14376__auto__.call(null);
(statearr_15024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_15024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__,jobs,results,process,async))
);

return c__14375__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15106 = [];
var len__7107__auto___15109 = arguments.length;
var i__7108__auto___15110 = (0);
while(true){
if((i__7108__auto___15110 < len__7107__auto___15109)){
args15106.push((arguments[i__7108__auto___15110]));

var G__15111 = (i__7108__auto___15110 + (1));
i__7108__auto___15110 = G__15111;
continue;
} else {
}
break;
}

var G__15108 = args15106.length;
switch (G__15108) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15106.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15113 = [];
var len__7107__auto___15124 = arguments.length;
var i__7108__auto___15125 = (0);
while(true){
if((i__7108__auto___15125 < len__7107__auto___15124)){
args15113.push((arguments[i__7108__auto___15125]));

var G__15126 = (i__7108__auto___15125 + (1));
i__7108__auto___15125 = G__15126;
continue;
} else {
}
break;
}

var G__15115 = args15113.length;
switch (G__15115) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15113.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15149 = [];
var len__7107__auto___15202 = arguments.length;
var i__7108__auto___15203 = (0);
while(true){
if((i__7108__auto___15203 < len__7107__auto___15202)){
args15149.push((arguments[i__7108__auto___15203]));

var G__15206 = (i__7108__auto___15203 + (1));
i__7108__auto___15203 = G__15206;
continue;
} else {
}
break;
}

var G__15151 = args15149.length;
switch (G__15151) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15149.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14375__auto___15209 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15209,tc,fc){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15209,tc,fc){
return (function (state_15177){
var state_val_15178 = (state_15177[(1)]);
if((state_val_15178 === (7))){
var inst_15173 = (state_15177[(2)]);
var state_15177__$1 = state_15177;
var statearr_15179_15210 = state_15177__$1;
(statearr_15179_15210[(2)] = inst_15173);

(statearr_15179_15210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (1))){
var state_15177__$1 = state_15177;
var statearr_15180_15212 = state_15177__$1;
(statearr_15180_15212[(2)] = null);

(statearr_15180_15212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (4))){
var inst_15154 = (state_15177[(7)]);
var inst_15154__$1 = (state_15177[(2)]);
var inst_15155 = (inst_15154__$1 == null);
var state_15177__$1 = (function (){var statearr_15181 = state_15177;
(statearr_15181[(7)] = inst_15154__$1);

return statearr_15181;
})();
if(cljs.core.truth_(inst_15155)){
var statearr_15182_15213 = state_15177__$1;
(statearr_15182_15213[(1)] = (5));

} else {
var statearr_15183_15214 = state_15177__$1;
(statearr_15183_15214[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (13))){
var state_15177__$1 = state_15177;
var statearr_15184_15215 = state_15177__$1;
(statearr_15184_15215[(2)] = null);

(statearr_15184_15215[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (6))){
var inst_15154 = (state_15177[(7)]);
var inst_15160 = p.call(null,inst_15154);
var state_15177__$1 = state_15177;
if(cljs.core.truth_(inst_15160)){
var statearr_15185_15216 = state_15177__$1;
(statearr_15185_15216[(1)] = (9));

} else {
var statearr_15186_15217 = state_15177__$1;
(statearr_15186_15217[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (3))){
var inst_15175 = (state_15177[(2)]);
var state_15177__$1 = state_15177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15177__$1,inst_15175);
} else {
if((state_val_15178 === (12))){
var state_15177__$1 = state_15177;
var statearr_15187_15218 = state_15177__$1;
(statearr_15187_15218[(2)] = null);

(statearr_15187_15218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (2))){
var state_15177__$1 = state_15177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15177__$1,(4),ch);
} else {
if((state_val_15178 === (11))){
var inst_15154 = (state_15177[(7)]);
var inst_15164 = (state_15177[(2)]);
var state_15177__$1 = state_15177;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15177__$1,(8),inst_15164,inst_15154);
} else {
if((state_val_15178 === (9))){
var state_15177__$1 = state_15177;
var statearr_15188_15219 = state_15177__$1;
(statearr_15188_15219[(2)] = tc);

(statearr_15188_15219[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (5))){
var inst_15157 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15158 = cljs.core.async.close_BANG_.call(null,fc);
var state_15177__$1 = (function (){var statearr_15189 = state_15177;
(statearr_15189[(8)] = inst_15157);

return statearr_15189;
})();
var statearr_15190_15222 = state_15177__$1;
(statearr_15190_15222[(2)] = inst_15158);

(statearr_15190_15222[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (14))){
var inst_15171 = (state_15177[(2)]);
var state_15177__$1 = state_15177;
var statearr_15191_15223 = state_15177__$1;
(statearr_15191_15223[(2)] = inst_15171);

(statearr_15191_15223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (10))){
var state_15177__$1 = state_15177;
var statearr_15192_15225 = state_15177__$1;
(statearr_15192_15225[(2)] = fc);

(statearr_15192_15225[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15178 === (8))){
var inst_15166 = (state_15177[(2)]);
var state_15177__$1 = state_15177;
if(cljs.core.truth_(inst_15166)){
var statearr_15193_15227 = state_15177__$1;
(statearr_15193_15227[(1)] = (12));

} else {
var statearr_15194_15228 = state_15177__$1;
(statearr_15194_15228[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___15209,tc,fc))
;
return ((function (switch__14236__auto__,c__14375__auto___15209,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15198 = [null,null,null,null,null,null,null,null,null];
(statearr_15198[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15198[(1)] = (1));

return statearr_15198;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15177){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15199){if((e15199 instanceof Object)){
var ex__14240__auto__ = e15199;
var statearr_15200_15229 = state_15177;
(statearr_15200_15229[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15199;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15230 = state_15177;
state_15177 = G__15230;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15177){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15209,tc,fc))
})();
var state__14377__auto__ = (function (){var statearr_15201 = f__14376__auto__.call(null);
(statearr_15201[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15209);

return statearr_15201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15209,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__){
return (function (state_15298){
var state_val_15299 = (state_15298[(1)]);
if((state_val_15299 === (7))){
var inst_15294 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
var statearr_15300_15321 = state_15298__$1;
(statearr_15300_15321[(2)] = inst_15294);

(statearr_15300_15321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (1))){
var inst_15278 = init;
var state_15298__$1 = (function (){var statearr_15301 = state_15298;
(statearr_15301[(7)] = inst_15278);

return statearr_15301;
})();
var statearr_15302_15322 = state_15298__$1;
(statearr_15302_15322[(2)] = null);

(statearr_15302_15322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (4))){
var inst_15281 = (state_15298[(8)]);
var inst_15281__$1 = (state_15298[(2)]);
var inst_15282 = (inst_15281__$1 == null);
var state_15298__$1 = (function (){var statearr_15303 = state_15298;
(statearr_15303[(8)] = inst_15281__$1);

return statearr_15303;
})();
if(cljs.core.truth_(inst_15282)){
var statearr_15304_15323 = state_15298__$1;
(statearr_15304_15323[(1)] = (5));

} else {
var statearr_15305_15324 = state_15298__$1;
(statearr_15305_15324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (6))){
var inst_15285 = (state_15298[(9)]);
var inst_15281 = (state_15298[(8)]);
var inst_15278 = (state_15298[(7)]);
var inst_15285__$1 = f.call(null,inst_15278,inst_15281);
var inst_15286 = cljs.core.reduced_QMARK_.call(null,inst_15285__$1);
var state_15298__$1 = (function (){var statearr_15306 = state_15298;
(statearr_15306[(9)] = inst_15285__$1);

return statearr_15306;
})();
if(inst_15286){
var statearr_15307_15325 = state_15298__$1;
(statearr_15307_15325[(1)] = (8));

} else {
var statearr_15308_15326 = state_15298__$1;
(statearr_15308_15326[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (3))){
var inst_15296 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15298__$1,inst_15296);
} else {
if((state_val_15299 === (2))){
var state_15298__$1 = state_15298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15298__$1,(4),ch);
} else {
if((state_val_15299 === (9))){
var inst_15285 = (state_15298[(9)]);
var inst_15278 = inst_15285;
var state_15298__$1 = (function (){var statearr_15309 = state_15298;
(statearr_15309[(7)] = inst_15278);

return statearr_15309;
})();
var statearr_15310_15327 = state_15298__$1;
(statearr_15310_15327[(2)] = null);

(statearr_15310_15327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (5))){
var inst_15278 = (state_15298[(7)]);
var state_15298__$1 = state_15298;
var statearr_15311_15328 = state_15298__$1;
(statearr_15311_15328[(2)] = inst_15278);

(statearr_15311_15328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (10))){
var inst_15292 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
var statearr_15312_15329 = state_15298__$1;
(statearr_15312_15329[(2)] = inst_15292);

(statearr_15312_15329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (8))){
var inst_15285 = (state_15298[(9)]);
var inst_15288 = cljs.core.deref.call(null,inst_15285);
var state_15298__$1 = state_15298;
var statearr_15313_15330 = state_15298__$1;
(statearr_15313_15330[(2)] = inst_15288);

(statearr_15313_15330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__))
;
return ((function (switch__14236__auto__,c__14375__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15317 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15317[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15317[(1)] = (1));

return statearr_15317;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15298){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15318){if((e15318 instanceof Object)){
var ex__14240__auto__ = e15318;
var statearr_15319_15331 = state_15298;
(statearr_15319_15331[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15318;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15332 = state_15298;
state_15298 = G__15332;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15298){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__))
})();
var state__14377__auto__ = (function (){var statearr_15320 = f__14376__auto__.call(null);
(statearr_15320[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_15320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__))
);

return c__14375__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15333 = [];
var len__7107__auto___15392 = arguments.length;
var i__7108__auto___15393 = (0);
while(true){
if((i__7108__auto___15393 < len__7107__auto___15392)){
args15333.push((arguments[i__7108__auto___15393]));

var G__15394 = (i__7108__auto___15393 + (1));
i__7108__auto___15393 = G__15394;
continue;
} else {
}
break;
}

var G__15335 = args15333.length;
switch (G__15335) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15333.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__){
return (function (state_15362){
var state_val_15363 = (state_15362[(1)]);
if((state_val_15363 === (7))){
var inst_15344 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
var statearr_15365_15396 = state_15362__$1;
(statearr_15365_15396[(2)] = inst_15344);

(statearr_15365_15396[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (1))){
var inst_15338 = cljs.core.seq.call(null,coll);
var inst_15339 = inst_15338;
var state_15362__$1 = (function (){var statearr_15366 = state_15362;
(statearr_15366[(7)] = inst_15339);

return statearr_15366;
})();
var statearr_15367_15397 = state_15362__$1;
(statearr_15367_15397[(2)] = null);

(statearr_15367_15397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (4))){
var inst_15339 = (state_15362[(7)]);
var inst_15342 = cljs.core.first.call(null,inst_15339);
var state_15362__$1 = state_15362;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15362__$1,(7),ch,inst_15342);
} else {
if((state_val_15363 === (13))){
var inst_15356 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
var statearr_15368_15398 = state_15362__$1;
(statearr_15368_15398[(2)] = inst_15356);

(statearr_15368_15398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (6))){
var inst_15347 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
if(cljs.core.truth_(inst_15347)){
var statearr_15369_15399 = state_15362__$1;
(statearr_15369_15399[(1)] = (8));

} else {
var statearr_15370_15400 = state_15362__$1;
(statearr_15370_15400[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (3))){
var inst_15360 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15362__$1,inst_15360);
} else {
if((state_val_15363 === (12))){
var state_15362__$1 = state_15362;
var statearr_15371_15401 = state_15362__$1;
(statearr_15371_15401[(2)] = null);

(statearr_15371_15401[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (2))){
var inst_15339 = (state_15362[(7)]);
var state_15362__$1 = state_15362;
if(cljs.core.truth_(inst_15339)){
var statearr_15374_15402 = state_15362__$1;
(statearr_15374_15402[(1)] = (4));

} else {
var statearr_15375_15403 = state_15362__$1;
(statearr_15375_15403[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (11))){
var inst_15353 = cljs.core.async.close_BANG_.call(null,ch);
var state_15362__$1 = state_15362;
var statearr_15376_15404 = state_15362__$1;
(statearr_15376_15404[(2)] = inst_15353);

(statearr_15376_15404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (9))){
var state_15362__$1 = state_15362;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15378_15405 = state_15362__$1;
(statearr_15378_15405[(1)] = (11));

} else {
var statearr_15380_15406 = state_15362__$1;
(statearr_15380_15406[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (5))){
var inst_15339 = (state_15362[(7)]);
var state_15362__$1 = state_15362;
var statearr_15381_15407 = state_15362__$1;
(statearr_15381_15407[(2)] = inst_15339);

(statearr_15381_15407[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (10))){
var inst_15358 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
var statearr_15382_15408 = state_15362__$1;
(statearr_15382_15408[(2)] = inst_15358);

(statearr_15382_15408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (8))){
var inst_15339 = (state_15362[(7)]);
var inst_15349 = cljs.core.next.call(null,inst_15339);
var inst_15339__$1 = inst_15349;
var state_15362__$1 = (function (){var statearr_15383 = state_15362;
(statearr_15383[(7)] = inst_15339__$1);

return statearr_15383;
})();
var statearr_15384_15415 = state_15362__$1;
(statearr_15384_15415[(2)] = null);

(statearr_15384_15415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__))
;
return ((function (switch__14236__auto__,c__14375__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15388 = [null,null,null,null,null,null,null,null];
(statearr_15388[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15388[(1)] = (1));

return statearr_15388;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15362){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15389){if((e15389 instanceof Object)){
var ex__14240__auto__ = e15389;
var statearr_15390_15416 = state_15362;
(statearr_15390_15416[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15389;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15417 = state_15362;
state_15362 = G__15417;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15362){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__))
})();
var state__14377__auto__ = (function (){var statearr_15391 = f__14376__auto__.call(null);
(statearr_15391[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_15391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__))
);

return c__14375__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15645 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15645 = (function (mult,ch,cs,meta15646){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15646 = meta15646;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15647,meta15646__$1){
var self__ = this;
var _15647__$1 = this;
return (new cljs.core.async.t_cljs$core$async15645(self__.mult,self__.ch,self__.cs,meta15646__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15647){
var self__ = this;
var _15647__$1 = this;
return self__.meta15646;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15646","meta15646",-1559815913,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15645.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15645";

cljs.core.async.t_cljs$core$async15645.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15645");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15645 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15645(mult__$1,ch__$1,cs__$1,meta15646){
return (new cljs.core.async.t_cljs$core$async15645(mult__$1,ch__$1,cs__$1,meta15646));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15645(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14375__auto___15881 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___15881,cs,m,dchan,dctr,done){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___15881,cs,m,dchan,dctr,done){
return (function (state_15782){
var state_val_15783 = (state_15782[(1)]);
if((state_val_15783 === (7))){
var inst_15776 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15784_15882 = state_15782__$1;
(statearr_15784_15882[(2)] = inst_15776);

(statearr_15784_15882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (20))){
var inst_15679 = (state_15782[(7)]);
var inst_15690 = cljs.core.first.call(null,inst_15679);
var inst_15691 = cljs.core.nth.call(null,inst_15690,(0),null);
var inst_15692 = cljs.core.nth.call(null,inst_15690,(1),null);
var state_15782__$1 = (function (){var statearr_15785 = state_15782;
(statearr_15785[(8)] = inst_15691);

return statearr_15785;
})();
if(cljs.core.truth_(inst_15692)){
var statearr_15786_15883 = state_15782__$1;
(statearr_15786_15883[(1)] = (22));

} else {
var statearr_15787_15884 = state_15782__$1;
(statearr_15787_15884[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (27))){
var inst_15721 = (state_15782[(9)]);
var inst_15723 = (state_15782[(10)]);
var inst_15728 = (state_15782[(11)]);
var inst_15650 = (state_15782[(12)]);
var inst_15728__$1 = cljs.core._nth.call(null,inst_15721,inst_15723);
var inst_15729 = cljs.core.async.put_BANG_.call(null,inst_15728__$1,inst_15650,done);
var state_15782__$1 = (function (){var statearr_15788 = state_15782;
(statearr_15788[(11)] = inst_15728__$1);

return statearr_15788;
})();
if(cljs.core.truth_(inst_15729)){
var statearr_15789_15885 = state_15782__$1;
(statearr_15789_15885[(1)] = (30));

} else {
var statearr_15790_15886 = state_15782__$1;
(statearr_15790_15886[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (1))){
var state_15782__$1 = state_15782;
var statearr_15791_15887 = state_15782__$1;
(statearr_15791_15887[(2)] = null);

(statearr_15791_15887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (24))){
var inst_15679 = (state_15782[(7)]);
var inst_15697 = (state_15782[(2)]);
var inst_15699 = cljs.core.next.call(null,inst_15679);
var inst_15659 = inst_15699;
var inst_15660 = null;
var inst_15661 = (0);
var inst_15662 = (0);
var state_15782__$1 = (function (){var statearr_15792 = state_15782;
(statearr_15792[(13)] = inst_15662);

(statearr_15792[(14)] = inst_15660);

(statearr_15792[(15)] = inst_15659);

(statearr_15792[(16)] = inst_15661);

(statearr_15792[(17)] = inst_15697);

return statearr_15792;
})();
var statearr_15793_15888 = state_15782__$1;
(statearr_15793_15888[(2)] = null);

(statearr_15793_15888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (39))){
var state_15782__$1 = state_15782;
var statearr_15797_15889 = state_15782__$1;
(statearr_15797_15889[(2)] = null);

(statearr_15797_15889[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (4))){
var inst_15650 = (state_15782[(12)]);
var inst_15650__$1 = (state_15782[(2)]);
var inst_15651 = (inst_15650__$1 == null);
var state_15782__$1 = (function (){var statearr_15798 = state_15782;
(statearr_15798[(12)] = inst_15650__$1);

return statearr_15798;
})();
if(cljs.core.truth_(inst_15651)){
var statearr_15799_15890 = state_15782__$1;
(statearr_15799_15890[(1)] = (5));

} else {
var statearr_15800_15891 = state_15782__$1;
(statearr_15800_15891[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (15))){
var inst_15662 = (state_15782[(13)]);
var inst_15660 = (state_15782[(14)]);
var inst_15659 = (state_15782[(15)]);
var inst_15661 = (state_15782[(16)]);
var inst_15675 = (state_15782[(2)]);
var inst_15676 = (inst_15662 + (1));
var tmp15794 = inst_15660;
var tmp15795 = inst_15659;
var tmp15796 = inst_15661;
var inst_15659__$1 = tmp15795;
var inst_15660__$1 = tmp15794;
var inst_15661__$1 = tmp15796;
var inst_15662__$1 = inst_15676;
var state_15782__$1 = (function (){var statearr_15801 = state_15782;
(statearr_15801[(13)] = inst_15662__$1);

(statearr_15801[(14)] = inst_15660__$1);

(statearr_15801[(18)] = inst_15675);

(statearr_15801[(15)] = inst_15659__$1);

(statearr_15801[(16)] = inst_15661__$1);

return statearr_15801;
})();
var statearr_15802_15898 = state_15782__$1;
(statearr_15802_15898[(2)] = null);

(statearr_15802_15898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (21))){
var inst_15702 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15806_15899 = state_15782__$1;
(statearr_15806_15899[(2)] = inst_15702);

(statearr_15806_15899[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (31))){
var inst_15728 = (state_15782[(11)]);
var inst_15732 = done.call(null,null);
var inst_15733 = cljs.core.async.untap_STAR_.call(null,m,inst_15728);
var state_15782__$1 = (function (){var statearr_15807 = state_15782;
(statearr_15807[(19)] = inst_15732);

return statearr_15807;
})();
var statearr_15808_15900 = state_15782__$1;
(statearr_15808_15900[(2)] = inst_15733);

(statearr_15808_15900[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (32))){
var inst_15721 = (state_15782[(9)]);
var inst_15723 = (state_15782[(10)]);
var inst_15722 = (state_15782[(20)]);
var inst_15720 = (state_15782[(21)]);
var inst_15735 = (state_15782[(2)]);
var inst_15736 = (inst_15723 + (1));
var tmp15803 = inst_15721;
var tmp15804 = inst_15722;
var tmp15805 = inst_15720;
var inst_15720__$1 = tmp15805;
var inst_15721__$1 = tmp15803;
var inst_15722__$1 = tmp15804;
var inst_15723__$1 = inst_15736;
var state_15782__$1 = (function (){var statearr_15809 = state_15782;
(statearr_15809[(9)] = inst_15721__$1);

(statearr_15809[(10)] = inst_15723__$1);

(statearr_15809[(20)] = inst_15722__$1);

(statearr_15809[(22)] = inst_15735);

(statearr_15809[(21)] = inst_15720__$1);

return statearr_15809;
})();
var statearr_15810_15904 = state_15782__$1;
(statearr_15810_15904[(2)] = null);

(statearr_15810_15904[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (40))){
var inst_15748 = (state_15782[(23)]);
var inst_15752 = done.call(null,null);
var inst_15753 = cljs.core.async.untap_STAR_.call(null,m,inst_15748);
var state_15782__$1 = (function (){var statearr_15811 = state_15782;
(statearr_15811[(24)] = inst_15752);

return statearr_15811;
})();
var statearr_15815_15905 = state_15782__$1;
(statearr_15815_15905[(2)] = inst_15753);

(statearr_15815_15905[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (33))){
var inst_15739 = (state_15782[(25)]);
var inst_15741 = cljs.core.chunked_seq_QMARK_.call(null,inst_15739);
var state_15782__$1 = state_15782;
if(inst_15741){
var statearr_15816_15906 = state_15782__$1;
(statearr_15816_15906[(1)] = (36));

} else {
var statearr_15817_15907 = state_15782__$1;
(statearr_15817_15907[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (13))){
var inst_15669 = (state_15782[(26)]);
var inst_15672 = cljs.core.async.close_BANG_.call(null,inst_15669);
var state_15782__$1 = state_15782;
var statearr_15818_15909 = state_15782__$1;
(statearr_15818_15909[(2)] = inst_15672);

(statearr_15818_15909[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (22))){
var inst_15691 = (state_15782[(8)]);
var inst_15694 = cljs.core.async.close_BANG_.call(null,inst_15691);
var state_15782__$1 = state_15782;
var statearr_15819_15910 = state_15782__$1;
(statearr_15819_15910[(2)] = inst_15694);

(statearr_15819_15910[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (36))){
var inst_15739 = (state_15782[(25)]);
var inst_15743 = cljs.core.chunk_first.call(null,inst_15739);
var inst_15744 = cljs.core.chunk_rest.call(null,inst_15739);
var inst_15745 = cljs.core.count.call(null,inst_15743);
var inst_15720 = inst_15744;
var inst_15721 = inst_15743;
var inst_15722 = inst_15745;
var inst_15723 = (0);
var state_15782__$1 = (function (){var statearr_15820 = state_15782;
(statearr_15820[(9)] = inst_15721);

(statearr_15820[(10)] = inst_15723);

(statearr_15820[(20)] = inst_15722);

(statearr_15820[(21)] = inst_15720);

return statearr_15820;
})();
var statearr_15821_15911 = state_15782__$1;
(statearr_15821_15911[(2)] = null);

(statearr_15821_15911[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (41))){
var inst_15739 = (state_15782[(25)]);
var inst_15755 = (state_15782[(2)]);
var inst_15756 = cljs.core.next.call(null,inst_15739);
var inst_15720 = inst_15756;
var inst_15721 = null;
var inst_15722 = (0);
var inst_15723 = (0);
var state_15782__$1 = (function (){var statearr_15822 = state_15782;
(statearr_15822[(9)] = inst_15721);

(statearr_15822[(10)] = inst_15723);

(statearr_15822[(20)] = inst_15722);

(statearr_15822[(21)] = inst_15720);

(statearr_15822[(27)] = inst_15755);

return statearr_15822;
})();
var statearr_15823_15912 = state_15782__$1;
(statearr_15823_15912[(2)] = null);

(statearr_15823_15912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (43))){
var state_15782__$1 = state_15782;
var statearr_15824_15913 = state_15782__$1;
(statearr_15824_15913[(2)] = null);

(statearr_15824_15913[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (29))){
var inst_15764 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15825_15914 = state_15782__$1;
(statearr_15825_15914[(2)] = inst_15764);

(statearr_15825_15914[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (44))){
var inst_15773 = (state_15782[(2)]);
var state_15782__$1 = (function (){var statearr_15826 = state_15782;
(statearr_15826[(28)] = inst_15773);

return statearr_15826;
})();
var statearr_15827_15915 = state_15782__$1;
(statearr_15827_15915[(2)] = null);

(statearr_15827_15915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (6))){
var inst_15712 = (state_15782[(29)]);
var inst_15711 = cljs.core.deref.call(null,cs);
var inst_15712__$1 = cljs.core.keys.call(null,inst_15711);
var inst_15713 = cljs.core.count.call(null,inst_15712__$1);
var inst_15714 = cljs.core.reset_BANG_.call(null,dctr,inst_15713);
var inst_15719 = cljs.core.seq.call(null,inst_15712__$1);
var inst_15720 = inst_15719;
var inst_15721 = null;
var inst_15722 = (0);
var inst_15723 = (0);
var state_15782__$1 = (function (){var statearr_15828 = state_15782;
(statearr_15828[(9)] = inst_15721);

(statearr_15828[(30)] = inst_15714);

(statearr_15828[(10)] = inst_15723);

(statearr_15828[(20)] = inst_15722);

(statearr_15828[(21)] = inst_15720);

(statearr_15828[(29)] = inst_15712__$1);

return statearr_15828;
})();
var statearr_15829_15916 = state_15782__$1;
(statearr_15829_15916[(2)] = null);

(statearr_15829_15916[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (28))){
var inst_15739 = (state_15782[(25)]);
var inst_15720 = (state_15782[(21)]);
var inst_15739__$1 = cljs.core.seq.call(null,inst_15720);
var state_15782__$1 = (function (){var statearr_15830 = state_15782;
(statearr_15830[(25)] = inst_15739__$1);

return statearr_15830;
})();
if(inst_15739__$1){
var statearr_15834_15917 = state_15782__$1;
(statearr_15834_15917[(1)] = (33));

} else {
var statearr_15835_15918 = state_15782__$1;
(statearr_15835_15918[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (25))){
var inst_15723 = (state_15782[(10)]);
var inst_15722 = (state_15782[(20)]);
var inst_15725 = (inst_15723 < inst_15722);
var inst_15726 = inst_15725;
var state_15782__$1 = state_15782;
if(cljs.core.truth_(inst_15726)){
var statearr_15837_15919 = state_15782__$1;
(statearr_15837_15919[(1)] = (27));

} else {
var statearr_15838_15920 = state_15782__$1;
(statearr_15838_15920[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (34))){
var state_15782__$1 = state_15782;
var statearr_15839_15921 = state_15782__$1;
(statearr_15839_15921[(2)] = null);

(statearr_15839_15921[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (17))){
var state_15782__$1 = state_15782;
var statearr_15840_15922 = state_15782__$1;
(statearr_15840_15922[(2)] = null);

(statearr_15840_15922[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (3))){
var inst_15778 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15782__$1,inst_15778);
} else {
if((state_val_15783 === (12))){
var inst_15707 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15841_15923 = state_15782__$1;
(statearr_15841_15923[(2)] = inst_15707);

(statearr_15841_15923[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (2))){
var state_15782__$1 = state_15782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15782__$1,(4),ch);
} else {
if((state_val_15783 === (23))){
var state_15782__$1 = state_15782;
var statearr_15842_15924 = state_15782__$1;
(statearr_15842_15924[(2)] = null);

(statearr_15842_15924[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (35))){
var inst_15762 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15843_15925 = state_15782__$1;
(statearr_15843_15925[(2)] = inst_15762);

(statearr_15843_15925[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (19))){
var inst_15679 = (state_15782[(7)]);
var inst_15683 = cljs.core.chunk_first.call(null,inst_15679);
var inst_15684 = cljs.core.chunk_rest.call(null,inst_15679);
var inst_15685 = cljs.core.count.call(null,inst_15683);
var inst_15659 = inst_15684;
var inst_15660 = inst_15683;
var inst_15661 = inst_15685;
var inst_15662 = (0);
var state_15782__$1 = (function (){var statearr_15844 = state_15782;
(statearr_15844[(13)] = inst_15662);

(statearr_15844[(14)] = inst_15660);

(statearr_15844[(15)] = inst_15659);

(statearr_15844[(16)] = inst_15661);

return statearr_15844;
})();
var statearr_15845_15926 = state_15782__$1;
(statearr_15845_15926[(2)] = null);

(statearr_15845_15926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (11))){
var inst_15659 = (state_15782[(15)]);
var inst_15679 = (state_15782[(7)]);
var inst_15679__$1 = cljs.core.seq.call(null,inst_15659);
var state_15782__$1 = (function (){var statearr_15846 = state_15782;
(statearr_15846[(7)] = inst_15679__$1);

return statearr_15846;
})();
if(inst_15679__$1){
var statearr_15847_15932 = state_15782__$1;
(statearr_15847_15932[(1)] = (16));

} else {
var statearr_15848_15933 = state_15782__$1;
(statearr_15848_15933[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (9))){
var inst_15709 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15849_15934 = state_15782__$1;
(statearr_15849_15934[(2)] = inst_15709);

(statearr_15849_15934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (5))){
var inst_15657 = cljs.core.deref.call(null,cs);
var inst_15658 = cljs.core.seq.call(null,inst_15657);
var inst_15659 = inst_15658;
var inst_15660 = null;
var inst_15661 = (0);
var inst_15662 = (0);
var state_15782__$1 = (function (){var statearr_15850 = state_15782;
(statearr_15850[(13)] = inst_15662);

(statearr_15850[(14)] = inst_15660);

(statearr_15850[(15)] = inst_15659);

(statearr_15850[(16)] = inst_15661);

return statearr_15850;
})();
var statearr_15851_15936 = state_15782__$1;
(statearr_15851_15936[(2)] = null);

(statearr_15851_15936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (14))){
var state_15782__$1 = state_15782;
var statearr_15852_15937 = state_15782__$1;
(statearr_15852_15937[(2)] = null);

(statearr_15852_15937[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (45))){
var inst_15770 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15853_15941 = state_15782__$1;
(statearr_15853_15941[(2)] = inst_15770);

(statearr_15853_15941[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (26))){
var inst_15712 = (state_15782[(29)]);
var inst_15766 = (state_15782[(2)]);
var inst_15767 = cljs.core.seq.call(null,inst_15712);
var state_15782__$1 = (function (){var statearr_15854 = state_15782;
(statearr_15854[(31)] = inst_15766);

return statearr_15854;
})();
if(inst_15767){
var statearr_15855_15942 = state_15782__$1;
(statearr_15855_15942[(1)] = (42));

} else {
var statearr_15856_15943 = state_15782__$1;
(statearr_15856_15943[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (16))){
var inst_15679 = (state_15782[(7)]);
var inst_15681 = cljs.core.chunked_seq_QMARK_.call(null,inst_15679);
var state_15782__$1 = state_15782;
if(inst_15681){
var statearr_15857_15945 = state_15782__$1;
(statearr_15857_15945[(1)] = (19));

} else {
var statearr_15858_15946 = state_15782__$1;
(statearr_15858_15946[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (38))){
var inst_15759 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15862_15947 = state_15782__$1;
(statearr_15862_15947[(2)] = inst_15759);

(statearr_15862_15947[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (30))){
var state_15782__$1 = state_15782;
var statearr_15863_15948 = state_15782__$1;
(statearr_15863_15948[(2)] = null);

(statearr_15863_15948[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (10))){
var inst_15662 = (state_15782[(13)]);
var inst_15660 = (state_15782[(14)]);
var inst_15668 = cljs.core._nth.call(null,inst_15660,inst_15662);
var inst_15669 = cljs.core.nth.call(null,inst_15668,(0),null);
var inst_15670 = cljs.core.nth.call(null,inst_15668,(1),null);
var state_15782__$1 = (function (){var statearr_15864 = state_15782;
(statearr_15864[(26)] = inst_15669);

return statearr_15864;
})();
if(cljs.core.truth_(inst_15670)){
var statearr_15865_15949 = state_15782__$1;
(statearr_15865_15949[(1)] = (13));

} else {
var statearr_15866_15950 = state_15782__$1;
(statearr_15866_15950[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (18))){
var inst_15705 = (state_15782[(2)]);
var state_15782__$1 = state_15782;
var statearr_15867_15951 = state_15782__$1;
(statearr_15867_15951[(2)] = inst_15705);

(statearr_15867_15951[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (42))){
var state_15782__$1 = state_15782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15782__$1,(45),dchan);
} else {
if((state_val_15783 === (37))){
var inst_15748 = (state_15782[(23)]);
var inst_15739 = (state_15782[(25)]);
var inst_15650 = (state_15782[(12)]);
var inst_15748__$1 = cljs.core.first.call(null,inst_15739);
var inst_15749 = cljs.core.async.put_BANG_.call(null,inst_15748__$1,inst_15650,done);
var state_15782__$1 = (function (){var statearr_15868 = state_15782;
(statearr_15868[(23)] = inst_15748__$1);

return statearr_15868;
})();
if(cljs.core.truth_(inst_15749)){
var statearr_15869_15952 = state_15782__$1;
(statearr_15869_15952[(1)] = (39));

} else {
var statearr_15870_15953 = state_15782__$1;
(statearr_15870_15953[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15783 === (8))){
var inst_15662 = (state_15782[(13)]);
var inst_15661 = (state_15782[(16)]);
var inst_15664 = (inst_15662 < inst_15661);
var inst_15665 = inst_15664;
var state_15782__$1 = state_15782;
if(cljs.core.truth_(inst_15665)){
var statearr_15871_15954 = state_15782__$1;
(statearr_15871_15954[(1)] = (10));

} else {
var statearr_15872_15955 = state_15782__$1;
(statearr_15872_15955[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___15881,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14375__auto___15881,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15876[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15876[(1)] = (1));

return statearr_15876;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15782){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15877){if((e15877 instanceof Object)){
var ex__14240__auto__ = e15877;
var statearr_15878_15956 = state_15782;
(statearr_15878_15956[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15782);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15877;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15957 = state_15782;
state_15782 = G__15957;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15782){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___15881,cs,m,dchan,dctr,done))
})();
var state__14377__auto__ = (function (){var statearr_15879 = f__14376__auto__.call(null);
(statearr_15879[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___15881);

return statearr_15879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___15881,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15959 = [];
var len__7107__auto___15967 = arguments.length;
var i__7108__auto___15968 = (0);
while(true){
if((i__7108__auto___15968 < len__7107__auto___15967)){
args15959.push((arguments[i__7108__auto___15968]));

var G__15970 = (i__7108__auto___15968 + (1));
i__7108__auto___15968 = G__15970;
continue;
} else {
}
break;
}

var G__15963 = args15959.length;
switch (G__15963) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15959.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___16004 = arguments.length;
var i__7108__auto___16005 = (0);
while(true){
if((i__7108__auto___16005 < len__7107__auto___16004)){
args__7114__auto__.push((arguments[i__7108__auto___16005]));

var G__16006 = (i__7108__auto___16005 + (1));
i__7108__auto___16005 = G__16006;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15998){
var map__15999 = p__15998;
var map__15999__$1 = ((((!((map__15999 == null)))?((((map__15999.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15999.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15999):map__15999);
var opts = map__15999__$1;
var statearr_16001_16007 = state;
(statearr_16001_16007[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15999,map__15999__$1,opts){
return (function (val){
var statearr_16002_16008 = state;
(statearr_16002_16008[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15999,map__15999__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_16003_16010 = state;
(statearr_16003_16010[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15991){
var G__15992 = cljs.core.first.call(null,seq15991);
var seq15991__$1 = cljs.core.next.call(null,seq15991);
var G__15993 = cljs.core.first.call(null,seq15991__$1);
var seq15991__$2 = cljs.core.next.call(null,seq15991__$1);
var G__15994 = cljs.core.first.call(null,seq15991__$2);
var seq15991__$3 = cljs.core.next.call(null,seq15991__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15992,G__15993,G__15994,seq15991__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16190 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16190 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16191){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16191 = meta16191;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16192,meta16191__$1){
var self__ = this;
var _16192__$1 = this;
return (new cljs.core.async.t_cljs$core$async16190(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16191__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16192){
var self__ = this;
var _16192__$1 = this;
return self__.meta16191;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16191","meta16191",756028122,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16190.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16190.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16190";

cljs.core.async.t_cljs$core$async16190.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16190");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16190 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16190(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16191){
return (new cljs.core.async.t_cljs$core$async16190(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16191));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16190(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14375__auto___16369 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16291){
var state_val_16292 = (state_16291[(1)]);
if((state_val_16292 === (7))){
var inst_16209 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16293_16370 = state_16291__$1;
(statearr_16293_16370[(2)] = inst_16209);

(statearr_16293_16370[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (20))){
var inst_16221 = (state_16291[(7)]);
var state_16291__$1 = state_16291;
var statearr_16294_16371 = state_16291__$1;
(statearr_16294_16371[(2)] = inst_16221);

(statearr_16294_16371[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (27))){
var state_16291__$1 = state_16291;
var statearr_16295_16372 = state_16291__$1;
(statearr_16295_16372[(2)] = null);

(statearr_16295_16372[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (1))){
var inst_16197 = (state_16291[(8)]);
var inst_16197__$1 = calc_state.call(null);
var inst_16199 = (inst_16197__$1 == null);
var inst_16200 = cljs.core.not.call(null,inst_16199);
var state_16291__$1 = (function (){var statearr_16296 = state_16291;
(statearr_16296[(8)] = inst_16197__$1);

return statearr_16296;
})();
if(inst_16200){
var statearr_16297_16373 = state_16291__$1;
(statearr_16297_16373[(1)] = (2));

} else {
var statearr_16298_16374 = state_16291__$1;
(statearr_16298_16374[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (24))){
var inst_16265 = (state_16291[(9)]);
var inst_16244 = (state_16291[(10)]);
var inst_16251 = (state_16291[(11)]);
var inst_16265__$1 = inst_16244.call(null,inst_16251);
var state_16291__$1 = (function (){var statearr_16299 = state_16291;
(statearr_16299[(9)] = inst_16265__$1);

return statearr_16299;
})();
if(cljs.core.truth_(inst_16265__$1)){
var statearr_16300_16379 = state_16291__$1;
(statearr_16300_16379[(1)] = (29));

} else {
var statearr_16301_16380 = state_16291__$1;
(statearr_16301_16380[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (4))){
var inst_16212 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16212)){
var statearr_16302_16381 = state_16291__$1;
(statearr_16302_16381[(1)] = (8));

} else {
var statearr_16303_16383 = state_16291__$1;
(statearr_16303_16383[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (15))){
var inst_16238 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16238)){
var statearr_16304_16384 = state_16291__$1;
(statearr_16304_16384[(1)] = (19));

} else {
var statearr_16305_16385 = state_16291__$1;
(statearr_16305_16385[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (21))){
var inst_16243 = (state_16291[(12)]);
var inst_16243__$1 = (state_16291[(2)]);
var inst_16244 = cljs.core.get.call(null,inst_16243__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16245 = cljs.core.get.call(null,inst_16243__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16246 = cljs.core.get.call(null,inst_16243__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16291__$1 = (function (){var statearr_16306 = state_16291;
(statearr_16306[(12)] = inst_16243__$1);

(statearr_16306[(10)] = inst_16244);

(statearr_16306[(13)] = inst_16245);

return statearr_16306;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16291__$1,(22),inst_16246);
} else {
if((state_val_16292 === (31))){
var inst_16273 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16273)){
var statearr_16307_16389 = state_16291__$1;
(statearr_16307_16389[(1)] = (32));

} else {
var statearr_16308_16390 = state_16291__$1;
(statearr_16308_16390[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (32))){
var inst_16250 = (state_16291[(14)]);
var state_16291__$1 = state_16291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16291__$1,(35),out,inst_16250);
} else {
if((state_val_16292 === (33))){
var inst_16243 = (state_16291[(12)]);
var inst_16221 = inst_16243;
var state_16291__$1 = (function (){var statearr_16309 = state_16291;
(statearr_16309[(7)] = inst_16221);

return statearr_16309;
})();
var statearr_16310_16391 = state_16291__$1;
(statearr_16310_16391[(2)] = null);

(statearr_16310_16391[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (13))){
var inst_16221 = (state_16291[(7)]);
var inst_16228 = inst_16221.cljs$lang$protocol_mask$partition0$;
var inst_16229 = (inst_16228 & (64));
var inst_16230 = inst_16221.cljs$core$ISeq$;
var inst_16231 = (inst_16229) || (inst_16230);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16231)){
var statearr_16311_16392 = state_16291__$1;
(statearr_16311_16392[(1)] = (16));

} else {
var statearr_16312_16393 = state_16291__$1;
(statearr_16312_16393[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (22))){
var inst_16251 = (state_16291[(11)]);
var inst_16250 = (state_16291[(14)]);
var inst_16249 = (state_16291[(2)]);
var inst_16250__$1 = cljs.core.nth.call(null,inst_16249,(0),null);
var inst_16251__$1 = cljs.core.nth.call(null,inst_16249,(1),null);
var inst_16252 = (inst_16250__$1 == null);
var inst_16253 = cljs.core._EQ_.call(null,inst_16251__$1,change);
var inst_16254 = (inst_16252) || (inst_16253);
var state_16291__$1 = (function (){var statearr_16313 = state_16291;
(statearr_16313[(11)] = inst_16251__$1);

(statearr_16313[(14)] = inst_16250__$1);

return statearr_16313;
})();
if(cljs.core.truth_(inst_16254)){
var statearr_16314_16395 = state_16291__$1;
(statearr_16314_16395[(1)] = (23));

} else {
var statearr_16315_16396 = state_16291__$1;
(statearr_16315_16396[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (36))){
var inst_16243 = (state_16291[(12)]);
var inst_16221 = inst_16243;
var state_16291__$1 = (function (){var statearr_16316 = state_16291;
(statearr_16316[(7)] = inst_16221);

return statearr_16316;
})();
var statearr_16317_16397 = state_16291__$1;
(statearr_16317_16397[(2)] = null);

(statearr_16317_16397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (29))){
var inst_16265 = (state_16291[(9)]);
var state_16291__$1 = state_16291;
var statearr_16318_16398 = state_16291__$1;
(statearr_16318_16398[(2)] = inst_16265);

(statearr_16318_16398[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (6))){
var state_16291__$1 = state_16291;
var statearr_16319_16399 = state_16291__$1;
(statearr_16319_16399[(2)] = false);

(statearr_16319_16399[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (28))){
var inst_16261 = (state_16291[(2)]);
var inst_16262 = calc_state.call(null);
var inst_16221 = inst_16262;
var state_16291__$1 = (function (){var statearr_16320 = state_16291;
(statearr_16320[(15)] = inst_16261);

(statearr_16320[(7)] = inst_16221);

return statearr_16320;
})();
var statearr_16321_16400 = state_16291__$1;
(statearr_16321_16400[(2)] = null);

(statearr_16321_16400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (25))){
var inst_16287 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16322_16401 = state_16291__$1;
(statearr_16322_16401[(2)] = inst_16287);

(statearr_16322_16401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (34))){
var inst_16285 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16323_16402 = state_16291__$1;
(statearr_16323_16402[(2)] = inst_16285);

(statearr_16323_16402[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (17))){
var state_16291__$1 = state_16291;
var statearr_16324_16403 = state_16291__$1;
(statearr_16324_16403[(2)] = false);

(statearr_16324_16403[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (3))){
var state_16291__$1 = state_16291;
var statearr_16325_16404 = state_16291__$1;
(statearr_16325_16404[(2)] = false);

(statearr_16325_16404[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (12))){
var inst_16289 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16291__$1,inst_16289);
} else {
if((state_val_16292 === (2))){
var inst_16197 = (state_16291[(8)]);
var inst_16202 = inst_16197.cljs$lang$protocol_mask$partition0$;
var inst_16203 = (inst_16202 & (64));
var inst_16204 = inst_16197.cljs$core$ISeq$;
var inst_16205 = (inst_16203) || (inst_16204);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16205)){
var statearr_16326_16405 = state_16291__$1;
(statearr_16326_16405[(1)] = (5));

} else {
var statearr_16327_16406 = state_16291__$1;
(statearr_16327_16406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (23))){
var inst_16250 = (state_16291[(14)]);
var inst_16256 = (inst_16250 == null);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16256)){
var statearr_16328_16407 = state_16291__$1;
(statearr_16328_16407[(1)] = (26));

} else {
var statearr_16329_16408 = state_16291__$1;
(statearr_16329_16408[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (35))){
var inst_16276 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16276)){
var statearr_16330_16409 = state_16291__$1;
(statearr_16330_16409[(1)] = (36));

} else {
var statearr_16331_16410 = state_16291__$1;
(statearr_16331_16410[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (19))){
var inst_16221 = (state_16291[(7)]);
var inst_16240 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16221);
var state_16291__$1 = state_16291;
var statearr_16332_16411 = state_16291__$1;
(statearr_16332_16411[(2)] = inst_16240);

(statearr_16332_16411[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (11))){
var inst_16221 = (state_16291[(7)]);
var inst_16225 = (inst_16221 == null);
var inst_16226 = cljs.core.not.call(null,inst_16225);
var state_16291__$1 = state_16291;
if(inst_16226){
var statearr_16333_16412 = state_16291__$1;
(statearr_16333_16412[(1)] = (13));

} else {
var statearr_16334_16413 = state_16291__$1;
(statearr_16334_16413[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (9))){
var inst_16197 = (state_16291[(8)]);
var state_16291__$1 = state_16291;
var statearr_16335_16414 = state_16291__$1;
(statearr_16335_16414[(2)] = inst_16197);

(statearr_16335_16414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (5))){
var state_16291__$1 = state_16291;
var statearr_16336_16415 = state_16291__$1;
(statearr_16336_16415[(2)] = true);

(statearr_16336_16415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (14))){
var state_16291__$1 = state_16291;
var statearr_16337_16416 = state_16291__$1;
(statearr_16337_16416[(2)] = false);

(statearr_16337_16416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (26))){
var inst_16251 = (state_16291[(11)]);
var inst_16258 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16251);
var state_16291__$1 = state_16291;
var statearr_16338_16420 = state_16291__$1;
(statearr_16338_16420[(2)] = inst_16258);

(statearr_16338_16420[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (16))){
var state_16291__$1 = state_16291;
var statearr_16341_16422 = state_16291__$1;
(statearr_16341_16422[(2)] = true);

(statearr_16341_16422[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (38))){
var inst_16281 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16342_16424 = state_16291__$1;
(statearr_16342_16424[(2)] = inst_16281);

(statearr_16342_16424[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (30))){
var inst_16244 = (state_16291[(10)]);
var inst_16245 = (state_16291[(13)]);
var inst_16251 = (state_16291[(11)]);
var inst_16268 = cljs.core.empty_QMARK_.call(null,inst_16244);
var inst_16269 = inst_16245.call(null,inst_16251);
var inst_16270 = cljs.core.not.call(null,inst_16269);
var inst_16271 = (inst_16268) && (inst_16270);
var state_16291__$1 = state_16291;
var statearr_16343_16425 = state_16291__$1;
(statearr_16343_16425[(2)] = inst_16271);

(statearr_16343_16425[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (10))){
var inst_16197 = (state_16291[(8)]);
var inst_16217 = (state_16291[(2)]);
var inst_16218 = cljs.core.get.call(null,inst_16217,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16219 = cljs.core.get.call(null,inst_16217,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16220 = cljs.core.get.call(null,inst_16217,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16221 = inst_16197;
var state_16291__$1 = (function (){var statearr_16344 = state_16291;
(statearr_16344[(16)] = inst_16219);

(statearr_16344[(7)] = inst_16221);

(statearr_16344[(17)] = inst_16220);

(statearr_16344[(18)] = inst_16218);

return statearr_16344;
})();
var statearr_16345_16426 = state_16291__$1;
(statearr_16345_16426[(2)] = null);

(statearr_16345_16426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (18))){
var inst_16235 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16346_16427 = state_16291__$1;
(statearr_16346_16427[(2)] = inst_16235);

(statearr_16346_16427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (37))){
var state_16291__$1 = state_16291;
var statearr_16347_16431 = state_16291__$1;
(statearr_16347_16431[(2)] = null);

(statearr_16347_16431[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16292 === (8))){
var inst_16197 = (state_16291[(8)]);
var inst_16214 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16197);
var state_16291__$1 = state_16291;
var statearr_16348_16436 = state_16291__$1;
(statearr_16348_16436[(2)] = inst_16214);

(statearr_16348_16436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16352 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16352[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16352[(1)] = (1));

return statearr_16352;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16291){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16353){if((e16353 instanceof Object)){
var ex__14240__auto__ = e16353;
var statearr_16354_16437 = state_16291;
(statearr_16354_16437[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16353;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16438 = state_16291;
state_16291 = G__16438;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16291){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14377__auto__ = (function (){var statearr_16355 = f__14376__auto__.call(null);
(statearr_16355[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16369);

return statearr_16355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16369,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16440 = [];
var len__7107__auto___16443 = arguments.length;
var i__7108__auto___16444 = (0);
while(true){
if((i__7108__auto___16444 < len__7107__auto___16443)){
args16440.push((arguments[i__7108__auto___16444]));

var G__16445 = (i__7108__auto___16444 + (1));
i__7108__auto___16444 = G__16445;
continue;
} else {
}
break;
}

var G__16442 = args16440.length;
switch (G__16442) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16440.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16448 = [];
var len__7107__auto___16575 = arguments.length;
var i__7108__auto___16576 = (0);
while(true){
if((i__7108__auto___16576 < len__7107__auto___16575)){
args16448.push((arguments[i__7108__auto___16576]));

var G__16577 = (i__7108__auto___16576 + (1));
i__7108__auto___16576 = G__16577;
continue;
} else {
}
break;
}

var G__16450 = args16448.length;
switch (G__16450) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16448.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16447_SHARP_){
if(cljs.core.truth_(p1__16447_SHARP_.call(null,topic))){
return p1__16447_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16447_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16451 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16451 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16452){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16452 = meta16452;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16453,meta16452__$1){
var self__ = this;
var _16453__$1 = this;
return (new cljs.core.async.t_cljs$core$async16451(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16452__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16453){
var self__ = this;
var _16453__$1 = this;
return self__.meta16452;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16452","meta16452",-150613344,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16451.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16451.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16451";

cljs.core.async.t_cljs$core$async16451.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16451");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16451 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16451(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16452){
return (new cljs.core.async.t_cljs$core$async16451(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16452));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16451(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14375__auto___16598 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16598,mults,ensure_mult,p){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16598,mults,ensure_mult,p){
return (function (state_16525){
var state_val_16526 = (state_16525[(1)]);
if((state_val_16526 === (7))){
var inst_16521 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
var statearr_16527_16601 = state_16525__$1;
(statearr_16527_16601[(2)] = inst_16521);

(statearr_16527_16601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (20))){
var state_16525__$1 = state_16525;
var statearr_16528_16602 = state_16525__$1;
(statearr_16528_16602[(2)] = null);

(statearr_16528_16602[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (1))){
var state_16525__$1 = state_16525;
var statearr_16529_16603 = state_16525__$1;
(statearr_16529_16603[(2)] = null);

(statearr_16529_16603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (24))){
var inst_16504 = (state_16525[(7)]);
var inst_16513 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16504);
var state_16525__$1 = state_16525;
var statearr_16530_16604 = state_16525__$1;
(statearr_16530_16604[(2)] = inst_16513);

(statearr_16530_16604[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (4))){
var inst_16456 = (state_16525[(8)]);
var inst_16456__$1 = (state_16525[(2)]);
var inst_16457 = (inst_16456__$1 == null);
var state_16525__$1 = (function (){var statearr_16531 = state_16525;
(statearr_16531[(8)] = inst_16456__$1);

return statearr_16531;
})();
if(cljs.core.truth_(inst_16457)){
var statearr_16532_16605 = state_16525__$1;
(statearr_16532_16605[(1)] = (5));

} else {
var statearr_16533_16607 = state_16525__$1;
(statearr_16533_16607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (15))){
var inst_16498 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
var statearr_16534_16608 = state_16525__$1;
(statearr_16534_16608[(2)] = inst_16498);

(statearr_16534_16608[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (21))){
var inst_16518 = (state_16525[(2)]);
var state_16525__$1 = (function (){var statearr_16536 = state_16525;
(statearr_16536[(9)] = inst_16518);

return statearr_16536;
})();
var statearr_16537_16609 = state_16525__$1;
(statearr_16537_16609[(2)] = null);

(statearr_16537_16609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (13))){
var inst_16480 = (state_16525[(10)]);
var inst_16482 = cljs.core.chunked_seq_QMARK_.call(null,inst_16480);
var state_16525__$1 = state_16525;
if(inst_16482){
var statearr_16538_16610 = state_16525__$1;
(statearr_16538_16610[(1)] = (16));

} else {
var statearr_16539_16611 = state_16525__$1;
(statearr_16539_16611[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (22))){
var inst_16510 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
if(cljs.core.truth_(inst_16510)){
var statearr_16540_16612 = state_16525__$1;
(statearr_16540_16612[(1)] = (23));

} else {
var statearr_16541_16613 = state_16525__$1;
(statearr_16541_16613[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (6))){
var inst_16504 = (state_16525[(7)]);
var inst_16456 = (state_16525[(8)]);
var inst_16506 = (state_16525[(11)]);
var inst_16504__$1 = topic_fn.call(null,inst_16456);
var inst_16505 = cljs.core.deref.call(null,mults);
var inst_16506__$1 = cljs.core.get.call(null,inst_16505,inst_16504__$1);
var state_16525__$1 = (function (){var statearr_16542 = state_16525;
(statearr_16542[(7)] = inst_16504__$1);

(statearr_16542[(11)] = inst_16506__$1);

return statearr_16542;
})();
if(cljs.core.truth_(inst_16506__$1)){
var statearr_16543_16614 = state_16525__$1;
(statearr_16543_16614[(1)] = (19));

} else {
var statearr_16544_16615 = state_16525__$1;
(statearr_16544_16615[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (25))){
var inst_16515 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
var statearr_16545_16616 = state_16525__$1;
(statearr_16545_16616[(2)] = inst_16515);

(statearr_16545_16616[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (17))){
var inst_16480 = (state_16525[(10)]);
var inst_16489 = cljs.core.first.call(null,inst_16480);
var inst_16490 = cljs.core.async.muxch_STAR_.call(null,inst_16489);
var inst_16491 = cljs.core.async.close_BANG_.call(null,inst_16490);
var inst_16492 = cljs.core.next.call(null,inst_16480);
var inst_16466 = inst_16492;
var inst_16467 = null;
var inst_16468 = (0);
var inst_16469 = (0);
var state_16525__$1 = (function (){var statearr_16546 = state_16525;
(statearr_16546[(12)] = inst_16491);

(statearr_16546[(13)] = inst_16469);

(statearr_16546[(14)] = inst_16466);

(statearr_16546[(15)] = inst_16467);

(statearr_16546[(16)] = inst_16468);

return statearr_16546;
})();
var statearr_16547_16617 = state_16525__$1;
(statearr_16547_16617[(2)] = null);

(statearr_16547_16617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (3))){
var inst_16523 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16525__$1,inst_16523);
} else {
if((state_val_16526 === (12))){
var inst_16500 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
var statearr_16548_16618 = state_16525__$1;
(statearr_16548_16618[(2)] = inst_16500);

(statearr_16548_16618[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (2))){
var state_16525__$1 = state_16525;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16525__$1,(4),ch);
} else {
if((state_val_16526 === (23))){
var state_16525__$1 = state_16525;
var statearr_16549_16619 = state_16525__$1;
(statearr_16549_16619[(2)] = null);

(statearr_16549_16619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (19))){
var inst_16456 = (state_16525[(8)]);
var inst_16506 = (state_16525[(11)]);
var inst_16508 = cljs.core.async.muxch_STAR_.call(null,inst_16506);
var state_16525__$1 = state_16525;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16525__$1,(22),inst_16508,inst_16456);
} else {
if((state_val_16526 === (11))){
var inst_16466 = (state_16525[(14)]);
var inst_16480 = (state_16525[(10)]);
var inst_16480__$1 = cljs.core.seq.call(null,inst_16466);
var state_16525__$1 = (function (){var statearr_16550 = state_16525;
(statearr_16550[(10)] = inst_16480__$1);

return statearr_16550;
})();
if(inst_16480__$1){
var statearr_16551_16620 = state_16525__$1;
(statearr_16551_16620[(1)] = (13));

} else {
var statearr_16552_16621 = state_16525__$1;
(statearr_16552_16621[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (9))){
var inst_16502 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
var statearr_16553_16622 = state_16525__$1;
(statearr_16553_16622[(2)] = inst_16502);

(statearr_16553_16622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (5))){
var inst_16463 = cljs.core.deref.call(null,mults);
var inst_16464 = cljs.core.vals.call(null,inst_16463);
var inst_16465 = cljs.core.seq.call(null,inst_16464);
var inst_16466 = inst_16465;
var inst_16467 = null;
var inst_16468 = (0);
var inst_16469 = (0);
var state_16525__$1 = (function (){var statearr_16555 = state_16525;
(statearr_16555[(13)] = inst_16469);

(statearr_16555[(14)] = inst_16466);

(statearr_16555[(15)] = inst_16467);

(statearr_16555[(16)] = inst_16468);

return statearr_16555;
})();
var statearr_16556_16623 = state_16525__$1;
(statearr_16556_16623[(2)] = null);

(statearr_16556_16623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (14))){
var state_16525__$1 = state_16525;
var statearr_16560_16624 = state_16525__$1;
(statearr_16560_16624[(2)] = null);

(statearr_16560_16624[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (16))){
var inst_16480 = (state_16525[(10)]);
var inst_16484 = cljs.core.chunk_first.call(null,inst_16480);
var inst_16485 = cljs.core.chunk_rest.call(null,inst_16480);
var inst_16486 = cljs.core.count.call(null,inst_16484);
var inst_16466 = inst_16485;
var inst_16467 = inst_16484;
var inst_16468 = inst_16486;
var inst_16469 = (0);
var state_16525__$1 = (function (){var statearr_16561 = state_16525;
(statearr_16561[(13)] = inst_16469);

(statearr_16561[(14)] = inst_16466);

(statearr_16561[(15)] = inst_16467);

(statearr_16561[(16)] = inst_16468);

return statearr_16561;
})();
var statearr_16562_16625 = state_16525__$1;
(statearr_16562_16625[(2)] = null);

(statearr_16562_16625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (10))){
var inst_16469 = (state_16525[(13)]);
var inst_16466 = (state_16525[(14)]);
var inst_16467 = (state_16525[(15)]);
var inst_16468 = (state_16525[(16)]);
var inst_16474 = cljs.core._nth.call(null,inst_16467,inst_16469);
var inst_16475 = cljs.core.async.muxch_STAR_.call(null,inst_16474);
var inst_16476 = cljs.core.async.close_BANG_.call(null,inst_16475);
var inst_16477 = (inst_16469 + (1));
var tmp16557 = inst_16466;
var tmp16558 = inst_16467;
var tmp16559 = inst_16468;
var inst_16466__$1 = tmp16557;
var inst_16467__$1 = tmp16558;
var inst_16468__$1 = tmp16559;
var inst_16469__$1 = inst_16477;
var state_16525__$1 = (function (){var statearr_16563 = state_16525;
(statearr_16563[(17)] = inst_16476);

(statearr_16563[(13)] = inst_16469__$1);

(statearr_16563[(14)] = inst_16466__$1);

(statearr_16563[(15)] = inst_16467__$1);

(statearr_16563[(16)] = inst_16468__$1);

return statearr_16563;
})();
var statearr_16564_16627 = state_16525__$1;
(statearr_16564_16627[(2)] = null);

(statearr_16564_16627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (18))){
var inst_16495 = (state_16525[(2)]);
var state_16525__$1 = state_16525;
var statearr_16565_16628 = state_16525__$1;
(statearr_16565_16628[(2)] = inst_16495);

(statearr_16565_16628[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16526 === (8))){
var inst_16469 = (state_16525[(13)]);
var inst_16468 = (state_16525[(16)]);
var inst_16471 = (inst_16469 < inst_16468);
var inst_16472 = inst_16471;
var state_16525__$1 = state_16525;
if(cljs.core.truth_(inst_16472)){
var statearr_16566_16629 = state_16525__$1;
(statearr_16566_16629[(1)] = (10));

} else {
var statearr_16567_16630 = state_16525__$1;
(statearr_16567_16630[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16598,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14375__auto___16598,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16571 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16571[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16571[(1)] = (1));

return statearr_16571;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16525){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16525);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16572){if((e16572 instanceof Object)){
var ex__14240__auto__ = e16572;
var statearr_16573_16631 = state_16525;
(statearr_16573_16631[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16525);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16572;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16632 = state_16525;
state_16525 = G__16632;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16525){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16598,mults,ensure_mult,p))
})();
var state__14377__auto__ = (function (){var statearr_16574 = f__14376__auto__.call(null);
(statearr_16574[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16598);

return statearr_16574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16598,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16634 = [];
var len__7107__auto___16648 = arguments.length;
var i__7108__auto___16649 = (0);
while(true){
if((i__7108__auto___16649 < len__7107__auto___16648)){
args16634.push((arguments[i__7108__auto___16649]));

var G__16650 = (i__7108__auto___16649 + (1));
i__7108__auto___16649 = G__16650;
continue;
} else {
}
break;
}

var G__16647 = args16634.length;
switch (G__16647) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16634.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16652 = [];
var len__7107__auto___16656 = arguments.length;
var i__7108__auto___16657 = (0);
while(true){
if((i__7108__auto___16657 < len__7107__auto___16656)){
args16652.push((arguments[i__7108__auto___16657]));

var G__16658 = (i__7108__auto___16657 + (1));
i__7108__auto___16657 = G__16658;
continue;
} else {
}
break;
}

var G__16654 = args16652.length;
switch (G__16654) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16652.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16660 = [];
var len__7107__auto___16741 = arguments.length;
var i__7108__auto___16743 = (0);
while(true){
if((i__7108__auto___16743 < len__7107__auto___16741)){
args16660.push((arguments[i__7108__auto___16743]));

var G__16745 = (i__7108__auto___16743 + (1));
i__7108__auto___16743 = G__16745;
continue;
} else {
}
break;
}

var G__16662 = args16660.length;
switch (G__16662) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16660.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14375__auto___16751 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16751,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16751,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16701){
var state_val_16702 = (state_16701[(1)]);
if((state_val_16702 === (7))){
var state_16701__$1 = state_16701;
var statearr_16703_16754 = state_16701__$1;
(statearr_16703_16754[(2)] = null);

(statearr_16703_16754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (1))){
var state_16701__$1 = state_16701;
var statearr_16704_16755 = state_16701__$1;
(statearr_16704_16755[(2)] = null);

(statearr_16704_16755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (4))){
var inst_16665 = (state_16701[(7)]);
var inst_16667 = (inst_16665 < cnt);
var state_16701__$1 = state_16701;
if(inst_16667){
var statearr_16705_16763 = state_16701__$1;
(statearr_16705_16763[(1)] = (6));

} else {
var statearr_16706_16764 = state_16701__$1;
(statearr_16706_16764[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (15))){
var inst_16697 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
var statearr_16707_16765 = state_16701__$1;
(statearr_16707_16765[(2)] = inst_16697);

(statearr_16707_16765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (13))){
var inst_16690 = cljs.core.async.close_BANG_.call(null,out);
var state_16701__$1 = state_16701;
var statearr_16708_16766 = state_16701__$1;
(statearr_16708_16766[(2)] = inst_16690);

(statearr_16708_16766[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (6))){
var state_16701__$1 = state_16701;
var statearr_16709_16767 = state_16701__$1;
(statearr_16709_16767[(2)] = null);

(statearr_16709_16767[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (3))){
var inst_16699 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16701__$1,inst_16699);
} else {
if((state_val_16702 === (12))){
var inst_16687 = (state_16701[(8)]);
var inst_16687__$1 = (state_16701[(2)]);
var inst_16688 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16687__$1);
var state_16701__$1 = (function (){var statearr_16710 = state_16701;
(statearr_16710[(8)] = inst_16687__$1);

return statearr_16710;
})();
if(cljs.core.truth_(inst_16688)){
var statearr_16711_16768 = state_16701__$1;
(statearr_16711_16768[(1)] = (13));

} else {
var statearr_16712_16769 = state_16701__$1;
(statearr_16712_16769[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (2))){
var inst_16664 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16665 = (0);
var state_16701__$1 = (function (){var statearr_16713 = state_16701;
(statearr_16713[(7)] = inst_16665);

(statearr_16713[(9)] = inst_16664);

return statearr_16713;
})();
var statearr_16714_16771 = state_16701__$1;
(statearr_16714_16771[(2)] = null);

(statearr_16714_16771[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (11))){
var inst_16665 = (state_16701[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16701,(10),Object,null,(9));
var inst_16674 = chs__$1.call(null,inst_16665);
var inst_16675 = done.call(null,inst_16665);
var inst_16676 = cljs.core.async.take_BANG_.call(null,inst_16674,inst_16675);
var state_16701__$1 = state_16701;
var statearr_16715_16772 = state_16701__$1;
(statearr_16715_16772[(2)] = inst_16676);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16701__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (9))){
var inst_16665 = (state_16701[(7)]);
var inst_16678 = (state_16701[(2)]);
var inst_16679 = (inst_16665 + (1));
var inst_16665__$1 = inst_16679;
var state_16701__$1 = (function (){var statearr_16716 = state_16701;
(statearr_16716[(7)] = inst_16665__$1);

(statearr_16716[(10)] = inst_16678);

return statearr_16716;
})();
var statearr_16717_16773 = state_16701__$1;
(statearr_16717_16773[(2)] = null);

(statearr_16717_16773[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (5))){
var inst_16685 = (state_16701[(2)]);
var state_16701__$1 = (function (){var statearr_16718 = state_16701;
(statearr_16718[(11)] = inst_16685);

return statearr_16718;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16701__$1,(12),dchan);
} else {
if((state_val_16702 === (14))){
var inst_16687 = (state_16701[(8)]);
var inst_16692 = cljs.core.apply.call(null,f,inst_16687);
var state_16701__$1 = state_16701;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16701__$1,(16),out,inst_16692);
} else {
if((state_val_16702 === (16))){
var inst_16694 = (state_16701[(2)]);
var state_16701__$1 = (function (){var statearr_16719 = state_16701;
(statearr_16719[(12)] = inst_16694);

return statearr_16719;
})();
var statearr_16720_16774 = state_16701__$1;
(statearr_16720_16774[(2)] = null);

(statearr_16720_16774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (10))){
var inst_16669 = (state_16701[(2)]);
var inst_16670 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16701__$1 = (function (){var statearr_16721 = state_16701;
(statearr_16721[(13)] = inst_16669);

return statearr_16721;
})();
var statearr_16722_16775 = state_16701__$1;
(statearr_16722_16775[(2)] = inst_16670);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16701__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (8))){
var inst_16683 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
var statearr_16723_16776 = state_16701__$1;
(statearr_16723_16776[(2)] = inst_16683);

(statearr_16723_16776[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16751,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14375__auto___16751,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16735 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16735[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16735[(1)] = (1));

return statearr_16735;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16701){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16736){if((e16736 instanceof Object)){
var ex__14240__auto__ = e16736;
var statearr_16737_16777 = state_16701;
(statearr_16737_16777[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16701);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16736;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16778 = state_16701;
state_16701 = G__16778;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16701){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16751,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14377__auto__ = (function (){var statearr_16740 = f__14376__auto__.call(null);
(statearr_16740[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16751);

return statearr_16740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16751,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16780 = [];
var len__7107__auto___16841 = arguments.length;
var i__7108__auto___16842 = (0);
while(true){
if((i__7108__auto___16842 < len__7107__auto___16841)){
args16780.push((arguments[i__7108__auto___16842]));

var G__16846 = (i__7108__auto___16842 + (1));
i__7108__auto___16842 = G__16846;
continue;
} else {
}
break;
}

var G__16782 = args16780.length;
switch (G__16782) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16780.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___16849 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16849,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16849,out){
return (function (state_16813){
var state_val_16814 = (state_16813[(1)]);
if((state_val_16814 === (7))){
var inst_16792 = (state_16813[(7)]);
var inst_16791 = (state_16813[(8)]);
var inst_16791__$1 = (state_16813[(2)]);
var inst_16792__$1 = cljs.core.nth.call(null,inst_16791__$1,(0),null);
var inst_16793 = cljs.core.nth.call(null,inst_16791__$1,(1),null);
var inst_16794 = (inst_16792__$1 == null);
var state_16813__$1 = (function (){var statearr_16815 = state_16813;
(statearr_16815[(9)] = inst_16793);

(statearr_16815[(7)] = inst_16792__$1);

(statearr_16815[(8)] = inst_16791__$1);

return statearr_16815;
})();
if(cljs.core.truth_(inst_16794)){
var statearr_16816_16851 = state_16813__$1;
(statearr_16816_16851[(1)] = (8));

} else {
var statearr_16817_16852 = state_16813__$1;
(statearr_16817_16852[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (1))){
var inst_16783 = cljs.core.vec.call(null,chs);
var inst_16784 = inst_16783;
var state_16813__$1 = (function (){var statearr_16818 = state_16813;
(statearr_16818[(10)] = inst_16784);

return statearr_16818;
})();
var statearr_16819_16853 = state_16813__$1;
(statearr_16819_16853[(2)] = null);

(statearr_16819_16853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (4))){
var inst_16784 = (state_16813[(10)]);
var state_16813__$1 = state_16813;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16813__$1,(7),inst_16784);
} else {
if((state_val_16814 === (6))){
var inst_16808 = (state_16813[(2)]);
var state_16813__$1 = state_16813;
var statearr_16820_16854 = state_16813__$1;
(statearr_16820_16854[(2)] = inst_16808);

(statearr_16820_16854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (3))){
var inst_16810 = (state_16813[(2)]);
var state_16813__$1 = state_16813;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16813__$1,inst_16810);
} else {
if((state_val_16814 === (2))){
var inst_16784 = (state_16813[(10)]);
var inst_16786 = cljs.core.count.call(null,inst_16784);
var inst_16787 = (inst_16786 > (0));
var state_16813__$1 = state_16813;
if(cljs.core.truth_(inst_16787)){
var statearr_16822_16855 = state_16813__$1;
(statearr_16822_16855[(1)] = (4));

} else {
var statearr_16823_16856 = state_16813__$1;
(statearr_16823_16856[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (11))){
var inst_16784 = (state_16813[(10)]);
var inst_16801 = (state_16813[(2)]);
var tmp16821 = inst_16784;
var inst_16784__$1 = tmp16821;
var state_16813__$1 = (function (){var statearr_16824 = state_16813;
(statearr_16824[(10)] = inst_16784__$1);

(statearr_16824[(11)] = inst_16801);

return statearr_16824;
})();
var statearr_16825_16857 = state_16813__$1;
(statearr_16825_16857[(2)] = null);

(statearr_16825_16857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (9))){
var inst_16792 = (state_16813[(7)]);
var state_16813__$1 = state_16813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16813__$1,(11),out,inst_16792);
} else {
if((state_val_16814 === (5))){
var inst_16806 = cljs.core.async.close_BANG_.call(null,out);
var state_16813__$1 = state_16813;
var statearr_16826_16861 = state_16813__$1;
(statearr_16826_16861[(2)] = inst_16806);

(statearr_16826_16861[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (10))){
var inst_16804 = (state_16813[(2)]);
var state_16813__$1 = state_16813;
var statearr_16827_16862 = state_16813__$1;
(statearr_16827_16862[(2)] = inst_16804);

(statearr_16827_16862[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (8))){
var inst_16793 = (state_16813[(9)]);
var inst_16792 = (state_16813[(7)]);
var inst_16791 = (state_16813[(8)]);
var inst_16784 = (state_16813[(10)]);
var inst_16796 = (function (){var cs = inst_16784;
var vec__16789 = inst_16791;
var v = inst_16792;
var c = inst_16793;
return ((function (cs,vec__16789,v,c,inst_16793,inst_16792,inst_16791,inst_16784,state_val_16814,c__14375__auto___16849,out){
return (function (p1__16779_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16779_SHARP_);
});
;})(cs,vec__16789,v,c,inst_16793,inst_16792,inst_16791,inst_16784,state_val_16814,c__14375__auto___16849,out))
})();
var inst_16797 = cljs.core.filterv.call(null,inst_16796,inst_16784);
var inst_16784__$1 = inst_16797;
var state_16813__$1 = (function (){var statearr_16828 = state_16813;
(statearr_16828[(10)] = inst_16784__$1);

return statearr_16828;
})();
var statearr_16830_16863 = state_16813__$1;
(statearr_16830_16863[(2)] = null);

(statearr_16830_16863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16849,out))
;
return ((function (switch__14236__auto__,c__14375__auto___16849,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16837 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16837[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16837[(1)] = (1));

return statearr_16837;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16813){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16838){if((e16838 instanceof Object)){
var ex__14240__auto__ = e16838;
var statearr_16839_16864 = state_16813;
(statearr_16839_16864[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16813);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16866 = state_16813;
state_16813 = G__16866;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16813){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16849,out))
})();
var state__14377__auto__ = (function (){var statearr_16840 = f__14376__auto__.call(null);
(statearr_16840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16849);

return statearr_16840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16849,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16867 = [];
var len__7107__auto___16916 = arguments.length;
var i__7108__auto___16917 = (0);
while(true){
if((i__7108__auto___16917 < len__7107__auto___16916)){
args16867.push((arguments[i__7108__auto___16917]));

var G__16918 = (i__7108__auto___16917 + (1));
i__7108__auto___16917 = G__16918;
continue;
} else {
}
break;
}

var G__16869 = args16867.length;
switch (G__16869) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16867.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___16920 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___16920,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___16920,out){
return (function (state_16893){
var state_val_16894 = (state_16893[(1)]);
if((state_val_16894 === (7))){
var inst_16875 = (state_16893[(7)]);
var inst_16875__$1 = (state_16893[(2)]);
var inst_16876 = (inst_16875__$1 == null);
var inst_16877 = cljs.core.not.call(null,inst_16876);
var state_16893__$1 = (function (){var statearr_16895 = state_16893;
(statearr_16895[(7)] = inst_16875__$1);

return statearr_16895;
})();
if(inst_16877){
var statearr_16896_16921 = state_16893__$1;
(statearr_16896_16921[(1)] = (8));

} else {
var statearr_16897_16922 = state_16893__$1;
(statearr_16897_16922[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (1))){
var inst_16870 = (0);
var state_16893__$1 = (function (){var statearr_16898 = state_16893;
(statearr_16898[(8)] = inst_16870);

return statearr_16898;
})();
var statearr_16899_16923 = state_16893__$1;
(statearr_16899_16923[(2)] = null);

(statearr_16899_16923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (4))){
var state_16893__$1 = state_16893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16893__$1,(7),ch);
} else {
if((state_val_16894 === (6))){
var inst_16888 = (state_16893[(2)]);
var state_16893__$1 = state_16893;
var statearr_16900_16924 = state_16893__$1;
(statearr_16900_16924[(2)] = inst_16888);

(statearr_16900_16924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (3))){
var inst_16890 = (state_16893[(2)]);
var inst_16891 = cljs.core.async.close_BANG_.call(null,out);
var state_16893__$1 = (function (){var statearr_16901 = state_16893;
(statearr_16901[(9)] = inst_16890);

return statearr_16901;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16893__$1,inst_16891);
} else {
if((state_val_16894 === (2))){
var inst_16870 = (state_16893[(8)]);
var inst_16872 = (inst_16870 < n);
var state_16893__$1 = state_16893;
if(cljs.core.truth_(inst_16872)){
var statearr_16902_16925 = state_16893__$1;
(statearr_16902_16925[(1)] = (4));

} else {
var statearr_16903_16926 = state_16893__$1;
(statearr_16903_16926[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (11))){
var inst_16870 = (state_16893[(8)]);
var inst_16880 = (state_16893[(2)]);
var inst_16881 = (inst_16870 + (1));
var inst_16870__$1 = inst_16881;
var state_16893__$1 = (function (){var statearr_16904 = state_16893;
(statearr_16904[(8)] = inst_16870__$1);

(statearr_16904[(10)] = inst_16880);

return statearr_16904;
})();
var statearr_16905_16928 = state_16893__$1;
(statearr_16905_16928[(2)] = null);

(statearr_16905_16928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (9))){
var state_16893__$1 = state_16893;
var statearr_16906_16930 = state_16893__$1;
(statearr_16906_16930[(2)] = null);

(statearr_16906_16930[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (5))){
var state_16893__$1 = state_16893;
var statearr_16907_16931 = state_16893__$1;
(statearr_16907_16931[(2)] = null);

(statearr_16907_16931[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (10))){
var inst_16885 = (state_16893[(2)]);
var state_16893__$1 = state_16893;
var statearr_16908_16933 = state_16893__$1;
(statearr_16908_16933[(2)] = inst_16885);

(statearr_16908_16933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16894 === (8))){
var inst_16875 = (state_16893[(7)]);
var state_16893__$1 = state_16893;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16893__$1,(11),out,inst_16875);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___16920,out))
;
return ((function (switch__14236__auto__,c__14375__auto___16920,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16912 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16912[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16912[(1)] = (1));

return statearr_16912;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16893){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16913){if((e16913 instanceof Object)){
var ex__14240__auto__ = e16913;
var statearr_16914_16938 = state_16893;
(statearr_16914_16938[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16893);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16913;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16939 = state_16893;
state_16893 = G__16939;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16893){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___16920,out))
})();
var state__14377__auto__ = (function (){var statearr_16915 = f__14376__auto__.call(null);
(statearr_16915[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___16920);

return statearr_16915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___16920,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16955 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16955 = (function (map_LT_,f,ch,meta16956){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16956 = meta16956;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16957,meta16956__$1){
var self__ = this;
var _16957__$1 = this;
return (new cljs.core.async.t_cljs$core$async16955(self__.map_LT_,self__.f,self__.ch,meta16956__$1));
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16957){
var self__ = this;
var _16957__$1 = this;
return self__.meta16956;
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16958 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16958 = (function (map_LT_,f,ch,meta16956,_,fn1,meta16959){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16956 = meta16956;
this._ = _;
this.fn1 = fn1;
this.meta16959 = meta16959;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16958.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16960,meta16959__$1){
var self__ = this;
var _16960__$1 = this;
return (new cljs.core.async.t_cljs$core$async16958(self__.map_LT_,self__.f,self__.ch,self__.meta16956,self__._,self__.fn1,meta16959__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16958.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16960){
var self__ = this;
var _16960__$1 = this;
return self__.meta16959;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16958.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16958.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16958.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16958.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16943_SHARP_){
return f1.call(null,(((p1__16943_SHARP_ == null))?null:self__.f.call(null,p1__16943_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16958.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16956","meta16956",1592207441,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16955","cljs.core.async/t_cljs$core$async16955",-1091858680,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16959","meta16959",501433838,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16958.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16958.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16958";

cljs.core.async.t_cljs$core$async16958.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16958");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16958 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16958(map_LT___$1,f__$1,ch__$1,meta16956__$1,___$2,fn1__$1,meta16959){
return (new cljs.core.async.t_cljs$core$async16958(map_LT___$1,f__$1,ch__$1,meta16956__$1,___$2,fn1__$1,meta16959));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16958(self__.map_LT_,self__.f,self__.ch,self__.meta16956,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16955.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16956","meta16956",1592207441,null)], null);
});

cljs.core.async.t_cljs$core$async16955.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16955.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16955";

cljs.core.async.t_cljs$core$async16955.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16955");
});

cljs.core.async.__GT_t_cljs$core$async16955 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16955(map_LT___$1,f__$1,ch__$1,meta16956){
return (new cljs.core.async.t_cljs$core$async16955(map_LT___$1,f__$1,ch__$1,meta16956));
});

}

return (new cljs.core.async.t_cljs$core$async16955(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16969 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16969 = (function (map_GT_,f,ch,meta16970){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16970 = meta16970;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16971,meta16970__$1){
var self__ = this;
var _16971__$1 = this;
return (new cljs.core.async.t_cljs$core$async16969(self__.map_GT_,self__.f,self__.ch,meta16970__$1));
});

cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16971){
var self__ = this;
var _16971__$1 = this;
return self__.meta16970;
});

cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16969.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16969.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16970","meta16970",1408418862,null)], null);
});

cljs.core.async.t_cljs$core$async16969.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16969.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16969";

cljs.core.async.t_cljs$core$async16969.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16969");
});

cljs.core.async.__GT_t_cljs$core$async16969 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16969(map_GT___$1,f__$1,ch__$1,meta16970){
return (new cljs.core.async.t_cljs$core$async16969(map_GT___$1,f__$1,ch__$1,meta16970));
});

}

return (new cljs.core.async.t_cljs$core$async16969(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16986 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16986 = (function (filter_GT_,p,ch,meta16987){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16987 = meta16987;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16988,meta16987__$1){
var self__ = this;
var _16988__$1 = this;
return (new cljs.core.async.t_cljs$core$async16986(self__.filter_GT_,self__.p,self__.ch,meta16987__$1));
});

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16988){
var self__ = this;
var _16988__$1 = this;
return self__.meta16987;
});

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16986.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16986.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16987","meta16987",1874359773,null)], null);
});

cljs.core.async.t_cljs$core$async16986.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16986.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16986";

cljs.core.async.t_cljs$core$async16986.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16986");
});

cljs.core.async.__GT_t_cljs$core$async16986 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16986(filter_GT___$1,p__$1,ch__$1,meta16987){
return (new cljs.core.async.t_cljs$core$async16986(filter_GT___$1,p__$1,ch__$1,meta16987));
});

}

return (new cljs.core.async.t_cljs$core$async16986(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16990 = [];
var len__7107__auto___17038 = arguments.length;
var i__7108__auto___17039 = (0);
while(true){
if((i__7108__auto___17039 < len__7107__auto___17038)){
args16990.push((arguments[i__7108__auto___17039]));

var G__17040 = (i__7108__auto___17039 + (1));
i__7108__auto___17039 = G__17040;
continue;
} else {
}
break;
}

var G__16992 = args16990.length;
switch (G__16992) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16990.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17045 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17045,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17045,out){
return (function (state_17013){
var state_val_17014 = (state_17013[(1)]);
if((state_val_17014 === (7))){
var inst_17009 = (state_17013[(2)]);
var state_17013__$1 = state_17013;
var statearr_17015_17047 = state_17013__$1;
(statearr_17015_17047[(2)] = inst_17009);

(statearr_17015_17047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (1))){
var state_17013__$1 = state_17013;
var statearr_17016_17048 = state_17013__$1;
(statearr_17016_17048[(2)] = null);

(statearr_17016_17048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (4))){
var inst_16995 = (state_17013[(7)]);
var inst_16995__$1 = (state_17013[(2)]);
var inst_16996 = (inst_16995__$1 == null);
var state_17013__$1 = (function (){var statearr_17017 = state_17013;
(statearr_17017[(7)] = inst_16995__$1);

return statearr_17017;
})();
if(cljs.core.truth_(inst_16996)){
var statearr_17018_17049 = state_17013__$1;
(statearr_17018_17049[(1)] = (5));

} else {
var statearr_17019_17050 = state_17013__$1;
(statearr_17019_17050[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (6))){
var inst_16995 = (state_17013[(7)]);
var inst_17000 = p.call(null,inst_16995);
var state_17013__$1 = state_17013;
if(cljs.core.truth_(inst_17000)){
var statearr_17020_17054 = state_17013__$1;
(statearr_17020_17054[(1)] = (8));

} else {
var statearr_17021_17055 = state_17013__$1;
(statearr_17021_17055[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (3))){
var inst_17011 = (state_17013[(2)]);
var state_17013__$1 = state_17013;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17013__$1,inst_17011);
} else {
if((state_val_17014 === (2))){
var state_17013__$1 = state_17013;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17013__$1,(4),ch);
} else {
if((state_val_17014 === (11))){
var inst_17003 = (state_17013[(2)]);
var state_17013__$1 = state_17013;
var statearr_17022_17056 = state_17013__$1;
(statearr_17022_17056[(2)] = inst_17003);

(statearr_17022_17056[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (9))){
var state_17013__$1 = state_17013;
var statearr_17023_17057 = state_17013__$1;
(statearr_17023_17057[(2)] = null);

(statearr_17023_17057[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (5))){
var inst_16998 = cljs.core.async.close_BANG_.call(null,out);
var state_17013__$1 = state_17013;
var statearr_17024_17058 = state_17013__$1;
(statearr_17024_17058[(2)] = inst_16998);

(statearr_17024_17058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (10))){
var inst_17006 = (state_17013[(2)]);
var state_17013__$1 = (function (){var statearr_17025 = state_17013;
(statearr_17025[(8)] = inst_17006);

return statearr_17025;
})();
var statearr_17027_17059 = state_17013__$1;
(statearr_17027_17059[(2)] = null);

(statearr_17027_17059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17014 === (8))){
var inst_16995 = (state_17013[(7)]);
var state_17013__$1 = state_17013;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17013__$1,(11),out,inst_16995);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17045,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17045,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17032 = [null,null,null,null,null,null,null,null,null];
(statearr_17032[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17032[(1)] = (1));

return statearr_17032;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17013){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17013);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17033){if((e17033 instanceof Object)){
var ex__14240__auto__ = e17033;
var statearr_17034_17061 = state_17013;
(statearr_17034_17061[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17013);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17062 = state_17013;
state_17013 = G__17062;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17045,out))
})();
var state__14377__auto__ = (function (){var statearr_17035 = f__14376__auto__.call(null);
(statearr_17035[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17045);

return statearr_17035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17045,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17063 = [];
var len__7107__auto___17066 = arguments.length;
var i__7108__auto___17067 = (0);
while(true){
if((i__7108__auto___17067 < len__7107__auto___17066)){
args17063.push((arguments[i__7108__auto___17067]));

var G__17068 = (i__7108__auto___17067 + (1));
i__7108__auto___17067 = G__17068;
continue;
} else {
}
break;
}

var G__17065 = args17063.length;
switch (G__17065) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17063.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14375__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto__){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto__){
return (function (state_17239){
var state_val_17240 = (state_17239[(1)]);
if((state_val_17240 === (7))){
var inst_17235 = (state_17239[(2)]);
var state_17239__$1 = state_17239;
var statearr_17241_17286 = state_17239__$1;
(statearr_17241_17286[(2)] = inst_17235);

(statearr_17241_17286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (20))){
var inst_17205 = (state_17239[(7)]);
var inst_17216 = (state_17239[(2)]);
var inst_17217 = cljs.core.next.call(null,inst_17205);
var inst_17191 = inst_17217;
var inst_17192 = null;
var inst_17193 = (0);
var inst_17194 = (0);
var state_17239__$1 = (function (){var statearr_17242 = state_17239;
(statearr_17242[(8)] = inst_17193);

(statearr_17242[(9)] = inst_17191);

(statearr_17242[(10)] = inst_17192);

(statearr_17242[(11)] = inst_17194);

(statearr_17242[(12)] = inst_17216);

return statearr_17242;
})();
var statearr_17246_17287 = state_17239__$1;
(statearr_17246_17287[(2)] = null);

(statearr_17246_17287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (1))){
var state_17239__$1 = state_17239;
var statearr_17247_17288 = state_17239__$1;
(statearr_17247_17288[(2)] = null);

(statearr_17247_17288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (4))){
var inst_17180 = (state_17239[(13)]);
var inst_17180__$1 = (state_17239[(2)]);
var inst_17181 = (inst_17180__$1 == null);
var state_17239__$1 = (function (){var statearr_17248 = state_17239;
(statearr_17248[(13)] = inst_17180__$1);

return statearr_17248;
})();
if(cljs.core.truth_(inst_17181)){
var statearr_17249_17289 = state_17239__$1;
(statearr_17249_17289[(1)] = (5));

} else {
var statearr_17250_17290 = state_17239__$1;
(statearr_17250_17290[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (15))){
var state_17239__$1 = state_17239;
var statearr_17254_17291 = state_17239__$1;
(statearr_17254_17291[(2)] = null);

(statearr_17254_17291[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (21))){
var state_17239__$1 = state_17239;
var statearr_17255_17292 = state_17239__$1;
(statearr_17255_17292[(2)] = null);

(statearr_17255_17292[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (13))){
var inst_17193 = (state_17239[(8)]);
var inst_17191 = (state_17239[(9)]);
var inst_17192 = (state_17239[(10)]);
var inst_17194 = (state_17239[(11)]);
var inst_17201 = (state_17239[(2)]);
var inst_17202 = (inst_17194 + (1));
var tmp17251 = inst_17193;
var tmp17252 = inst_17191;
var tmp17253 = inst_17192;
var inst_17191__$1 = tmp17252;
var inst_17192__$1 = tmp17253;
var inst_17193__$1 = tmp17251;
var inst_17194__$1 = inst_17202;
var state_17239__$1 = (function (){var statearr_17256 = state_17239;
(statearr_17256[(14)] = inst_17201);

(statearr_17256[(8)] = inst_17193__$1);

(statearr_17256[(9)] = inst_17191__$1);

(statearr_17256[(10)] = inst_17192__$1);

(statearr_17256[(11)] = inst_17194__$1);

return statearr_17256;
})();
var statearr_17257_17293 = state_17239__$1;
(statearr_17257_17293[(2)] = null);

(statearr_17257_17293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (22))){
var state_17239__$1 = state_17239;
var statearr_17258_17294 = state_17239__$1;
(statearr_17258_17294[(2)] = null);

(statearr_17258_17294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (6))){
var inst_17180 = (state_17239[(13)]);
var inst_17189 = f.call(null,inst_17180);
var inst_17190 = cljs.core.seq.call(null,inst_17189);
var inst_17191 = inst_17190;
var inst_17192 = null;
var inst_17193 = (0);
var inst_17194 = (0);
var state_17239__$1 = (function (){var statearr_17259 = state_17239;
(statearr_17259[(8)] = inst_17193);

(statearr_17259[(9)] = inst_17191);

(statearr_17259[(10)] = inst_17192);

(statearr_17259[(11)] = inst_17194);

return statearr_17259;
})();
var statearr_17260_17297 = state_17239__$1;
(statearr_17260_17297[(2)] = null);

(statearr_17260_17297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (17))){
var inst_17205 = (state_17239[(7)]);
var inst_17209 = cljs.core.chunk_first.call(null,inst_17205);
var inst_17210 = cljs.core.chunk_rest.call(null,inst_17205);
var inst_17211 = cljs.core.count.call(null,inst_17209);
var inst_17191 = inst_17210;
var inst_17192 = inst_17209;
var inst_17193 = inst_17211;
var inst_17194 = (0);
var state_17239__$1 = (function (){var statearr_17261 = state_17239;
(statearr_17261[(8)] = inst_17193);

(statearr_17261[(9)] = inst_17191);

(statearr_17261[(10)] = inst_17192);

(statearr_17261[(11)] = inst_17194);

return statearr_17261;
})();
var statearr_17262_17300 = state_17239__$1;
(statearr_17262_17300[(2)] = null);

(statearr_17262_17300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (3))){
var inst_17237 = (state_17239[(2)]);
var state_17239__$1 = state_17239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17239__$1,inst_17237);
} else {
if((state_val_17240 === (12))){
var inst_17225 = (state_17239[(2)]);
var state_17239__$1 = state_17239;
var statearr_17263_17301 = state_17239__$1;
(statearr_17263_17301[(2)] = inst_17225);

(statearr_17263_17301[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (2))){
var state_17239__$1 = state_17239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17239__$1,(4),in$);
} else {
if((state_val_17240 === (23))){
var inst_17233 = (state_17239[(2)]);
var state_17239__$1 = state_17239;
var statearr_17265_17302 = state_17239__$1;
(statearr_17265_17302[(2)] = inst_17233);

(statearr_17265_17302[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (19))){
var inst_17220 = (state_17239[(2)]);
var state_17239__$1 = state_17239;
var statearr_17266_17303 = state_17239__$1;
(statearr_17266_17303[(2)] = inst_17220);

(statearr_17266_17303[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (11))){
var inst_17191 = (state_17239[(9)]);
var inst_17205 = (state_17239[(7)]);
var inst_17205__$1 = cljs.core.seq.call(null,inst_17191);
var state_17239__$1 = (function (){var statearr_17267 = state_17239;
(statearr_17267[(7)] = inst_17205__$1);

return statearr_17267;
})();
if(inst_17205__$1){
var statearr_17268_17307 = state_17239__$1;
(statearr_17268_17307[(1)] = (14));

} else {
var statearr_17269_17308 = state_17239__$1;
(statearr_17269_17308[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (9))){
var inst_17227 = (state_17239[(2)]);
var inst_17228 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17239__$1 = (function (){var statearr_17270 = state_17239;
(statearr_17270[(15)] = inst_17227);

return statearr_17270;
})();
if(cljs.core.truth_(inst_17228)){
var statearr_17271_17309 = state_17239__$1;
(statearr_17271_17309[(1)] = (21));

} else {
var statearr_17272_17310 = state_17239__$1;
(statearr_17272_17310[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (5))){
var inst_17183 = cljs.core.async.close_BANG_.call(null,out);
var state_17239__$1 = state_17239;
var statearr_17273_17311 = state_17239__$1;
(statearr_17273_17311[(2)] = inst_17183);

(statearr_17273_17311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (14))){
var inst_17205 = (state_17239[(7)]);
var inst_17207 = cljs.core.chunked_seq_QMARK_.call(null,inst_17205);
var state_17239__$1 = state_17239;
if(inst_17207){
var statearr_17274_17313 = state_17239__$1;
(statearr_17274_17313[(1)] = (17));

} else {
var statearr_17275_17314 = state_17239__$1;
(statearr_17275_17314[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (16))){
var inst_17223 = (state_17239[(2)]);
var state_17239__$1 = state_17239;
var statearr_17276_17315 = state_17239__$1;
(statearr_17276_17315[(2)] = inst_17223);

(statearr_17276_17315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17240 === (10))){
var inst_17192 = (state_17239[(10)]);
var inst_17194 = (state_17239[(11)]);
var inst_17199 = cljs.core._nth.call(null,inst_17192,inst_17194);
var state_17239__$1 = state_17239;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17239__$1,(13),out,inst_17199);
} else {
if((state_val_17240 === (18))){
var inst_17205 = (state_17239[(7)]);
var inst_17214 = cljs.core.first.call(null,inst_17205);
var state_17239__$1 = state_17239;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17239__$1,(20),out,inst_17214);
} else {
if((state_val_17240 === (8))){
var inst_17193 = (state_17239[(8)]);
var inst_17194 = (state_17239[(11)]);
var inst_17196 = (inst_17194 < inst_17193);
var inst_17197 = inst_17196;
var state_17239__$1 = state_17239;
if(cljs.core.truth_(inst_17197)){
var statearr_17277_17316 = state_17239__$1;
(statearr_17277_17316[(1)] = (10));

} else {
var statearr_17278_17317 = state_17239__$1;
(statearr_17278_17317[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto__))
;
return ((function (switch__14236__auto__,c__14375__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17282 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17282[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17282[(1)] = (1));

return statearr_17282;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17239){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17283){if((e17283 instanceof Object)){
var ex__14240__auto__ = e17283;
var statearr_17284_17318 = state_17239;
(statearr_17284_17318[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17239);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17283;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17319 = state_17239;
state_17239 = G__17319;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17239){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto__))
})();
var state__14377__auto__ = (function (){var statearr_17285 = f__14376__auto__.call(null);
(statearr_17285[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto__);

return statearr_17285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto__))
);

return c__14375__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17320 = [];
var len__7107__auto___17323 = arguments.length;
var i__7108__auto___17324 = (0);
while(true){
if((i__7108__auto___17324 < len__7107__auto___17323)){
args17320.push((arguments[i__7108__auto___17324]));

var G__17325 = (i__7108__auto___17324 + (1));
i__7108__auto___17324 = G__17325;
continue;
} else {
}
break;
}

var G__17322 = args17320.length;
switch (G__17322) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17320.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17327 = [];
var len__7107__auto___17330 = arguments.length;
var i__7108__auto___17331 = (0);
while(true){
if((i__7108__auto___17331 < len__7107__auto___17330)){
args17327.push((arguments[i__7108__auto___17331]));

var G__17332 = (i__7108__auto___17331 + (1));
i__7108__auto___17331 = G__17332;
continue;
} else {
}
break;
}

var G__17329 = args17327.length;
switch (G__17329) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17327.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17334 = [];
var len__7107__auto___17396 = arguments.length;
var i__7108__auto___17397 = (0);
while(true){
if((i__7108__auto___17397 < len__7107__auto___17396)){
args17334.push((arguments[i__7108__auto___17397]));

var G__17398 = (i__7108__auto___17397 + (1));
i__7108__auto___17397 = G__17398;
continue;
} else {
}
break;
}

var G__17339 = args17334.length;
switch (G__17339) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17334.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17401,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17401,out){
return (function (state_17364){
var state_val_17365 = (state_17364[(1)]);
if((state_val_17365 === (7))){
var inst_17359 = (state_17364[(2)]);
var state_17364__$1 = state_17364;
var statearr_17366_17402 = state_17364__$1;
(statearr_17366_17402[(2)] = inst_17359);

(statearr_17366_17402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (1))){
var inst_17341 = null;
var state_17364__$1 = (function (){var statearr_17367 = state_17364;
(statearr_17367[(7)] = inst_17341);

return statearr_17367;
})();
var statearr_17368_17403 = state_17364__$1;
(statearr_17368_17403[(2)] = null);

(statearr_17368_17403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (4))){
var inst_17344 = (state_17364[(8)]);
var inst_17344__$1 = (state_17364[(2)]);
var inst_17345 = (inst_17344__$1 == null);
var inst_17346 = cljs.core.not.call(null,inst_17345);
var state_17364__$1 = (function (){var statearr_17369 = state_17364;
(statearr_17369[(8)] = inst_17344__$1);

return statearr_17369;
})();
if(inst_17346){
var statearr_17370_17404 = state_17364__$1;
(statearr_17370_17404[(1)] = (5));

} else {
var statearr_17371_17405 = state_17364__$1;
(statearr_17371_17405[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (6))){
var state_17364__$1 = state_17364;
var statearr_17372_17406 = state_17364__$1;
(statearr_17372_17406[(2)] = null);

(statearr_17372_17406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (3))){
var inst_17361 = (state_17364[(2)]);
var inst_17362 = cljs.core.async.close_BANG_.call(null,out);
var state_17364__$1 = (function (){var statearr_17373 = state_17364;
(statearr_17373[(9)] = inst_17361);

return statearr_17373;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17364__$1,inst_17362);
} else {
if((state_val_17365 === (2))){
var state_17364__$1 = state_17364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17364__$1,(4),ch);
} else {
if((state_val_17365 === (11))){
var inst_17344 = (state_17364[(8)]);
var inst_17353 = (state_17364[(2)]);
var inst_17341 = inst_17344;
var state_17364__$1 = (function (){var statearr_17374 = state_17364;
(statearr_17374[(10)] = inst_17353);

(statearr_17374[(7)] = inst_17341);

return statearr_17374;
})();
var statearr_17375_17407 = state_17364__$1;
(statearr_17375_17407[(2)] = null);

(statearr_17375_17407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (9))){
var inst_17344 = (state_17364[(8)]);
var state_17364__$1 = state_17364;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17364__$1,(11),out,inst_17344);
} else {
if((state_val_17365 === (5))){
var inst_17341 = (state_17364[(7)]);
var inst_17344 = (state_17364[(8)]);
var inst_17348 = cljs.core._EQ_.call(null,inst_17344,inst_17341);
var state_17364__$1 = state_17364;
if(inst_17348){
var statearr_17380_17408 = state_17364__$1;
(statearr_17380_17408[(1)] = (8));

} else {
var statearr_17381_17409 = state_17364__$1;
(statearr_17381_17409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (10))){
var inst_17356 = (state_17364[(2)]);
var state_17364__$1 = state_17364;
var statearr_17382_17410 = state_17364__$1;
(statearr_17382_17410[(2)] = inst_17356);

(statearr_17382_17410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (8))){
var inst_17341 = (state_17364[(7)]);
var tmp17379 = inst_17341;
var inst_17341__$1 = tmp17379;
var state_17364__$1 = (function (){var statearr_17383 = state_17364;
(statearr_17383[(7)] = inst_17341__$1);

return statearr_17383;
})();
var statearr_17384_17411 = state_17364__$1;
(statearr_17384_17411[(2)] = null);

(statearr_17384_17411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17401,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17401,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17392 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17392[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17392[(1)] = (1));

return statearr_17392;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17364){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17393){if((e17393 instanceof Object)){
var ex__14240__auto__ = e17393;
var statearr_17394_17412 = state_17364;
(statearr_17394_17412[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17364);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17413 = state_17364;
state_17364 = G__17413;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17364){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17401,out))
})();
var state__14377__auto__ = (function (){var statearr_17395 = f__14376__auto__.call(null);
(statearr_17395[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17401);

return statearr_17395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17401,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17414 = [];
var len__7107__auto___17484 = arguments.length;
var i__7108__auto___17485 = (0);
while(true){
if((i__7108__auto___17485 < len__7107__auto___17484)){
args17414.push((arguments[i__7108__auto___17485]));

var G__17486 = (i__7108__auto___17485 + (1));
i__7108__auto___17485 = G__17486;
continue;
} else {
}
break;
}

var G__17416 = args17414.length;
switch (G__17416) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17414.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17488 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17488,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17488,out){
return (function (state_17454){
var state_val_17455 = (state_17454[(1)]);
if((state_val_17455 === (7))){
var inst_17450 = (state_17454[(2)]);
var state_17454__$1 = state_17454;
var statearr_17456_17489 = state_17454__$1;
(statearr_17456_17489[(2)] = inst_17450);

(statearr_17456_17489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (1))){
var inst_17417 = (new Array(n));
var inst_17418 = inst_17417;
var inst_17419 = (0);
var state_17454__$1 = (function (){var statearr_17457 = state_17454;
(statearr_17457[(7)] = inst_17418);

(statearr_17457[(8)] = inst_17419);

return statearr_17457;
})();
var statearr_17458_17490 = state_17454__$1;
(statearr_17458_17490[(2)] = null);

(statearr_17458_17490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (4))){
var inst_17422 = (state_17454[(9)]);
var inst_17422__$1 = (state_17454[(2)]);
var inst_17423 = (inst_17422__$1 == null);
var inst_17424 = cljs.core.not.call(null,inst_17423);
var state_17454__$1 = (function (){var statearr_17459 = state_17454;
(statearr_17459[(9)] = inst_17422__$1);

return statearr_17459;
})();
if(inst_17424){
var statearr_17460_17491 = state_17454__$1;
(statearr_17460_17491[(1)] = (5));

} else {
var statearr_17461_17492 = state_17454__$1;
(statearr_17461_17492[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (15))){
var inst_17444 = (state_17454[(2)]);
var state_17454__$1 = state_17454;
var statearr_17462_17493 = state_17454__$1;
(statearr_17462_17493[(2)] = inst_17444);

(statearr_17462_17493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (13))){
var state_17454__$1 = state_17454;
var statearr_17463_17494 = state_17454__$1;
(statearr_17463_17494[(2)] = null);

(statearr_17463_17494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (6))){
var inst_17419 = (state_17454[(8)]);
var inst_17440 = (inst_17419 > (0));
var state_17454__$1 = state_17454;
if(cljs.core.truth_(inst_17440)){
var statearr_17464_17496 = state_17454__$1;
(statearr_17464_17496[(1)] = (12));

} else {
var statearr_17465_17497 = state_17454__$1;
(statearr_17465_17497[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (3))){
var inst_17452 = (state_17454[(2)]);
var state_17454__$1 = state_17454;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17454__$1,inst_17452);
} else {
if((state_val_17455 === (12))){
var inst_17418 = (state_17454[(7)]);
var inst_17442 = cljs.core.vec.call(null,inst_17418);
var state_17454__$1 = state_17454;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17454__$1,(15),out,inst_17442);
} else {
if((state_val_17455 === (2))){
var state_17454__$1 = state_17454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17454__$1,(4),ch);
} else {
if((state_val_17455 === (11))){
var inst_17434 = (state_17454[(2)]);
var inst_17435 = (new Array(n));
var inst_17418 = inst_17435;
var inst_17419 = (0);
var state_17454__$1 = (function (){var statearr_17466 = state_17454;
(statearr_17466[(7)] = inst_17418);

(statearr_17466[(10)] = inst_17434);

(statearr_17466[(8)] = inst_17419);

return statearr_17466;
})();
var statearr_17467_17504 = state_17454__$1;
(statearr_17467_17504[(2)] = null);

(statearr_17467_17504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (9))){
var inst_17418 = (state_17454[(7)]);
var inst_17432 = cljs.core.vec.call(null,inst_17418);
var state_17454__$1 = state_17454;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17454__$1,(11),out,inst_17432);
} else {
if((state_val_17455 === (5))){
var inst_17418 = (state_17454[(7)]);
var inst_17427 = (state_17454[(11)]);
var inst_17419 = (state_17454[(8)]);
var inst_17422 = (state_17454[(9)]);
var inst_17426 = (inst_17418[inst_17419] = inst_17422);
var inst_17427__$1 = (inst_17419 + (1));
var inst_17428 = (inst_17427__$1 < n);
var state_17454__$1 = (function (){var statearr_17468 = state_17454;
(statearr_17468[(12)] = inst_17426);

(statearr_17468[(11)] = inst_17427__$1);

return statearr_17468;
})();
if(cljs.core.truth_(inst_17428)){
var statearr_17469_17507 = state_17454__$1;
(statearr_17469_17507[(1)] = (8));

} else {
var statearr_17470_17508 = state_17454__$1;
(statearr_17470_17508[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (14))){
var inst_17447 = (state_17454[(2)]);
var inst_17448 = cljs.core.async.close_BANG_.call(null,out);
var state_17454__$1 = (function (){var statearr_17472 = state_17454;
(statearr_17472[(13)] = inst_17447);

return statearr_17472;
})();
var statearr_17473_17513 = state_17454__$1;
(statearr_17473_17513[(2)] = inst_17448);

(statearr_17473_17513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (10))){
var inst_17438 = (state_17454[(2)]);
var state_17454__$1 = state_17454;
var statearr_17474_17515 = state_17454__$1;
(statearr_17474_17515[(2)] = inst_17438);

(statearr_17474_17515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17455 === (8))){
var inst_17418 = (state_17454[(7)]);
var inst_17427 = (state_17454[(11)]);
var tmp17471 = inst_17418;
var inst_17418__$1 = tmp17471;
var inst_17419 = inst_17427;
var state_17454__$1 = (function (){var statearr_17475 = state_17454;
(statearr_17475[(7)] = inst_17418__$1);

(statearr_17475[(8)] = inst_17419);

return statearr_17475;
})();
var statearr_17476_17518 = state_17454__$1;
(statearr_17476_17518[(2)] = null);

(statearr_17476_17518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17488,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17488,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17480 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17480[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17480[(1)] = (1));

return statearr_17480;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17454){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17454);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17481){if((e17481 instanceof Object)){
var ex__14240__auto__ = e17481;
var statearr_17482_17521 = state_17454;
(statearr_17482_17521[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17481;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17522 = state_17454;
state_17454 = G__17522;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17454){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17488,out))
})();
var state__14377__auto__ = (function (){var statearr_17483 = f__14376__auto__.call(null);
(statearr_17483[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17488);

return statearr_17483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17488,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17523 = [];
var len__7107__auto___17606 = arguments.length;
var i__7108__auto___17611 = (0);
while(true){
if((i__7108__auto___17611 < len__7107__auto___17606)){
args17523.push((arguments[i__7108__auto___17611]));

var G__17612 = (i__7108__auto___17611 + (1));
i__7108__auto___17611 = G__17612;
continue;
} else {
}
break;
}

var G__17525 = args17523.length;
switch (G__17525) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17523.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14375__auto___17618 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14375__auto___17618,out){
return (function (){
var f__14376__auto__ = (function (){var switch__14236__auto__ = ((function (c__14375__auto___17618,out){
return (function (state_17568){
var state_val_17569 = (state_17568[(1)]);
if((state_val_17569 === (7))){
var inst_17563 = (state_17568[(2)]);
var state_17568__$1 = state_17568;
var statearr_17570_17619 = state_17568__$1;
(statearr_17570_17619[(2)] = inst_17563);

(statearr_17570_17619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (1))){
var inst_17526 = [];
var inst_17527 = inst_17526;
var inst_17528 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17568__$1 = (function (){var statearr_17571 = state_17568;
(statearr_17571[(7)] = inst_17527);

(statearr_17571[(8)] = inst_17528);

return statearr_17571;
})();
var statearr_17572_17620 = state_17568__$1;
(statearr_17572_17620[(2)] = null);

(statearr_17572_17620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (4))){
var inst_17531 = (state_17568[(9)]);
var inst_17531__$1 = (state_17568[(2)]);
var inst_17532 = (inst_17531__$1 == null);
var inst_17533 = cljs.core.not.call(null,inst_17532);
var state_17568__$1 = (function (){var statearr_17573 = state_17568;
(statearr_17573[(9)] = inst_17531__$1);

return statearr_17573;
})();
if(inst_17533){
var statearr_17574_17622 = state_17568__$1;
(statearr_17574_17622[(1)] = (5));

} else {
var statearr_17575_17623 = state_17568__$1;
(statearr_17575_17623[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (15))){
var inst_17557 = (state_17568[(2)]);
var state_17568__$1 = state_17568;
var statearr_17576_17624 = state_17568__$1;
(statearr_17576_17624[(2)] = inst_17557);

(statearr_17576_17624[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (13))){
var state_17568__$1 = state_17568;
var statearr_17577_17626 = state_17568__$1;
(statearr_17577_17626[(2)] = null);

(statearr_17577_17626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (6))){
var inst_17527 = (state_17568[(7)]);
var inst_17552 = inst_17527.length;
var inst_17553 = (inst_17552 > (0));
var state_17568__$1 = state_17568;
if(cljs.core.truth_(inst_17553)){
var statearr_17578_17627 = state_17568__$1;
(statearr_17578_17627[(1)] = (12));

} else {
var statearr_17579_17628 = state_17568__$1;
(statearr_17579_17628[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (3))){
var inst_17565 = (state_17568[(2)]);
var state_17568__$1 = state_17568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17568__$1,inst_17565);
} else {
if((state_val_17569 === (12))){
var inst_17527 = (state_17568[(7)]);
var inst_17555 = cljs.core.vec.call(null,inst_17527);
var state_17568__$1 = state_17568;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17568__$1,(15),out,inst_17555);
} else {
if((state_val_17569 === (2))){
var state_17568__$1 = state_17568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17568__$1,(4),ch);
} else {
if((state_val_17569 === (11))){
var inst_17531 = (state_17568[(9)]);
var inst_17535 = (state_17568[(10)]);
var inst_17545 = (state_17568[(2)]);
var inst_17546 = [];
var inst_17547 = inst_17546.push(inst_17531);
var inst_17527 = inst_17546;
var inst_17528 = inst_17535;
var state_17568__$1 = (function (){var statearr_17580 = state_17568;
(statearr_17580[(7)] = inst_17527);

(statearr_17580[(11)] = inst_17545);

(statearr_17580[(8)] = inst_17528);

(statearr_17580[(12)] = inst_17547);

return statearr_17580;
})();
var statearr_17581_17642 = state_17568__$1;
(statearr_17581_17642[(2)] = null);

(statearr_17581_17642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (9))){
var inst_17527 = (state_17568[(7)]);
var inst_17543 = cljs.core.vec.call(null,inst_17527);
var state_17568__$1 = state_17568;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17568__$1,(11),out,inst_17543);
} else {
if((state_val_17569 === (5))){
var inst_17531 = (state_17568[(9)]);
var inst_17528 = (state_17568[(8)]);
var inst_17535 = (state_17568[(10)]);
var inst_17535__$1 = f.call(null,inst_17531);
var inst_17536 = cljs.core._EQ_.call(null,inst_17535__$1,inst_17528);
var inst_17537 = cljs.core.keyword_identical_QMARK_.call(null,inst_17528,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17538 = (inst_17536) || (inst_17537);
var state_17568__$1 = (function (){var statearr_17582 = state_17568;
(statearr_17582[(10)] = inst_17535__$1);

return statearr_17582;
})();
if(cljs.core.truth_(inst_17538)){
var statearr_17583_17646 = state_17568__$1;
(statearr_17583_17646[(1)] = (8));

} else {
var statearr_17584_17647 = state_17568__$1;
(statearr_17584_17647[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (14))){
var inst_17560 = (state_17568[(2)]);
var inst_17561 = cljs.core.async.close_BANG_.call(null,out);
var state_17568__$1 = (function (){var statearr_17586 = state_17568;
(statearr_17586[(13)] = inst_17560);

return statearr_17586;
})();
var statearr_17587_17648 = state_17568__$1;
(statearr_17587_17648[(2)] = inst_17561);

(statearr_17587_17648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (10))){
var inst_17550 = (state_17568[(2)]);
var state_17568__$1 = state_17568;
var statearr_17588_17650 = state_17568__$1;
(statearr_17588_17650[(2)] = inst_17550);

(statearr_17588_17650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17569 === (8))){
var inst_17527 = (state_17568[(7)]);
var inst_17531 = (state_17568[(9)]);
var inst_17535 = (state_17568[(10)]);
var inst_17540 = inst_17527.push(inst_17531);
var tmp17585 = inst_17527;
var inst_17527__$1 = tmp17585;
var inst_17528 = inst_17535;
var state_17568__$1 = (function (){var statearr_17589 = state_17568;
(statearr_17589[(14)] = inst_17540);

(statearr_17589[(7)] = inst_17527__$1);

(statearr_17589[(8)] = inst_17528);

return statearr_17589;
})();
var statearr_17594_17651 = state_17568__$1;
(statearr_17594_17651[(2)] = null);

(statearr_17594_17651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14375__auto___17618,out))
;
return ((function (switch__14236__auto__,c__14375__auto___17618,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17600[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17600[(1)] = (1));

return statearr_17600;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17568){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17601){if((e17601 instanceof Object)){
var ex__14240__auto__ = e17601;
var statearr_17602_17652 = state_17568;
(statearr_17602_17652[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17601;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17653 = state_17568;
state_17568 = G__17653;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17568){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14375__auto___17618,out))
})();
var state__14377__auto__ = (function (){var statearr_17604 = f__14376__auto__.call(null);
(statearr_17604[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14375__auto___17618);

return statearr_17604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14377__auto__);
});})(c__14375__auto___17618,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472735704040