// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14416 = [];
var len__7107__auto___14422 = arguments.length;
var i__7108__auto___14423 = (0);
while(true){
if((i__7108__auto___14423 < len__7107__auto___14422)){
args14416.push((arguments[i__7108__auto___14423]));

var G__14424 = (i__7108__auto___14423 + (1));
i__7108__auto___14423 = G__14424;
continue;
} else {
}
break;
}

var G__14418 = args14416.length;
switch (G__14418) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14416.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14419 = (function (f,blockable,meta14420){
this.f = f;
this.blockable = blockable;
this.meta14420 = meta14420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14421,meta14420__$1){
var self__ = this;
var _14421__$1 = this;
return (new cljs.core.async.t_cljs$core$async14419(self__.f,self__.blockable,meta14420__$1));
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14421){
var self__ = this;
var _14421__$1 = this;
return self__.meta14420;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14420","meta14420",1333243082,null)], null);
});

cljs.core.async.t_cljs$core$async14419.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14419";

cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14419");
});

cljs.core.async.__GT_t_cljs$core$async14419 = (function cljs$core$async$__GT_t_cljs$core$async14419(f__$1,blockable__$1,meta14420){
return (new cljs.core.async.t_cljs$core$async14419(f__$1,blockable__$1,meta14420));
});

}

return (new cljs.core.async.t_cljs$core$async14419(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14428 = [];
var len__7107__auto___14434 = arguments.length;
var i__7108__auto___14435 = (0);
while(true){
if((i__7108__auto___14435 < len__7107__auto___14434)){
args14428.push((arguments[i__7108__auto___14435]));

var G__14436 = (i__7108__auto___14435 + (1));
i__7108__auto___14435 = G__14436;
continue;
} else {
}
break;
}

var G__14430 = args14428.length;
switch (G__14430) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14428.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14442 = [];
var len__7107__auto___14445 = arguments.length;
var i__7108__auto___14446 = (0);
while(true){
if((i__7108__auto___14446 < len__7107__auto___14445)){
args14442.push((arguments[i__7108__auto___14446]));

var G__14447 = (i__7108__auto___14446 + (1));
i__7108__auto___14446 = G__14447;
continue;
} else {
}
break;
}

var G__14444 = args14442.length;
switch (G__14444) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14442.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14449 = [];
var len__7107__auto___14456 = arguments.length;
var i__7108__auto___14457 = (0);
while(true){
if((i__7108__auto___14457 < len__7107__auto___14456)){
args14449.push((arguments[i__7108__auto___14457]));

var G__14458 = (i__7108__auto___14457 + (1));
i__7108__auto___14457 = G__14458;
continue;
} else {
}
break;
}

var G__14453 = args14449.length;
switch (G__14453) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14449.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14464 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14464);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14464,ret){
return (function (){
return fn1.call(null,val_14464);
});})(val_14464,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14466 = [];
var len__7107__auto___14473 = arguments.length;
var i__7108__auto___14474 = (0);
while(true){
if((i__7108__auto___14474 < len__7107__auto___14473)){
args14466.push((arguments[i__7108__auto___14474]));

var G__14475 = (i__7108__auto___14474 + (1));
i__7108__auto___14474 = G__14475;
continue;
} else {
}
break;
}

var G__14468 = args14466.length;
switch (G__14468) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14466.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14484 = n;
var x_14485 = (0);
while(true){
if((x_14485 < n__6952__auto___14484)){
(a[x_14485] = (0));

var G__14488 = (x_14485 + (1));
x_14485 = G__14488;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14489 = (i + (1));
i = G__14489;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14493 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14493 = (function (alt_flag,flag,meta14494){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14494 = meta14494;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14493.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14495,meta14494__$1){
var self__ = this;
var _14495__$1 = this;
return (new cljs.core.async.t_cljs$core$async14493(self__.alt_flag,self__.flag,meta14494__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14493.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14495){
var self__ = this;
var _14495__$1 = this;
return self__.meta14494;
});})(flag))
;

cljs.core.async.t_cljs$core$async14493.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14493.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14493.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14493.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14493.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14494","meta14494",-1214888322,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14493.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14493.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14493";

cljs.core.async.t_cljs$core$async14493.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14493");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14493 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14493(alt_flag__$1,flag__$1,meta14494){
return (new cljs.core.async.t_cljs$core$async14493(alt_flag__$1,flag__$1,meta14494));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14493(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14504 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14504 = (function (alt_handler,flag,cb,meta14505){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14505 = meta14505;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14504.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14506,meta14505__$1){
var self__ = this;
var _14506__$1 = this;
return (new cljs.core.async.t_cljs$core$async14504(self__.alt_handler,self__.flag,self__.cb,meta14505__$1));
});

cljs.core.async.t_cljs$core$async14504.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14506){
var self__ = this;
var _14506__$1 = this;
return self__.meta14505;
});

cljs.core.async.t_cljs$core$async14504.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14504.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14504.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14504.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14504.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14505","meta14505",701180436,null)], null);
});

cljs.core.async.t_cljs$core$async14504.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14504.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14504";

cljs.core.async.t_cljs$core$async14504.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14504");
});

cljs.core.async.__GT_t_cljs$core$async14504 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14504(alt_handler__$1,flag__$1,cb__$1,meta14505){
return (new cljs.core.async.t_cljs$core$async14504(alt_handler__$1,flag__$1,cb__$1,meta14505));
});

}

return (new cljs.core.async.t_cljs$core$async14504(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14514_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14514_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14515_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14515_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14517 = (i + (1));
i = G__14517;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14523 = arguments.length;
var i__7108__auto___14524 = (0);
while(true){
if((i__7108__auto___14524 < len__7107__auto___14523)){
args__7114__auto__.push((arguments[i__7108__auto___14524]));

var G__14525 = (i__7108__auto___14524 + (1));
i__7108__auto___14524 = G__14525;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14520){
var map__14521 = p__14520;
var map__14521__$1 = ((((!((map__14521 == null)))?((((map__14521.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14521.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14521):map__14521);
var opts = map__14521__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14518){
var G__14519 = cljs.core.first.call(null,seq14518);
var seq14518__$1 = cljs.core.next.call(null,seq14518);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14519,seq14518__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14528 = [];
var len__7107__auto___14588 = arguments.length;
var i__7108__auto___14589 = (0);
while(true){
if((i__7108__auto___14589 < len__7107__auto___14588)){
args14528.push((arguments[i__7108__auto___14589]));

var G__14590 = (i__7108__auto___14589 + (1));
i__7108__auto___14589 = G__14590;
continue;
} else {
}
break;
}

var G__14531 = args14528.length;
switch (G__14531) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14528.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14371__auto___14592 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___14592){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___14592){
return (function (state_14561){
var state_val_14562 = (state_14561[(1)]);
if((state_val_14562 === (7))){
var inst_14554 = (state_14561[(2)]);
var state_14561__$1 = state_14561;
var statearr_14563_14593 = state_14561__$1;
(statearr_14563_14593[(2)] = inst_14554);

(statearr_14563_14593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (1))){
var state_14561__$1 = state_14561;
var statearr_14564_14594 = state_14561__$1;
(statearr_14564_14594[(2)] = null);

(statearr_14564_14594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (4))){
var inst_14537 = (state_14561[(7)]);
var inst_14537__$1 = (state_14561[(2)]);
var inst_14538 = (inst_14537__$1 == null);
var state_14561__$1 = (function (){var statearr_14565 = state_14561;
(statearr_14565[(7)] = inst_14537__$1);

return statearr_14565;
})();
if(cljs.core.truth_(inst_14538)){
var statearr_14566_14595 = state_14561__$1;
(statearr_14566_14595[(1)] = (5));

} else {
var statearr_14567_14596 = state_14561__$1;
(statearr_14567_14596[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (13))){
var state_14561__$1 = state_14561;
var statearr_14568_14597 = state_14561__$1;
(statearr_14568_14597[(2)] = null);

(statearr_14568_14597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (6))){
var inst_14537 = (state_14561[(7)]);
var state_14561__$1 = state_14561;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14561__$1,(11),to,inst_14537);
} else {
if((state_val_14562 === (3))){
var inst_14556 = (state_14561[(2)]);
var state_14561__$1 = state_14561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14561__$1,inst_14556);
} else {
if((state_val_14562 === (12))){
var state_14561__$1 = state_14561;
var statearr_14569_14598 = state_14561__$1;
(statearr_14569_14598[(2)] = null);

(statearr_14569_14598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (2))){
var state_14561__$1 = state_14561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14561__$1,(4),from);
} else {
if((state_val_14562 === (11))){
var inst_14547 = (state_14561[(2)]);
var state_14561__$1 = state_14561;
if(cljs.core.truth_(inst_14547)){
var statearr_14570_14599 = state_14561__$1;
(statearr_14570_14599[(1)] = (12));

} else {
var statearr_14571_14600 = state_14561__$1;
(statearr_14571_14600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (9))){
var state_14561__$1 = state_14561;
var statearr_14572_14601 = state_14561__$1;
(statearr_14572_14601[(2)] = null);

(statearr_14572_14601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (5))){
var state_14561__$1 = state_14561;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14573_14602 = state_14561__$1;
(statearr_14573_14602[(1)] = (8));

} else {
var statearr_14574_14603 = state_14561__$1;
(statearr_14574_14603[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (14))){
var inst_14552 = (state_14561[(2)]);
var state_14561__$1 = state_14561;
var statearr_14576_14604 = state_14561__$1;
(statearr_14576_14604[(2)] = inst_14552);

(statearr_14576_14604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (10))){
var inst_14544 = (state_14561[(2)]);
var state_14561__$1 = state_14561;
var statearr_14577_14605 = state_14561__$1;
(statearr_14577_14605[(2)] = inst_14544);

(statearr_14577_14605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14562 === (8))){
var inst_14541 = cljs.core.async.close_BANG_.call(null,to);
var state_14561__$1 = state_14561;
var statearr_14578_14606 = state_14561__$1;
(statearr_14578_14606[(2)] = inst_14541);

(statearr_14578_14606[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___14592))
;
return ((function (switch__14236__auto__,c__14371__auto___14592){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14583 = [null,null,null,null,null,null,null,null];
(statearr_14583[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14583[(1)] = (1));

return statearr_14583;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14561){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14584){if((e14584 instanceof Object)){
var ex__14240__auto__ = e14584;
var statearr_14586_14607 = state_14561;
(statearr_14586_14607[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14561);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14584;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14608 = state_14561;
state_14561 = G__14608;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14561){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___14592))
})();
var state__14373__auto__ = (function (){var statearr_14587 = f__14372__auto__.call(null);
(statearr_14587[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___14592);

return statearr_14587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___14592))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14819){
var vec__14820 = p__14819;
var v = cljs.core.nth.call(null,vec__14820,(0),null);
var p = cljs.core.nth.call(null,vec__14820,(1),null);
var job = vec__14820;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14371__auto___15017 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___15017,res,vec__14820,v,p,job,jobs,results){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___15017,res,vec__14820,v,p,job,jobs,results){
return (function (state_14825){
var state_val_14826 = (state_14825[(1)]);
if((state_val_14826 === (1))){
var state_14825__$1 = state_14825;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14825__$1,(2),res,v);
} else {
if((state_val_14826 === (2))){
var inst_14822 = (state_14825[(2)]);
var inst_14823 = cljs.core.async.close_BANG_.call(null,res);
var state_14825__$1 = (function (){var statearr_14827 = state_14825;
(statearr_14827[(7)] = inst_14822);

return statearr_14827;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14825__$1,inst_14823);
} else {
return null;
}
}
});})(c__14371__auto___15017,res,vec__14820,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14371__auto___15017,res,vec__14820,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14831 = [null,null,null,null,null,null,null,null];
(statearr_14831[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14831[(1)] = (1));

return statearr_14831;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14825){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14832){if((e14832 instanceof Object)){
var ex__14240__auto__ = e14832;
var statearr_14833_15021 = state_14825;
(statearr_14833_15021[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14825);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14832;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15022 = state_14825;
state_14825 = G__15022;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14825){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___15017,res,vec__14820,v,p,job,jobs,results))
})();
var state__14373__auto__ = (function (){var statearr_14834 = f__14372__auto__.call(null);
(statearr_14834[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___15017);

return statearr_14834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___15017,res,vec__14820,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14835){
var vec__14836 = p__14835;
var v = cljs.core.nth.call(null,vec__14836,(0),null);
var p = cljs.core.nth.call(null,vec__14836,(1),null);
var job = vec__14836;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15027 = n;
var __15028 = (0);
while(true){
if((__15028 < n__6952__auto___15027)){
var G__14839_15029 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14839_15029) {
case "compute":
var c__14371__auto___15031 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15028,c__14371__auto___15031,G__14839_15029,n__6952__auto___15027,jobs,results,process,async){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (__15028,c__14371__auto___15031,G__14839_15029,n__6952__auto___15027,jobs,results,process,async){
return (function (state_14852){
var state_val_14853 = (state_14852[(1)]);
if((state_val_14853 === (1))){
var state_14852__$1 = state_14852;
var statearr_14854_15032 = state_14852__$1;
(statearr_14854_15032[(2)] = null);

(statearr_14854_15032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14853 === (2))){
var state_14852__$1 = state_14852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14852__$1,(4),jobs);
} else {
if((state_val_14853 === (3))){
var inst_14850 = (state_14852[(2)]);
var state_14852__$1 = state_14852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14852__$1,inst_14850);
} else {
if((state_val_14853 === (4))){
var inst_14842 = (state_14852[(2)]);
var inst_14843 = process.call(null,inst_14842);
var state_14852__$1 = state_14852;
if(cljs.core.truth_(inst_14843)){
var statearr_14855_15034 = state_14852__$1;
(statearr_14855_15034[(1)] = (5));

} else {
var statearr_14856_15035 = state_14852__$1;
(statearr_14856_15035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14853 === (5))){
var state_14852__$1 = state_14852;
var statearr_14857_15036 = state_14852__$1;
(statearr_14857_15036[(2)] = null);

(statearr_14857_15036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14853 === (6))){
var state_14852__$1 = state_14852;
var statearr_14858_15037 = state_14852__$1;
(statearr_14858_15037[(2)] = null);

(statearr_14858_15037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14853 === (7))){
var inst_14848 = (state_14852[(2)]);
var state_14852__$1 = state_14852;
var statearr_14859_15038 = state_14852__$1;
(statearr_14859_15038[(2)] = inst_14848);

(statearr_14859_15038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15028,c__14371__auto___15031,G__14839_15029,n__6952__auto___15027,jobs,results,process,async))
;
return ((function (__15028,switch__14236__auto__,c__14371__auto___15031,G__14839_15029,n__6952__auto___15027,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14863 = [null,null,null,null,null,null,null];
(statearr_14863[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14863[(1)] = (1));

return statearr_14863;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14852){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14865){if((e14865 instanceof Object)){
var ex__14240__auto__ = e14865;
var statearr_14866_15039 = state_14852;
(statearr_14866_15039[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14865;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15040 = state_14852;
state_14852 = G__15040;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14852){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15028,switch__14236__auto__,c__14371__auto___15031,G__14839_15029,n__6952__auto___15027,jobs,results,process,async))
})();
var state__14373__auto__ = (function (){var statearr_14867 = f__14372__auto__.call(null);
(statearr_14867[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___15031);

return statearr_14867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(__15028,c__14371__auto___15031,G__14839_15029,n__6952__auto___15027,jobs,results,process,async))
);


break;
case "async":
var c__14371__auto___15041 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15028,c__14371__auto___15041,G__14839_15029,n__6952__auto___15027,jobs,results,process,async){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (__15028,c__14371__auto___15041,G__14839_15029,n__6952__auto___15027,jobs,results,process,async){
return (function (state_14880){
var state_val_14881 = (state_14880[(1)]);
if((state_val_14881 === (1))){
var state_14880__$1 = state_14880;
var statearr_14882_15042 = state_14880__$1;
(statearr_14882_15042[(2)] = null);

(statearr_14882_15042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14881 === (2))){
var state_14880__$1 = state_14880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14880__$1,(4),jobs);
} else {
if((state_val_14881 === (3))){
var inst_14878 = (state_14880[(2)]);
var state_14880__$1 = state_14880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14880__$1,inst_14878);
} else {
if((state_val_14881 === (4))){
var inst_14870 = (state_14880[(2)]);
var inst_14871 = async.call(null,inst_14870);
var state_14880__$1 = state_14880;
if(cljs.core.truth_(inst_14871)){
var statearr_14883_15043 = state_14880__$1;
(statearr_14883_15043[(1)] = (5));

} else {
var statearr_14884_15044 = state_14880__$1;
(statearr_14884_15044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14881 === (5))){
var state_14880__$1 = state_14880;
var statearr_14885_15045 = state_14880__$1;
(statearr_14885_15045[(2)] = null);

(statearr_14885_15045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14881 === (6))){
var state_14880__$1 = state_14880;
var statearr_14886_15046 = state_14880__$1;
(statearr_14886_15046[(2)] = null);

(statearr_14886_15046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14881 === (7))){
var inst_14876 = (state_14880[(2)]);
var state_14880__$1 = state_14880;
var statearr_14889_15047 = state_14880__$1;
(statearr_14889_15047[(2)] = inst_14876);

(statearr_14889_15047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15028,c__14371__auto___15041,G__14839_15029,n__6952__auto___15027,jobs,results,process,async))
;
return ((function (__15028,switch__14236__auto__,c__14371__auto___15041,G__14839_15029,n__6952__auto___15027,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14893 = [null,null,null,null,null,null,null];
(statearr_14893[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14893[(1)] = (1));

return statearr_14893;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14880){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14894){if((e14894 instanceof Object)){
var ex__14240__auto__ = e14894;
var statearr_14895_15048 = state_14880;
(statearr_14895_15048[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14880);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14894;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15049 = state_14880;
state_14880 = G__15049;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14880){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15028,switch__14236__auto__,c__14371__auto___15041,G__14839_15029,n__6952__auto___15027,jobs,results,process,async))
})();
var state__14373__auto__ = (function (){var statearr_14898 = f__14372__auto__.call(null);
(statearr_14898[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___15041);

return statearr_14898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(__15028,c__14371__auto___15041,G__14839_15029,n__6952__auto___15027,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15050 = (__15028 + (1));
__15028 = G__15050;
continue;
} else {
}
break;
}

var c__14371__auto___15051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___15051,jobs,results,process,async){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___15051,jobs,results,process,async){
return (function (state_14921){
var state_val_14922 = (state_14921[(1)]);
if((state_val_14922 === (1))){
var state_14921__$1 = state_14921;
var statearr_14923_15052 = state_14921__$1;
(statearr_14923_15052[(2)] = null);

(statearr_14923_15052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14922 === (2))){
var state_14921__$1 = state_14921;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14921__$1,(4),from);
} else {
if((state_val_14922 === (3))){
var inst_14919 = (state_14921[(2)]);
var state_14921__$1 = state_14921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14921__$1,inst_14919);
} else {
if((state_val_14922 === (4))){
var inst_14902 = (state_14921[(7)]);
var inst_14902__$1 = (state_14921[(2)]);
var inst_14903 = (inst_14902__$1 == null);
var state_14921__$1 = (function (){var statearr_14924 = state_14921;
(statearr_14924[(7)] = inst_14902__$1);

return statearr_14924;
})();
if(cljs.core.truth_(inst_14903)){
var statearr_14925_15053 = state_14921__$1;
(statearr_14925_15053[(1)] = (5));

} else {
var statearr_14926_15054 = state_14921__$1;
(statearr_14926_15054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14922 === (5))){
var inst_14905 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14921__$1 = state_14921;
var statearr_14927_15055 = state_14921__$1;
(statearr_14927_15055[(2)] = inst_14905);

(statearr_14927_15055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14922 === (6))){
var inst_14907 = (state_14921[(8)]);
var inst_14902 = (state_14921[(7)]);
var inst_14907__$1 = cljs.core.async.chan.call(null,(1));
var inst_14908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14909 = [inst_14902,inst_14907__$1];
var inst_14910 = (new cljs.core.PersistentVector(null,2,(5),inst_14908,inst_14909,null));
var state_14921__$1 = (function (){var statearr_14928 = state_14921;
(statearr_14928[(8)] = inst_14907__$1);

return statearr_14928;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14921__$1,(8),jobs,inst_14910);
} else {
if((state_val_14922 === (7))){
var inst_14917 = (state_14921[(2)]);
var state_14921__$1 = state_14921;
var statearr_14929_15056 = state_14921__$1;
(statearr_14929_15056[(2)] = inst_14917);

(statearr_14929_15056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14922 === (8))){
var inst_14907 = (state_14921[(8)]);
var inst_14912 = (state_14921[(2)]);
var state_14921__$1 = (function (){var statearr_14930 = state_14921;
(statearr_14930[(9)] = inst_14912);

return statearr_14930;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14921__$1,(9),results,inst_14907);
} else {
if((state_val_14922 === (9))){
var inst_14914 = (state_14921[(2)]);
var state_14921__$1 = (function (){var statearr_14931 = state_14921;
(statearr_14931[(10)] = inst_14914);

return statearr_14931;
})();
var statearr_14932_15057 = state_14921__$1;
(statearr_14932_15057[(2)] = null);

(statearr_14932_15057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___15051,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14371__auto___15051,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14941 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14941[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14941[(1)] = (1));

return statearr_14941;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14921){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14942){if((e14942 instanceof Object)){
var ex__14240__auto__ = e14942;
var statearr_14943_15058 = state_14921;
(statearr_14943_15058[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14921);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14942;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15059 = state_14921;
state_14921 = G__15059;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14921){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___15051,jobs,results,process,async))
})();
var state__14373__auto__ = (function (){var statearr_14944 = f__14372__auto__.call(null);
(statearr_14944[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___15051);

return statearr_14944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___15051,jobs,results,process,async))
);


var c__14371__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto__,jobs,results,process,async){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto__,jobs,results,process,async){
return (function (state_14982){
var state_val_14983 = (state_14982[(1)]);
if((state_val_14983 === (7))){
var inst_14978 = (state_14982[(2)]);
var state_14982__$1 = state_14982;
var statearr_14984_15060 = state_14982__$1;
(statearr_14984_15060[(2)] = inst_14978);

(statearr_14984_15060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (20))){
var state_14982__$1 = state_14982;
var statearr_14985_15061 = state_14982__$1;
(statearr_14985_15061[(2)] = null);

(statearr_14985_15061[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (1))){
var state_14982__$1 = state_14982;
var statearr_14986_15062 = state_14982__$1;
(statearr_14986_15062[(2)] = null);

(statearr_14986_15062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (4))){
var inst_14947 = (state_14982[(7)]);
var inst_14947__$1 = (state_14982[(2)]);
var inst_14948 = (inst_14947__$1 == null);
var state_14982__$1 = (function (){var statearr_14987 = state_14982;
(statearr_14987[(7)] = inst_14947__$1);

return statearr_14987;
})();
if(cljs.core.truth_(inst_14948)){
var statearr_14988_15063 = state_14982__$1;
(statearr_14988_15063[(1)] = (5));

} else {
var statearr_14989_15064 = state_14982__$1;
(statearr_14989_15064[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (15))){
var inst_14960 = (state_14982[(8)]);
var state_14982__$1 = state_14982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14982__$1,(18),to,inst_14960);
} else {
if((state_val_14983 === (21))){
var inst_14973 = (state_14982[(2)]);
var state_14982__$1 = state_14982;
var statearr_14990_15065 = state_14982__$1;
(statearr_14990_15065[(2)] = inst_14973);

(statearr_14990_15065[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (13))){
var inst_14975 = (state_14982[(2)]);
var state_14982__$1 = (function (){var statearr_14991 = state_14982;
(statearr_14991[(9)] = inst_14975);

return statearr_14991;
})();
var statearr_14992_15066 = state_14982__$1;
(statearr_14992_15066[(2)] = null);

(statearr_14992_15066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (6))){
var inst_14947 = (state_14982[(7)]);
var state_14982__$1 = state_14982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14982__$1,(11),inst_14947);
} else {
if((state_val_14983 === (17))){
var inst_14968 = (state_14982[(2)]);
var state_14982__$1 = state_14982;
if(cljs.core.truth_(inst_14968)){
var statearr_14994_15067 = state_14982__$1;
(statearr_14994_15067[(1)] = (19));

} else {
var statearr_14995_15068 = state_14982__$1;
(statearr_14995_15068[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (3))){
var inst_14980 = (state_14982[(2)]);
var state_14982__$1 = state_14982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14982__$1,inst_14980);
} else {
if((state_val_14983 === (12))){
var inst_14957 = (state_14982[(10)]);
var state_14982__$1 = state_14982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14982__$1,(14),inst_14957);
} else {
if((state_val_14983 === (2))){
var state_14982__$1 = state_14982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14982__$1,(4),results);
} else {
if((state_val_14983 === (19))){
var state_14982__$1 = state_14982;
var statearr_14997_15069 = state_14982__$1;
(statearr_14997_15069[(2)] = null);

(statearr_14997_15069[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (11))){
var inst_14957 = (state_14982[(2)]);
var state_14982__$1 = (function (){var statearr_14998 = state_14982;
(statearr_14998[(10)] = inst_14957);

return statearr_14998;
})();
var statearr_14999_15070 = state_14982__$1;
(statearr_14999_15070[(2)] = null);

(statearr_14999_15070[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (9))){
var state_14982__$1 = state_14982;
var statearr_15000_15071 = state_14982__$1;
(statearr_15000_15071[(2)] = null);

(statearr_15000_15071[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (5))){
var state_14982__$1 = state_14982;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15001_15072 = state_14982__$1;
(statearr_15001_15072[(1)] = (8));

} else {
var statearr_15002_15073 = state_14982__$1;
(statearr_15002_15073[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (14))){
var inst_14962 = (state_14982[(11)]);
var inst_14960 = (state_14982[(8)]);
var inst_14960__$1 = (state_14982[(2)]);
var inst_14961 = (inst_14960__$1 == null);
var inst_14962__$1 = cljs.core.not.call(null,inst_14961);
var state_14982__$1 = (function (){var statearr_15003 = state_14982;
(statearr_15003[(11)] = inst_14962__$1);

(statearr_15003[(8)] = inst_14960__$1);

return statearr_15003;
})();
if(inst_14962__$1){
var statearr_15004_15074 = state_14982__$1;
(statearr_15004_15074[(1)] = (15));

} else {
var statearr_15005_15075 = state_14982__$1;
(statearr_15005_15075[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (16))){
var inst_14962 = (state_14982[(11)]);
var state_14982__$1 = state_14982;
var statearr_15006_15076 = state_14982__$1;
(statearr_15006_15076[(2)] = inst_14962);

(statearr_15006_15076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (10))){
var inst_14954 = (state_14982[(2)]);
var state_14982__$1 = state_14982;
var statearr_15007_15077 = state_14982__$1;
(statearr_15007_15077[(2)] = inst_14954);

(statearr_15007_15077[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (18))){
var inst_14965 = (state_14982[(2)]);
var state_14982__$1 = state_14982;
var statearr_15008_15078 = state_14982__$1;
(statearr_15008_15078[(2)] = inst_14965);

(statearr_15008_15078[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14983 === (8))){
var inst_14951 = cljs.core.async.close_BANG_.call(null,to);
var state_14982__$1 = state_14982;
var statearr_15009_15079 = state_14982__$1;
(statearr_15009_15079[(2)] = inst_14951);

(statearr_15009_15079[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14371__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15013 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15013[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15013[(1)] = (1));

return statearr_15013;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14982){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15014){if((e15014 instanceof Object)){
var ex__14240__auto__ = e15014;
var statearr_15015_15080 = state_14982;
(statearr_15015_15080[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15081 = state_14982;
state_14982 = G__15081;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14982){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto__,jobs,results,process,async))
})();
var state__14373__auto__ = (function (){var statearr_15016 = f__14372__auto__.call(null);
(statearr_15016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto__);

return statearr_15016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto__,jobs,results,process,async))
);

return c__14371__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15082 = [];
var len__7107__auto___15085 = arguments.length;
var i__7108__auto___15086 = (0);
while(true){
if((i__7108__auto___15086 < len__7107__auto___15085)){
args15082.push((arguments[i__7108__auto___15086]));

var G__15087 = (i__7108__auto___15086 + (1));
i__7108__auto___15086 = G__15087;
continue;
} else {
}
break;
}

var G__15084 = args15082.length;
switch (G__15084) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15082.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15091 = [];
var len__7107__auto___15094 = arguments.length;
var i__7108__auto___15095 = (0);
while(true){
if((i__7108__auto___15095 < len__7107__auto___15094)){
args15091.push((arguments[i__7108__auto___15095]));

var G__15096 = (i__7108__auto___15095 + (1));
i__7108__auto___15095 = G__15096;
continue;
} else {
}
break;
}

var G__15093 = args15091.length;
switch (G__15093) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15091.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15098 = [];
var len__7107__auto___15159 = arguments.length;
var i__7108__auto___15160 = (0);
while(true){
if((i__7108__auto___15160 < len__7107__auto___15159)){
args15098.push((arguments[i__7108__auto___15160]));

var G__15161 = (i__7108__auto___15160 + (1));
i__7108__auto___15160 = G__15161;
continue;
} else {
}
break;
}

var G__15102 = args15098.length;
switch (G__15102) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15098.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14371__auto___15167 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___15167,tc,fc){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___15167,tc,fc){
return (function (state_15128){
var state_val_15129 = (state_15128[(1)]);
if((state_val_15129 === (7))){
var inst_15124 = (state_15128[(2)]);
var state_15128__$1 = state_15128;
var statearr_15130_15168 = state_15128__$1;
(statearr_15130_15168[(2)] = inst_15124);

(statearr_15130_15168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (1))){
var state_15128__$1 = state_15128;
var statearr_15131_15169 = state_15128__$1;
(statearr_15131_15169[(2)] = null);

(statearr_15131_15169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (4))){
var inst_15105 = (state_15128[(7)]);
var inst_15105__$1 = (state_15128[(2)]);
var inst_15106 = (inst_15105__$1 == null);
var state_15128__$1 = (function (){var statearr_15132 = state_15128;
(statearr_15132[(7)] = inst_15105__$1);

return statearr_15132;
})();
if(cljs.core.truth_(inst_15106)){
var statearr_15133_15170 = state_15128__$1;
(statearr_15133_15170[(1)] = (5));

} else {
var statearr_15134_15171 = state_15128__$1;
(statearr_15134_15171[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (13))){
var state_15128__$1 = state_15128;
var statearr_15135_15172 = state_15128__$1;
(statearr_15135_15172[(2)] = null);

(statearr_15135_15172[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (6))){
var inst_15105 = (state_15128[(7)]);
var inst_15111 = p.call(null,inst_15105);
var state_15128__$1 = state_15128;
if(cljs.core.truth_(inst_15111)){
var statearr_15136_15173 = state_15128__$1;
(statearr_15136_15173[(1)] = (9));

} else {
var statearr_15137_15174 = state_15128__$1;
(statearr_15137_15174[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (3))){
var inst_15126 = (state_15128[(2)]);
var state_15128__$1 = state_15128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15128__$1,inst_15126);
} else {
if((state_val_15129 === (12))){
var state_15128__$1 = state_15128;
var statearr_15138_15175 = state_15128__$1;
(statearr_15138_15175[(2)] = null);

(statearr_15138_15175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (2))){
var state_15128__$1 = state_15128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15128__$1,(4),ch);
} else {
if((state_val_15129 === (11))){
var inst_15105 = (state_15128[(7)]);
var inst_15115 = (state_15128[(2)]);
var state_15128__$1 = state_15128;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15128__$1,(8),inst_15115,inst_15105);
} else {
if((state_val_15129 === (9))){
var state_15128__$1 = state_15128;
var statearr_15139_15176 = state_15128__$1;
(statearr_15139_15176[(2)] = tc);

(statearr_15139_15176[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (5))){
var inst_15108 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15109 = cljs.core.async.close_BANG_.call(null,fc);
var state_15128__$1 = (function (){var statearr_15140 = state_15128;
(statearr_15140[(8)] = inst_15108);

return statearr_15140;
})();
var statearr_15141_15177 = state_15128__$1;
(statearr_15141_15177[(2)] = inst_15109);

(statearr_15141_15177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (14))){
var inst_15122 = (state_15128[(2)]);
var state_15128__$1 = state_15128;
var statearr_15142_15178 = state_15128__$1;
(statearr_15142_15178[(2)] = inst_15122);

(statearr_15142_15178[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (10))){
var state_15128__$1 = state_15128;
var statearr_15143_15179 = state_15128__$1;
(statearr_15143_15179[(2)] = fc);

(statearr_15143_15179[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15129 === (8))){
var inst_15117 = (state_15128[(2)]);
var state_15128__$1 = state_15128;
if(cljs.core.truth_(inst_15117)){
var statearr_15144_15180 = state_15128__$1;
(statearr_15144_15180[(1)] = (12));

} else {
var statearr_15145_15181 = state_15128__$1;
(statearr_15145_15181[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___15167,tc,fc))
;
return ((function (switch__14236__auto__,c__14371__auto___15167,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15149 = [null,null,null,null,null,null,null,null,null];
(statearr_15149[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15149[(1)] = (1));

return statearr_15149;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15128){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15150){if((e15150 instanceof Object)){
var ex__14240__auto__ = e15150;
var statearr_15151_15182 = state_15128;
(statearr_15151_15182[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15183 = state_15128;
state_15128 = G__15183;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15128){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___15167,tc,fc))
})();
var state__14373__auto__ = (function (){var statearr_15157 = f__14372__auto__.call(null);
(statearr_15157[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___15167);

return statearr_15157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___15167,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14371__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto__){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto__){
return (function (state_15253){
var state_val_15254 = (state_15253[(1)]);
if((state_val_15254 === (7))){
var inst_15249 = (state_15253[(2)]);
var state_15253__$1 = state_15253;
var statearr_15255_15280 = state_15253__$1;
(statearr_15255_15280[(2)] = inst_15249);

(statearr_15255_15280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15254 === (1))){
var inst_15233 = init;
var state_15253__$1 = (function (){var statearr_15256 = state_15253;
(statearr_15256[(7)] = inst_15233);

return statearr_15256;
})();
var statearr_15257_15281 = state_15253__$1;
(statearr_15257_15281[(2)] = null);

(statearr_15257_15281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15254 === (4))){
var inst_15236 = (state_15253[(8)]);
var inst_15236__$1 = (state_15253[(2)]);
var inst_15237 = (inst_15236__$1 == null);
var state_15253__$1 = (function (){var statearr_15258 = state_15253;
(statearr_15258[(8)] = inst_15236__$1);

return statearr_15258;
})();
if(cljs.core.truth_(inst_15237)){
var statearr_15259_15282 = state_15253__$1;
(statearr_15259_15282[(1)] = (5));

} else {
var statearr_15260_15283 = state_15253__$1;
(statearr_15260_15283[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15254 === (6))){
var inst_15233 = (state_15253[(7)]);
var inst_15236 = (state_15253[(8)]);
var inst_15240 = (state_15253[(9)]);
var inst_15240__$1 = f.call(null,inst_15233,inst_15236);
var inst_15241 = cljs.core.reduced_QMARK_.call(null,inst_15240__$1);
var state_15253__$1 = (function (){var statearr_15264 = state_15253;
(statearr_15264[(9)] = inst_15240__$1);

return statearr_15264;
})();
if(inst_15241){
var statearr_15265_15284 = state_15253__$1;
(statearr_15265_15284[(1)] = (8));

} else {
var statearr_15266_15285 = state_15253__$1;
(statearr_15266_15285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15254 === (3))){
var inst_15251 = (state_15253[(2)]);
var state_15253__$1 = state_15253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15253__$1,inst_15251);
} else {
if((state_val_15254 === (2))){
var state_15253__$1 = state_15253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15253__$1,(4),ch);
} else {
if((state_val_15254 === (9))){
var inst_15240 = (state_15253[(9)]);
var inst_15233 = inst_15240;
var state_15253__$1 = (function (){var statearr_15267 = state_15253;
(statearr_15267[(7)] = inst_15233);

return statearr_15267;
})();
var statearr_15268_15286 = state_15253__$1;
(statearr_15268_15286[(2)] = null);

(statearr_15268_15286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15254 === (5))){
var inst_15233 = (state_15253[(7)]);
var state_15253__$1 = state_15253;
var statearr_15269_15287 = state_15253__$1;
(statearr_15269_15287[(2)] = inst_15233);

(statearr_15269_15287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15254 === (10))){
var inst_15247 = (state_15253[(2)]);
var state_15253__$1 = state_15253;
var statearr_15270_15288 = state_15253__$1;
(statearr_15270_15288[(2)] = inst_15247);

(statearr_15270_15288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15254 === (8))){
var inst_15240 = (state_15253[(9)]);
var inst_15243 = cljs.core.deref.call(null,inst_15240);
var state_15253__$1 = state_15253;
var statearr_15271_15289 = state_15253__$1;
(statearr_15271_15289[(2)] = inst_15243);

(statearr_15271_15289[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto__))
;
return ((function (switch__14236__auto__,c__14371__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15275 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15275[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15275[(1)] = (1));

return statearr_15275;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15253){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15276){if((e15276 instanceof Object)){
var ex__14240__auto__ = e15276;
var statearr_15277_15290 = state_15253;
(statearr_15277_15290[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15276;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15291 = state_15253;
state_15253 = G__15291;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15253){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto__))
})();
var state__14373__auto__ = (function (){var statearr_15278 = f__14372__auto__.call(null);
(statearr_15278[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto__);

return statearr_15278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto__))
);

return c__14371__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15292 = [];
var len__7107__auto___15344 = arguments.length;
var i__7108__auto___15345 = (0);
while(true){
if((i__7108__auto___15345 < len__7107__auto___15344)){
args15292.push((arguments[i__7108__auto___15345]));

var G__15346 = (i__7108__auto___15345 + (1));
i__7108__auto___15345 = G__15346;
continue;
} else {
}
break;
}

var G__15294 = args15292.length;
switch (G__15294) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15292.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14371__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto__){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto__){
return (function (state_15319){
var state_val_15320 = (state_15319[(1)]);
if((state_val_15320 === (7))){
var inst_15301 = (state_15319[(2)]);
var state_15319__$1 = state_15319;
var statearr_15321_15348 = state_15319__$1;
(statearr_15321_15348[(2)] = inst_15301);

(statearr_15321_15348[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (1))){
var inst_15295 = cljs.core.seq.call(null,coll);
var inst_15296 = inst_15295;
var state_15319__$1 = (function (){var statearr_15322 = state_15319;
(statearr_15322[(7)] = inst_15296);

return statearr_15322;
})();
var statearr_15323_15349 = state_15319__$1;
(statearr_15323_15349[(2)] = null);

(statearr_15323_15349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (4))){
var inst_15296 = (state_15319[(7)]);
var inst_15299 = cljs.core.first.call(null,inst_15296);
var state_15319__$1 = state_15319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15319__$1,(7),ch,inst_15299);
} else {
if((state_val_15320 === (13))){
var inst_15313 = (state_15319[(2)]);
var state_15319__$1 = state_15319;
var statearr_15324_15350 = state_15319__$1;
(statearr_15324_15350[(2)] = inst_15313);

(statearr_15324_15350[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (6))){
var inst_15304 = (state_15319[(2)]);
var state_15319__$1 = state_15319;
if(cljs.core.truth_(inst_15304)){
var statearr_15325_15351 = state_15319__$1;
(statearr_15325_15351[(1)] = (8));

} else {
var statearr_15326_15352 = state_15319__$1;
(statearr_15326_15352[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (3))){
var inst_15317 = (state_15319[(2)]);
var state_15319__$1 = state_15319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15319__$1,inst_15317);
} else {
if((state_val_15320 === (12))){
var state_15319__$1 = state_15319;
var statearr_15327_15353 = state_15319__$1;
(statearr_15327_15353[(2)] = null);

(statearr_15327_15353[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (2))){
var inst_15296 = (state_15319[(7)]);
var state_15319__$1 = state_15319;
if(cljs.core.truth_(inst_15296)){
var statearr_15328_15354 = state_15319__$1;
(statearr_15328_15354[(1)] = (4));

} else {
var statearr_15329_15355 = state_15319__$1;
(statearr_15329_15355[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (11))){
var inst_15310 = cljs.core.async.close_BANG_.call(null,ch);
var state_15319__$1 = state_15319;
var statearr_15330_15356 = state_15319__$1;
(statearr_15330_15356[(2)] = inst_15310);

(statearr_15330_15356[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (9))){
var state_15319__$1 = state_15319;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15331_15357 = state_15319__$1;
(statearr_15331_15357[(1)] = (11));

} else {
var statearr_15332_15358 = state_15319__$1;
(statearr_15332_15358[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (5))){
var inst_15296 = (state_15319[(7)]);
var state_15319__$1 = state_15319;
var statearr_15333_15359 = state_15319__$1;
(statearr_15333_15359[(2)] = inst_15296);

(statearr_15333_15359[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (10))){
var inst_15315 = (state_15319[(2)]);
var state_15319__$1 = state_15319;
var statearr_15334_15360 = state_15319__$1;
(statearr_15334_15360[(2)] = inst_15315);

(statearr_15334_15360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15320 === (8))){
var inst_15296 = (state_15319[(7)]);
var inst_15306 = cljs.core.next.call(null,inst_15296);
var inst_15296__$1 = inst_15306;
var state_15319__$1 = (function (){var statearr_15335 = state_15319;
(statearr_15335[(7)] = inst_15296__$1);

return statearr_15335;
})();
var statearr_15336_15361 = state_15319__$1;
(statearr_15336_15361[(2)] = null);

(statearr_15336_15361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto__))
;
return ((function (switch__14236__auto__,c__14371__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15340 = [null,null,null,null,null,null,null,null];
(statearr_15340[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15340[(1)] = (1));

return statearr_15340;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15319){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15341){if((e15341 instanceof Object)){
var ex__14240__auto__ = e15341;
var statearr_15342_15362 = state_15319;
(statearr_15342_15362[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15341;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15363 = state_15319;
state_15319 = G__15363;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15319){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto__))
})();
var state__14373__auto__ = (function (){var statearr_15343 = f__14372__auto__.call(null);
(statearr_15343[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto__);

return statearr_15343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto__))
);

return c__14371__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15625 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15625 = (function (mult,ch,cs,meta15626){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15626 = meta15626;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15627,meta15626__$1){
var self__ = this;
var _15627__$1 = this;
return (new cljs.core.async.t_cljs$core$async15625(self__.mult,self__.ch,self__.cs,meta15626__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15627){
var self__ = this;
var _15627__$1 = this;
return self__.meta15626;
});})(cs))
;

cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15625.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15625.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15626","meta15626",872458636,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15625.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15625.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15625";

cljs.core.async.t_cljs$core$async15625.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15625");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15625 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15625(mult__$1,ch__$1,cs__$1,meta15626){
return (new cljs.core.async.t_cljs$core$async15625(mult__$1,ch__$1,cs__$1,meta15626));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15625(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14371__auto___15854 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___15854,cs,m,dchan,dctr,done){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___15854,cs,m,dchan,dctr,done){
return (function (state_15759){
var state_val_15760 = (state_15759[(1)]);
if((state_val_15760 === (7))){
var inst_15754 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15761_15855 = state_15759__$1;
(statearr_15761_15855[(2)] = inst_15754);

(statearr_15761_15855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (20))){
var inst_15659 = (state_15759[(7)]);
var inst_15669 = cljs.core.first.call(null,inst_15659);
var inst_15670 = cljs.core.nth.call(null,inst_15669,(0),null);
var inst_15671 = cljs.core.nth.call(null,inst_15669,(1),null);
var state_15759__$1 = (function (){var statearr_15762 = state_15759;
(statearr_15762[(8)] = inst_15670);

return statearr_15762;
})();
if(cljs.core.truth_(inst_15671)){
var statearr_15763_15856 = state_15759__$1;
(statearr_15763_15856[(1)] = (22));

} else {
var statearr_15764_15857 = state_15759__$1;
(statearr_15764_15857[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (27))){
var inst_15701 = (state_15759[(9)]);
var inst_15699 = (state_15759[(10)]);
var inst_15630 = (state_15759[(11)]);
var inst_15706 = (state_15759[(12)]);
var inst_15706__$1 = cljs.core._nth.call(null,inst_15699,inst_15701);
var inst_15707 = cljs.core.async.put_BANG_.call(null,inst_15706__$1,inst_15630,done);
var state_15759__$1 = (function (){var statearr_15765 = state_15759;
(statearr_15765[(12)] = inst_15706__$1);

return statearr_15765;
})();
if(cljs.core.truth_(inst_15707)){
var statearr_15766_15858 = state_15759__$1;
(statearr_15766_15858[(1)] = (30));

} else {
var statearr_15767_15859 = state_15759__$1;
(statearr_15767_15859[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (1))){
var state_15759__$1 = state_15759;
var statearr_15768_15860 = state_15759__$1;
(statearr_15768_15860[(2)] = null);

(statearr_15768_15860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (24))){
var inst_15659 = (state_15759[(7)]);
var inst_15676 = (state_15759[(2)]);
var inst_15677 = cljs.core.next.call(null,inst_15659);
var inst_15639 = inst_15677;
var inst_15640 = null;
var inst_15641 = (0);
var inst_15642 = (0);
var state_15759__$1 = (function (){var statearr_15769 = state_15759;
(statearr_15769[(13)] = inst_15639);

(statearr_15769[(14)] = inst_15676);

(statearr_15769[(15)] = inst_15640);

(statearr_15769[(16)] = inst_15642);

(statearr_15769[(17)] = inst_15641);

return statearr_15769;
})();
var statearr_15770_15861 = state_15759__$1;
(statearr_15770_15861[(2)] = null);

(statearr_15770_15861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (39))){
var state_15759__$1 = state_15759;
var statearr_15774_15862 = state_15759__$1;
(statearr_15774_15862[(2)] = null);

(statearr_15774_15862[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (4))){
var inst_15630 = (state_15759[(11)]);
var inst_15630__$1 = (state_15759[(2)]);
var inst_15631 = (inst_15630__$1 == null);
var state_15759__$1 = (function (){var statearr_15775 = state_15759;
(statearr_15775[(11)] = inst_15630__$1);

return statearr_15775;
})();
if(cljs.core.truth_(inst_15631)){
var statearr_15776_15867 = state_15759__$1;
(statearr_15776_15867[(1)] = (5));

} else {
var statearr_15777_15868 = state_15759__$1;
(statearr_15777_15868[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (15))){
var inst_15639 = (state_15759[(13)]);
var inst_15640 = (state_15759[(15)]);
var inst_15642 = (state_15759[(16)]);
var inst_15641 = (state_15759[(17)]);
var inst_15655 = (state_15759[(2)]);
var inst_15656 = (inst_15642 + (1));
var tmp15771 = inst_15639;
var tmp15772 = inst_15640;
var tmp15773 = inst_15641;
var inst_15639__$1 = tmp15771;
var inst_15640__$1 = tmp15772;
var inst_15641__$1 = tmp15773;
var inst_15642__$1 = inst_15656;
var state_15759__$1 = (function (){var statearr_15778 = state_15759;
(statearr_15778[(18)] = inst_15655);

(statearr_15778[(13)] = inst_15639__$1);

(statearr_15778[(15)] = inst_15640__$1);

(statearr_15778[(16)] = inst_15642__$1);

(statearr_15778[(17)] = inst_15641__$1);

return statearr_15778;
})();
var statearr_15779_15870 = state_15759__$1;
(statearr_15779_15870[(2)] = null);

(statearr_15779_15870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (21))){
var inst_15680 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15783_15871 = state_15759__$1;
(statearr_15783_15871[(2)] = inst_15680);

(statearr_15783_15871[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (31))){
var inst_15706 = (state_15759[(12)]);
var inst_15710 = done.call(null,null);
var inst_15711 = cljs.core.async.untap_STAR_.call(null,m,inst_15706);
var state_15759__$1 = (function (){var statearr_15784 = state_15759;
(statearr_15784[(19)] = inst_15710);

return statearr_15784;
})();
var statearr_15785_15872 = state_15759__$1;
(statearr_15785_15872[(2)] = inst_15711);

(statearr_15785_15872[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (32))){
var inst_15701 = (state_15759[(9)]);
var inst_15699 = (state_15759[(10)]);
var inst_15700 = (state_15759[(20)]);
var inst_15698 = (state_15759[(21)]);
var inst_15713 = (state_15759[(2)]);
var inst_15714 = (inst_15701 + (1));
var tmp15780 = inst_15699;
var tmp15781 = inst_15700;
var tmp15782 = inst_15698;
var inst_15698__$1 = tmp15782;
var inst_15699__$1 = tmp15780;
var inst_15700__$1 = tmp15781;
var inst_15701__$1 = inst_15714;
var state_15759__$1 = (function (){var statearr_15786 = state_15759;
(statearr_15786[(9)] = inst_15701__$1);

(statearr_15786[(10)] = inst_15699__$1);

(statearr_15786[(20)] = inst_15700__$1);

(statearr_15786[(22)] = inst_15713);

(statearr_15786[(21)] = inst_15698__$1);

return statearr_15786;
})();
var statearr_15787_15874 = state_15759__$1;
(statearr_15787_15874[(2)] = null);

(statearr_15787_15874[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (40))){
var inst_15726 = (state_15759[(23)]);
var inst_15730 = done.call(null,null);
var inst_15731 = cljs.core.async.untap_STAR_.call(null,m,inst_15726);
var state_15759__$1 = (function (){var statearr_15788 = state_15759;
(statearr_15788[(24)] = inst_15730);

return statearr_15788;
})();
var statearr_15789_15875 = state_15759__$1;
(statearr_15789_15875[(2)] = inst_15731);

(statearr_15789_15875[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (33))){
var inst_15717 = (state_15759[(25)]);
var inst_15719 = cljs.core.chunked_seq_QMARK_.call(null,inst_15717);
var state_15759__$1 = state_15759;
if(inst_15719){
var statearr_15790_15876 = state_15759__$1;
(statearr_15790_15876[(1)] = (36));

} else {
var statearr_15791_15877 = state_15759__$1;
(statearr_15791_15877[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (13))){
var inst_15649 = (state_15759[(26)]);
var inst_15652 = cljs.core.async.close_BANG_.call(null,inst_15649);
var state_15759__$1 = state_15759;
var statearr_15792_15881 = state_15759__$1;
(statearr_15792_15881[(2)] = inst_15652);

(statearr_15792_15881[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (22))){
var inst_15670 = (state_15759[(8)]);
var inst_15673 = cljs.core.async.close_BANG_.call(null,inst_15670);
var state_15759__$1 = state_15759;
var statearr_15793_15882 = state_15759__$1;
(statearr_15793_15882[(2)] = inst_15673);

(statearr_15793_15882[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (36))){
var inst_15717 = (state_15759[(25)]);
var inst_15721 = cljs.core.chunk_first.call(null,inst_15717);
var inst_15722 = cljs.core.chunk_rest.call(null,inst_15717);
var inst_15723 = cljs.core.count.call(null,inst_15721);
var inst_15698 = inst_15722;
var inst_15699 = inst_15721;
var inst_15700 = inst_15723;
var inst_15701 = (0);
var state_15759__$1 = (function (){var statearr_15794 = state_15759;
(statearr_15794[(9)] = inst_15701);

(statearr_15794[(10)] = inst_15699);

(statearr_15794[(20)] = inst_15700);

(statearr_15794[(21)] = inst_15698);

return statearr_15794;
})();
var statearr_15795_15884 = state_15759__$1;
(statearr_15795_15884[(2)] = null);

(statearr_15795_15884[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (41))){
var inst_15717 = (state_15759[(25)]);
var inst_15733 = (state_15759[(2)]);
var inst_15734 = cljs.core.next.call(null,inst_15717);
var inst_15698 = inst_15734;
var inst_15699 = null;
var inst_15700 = (0);
var inst_15701 = (0);
var state_15759__$1 = (function (){var statearr_15796 = state_15759;
(statearr_15796[(9)] = inst_15701);

(statearr_15796[(10)] = inst_15699);

(statearr_15796[(20)] = inst_15700);

(statearr_15796[(27)] = inst_15733);

(statearr_15796[(21)] = inst_15698);

return statearr_15796;
})();
var statearr_15797_15885 = state_15759__$1;
(statearr_15797_15885[(2)] = null);

(statearr_15797_15885[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (43))){
var state_15759__$1 = state_15759;
var statearr_15798_15886 = state_15759__$1;
(statearr_15798_15886[(2)] = null);

(statearr_15798_15886[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (29))){
var inst_15742 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15799_15887 = state_15759__$1;
(statearr_15799_15887[(2)] = inst_15742);

(statearr_15799_15887[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (44))){
var inst_15751 = (state_15759[(2)]);
var state_15759__$1 = (function (){var statearr_15800 = state_15759;
(statearr_15800[(28)] = inst_15751);

return statearr_15800;
})();
var statearr_15801_15888 = state_15759__$1;
(statearr_15801_15888[(2)] = null);

(statearr_15801_15888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (6))){
var inst_15690 = (state_15759[(29)]);
var inst_15689 = cljs.core.deref.call(null,cs);
var inst_15690__$1 = cljs.core.keys.call(null,inst_15689);
var inst_15691 = cljs.core.count.call(null,inst_15690__$1);
var inst_15692 = cljs.core.reset_BANG_.call(null,dctr,inst_15691);
var inst_15697 = cljs.core.seq.call(null,inst_15690__$1);
var inst_15698 = inst_15697;
var inst_15699 = null;
var inst_15700 = (0);
var inst_15701 = (0);
var state_15759__$1 = (function (){var statearr_15802 = state_15759;
(statearr_15802[(9)] = inst_15701);

(statearr_15802[(10)] = inst_15699);

(statearr_15802[(20)] = inst_15700);

(statearr_15802[(30)] = inst_15692);

(statearr_15802[(29)] = inst_15690__$1);

(statearr_15802[(21)] = inst_15698);

return statearr_15802;
})();
var statearr_15803_15889 = state_15759__$1;
(statearr_15803_15889[(2)] = null);

(statearr_15803_15889[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (28))){
var inst_15717 = (state_15759[(25)]);
var inst_15698 = (state_15759[(21)]);
var inst_15717__$1 = cljs.core.seq.call(null,inst_15698);
var state_15759__$1 = (function (){var statearr_15804 = state_15759;
(statearr_15804[(25)] = inst_15717__$1);

return statearr_15804;
})();
if(inst_15717__$1){
var statearr_15805_15890 = state_15759__$1;
(statearr_15805_15890[(1)] = (33));

} else {
var statearr_15806_15891 = state_15759__$1;
(statearr_15806_15891[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (25))){
var inst_15701 = (state_15759[(9)]);
var inst_15700 = (state_15759[(20)]);
var inst_15703 = (inst_15701 < inst_15700);
var inst_15704 = inst_15703;
var state_15759__$1 = state_15759;
if(cljs.core.truth_(inst_15704)){
var statearr_15807_15892 = state_15759__$1;
(statearr_15807_15892[(1)] = (27));

} else {
var statearr_15808_15893 = state_15759__$1;
(statearr_15808_15893[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (34))){
var state_15759__$1 = state_15759;
var statearr_15809_15894 = state_15759__$1;
(statearr_15809_15894[(2)] = null);

(statearr_15809_15894[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (17))){
var state_15759__$1 = state_15759;
var statearr_15810_15895 = state_15759__$1;
(statearr_15810_15895[(2)] = null);

(statearr_15810_15895[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (3))){
var inst_15756 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15759__$1,inst_15756);
} else {
if((state_val_15760 === (12))){
var inst_15685 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15811_15896 = state_15759__$1;
(statearr_15811_15896[(2)] = inst_15685);

(statearr_15811_15896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (2))){
var state_15759__$1 = state_15759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15759__$1,(4),ch);
} else {
if((state_val_15760 === (23))){
var state_15759__$1 = state_15759;
var statearr_15812_15897 = state_15759__$1;
(statearr_15812_15897[(2)] = null);

(statearr_15812_15897[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (35))){
var inst_15740 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15813_15898 = state_15759__$1;
(statearr_15813_15898[(2)] = inst_15740);

(statearr_15813_15898[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (19))){
var inst_15659 = (state_15759[(7)]);
var inst_15663 = cljs.core.chunk_first.call(null,inst_15659);
var inst_15664 = cljs.core.chunk_rest.call(null,inst_15659);
var inst_15665 = cljs.core.count.call(null,inst_15663);
var inst_15639 = inst_15664;
var inst_15640 = inst_15663;
var inst_15641 = inst_15665;
var inst_15642 = (0);
var state_15759__$1 = (function (){var statearr_15814 = state_15759;
(statearr_15814[(13)] = inst_15639);

(statearr_15814[(15)] = inst_15640);

(statearr_15814[(16)] = inst_15642);

(statearr_15814[(17)] = inst_15641);

return statearr_15814;
})();
var statearr_15815_15899 = state_15759__$1;
(statearr_15815_15899[(2)] = null);

(statearr_15815_15899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (11))){
var inst_15659 = (state_15759[(7)]);
var inst_15639 = (state_15759[(13)]);
var inst_15659__$1 = cljs.core.seq.call(null,inst_15639);
var state_15759__$1 = (function (){var statearr_15816 = state_15759;
(statearr_15816[(7)] = inst_15659__$1);

return statearr_15816;
})();
if(inst_15659__$1){
var statearr_15817_15900 = state_15759__$1;
(statearr_15817_15900[(1)] = (16));

} else {
var statearr_15818_15901 = state_15759__$1;
(statearr_15818_15901[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (9))){
var inst_15687 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15819_15902 = state_15759__$1;
(statearr_15819_15902[(2)] = inst_15687);

(statearr_15819_15902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (5))){
var inst_15637 = cljs.core.deref.call(null,cs);
var inst_15638 = cljs.core.seq.call(null,inst_15637);
var inst_15639 = inst_15638;
var inst_15640 = null;
var inst_15641 = (0);
var inst_15642 = (0);
var state_15759__$1 = (function (){var statearr_15820 = state_15759;
(statearr_15820[(13)] = inst_15639);

(statearr_15820[(15)] = inst_15640);

(statearr_15820[(16)] = inst_15642);

(statearr_15820[(17)] = inst_15641);

return statearr_15820;
})();
var statearr_15821_15903 = state_15759__$1;
(statearr_15821_15903[(2)] = null);

(statearr_15821_15903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (14))){
var state_15759__$1 = state_15759;
var statearr_15822_15904 = state_15759__$1;
(statearr_15822_15904[(2)] = null);

(statearr_15822_15904[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (45))){
var inst_15748 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15823_15905 = state_15759__$1;
(statearr_15823_15905[(2)] = inst_15748);

(statearr_15823_15905[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (26))){
var inst_15690 = (state_15759[(29)]);
var inst_15744 = (state_15759[(2)]);
var inst_15745 = cljs.core.seq.call(null,inst_15690);
var state_15759__$1 = (function (){var statearr_15824 = state_15759;
(statearr_15824[(31)] = inst_15744);

return statearr_15824;
})();
if(inst_15745){
var statearr_15825_15908 = state_15759__$1;
(statearr_15825_15908[(1)] = (42));

} else {
var statearr_15826_15909 = state_15759__$1;
(statearr_15826_15909[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (16))){
var inst_15659 = (state_15759[(7)]);
var inst_15661 = cljs.core.chunked_seq_QMARK_.call(null,inst_15659);
var state_15759__$1 = state_15759;
if(inst_15661){
var statearr_15827_15910 = state_15759__$1;
(statearr_15827_15910[(1)] = (19));

} else {
var statearr_15828_15911 = state_15759__$1;
(statearr_15828_15911[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (38))){
var inst_15737 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15829_15912 = state_15759__$1;
(statearr_15829_15912[(2)] = inst_15737);

(statearr_15829_15912[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (30))){
var state_15759__$1 = state_15759;
var statearr_15830_15913 = state_15759__$1;
(statearr_15830_15913[(2)] = null);

(statearr_15830_15913[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (10))){
var inst_15640 = (state_15759[(15)]);
var inst_15642 = (state_15759[(16)]);
var inst_15648 = cljs.core._nth.call(null,inst_15640,inst_15642);
var inst_15649 = cljs.core.nth.call(null,inst_15648,(0),null);
var inst_15650 = cljs.core.nth.call(null,inst_15648,(1),null);
var state_15759__$1 = (function (){var statearr_15831 = state_15759;
(statearr_15831[(26)] = inst_15649);

return statearr_15831;
})();
if(cljs.core.truth_(inst_15650)){
var statearr_15832_15914 = state_15759__$1;
(statearr_15832_15914[(1)] = (13));

} else {
var statearr_15833_15915 = state_15759__$1;
(statearr_15833_15915[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (18))){
var inst_15683 = (state_15759[(2)]);
var state_15759__$1 = state_15759;
var statearr_15834_15916 = state_15759__$1;
(statearr_15834_15916[(2)] = inst_15683);

(statearr_15834_15916[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (42))){
var state_15759__$1 = state_15759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15759__$1,(45),dchan);
} else {
if((state_val_15760 === (37))){
var inst_15630 = (state_15759[(11)]);
var inst_15726 = (state_15759[(23)]);
var inst_15717 = (state_15759[(25)]);
var inst_15726__$1 = cljs.core.first.call(null,inst_15717);
var inst_15727 = cljs.core.async.put_BANG_.call(null,inst_15726__$1,inst_15630,done);
var state_15759__$1 = (function (){var statearr_15835 = state_15759;
(statearr_15835[(23)] = inst_15726__$1);

return statearr_15835;
})();
if(cljs.core.truth_(inst_15727)){
var statearr_15836_15921 = state_15759__$1;
(statearr_15836_15921[(1)] = (39));

} else {
var statearr_15837_15922 = state_15759__$1;
(statearr_15837_15922[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15760 === (8))){
var inst_15642 = (state_15759[(16)]);
var inst_15641 = (state_15759[(17)]);
var inst_15644 = (inst_15642 < inst_15641);
var inst_15645 = inst_15644;
var state_15759__$1 = state_15759;
if(cljs.core.truth_(inst_15645)){
var statearr_15838_15926 = state_15759__$1;
(statearr_15838_15926[(1)] = (10));

} else {
var statearr_15839_15927 = state_15759__$1;
(statearr_15839_15927[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___15854,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14371__auto___15854,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15843[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15843[(1)] = (1));

return statearr_15843;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15759){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15759);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15844){if((e15844 instanceof Object)){
var ex__14240__auto__ = e15844;
var statearr_15845_15928 = state_15759;
(statearr_15845_15928[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15759);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15844;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15931 = state_15759;
state_15759 = G__15931;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15759){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___15854,cs,m,dchan,dctr,done))
})();
var state__14373__auto__ = (function (){var statearr_15846 = f__14372__auto__.call(null);
(statearr_15846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___15854);

return statearr_15846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___15854,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15933 = [];
var len__7107__auto___15937 = arguments.length;
var i__7108__auto___15938 = (0);
while(true){
if((i__7108__auto___15938 < len__7107__auto___15937)){
args15933.push((arguments[i__7108__auto___15938]));

var G__15939 = (i__7108__auto___15938 + (1));
i__7108__auto___15938 = G__15939;
continue;
} else {
}
break;
}

var G__15936 = args15933.length;
switch (G__15936) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15933.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___15960 = arguments.length;
var i__7108__auto___15961 = (0);
while(true){
if((i__7108__auto___15961 < len__7107__auto___15960)){
args__7114__auto__.push((arguments[i__7108__auto___15961]));

var G__15962 = (i__7108__auto___15961 + (1));
i__7108__auto___15961 = G__15962;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15953){
var map__15954 = p__15953;
var map__15954__$1 = ((((!((map__15954 == null)))?((((map__15954.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15954.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15954):map__15954);
var opts = map__15954__$1;
var statearr_15957_15964 = state;
(statearr_15957_15964[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15954,map__15954__$1,opts){
return (function (val){
var statearr_15958_15965 = state;
(statearr_15958_15965[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15954,map__15954__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15959_15966 = state;
(statearr_15959_15966[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15945){
var G__15946 = cljs.core.first.call(null,seq15945);
var seq15945__$1 = cljs.core.next.call(null,seq15945);
var G__15947 = cljs.core.first.call(null,seq15945__$1);
var seq15945__$2 = cljs.core.next.call(null,seq15945__$1);
var G__15948 = cljs.core.first.call(null,seq15945__$2);
var seq15945__$3 = cljs.core.next.call(null,seq15945__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15946,G__15947,G__15948,seq15945__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16134 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16134 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16135){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16135 = meta16135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16136,meta16135__$1){
var self__ = this;
var _16136__$1 = this;
return (new cljs.core.async.t_cljs$core$async16134(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16135__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16136){
var self__ = this;
var _16136__$1 = this;
return self__.meta16135;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16135","meta16135",322546943,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16134.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16134";

cljs.core.async.t_cljs$core$async16134.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16134");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16134 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16134(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16135){
return (new cljs.core.async.t_cljs$core$async16134(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16135));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16134(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14371__auto___16324 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___16324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___16324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16243){
var state_val_16244 = (state_16243[(1)]);
if((state_val_16244 === (7))){
var inst_16152 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
var statearr_16245_16325 = state_16243__$1;
(statearr_16245_16325[(2)] = inst_16152);

(statearr_16245_16325[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (20))){
var inst_16164 = (state_16243[(7)]);
var state_16243__$1 = state_16243;
var statearr_16246_16326 = state_16243__$1;
(statearr_16246_16326[(2)] = inst_16164);

(statearr_16246_16326[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (27))){
var state_16243__$1 = state_16243;
var statearr_16247_16327 = state_16243__$1;
(statearr_16247_16327[(2)] = null);

(statearr_16247_16327[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (1))){
var inst_16140 = (state_16243[(8)]);
var inst_16140__$1 = calc_state.call(null);
var inst_16142 = (inst_16140__$1 == null);
var inst_16143 = cljs.core.not.call(null,inst_16142);
var state_16243__$1 = (function (){var statearr_16248 = state_16243;
(statearr_16248[(8)] = inst_16140__$1);

return statearr_16248;
})();
if(inst_16143){
var statearr_16249_16328 = state_16243__$1;
(statearr_16249_16328[(1)] = (2));

} else {
var statearr_16250_16329 = state_16243__$1;
(statearr_16250_16329[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (24))){
var inst_16212 = (state_16243[(9)]);
var inst_16187 = (state_16243[(10)]);
var inst_16194 = (state_16243[(11)]);
var inst_16212__$1 = inst_16187.call(null,inst_16194);
var state_16243__$1 = (function (){var statearr_16252 = state_16243;
(statearr_16252[(9)] = inst_16212__$1);

return statearr_16252;
})();
if(cljs.core.truth_(inst_16212__$1)){
var statearr_16253_16330 = state_16243__$1;
(statearr_16253_16330[(1)] = (29));

} else {
var statearr_16254_16331 = state_16243__$1;
(statearr_16254_16331[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (4))){
var inst_16155 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
if(cljs.core.truth_(inst_16155)){
var statearr_16255_16332 = state_16243__$1;
(statearr_16255_16332[(1)] = (8));

} else {
var statearr_16256_16333 = state_16243__$1;
(statearr_16256_16333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (15))){
var inst_16181 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
if(cljs.core.truth_(inst_16181)){
var statearr_16257_16334 = state_16243__$1;
(statearr_16257_16334[(1)] = (19));

} else {
var statearr_16258_16335 = state_16243__$1;
(statearr_16258_16335[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (21))){
var inst_16186 = (state_16243[(12)]);
var inst_16186__$1 = (state_16243[(2)]);
var inst_16187 = cljs.core.get.call(null,inst_16186__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16188 = cljs.core.get.call(null,inst_16186__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16189 = cljs.core.get.call(null,inst_16186__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16243__$1 = (function (){var statearr_16259 = state_16243;
(statearr_16259[(12)] = inst_16186__$1);

(statearr_16259[(10)] = inst_16187);

(statearr_16259[(13)] = inst_16188);

return statearr_16259;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16243__$1,(22),inst_16189);
} else {
if((state_val_16244 === (31))){
var inst_16220 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
if(cljs.core.truth_(inst_16220)){
var statearr_16260_16336 = state_16243__$1;
(statearr_16260_16336[(1)] = (32));

} else {
var statearr_16261_16337 = state_16243__$1;
(statearr_16261_16337[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (32))){
var inst_16193 = (state_16243[(14)]);
var state_16243__$1 = state_16243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16243__$1,(35),out,inst_16193);
} else {
if((state_val_16244 === (33))){
var inst_16186 = (state_16243[(12)]);
var inst_16164 = inst_16186;
var state_16243__$1 = (function (){var statearr_16262 = state_16243;
(statearr_16262[(7)] = inst_16164);

return statearr_16262;
})();
var statearr_16263_16338 = state_16243__$1;
(statearr_16263_16338[(2)] = null);

(statearr_16263_16338[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (13))){
var inst_16164 = (state_16243[(7)]);
var inst_16171 = inst_16164.cljs$lang$protocol_mask$partition0$;
var inst_16172 = (inst_16171 & (64));
var inst_16173 = inst_16164.cljs$core$ISeq$;
var inst_16174 = (inst_16172) || (inst_16173);
var state_16243__$1 = state_16243;
if(cljs.core.truth_(inst_16174)){
var statearr_16264_16339 = state_16243__$1;
(statearr_16264_16339[(1)] = (16));

} else {
var statearr_16265_16340 = state_16243__$1;
(statearr_16265_16340[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (22))){
var inst_16193 = (state_16243[(14)]);
var inst_16194 = (state_16243[(11)]);
var inst_16192 = (state_16243[(2)]);
var inst_16193__$1 = cljs.core.nth.call(null,inst_16192,(0),null);
var inst_16194__$1 = cljs.core.nth.call(null,inst_16192,(1),null);
var inst_16195 = (inst_16193__$1 == null);
var inst_16196 = cljs.core._EQ_.call(null,inst_16194__$1,change);
var inst_16197 = (inst_16195) || (inst_16196);
var state_16243__$1 = (function (){var statearr_16266 = state_16243;
(statearr_16266[(14)] = inst_16193__$1);

(statearr_16266[(11)] = inst_16194__$1);

return statearr_16266;
})();
if(cljs.core.truth_(inst_16197)){
var statearr_16267_16342 = state_16243__$1;
(statearr_16267_16342[(1)] = (23));

} else {
var statearr_16268_16343 = state_16243__$1;
(statearr_16268_16343[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (36))){
var inst_16186 = (state_16243[(12)]);
var inst_16164 = inst_16186;
var state_16243__$1 = (function (){var statearr_16269 = state_16243;
(statearr_16269[(7)] = inst_16164);

return statearr_16269;
})();
var statearr_16270_16346 = state_16243__$1;
(statearr_16270_16346[(2)] = null);

(statearr_16270_16346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (29))){
var inst_16212 = (state_16243[(9)]);
var state_16243__$1 = state_16243;
var statearr_16271_16348 = state_16243__$1;
(statearr_16271_16348[(2)] = inst_16212);

(statearr_16271_16348[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (6))){
var state_16243__$1 = state_16243;
var statearr_16272_16349 = state_16243__$1;
(statearr_16272_16349[(2)] = false);

(statearr_16272_16349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (28))){
var inst_16206 = (state_16243[(2)]);
var inst_16207 = calc_state.call(null);
var inst_16164 = inst_16207;
var state_16243__$1 = (function (){var statearr_16273 = state_16243;
(statearr_16273[(7)] = inst_16164);

(statearr_16273[(15)] = inst_16206);

return statearr_16273;
})();
var statearr_16274_16354 = state_16243__$1;
(statearr_16274_16354[(2)] = null);

(statearr_16274_16354[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (25))){
var inst_16235 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
var statearr_16275_16355 = state_16243__$1;
(statearr_16275_16355[(2)] = inst_16235);

(statearr_16275_16355[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (34))){
var inst_16233 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
var statearr_16276_16357 = state_16243__$1;
(statearr_16276_16357[(2)] = inst_16233);

(statearr_16276_16357[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (17))){
var state_16243__$1 = state_16243;
var statearr_16277_16358 = state_16243__$1;
(statearr_16277_16358[(2)] = false);

(statearr_16277_16358[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (3))){
var state_16243__$1 = state_16243;
var statearr_16278_16359 = state_16243__$1;
(statearr_16278_16359[(2)] = false);

(statearr_16278_16359[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (12))){
var inst_16237 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16243__$1,inst_16237);
} else {
if((state_val_16244 === (2))){
var inst_16140 = (state_16243[(8)]);
var inst_16145 = inst_16140.cljs$lang$protocol_mask$partition0$;
var inst_16146 = (inst_16145 & (64));
var inst_16147 = inst_16140.cljs$core$ISeq$;
var inst_16148 = (inst_16146) || (inst_16147);
var state_16243__$1 = state_16243;
if(cljs.core.truth_(inst_16148)){
var statearr_16279_16360 = state_16243__$1;
(statearr_16279_16360[(1)] = (5));

} else {
var statearr_16280_16361 = state_16243__$1;
(statearr_16280_16361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (23))){
var inst_16193 = (state_16243[(14)]);
var inst_16199 = (inst_16193 == null);
var state_16243__$1 = state_16243;
if(cljs.core.truth_(inst_16199)){
var statearr_16281_16365 = state_16243__$1;
(statearr_16281_16365[(1)] = (26));

} else {
var statearr_16282_16366 = state_16243__$1;
(statearr_16282_16366[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (35))){
var inst_16224 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
if(cljs.core.truth_(inst_16224)){
var statearr_16283_16367 = state_16243__$1;
(statearr_16283_16367[(1)] = (36));

} else {
var statearr_16284_16368 = state_16243__$1;
(statearr_16284_16368[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (19))){
var inst_16164 = (state_16243[(7)]);
var inst_16183 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16164);
var state_16243__$1 = state_16243;
var statearr_16285_16369 = state_16243__$1;
(statearr_16285_16369[(2)] = inst_16183);

(statearr_16285_16369[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (11))){
var inst_16164 = (state_16243[(7)]);
var inst_16168 = (inst_16164 == null);
var inst_16169 = cljs.core.not.call(null,inst_16168);
var state_16243__$1 = state_16243;
if(inst_16169){
var statearr_16286_16370 = state_16243__$1;
(statearr_16286_16370[(1)] = (13));

} else {
var statearr_16287_16371 = state_16243__$1;
(statearr_16287_16371[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (9))){
var inst_16140 = (state_16243[(8)]);
var state_16243__$1 = state_16243;
var statearr_16288_16372 = state_16243__$1;
(statearr_16288_16372[(2)] = inst_16140);

(statearr_16288_16372[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (5))){
var state_16243__$1 = state_16243;
var statearr_16289_16374 = state_16243__$1;
(statearr_16289_16374[(2)] = true);

(statearr_16289_16374[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (14))){
var state_16243__$1 = state_16243;
var statearr_16290_16375 = state_16243__$1;
(statearr_16290_16375[(2)] = false);

(statearr_16290_16375[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (26))){
var inst_16194 = (state_16243[(11)]);
var inst_16203 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16194);
var state_16243__$1 = state_16243;
var statearr_16291_16376 = state_16243__$1;
(statearr_16291_16376[(2)] = inst_16203);

(statearr_16291_16376[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (16))){
var state_16243__$1 = state_16243;
var statearr_16292_16377 = state_16243__$1;
(statearr_16292_16377[(2)] = true);

(statearr_16292_16377[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (38))){
var inst_16229 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
var statearr_16293_16378 = state_16243__$1;
(statearr_16293_16378[(2)] = inst_16229);

(statearr_16293_16378[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (30))){
var inst_16187 = (state_16243[(10)]);
var inst_16188 = (state_16243[(13)]);
var inst_16194 = (state_16243[(11)]);
var inst_16215 = cljs.core.empty_QMARK_.call(null,inst_16187);
var inst_16216 = inst_16188.call(null,inst_16194);
var inst_16217 = cljs.core.not.call(null,inst_16216);
var inst_16218 = (inst_16215) && (inst_16217);
var state_16243__$1 = state_16243;
var statearr_16294_16379 = state_16243__$1;
(statearr_16294_16379[(2)] = inst_16218);

(statearr_16294_16379[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (10))){
var inst_16140 = (state_16243[(8)]);
var inst_16160 = (state_16243[(2)]);
var inst_16161 = cljs.core.get.call(null,inst_16160,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16162 = cljs.core.get.call(null,inst_16160,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16163 = cljs.core.get.call(null,inst_16160,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16164 = inst_16140;
var state_16243__$1 = (function (){var statearr_16295 = state_16243;
(statearr_16295[(16)] = inst_16162);

(statearr_16295[(7)] = inst_16164);

(statearr_16295[(17)] = inst_16161);

(statearr_16295[(18)] = inst_16163);

return statearr_16295;
})();
var statearr_16296_16380 = state_16243__$1;
(statearr_16296_16380[(2)] = null);

(statearr_16296_16380[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (18))){
var inst_16178 = (state_16243[(2)]);
var state_16243__$1 = state_16243;
var statearr_16297_16381 = state_16243__$1;
(statearr_16297_16381[(2)] = inst_16178);

(statearr_16297_16381[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (37))){
var state_16243__$1 = state_16243;
var statearr_16298_16382 = state_16243__$1;
(statearr_16298_16382[(2)] = null);

(statearr_16298_16382[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16244 === (8))){
var inst_16140 = (state_16243[(8)]);
var inst_16157 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16140);
var state_16243__$1 = state_16243;
var statearr_16299_16383 = state_16243__$1;
(statearr_16299_16383[(2)] = inst_16157);

(statearr_16299_16383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___16324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14371__auto___16324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16305 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16305[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16305[(1)] = (1));

return statearr_16305;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16243){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16306){if((e16306 instanceof Object)){
var ex__14240__auto__ = e16306;
var statearr_16307_16386 = state_16243;
(statearr_16307_16386[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16387 = state_16243;
state_16243 = G__16387;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16243){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___16324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14373__auto__ = (function (){var statearr_16308 = f__14372__auto__.call(null);
(statearr_16308[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___16324);

return statearr_16308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___16324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16393 = [];
var len__7107__auto___16405 = arguments.length;
var i__7108__auto___16406 = (0);
while(true){
if((i__7108__auto___16406 < len__7107__auto___16405)){
args16393.push((arguments[i__7108__auto___16406]));

var G__16407 = (i__7108__auto___16406 + (1));
i__7108__auto___16406 = G__16407;
continue;
} else {
}
break;
}

var G__16395 = args16393.length;
switch (G__16395) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16393.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16411 = [];
var len__7107__auto___16551 = arguments.length;
var i__7108__auto___16552 = (0);
while(true){
if((i__7108__auto___16552 < len__7107__auto___16551)){
args16411.push((arguments[i__7108__auto___16552]));

var G__16553 = (i__7108__auto___16552 + (1));
i__7108__auto___16552 = G__16553;
continue;
} else {
}
break;
}

var G__16415 = args16411.length;
switch (G__16415) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16411.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16410_SHARP_){
if(cljs.core.truth_(p1__16410_SHARP_.call(null,topic))){
return p1__16410_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16410_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16421 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16422){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16422 = meta16422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16423,meta16422__$1){
var self__ = this;
var _16423__$1 = this;
return (new cljs.core.async.t_cljs$core$async16421(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16422__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16423){
var self__ = this;
var _16423__$1 = this;
return self__.meta16422;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16422","meta16422",1612709001,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16421";

cljs.core.async.t_cljs$core$async16421.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16421");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16421 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16421(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16422){
return (new cljs.core.async.t_cljs$core$async16421(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16422));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16421(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14371__auto___16555 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___16555,mults,ensure_mult,p){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___16555,mults,ensure_mult,p){
return (function (state_16498){
var state_val_16499 = (state_16498[(1)]);
if((state_val_16499 === (7))){
var inst_16494 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
var statearr_16501_16556 = state_16498__$1;
(statearr_16501_16556[(2)] = inst_16494);

(statearr_16501_16556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (20))){
var state_16498__$1 = state_16498;
var statearr_16502_16557 = state_16498__$1;
(statearr_16502_16557[(2)] = null);

(statearr_16502_16557[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (1))){
var state_16498__$1 = state_16498;
var statearr_16503_16558 = state_16498__$1;
(statearr_16503_16558[(2)] = null);

(statearr_16503_16558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (24))){
var inst_16477 = (state_16498[(7)]);
var inst_16486 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16477);
var state_16498__$1 = state_16498;
var statearr_16504_16559 = state_16498__$1;
(statearr_16504_16559[(2)] = inst_16486);

(statearr_16504_16559[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (4))){
var inst_16429 = (state_16498[(8)]);
var inst_16429__$1 = (state_16498[(2)]);
var inst_16430 = (inst_16429__$1 == null);
var state_16498__$1 = (function (){var statearr_16505 = state_16498;
(statearr_16505[(8)] = inst_16429__$1);

return statearr_16505;
})();
if(cljs.core.truth_(inst_16430)){
var statearr_16506_16560 = state_16498__$1;
(statearr_16506_16560[(1)] = (5));

} else {
var statearr_16507_16561 = state_16498__$1;
(statearr_16507_16561[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (15))){
var inst_16471 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
var statearr_16508_16566 = state_16498__$1;
(statearr_16508_16566[(2)] = inst_16471);

(statearr_16508_16566[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (21))){
var inst_16491 = (state_16498[(2)]);
var state_16498__$1 = (function (){var statearr_16509 = state_16498;
(statearr_16509[(9)] = inst_16491);

return statearr_16509;
})();
var statearr_16510_16568 = state_16498__$1;
(statearr_16510_16568[(2)] = null);

(statearr_16510_16568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (13))){
var inst_16453 = (state_16498[(10)]);
var inst_16455 = cljs.core.chunked_seq_QMARK_.call(null,inst_16453);
var state_16498__$1 = state_16498;
if(inst_16455){
var statearr_16511_16569 = state_16498__$1;
(statearr_16511_16569[(1)] = (16));

} else {
var statearr_16512_16570 = state_16498__$1;
(statearr_16512_16570[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (22))){
var inst_16483 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
if(cljs.core.truth_(inst_16483)){
var statearr_16513_16571 = state_16498__$1;
(statearr_16513_16571[(1)] = (23));

} else {
var statearr_16514_16572 = state_16498__$1;
(statearr_16514_16572[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (6))){
var inst_16479 = (state_16498[(11)]);
var inst_16477 = (state_16498[(7)]);
var inst_16429 = (state_16498[(8)]);
var inst_16477__$1 = topic_fn.call(null,inst_16429);
var inst_16478 = cljs.core.deref.call(null,mults);
var inst_16479__$1 = cljs.core.get.call(null,inst_16478,inst_16477__$1);
var state_16498__$1 = (function (){var statearr_16515 = state_16498;
(statearr_16515[(11)] = inst_16479__$1);

(statearr_16515[(7)] = inst_16477__$1);

return statearr_16515;
})();
if(cljs.core.truth_(inst_16479__$1)){
var statearr_16516_16576 = state_16498__$1;
(statearr_16516_16576[(1)] = (19));

} else {
var statearr_16517_16577 = state_16498__$1;
(statearr_16517_16577[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (25))){
var inst_16488 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
var statearr_16518_16578 = state_16498__$1;
(statearr_16518_16578[(2)] = inst_16488);

(statearr_16518_16578[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (17))){
var inst_16453 = (state_16498[(10)]);
var inst_16462 = cljs.core.first.call(null,inst_16453);
var inst_16463 = cljs.core.async.muxch_STAR_.call(null,inst_16462);
var inst_16464 = cljs.core.async.close_BANG_.call(null,inst_16463);
var inst_16465 = cljs.core.next.call(null,inst_16453);
var inst_16439 = inst_16465;
var inst_16440 = null;
var inst_16441 = (0);
var inst_16442 = (0);
var state_16498__$1 = (function (){var statearr_16519 = state_16498;
(statearr_16519[(12)] = inst_16442);

(statearr_16519[(13)] = inst_16441);

(statearr_16519[(14)] = inst_16439);

(statearr_16519[(15)] = inst_16440);

(statearr_16519[(16)] = inst_16464);

return statearr_16519;
})();
var statearr_16520_16580 = state_16498__$1;
(statearr_16520_16580[(2)] = null);

(statearr_16520_16580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (3))){
var inst_16496 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16498__$1,inst_16496);
} else {
if((state_val_16499 === (12))){
var inst_16473 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
var statearr_16521_16581 = state_16498__$1;
(statearr_16521_16581[(2)] = inst_16473);

(statearr_16521_16581[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (2))){
var state_16498__$1 = state_16498;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16498__$1,(4),ch);
} else {
if((state_val_16499 === (23))){
var state_16498__$1 = state_16498;
var statearr_16522_16582 = state_16498__$1;
(statearr_16522_16582[(2)] = null);

(statearr_16522_16582[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (19))){
var inst_16479 = (state_16498[(11)]);
var inst_16429 = (state_16498[(8)]);
var inst_16481 = cljs.core.async.muxch_STAR_.call(null,inst_16479);
var state_16498__$1 = state_16498;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16498__$1,(22),inst_16481,inst_16429);
} else {
if((state_val_16499 === (11))){
var inst_16453 = (state_16498[(10)]);
var inst_16439 = (state_16498[(14)]);
var inst_16453__$1 = cljs.core.seq.call(null,inst_16439);
var state_16498__$1 = (function (){var statearr_16523 = state_16498;
(statearr_16523[(10)] = inst_16453__$1);

return statearr_16523;
})();
if(inst_16453__$1){
var statearr_16524_16583 = state_16498__$1;
(statearr_16524_16583[(1)] = (13));

} else {
var statearr_16525_16584 = state_16498__$1;
(statearr_16525_16584[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (9))){
var inst_16475 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
var statearr_16526_16585 = state_16498__$1;
(statearr_16526_16585[(2)] = inst_16475);

(statearr_16526_16585[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (5))){
var inst_16436 = cljs.core.deref.call(null,mults);
var inst_16437 = cljs.core.vals.call(null,inst_16436);
var inst_16438 = cljs.core.seq.call(null,inst_16437);
var inst_16439 = inst_16438;
var inst_16440 = null;
var inst_16441 = (0);
var inst_16442 = (0);
var state_16498__$1 = (function (){var statearr_16530 = state_16498;
(statearr_16530[(12)] = inst_16442);

(statearr_16530[(13)] = inst_16441);

(statearr_16530[(14)] = inst_16439);

(statearr_16530[(15)] = inst_16440);

return statearr_16530;
})();
var statearr_16531_16586 = state_16498__$1;
(statearr_16531_16586[(2)] = null);

(statearr_16531_16586[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (14))){
var state_16498__$1 = state_16498;
var statearr_16535_16587 = state_16498__$1;
(statearr_16535_16587[(2)] = null);

(statearr_16535_16587[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (16))){
var inst_16453 = (state_16498[(10)]);
var inst_16457 = cljs.core.chunk_first.call(null,inst_16453);
var inst_16458 = cljs.core.chunk_rest.call(null,inst_16453);
var inst_16459 = cljs.core.count.call(null,inst_16457);
var inst_16439 = inst_16458;
var inst_16440 = inst_16457;
var inst_16441 = inst_16459;
var inst_16442 = (0);
var state_16498__$1 = (function (){var statearr_16536 = state_16498;
(statearr_16536[(12)] = inst_16442);

(statearr_16536[(13)] = inst_16441);

(statearr_16536[(14)] = inst_16439);

(statearr_16536[(15)] = inst_16440);

return statearr_16536;
})();
var statearr_16537_16588 = state_16498__$1;
(statearr_16537_16588[(2)] = null);

(statearr_16537_16588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (10))){
var inst_16442 = (state_16498[(12)]);
var inst_16441 = (state_16498[(13)]);
var inst_16439 = (state_16498[(14)]);
var inst_16440 = (state_16498[(15)]);
var inst_16447 = cljs.core._nth.call(null,inst_16440,inst_16442);
var inst_16448 = cljs.core.async.muxch_STAR_.call(null,inst_16447);
var inst_16449 = cljs.core.async.close_BANG_.call(null,inst_16448);
var inst_16450 = (inst_16442 + (1));
var tmp16532 = inst_16441;
var tmp16533 = inst_16439;
var tmp16534 = inst_16440;
var inst_16439__$1 = tmp16533;
var inst_16440__$1 = tmp16534;
var inst_16441__$1 = tmp16532;
var inst_16442__$1 = inst_16450;
var state_16498__$1 = (function (){var statearr_16538 = state_16498;
(statearr_16538[(12)] = inst_16442__$1);

(statearr_16538[(13)] = inst_16441__$1);

(statearr_16538[(14)] = inst_16439__$1);

(statearr_16538[(17)] = inst_16449);

(statearr_16538[(15)] = inst_16440__$1);

return statearr_16538;
})();
var statearr_16539_16589 = state_16498__$1;
(statearr_16539_16589[(2)] = null);

(statearr_16539_16589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (18))){
var inst_16468 = (state_16498[(2)]);
var state_16498__$1 = state_16498;
var statearr_16540_16590 = state_16498__$1;
(statearr_16540_16590[(2)] = inst_16468);

(statearr_16540_16590[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16499 === (8))){
var inst_16442 = (state_16498[(12)]);
var inst_16441 = (state_16498[(13)]);
var inst_16444 = (inst_16442 < inst_16441);
var inst_16445 = inst_16444;
var state_16498__$1 = state_16498;
if(cljs.core.truth_(inst_16445)){
var statearr_16541_16591 = state_16498__$1;
(statearr_16541_16591[(1)] = (10));

} else {
var statearr_16542_16595 = state_16498__$1;
(statearr_16542_16595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___16555,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14371__auto___16555,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16547[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16547[(1)] = (1));

return statearr_16547;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16498){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16548){if((e16548 instanceof Object)){
var ex__14240__auto__ = e16548;
var statearr_16549_16598 = state_16498;
(statearr_16549_16598[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16498);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16548;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16599 = state_16498;
state_16498 = G__16599;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16498){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___16555,mults,ensure_mult,p))
})();
var state__14373__auto__ = (function (){var statearr_16550 = f__14372__auto__.call(null);
(statearr_16550[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___16555);

return statearr_16550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___16555,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16603 = [];
var len__7107__auto___16610 = arguments.length;
var i__7108__auto___16611 = (0);
while(true){
if((i__7108__auto___16611 < len__7107__auto___16610)){
args16603.push((arguments[i__7108__auto___16611]));

var G__16612 = (i__7108__auto___16611 + (1));
i__7108__auto___16611 = G__16612;
continue;
} else {
}
break;
}

var G__16609 = args16603.length;
switch (G__16609) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16603.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16614 = [];
var len__7107__auto___16618 = arguments.length;
var i__7108__auto___16619 = (0);
while(true){
if((i__7108__auto___16619 < len__7107__auto___16618)){
args16614.push((arguments[i__7108__auto___16619]));

var G__16620 = (i__7108__auto___16619 + (1));
i__7108__auto___16619 = G__16620;
continue;
} else {
}
break;
}

var G__16617 = args16614.length;
switch (G__16617) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16614.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16622 = [];
var len__7107__auto___16706 = arguments.length;
var i__7108__auto___16707 = (0);
while(true){
if((i__7108__auto___16707 < len__7107__auto___16706)){
args16622.push((arguments[i__7108__auto___16707]));

var G__16712 = (i__7108__auto___16707 + (1));
i__7108__auto___16707 = G__16712;
continue;
} else {
}
break;
}

var G__16624 = args16622.length;
switch (G__16624) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16622.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14371__auto___16720 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___16720,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___16720,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16664){
var state_val_16665 = (state_16664[(1)]);
if((state_val_16665 === (7))){
var state_16664__$1 = state_16664;
var statearr_16666_16721 = state_16664__$1;
(statearr_16666_16721[(2)] = null);

(statearr_16666_16721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (1))){
var state_16664__$1 = state_16664;
var statearr_16667_16723 = state_16664__$1;
(statearr_16667_16723[(2)] = null);

(statearr_16667_16723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (4))){
var inst_16628 = (state_16664[(7)]);
var inst_16630 = (inst_16628 < cnt);
var state_16664__$1 = state_16664;
if(cljs.core.truth_(inst_16630)){
var statearr_16668_16724 = state_16664__$1;
(statearr_16668_16724[(1)] = (6));

} else {
var statearr_16670_16725 = state_16664__$1;
(statearr_16670_16725[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (15))){
var inst_16660 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
var statearr_16671_16726 = state_16664__$1;
(statearr_16671_16726[(2)] = inst_16660);

(statearr_16671_16726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (13))){
var inst_16653 = cljs.core.async.close_BANG_.call(null,out);
var state_16664__$1 = state_16664;
var statearr_16672_16727 = state_16664__$1;
(statearr_16672_16727[(2)] = inst_16653);

(statearr_16672_16727[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (6))){
var state_16664__$1 = state_16664;
var statearr_16673_16728 = state_16664__$1;
(statearr_16673_16728[(2)] = null);

(statearr_16673_16728[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (3))){
var inst_16662 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16664__$1,inst_16662);
} else {
if((state_val_16665 === (12))){
var inst_16650 = (state_16664[(8)]);
var inst_16650__$1 = (state_16664[(2)]);
var inst_16651 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16650__$1);
var state_16664__$1 = (function (){var statearr_16678 = state_16664;
(statearr_16678[(8)] = inst_16650__$1);

return statearr_16678;
})();
if(cljs.core.truth_(inst_16651)){
var statearr_16679_16729 = state_16664__$1;
(statearr_16679_16729[(1)] = (13));

} else {
var statearr_16680_16730 = state_16664__$1;
(statearr_16680_16730[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (2))){
var inst_16627 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16628 = (0);
var state_16664__$1 = (function (){var statearr_16684 = state_16664;
(statearr_16684[(7)] = inst_16628);

(statearr_16684[(9)] = inst_16627);

return statearr_16684;
})();
var statearr_16685_16731 = state_16664__$1;
(statearr_16685_16731[(2)] = null);

(statearr_16685_16731[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (11))){
var inst_16628 = (state_16664[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16664,(10),Object,null,(9));
var inst_16637 = chs__$1.call(null,inst_16628);
var inst_16638 = done.call(null,inst_16628);
var inst_16639 = cljs.core.async.take_BANG_.call(null,inst_16637,inst_16638);
var state_16664__$1 = state_16664;
var statearr_16686_16732 = state_16664__$1;
(statearr_16686_16732[(2)] = inst_16639);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16664__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (9))){
var inst_16628 = (state_16664[(7)]);
var inst_16641 = (state_16664[(2)]);
var inst_16642 = (inst_16628 + (1));
var inst_16628__$1 = inst_16642;
var state_16664__$1 = (function (){var statearr_16687 = state_16664;
(statearr_16687[(10)] = inst_16641);

(statearr_16687[(7)] = inst_16628__$1);

return statearr_16687;
})();
var statearr_16688_16733 = state_16664__$1;
(statearr_16688_16733[(2)] = null);

(statearr_16688_16733[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (5))){
var inst_16648 = (state_16664[(2)]);
var state_16664__$1 = (function (){var statearr_16689 = state_16664;
(statearr_16689[(11)] = inst_16648);

return statearr_16689;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16664__$1,(12),dchan);
} else {
if((state_val_16665 === (14))){
var inst_16650 = (state_16664[(8)]);
var inst_16655 = cljs.core.apply.call(null,f,inst_16650);
var state_16664__$1 = state_16664;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16664__$1,(16),out,inst_16655);
} else {
if((state_val_16665 === (16))){
var inst_16657 = (state_16664[(2)]);
var state_16664__$1 = (function (){var statearr_16691 = state_16664;
(statearr_16691[(12)] = inst_16657);

return statearr_16691;
})();
var statearr_16692_16734 = state_16664__$1;
(statearr_16692_16734[(2)] = null);

(statearr_16692_16734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (10))){
var inst_16632 = (state_16664[(2)]);
var inst_16633 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16664__$1 = (function (){var statearr_16693 = state_16664;
(statearr_16693[(13)] = inst_16632);

return statearr_16693;
})();
var statearr_16694_16735 = state_16664__$1;
(statearr_16694_16735[(2)] = inst_16633);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16664__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (8))){
var inst_16646 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
var statearr_16695_16736 = state_16664__$1;
(statearr_16695_16736[(2)] = inst_16646);

(statearr_16695_16736[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___16720,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14371__auto___16720,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16699 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16699[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16699[(1)] = (1));

return statearr_16699;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16664){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16700){if((e16700 instanceof Object)){
var ex__14240__auto__ = e16700;
var statearr_16701_16738 = state_16664;
(statearr_16701_16738[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16664);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16700;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16739 = state_16664;
state_16664 = G__16739;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16664){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___16720,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14373__auto__ = (function (){var statearr_16705 = f__14372__auto__.call(null);
(statearr_16705[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___16720);

return statearr_16705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___16720,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16741 = [];
var len__7107__auto___16804 = arguments.length;
var i__7108__auto___16805 = (0);
while(true){
if((i__7108__auto___16805 < len__7107__auto___16804)){
args16741.push((arguments[i__7108__auto___16805]));

var G__16806 = (i__7108__auto___16805 + (1));
i__7108__auto___16805 = G__16806;
continue;
} else {
}
break;
}

var G__16743 = args16741.length;
switch (G__16743) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16741.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14371__auto___16809 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___16809,out){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___16809,out){
return (function (state_16773){
var state_val_16774 = (state_16773[(1)]);
if((state_val_16774 === (7))){
var inst_16753 = (state_16773[(7)]);
var inst_16752 = (state_16773[(8)]);
var inst_16752__$1 = (state_16773[(2)]);
var inst_16753__$1 = cljs.core.nth.call(null,inst_16752__$1,(0),null);
var inst_16754 = cljs.core.nth.call(null,inst_16752__$1,(1),null);
var inst_16755 = (inst_16753__$1 == null);
var state_16773__$1 = (function (){var statearr_16775 = state_16773;
(statearr_16775[(9)] = inst_16754);

(statearr_16775[(7)] = inst_16753__$1);

(statearr_16775[(8)] = inst_16752__$1);

return statearr_16775;
})();
if(cljs.core.truth_(inst_16755)){
var statearr_16776_16814 = state_16773__$1;
(statearr_16776_16814[(1)] = (8));

} else {
var statearr_16777_16815 = state_16773__$1;
(statearr_16777_16815[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16774 === (1))){
var inst_16744 = cljs.core.vec.call(null,chs);
var inst_16745 = inst_16744;
var state_16773__$1 = (function (){var statearr_16778 = state_16773;
(statearr_16778[(10)] = inst_16745);

return statearr_16778;
})();
var statearr_16779_16816 = state_16773__$1;
(statearr_16779_16816[(2)] = null);

(statearr_16779_16816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16774 === (4))){
var inst_16745 = (state_16773[(10)]);
var state_16773__$1 = state_16773;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16773__$1,(7),inst_16745);
} else {
if((state_val_16774 === (6))){
var inst_16769 = (state_16773[(2)]);
var state_16773__$1 = state_16773;
var statearr_16780_16817 = state_16773__$1;
(statearr_16780_16817[(2)] = inst_16769);

(statearr_16780_16817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16774 === (3))){
var inst_16771 = (state_16773[(2)]);
var state_16773__$1 = state_16773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16773__$1,inst_16771);
} else {
if((state_val_16774 === (2))){
var inst_16745 = (state_16773[(10)]);
var inst_16747 = cljs.core.count.call(null,inst_16745);
var inst_16748 = (inst_16747 > (0));
var state_16773__$1 = state_16773;
if(cljs.core.truth_(inst_16748)){
var statearr_16783_16818 = state_16773__$1;
(statearr_16783_16818[(1)] = (4));

} else {
var statearr_16784_16819 = state_16773__$1;
(statearr_16784_16819[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16774 === (11))){
var inst_16745 = (state_16773[(10)]);
var inst_16762 = (state_16773[(2)]);
var tmp16781 = inst_16745;
var inst_16745__$1 = tmp16781;
var state_16773__$1 = (function (){var statearr_16785 = state_16773;
(statearr_16785[(11)] = inst_16762);

(statearr_16785[(10)] = inst_16745__$1);

return statearr_16785;
})();
var statearr_16786_16821 = state_16773__$1;
(statearr_16786_16821[(2)] = null);

(statearr_16786_16821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16774 === (9))){
var inst_16753 = (state_16773[(7)]);
var state_16773__$1 = state_16773;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16773__$1,(11),out,inst_16753);
} else {
if((state_val_16774 === (5))){
var inst_16767 = cljs.core.async.close_BANG_.call(null,out);
var state_16773__$1 = state_16773;
var statearr_16791_16822 = state_16773__$1;
(statearr_16791_16822[(2)] = inst_16767);

(statearr_16791_16822[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16774 === (10))){
var inst_16765 = (state_16773[(2)]);
var state_16773__$1 = state_16773;
var statearr_16793_16823 = state_16773__$1;
(statearr_16793_16823[(2)] = inst_16765);

(statearr_16793_16823[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16774 === (8))){
var inst_16745 = (state_16773[(10)]);
var inst_16754 = (state_16773[(9)]);
var inst_16753 = (state_16773[(7)]);
var inst_16752 = (state_16773[(8)]);
var inst_16757 = (function (){var cs = inst_16745;
var vec__16750 = inst_16752;
var v = inst_16753;
var c = inst_16754;
return ((function (cs,vec__16750,v,c,inst_16745,inst_16754,inst_16753,inst_16752,state_val_16774,c__14371__auto___16809,out){
return (function (p1__16740_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16740_SHARP_);
});
;})(cs,vec__16750,v,c,inst_16745,inst_16754,inst_16753,inst_16752,state_val_16774,c__14371__auto___16809,out))
})();
var inst_16758 = cljs.core.filterv.call(null,inst_16757,inst_16745);
var inst_16745__$1 = inst_16758;
var state_16773__$1 = (function (){var statearr_16794 = state_16773;
(statearr_16794[(10)] = inst_16745__$1);

return statearr_16794;
})();
var statearr_16796_16824 = state_16773__$1;
(statearr_16796_16824[(2)] = null);

(statearr_16796_16824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___16809,out))
;
return ((function (switch__14236__auto__,c__14371__auto___16809,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16800 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16800[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16800[(1)] = (1));

return statearr_16800;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16773){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16801){if((e16801 instanceof Object)){
var ex__14240__auto__ = e16801;
var statearr_16802_16825 = state_16773;
(statearr_16802_16825[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16801;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16830 = state_16773;
state_16773 = G__16830;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16773){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___16809,out))
})();
var state__14373__auto__ = (function (){var statearr_16803 = f__14372__auto__.call(null);
(statearr_16803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___16809);

return statearr_16803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___16809,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16839 = [];
var len__7107__auto___16889 = arguments.length;
var i__7108__auto___16890 = (0);
while(true){
if((i__7108__auto___16890 < len__7107__auto___16889)){
args16839.push((arguments[i__7108__auto___16890]));

var G__16891 = (i__7108__auto___16890 + (1));
i__7108__auto___16890 = G__16891;
continue;
} else {
}
break;
}

var G__16841 = args16839.length;
switch (G__16841) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16839.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14371__auto___16897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___16897,out){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___16897,out){
return (function (state_16865){
var state_val_16866 = (state_16865[(1)]);
if((state_val_16866 === (7))){
var inst_16847 = (state_16865[(7)]);
var inst_16847__$1 = (state_16865[(2)]);
var inst_16848 = (inst_16847__$1 == null);
var inst_16849 = cljs.core.not.call(null,inst_16848);
var state_16865__$1 = (function (){var statearr_16867 = state_16865;
(statearr_16867[(7)] = inst_16847__$1);

return statearr_16867;
})();
if(inst_16849){
var statearr_16868_16899 = state_16865__$1;
(statearr_16868_16899[(1)] = (8));

} else {
var statearr_16869_16900 = state_16865__$1;
(statearr_16869_16900[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (1))){
var inst_16842 = (0);
var state_16865__$1 = (function (){var statearr_16870 = state_16865;
(statearr_16870[(8)] = inst_16842);

return statearr_16870;
})();
var statearr_16871_16901 = state_16865__$1;
(statearr_16871_16901[(2)] = null);

(statearr_16871_16901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (4))){
var state_16865__$1 = state_16865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16865__$1,(7),ch);
} else {
if((state_val_16866 === (6))){
var inst_16860 = (state_16865[(2)]);
var state_16865__$1 = state_16865;
var statearr_16872_16905 = state_16865__$1;
(statearr_16872_16905[(2)] = inst_16860);

(statearr_16872_16905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (3))){
var inst_16862 = (state_16865[(2)]);
var inst_16863 = cljs.core.async.close_BANG_.call(null,out);
var state_16865__$1 = (function (){var statearr_16873 = state_16865;
(statearr_16873[(9)] = inst_16862);

return statearr_16873;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16865__$1,inst_16863);
} else {
if((state_val_16866 === (2))){
var inst_16842 = (state_16865[(8)]);
var inst_16844 = (inst_16842 < n);
var state_16865__$1 = state_16865;
if(cljs.core.truth_(inst_16844)){
var statearr_16874_16910 = state_16865__$1;
(statearr_16874_16910[(1)] = (4));

} else {
var statearr_16876_16911 = state_16865__$1;
(statearr_16876_16911[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (11))){
var inst_16842 = (state_16865[(8)]);
var inst_16852 = (state_16865[(2)]);
var inst_16853 = (inst_16842 + (1));
var inst_16842__$1 = inst_16853;
var state_16865__$1 = (function (){var statearr_16877 = state_16865;
(statearr_16877[(10)] = inst_16852);

(statearr_16877[(8)] = inst_16842__$1);

return statearr_16877;
})();
var statearr_16878_16912 = state_16865__$1;
(statearr_16878_16912[(2)] = null);

(statearr_16878_16912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (9))){
var state_16865__$1 = state_16865;
var statearr_16879_16913 = state_16865__$1;
(statearr_16879_16913[(2)] = null);

(statearr_16879_16913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (5))){
var state_16865__$1 = state_16865;
var statearr_16880_16914 = state_16865__$1;
(statearr_16880_16914[(2)] = null);

(statearr_16880_16914[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (10))){
var inst_16857 = (state_16865[(2)]);
var state_16865__$1 = state_16865;
var statearr_16881_16915 = state_16865__$1;
(statearr_16881_16915[(2)] = inst_16857);

(statearr_16881_16915[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16866 === (8))){
var inst_16847 = (state_16865[(7)]);
var state_16865__$1 = state_16865;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16865__$1,(11),out,inst_16847);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___16897,out))
;
return ((function (switch__14236__auto__,c__14371__auto___16897,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16885 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16885[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16885[(1)] = (1));

return statearr_16885;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16865){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16886){if((e16886 instanceof Object)){
var ex__14240__auto__ = e16886;
var statearr_16887_16917 = state_16865;
(statearr_16887_16917[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16865);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16886;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16918 = state_16865;
state_16865 = G__16918;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16865){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___16897,out))
})();
var state__14373__auto__ = (function (){var statearr_16888 = f__14372__auto__.call(null);
(statearr_16888[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___16897);

return statearr_16888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___16897,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16926 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16926 = (function (map_LT_,f,ch,meta16927){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16927 = meta16927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16928,meta16927__$1){
var self__ = this;
var _16928__$1 = this;
return (new cljs.core.async.t_cljs$core$async16926(self__.map_LT_,self__.f,self__.ch,meta16927__$1));
});

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16928){
var self__ = this;
var _16928__$1 = this;
return self__.meta16927;
});

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16929 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16929 = (function (map_LT_,f,ch,meta16927,_,fn1,meta16930){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16927 = meta16927;
this._ = _;
this.fn1 = fn1;
this.meta16930 = meta16930;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16931,meta16930__$1){
var self__ = this;
var _16931__$1 = this;
return (new cljs.core.async.t_cljs$core$async16929(self__.map_LT_,self__.f,self__.ch,self__.meta16927,self__._,self__.fn1,meta16930__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16929.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16931){
var self__ = this;
var _16931__$1 = this;
return self__.meta16930;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16929.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16929.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16929.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16929.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16919_SHARP_){
return f1.call(null,(((p1__16919_SHARP_ == null))?null:self__.f.call(null,p1__16919_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16929.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16927","meta16927",824255156,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16926","cljs.core.async/t_cljs$core$async16926",878153425,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16930","meta16930",588166664,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16929.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16929.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16929";

cljs.core.async.t_cljs$core$async16929.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16929");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16929 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16929(map_LT___$1,f__$1,ch__$1,meta16927__$1,___$2,fn1__$1,meta16930){
return (new cljs.core.async.t_cljs$core$async16929(map_LT___$1,f__$1,ch__$1,meta16927__$1,___$2,fn1__$1,meta16930));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16929(self__.map_LT_,self__.f,self__.ch,self__.meta16927,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16926.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16927","meta16927",824255156,null)], null);
});

cljs.core.async.t_cljs$core$async16926.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16926.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16926";

cljs.core.async.t_cljs$core$async16926.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16926");
});

cljs.core.async.__GT_t_cljs$core$async16926 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16926(map_LT___$1,f__$1,ch__$1,meta16927){
return (new cljs.core.async.t_cljs$core$async16926(map_LT___$1,f__$1,ch__$1,meta16927));
});

}

return (new cljs.core.async.t_cljs$core$async16926(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16949 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16949 = (function (map_GT_,f,ch,meta16950){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16950 = meta16950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16951,meta16950__$1){
var self__ = this;
var _16951__$1 = this;
return (new cljs.core.async.t_cljs$core$async16949(self__.map_GT_,self__.f,self__.ch,meta16950__$1));
});

cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16951){
var self__ = this;
var _16951__$1 = this;
return self__.meta16950;
});

cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16949.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16949.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16950","meta16950",1665798647,null)], null);
});

cljs.core.async.t_cljs$core$async16949.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16949.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16949";

cljs.core.async.t_cljs$core$async16949.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16949");
});

cljs.core.async.__GT_t_cljs$core$async16949 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16949(map_GT___$1,f__$1,ch__$1,meta16950){
return (new cljs.core.async.t_cljs$core$async16949(map_GT___$1,f__$1,ch__$1,meta16950));
});

}

return (new cljs.core.async.t_cljs$core$async16949(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16955 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16955 = (function (filter_GT_,p,ch,meta16956){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16956 = meta16956;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16957,meta16956__$1){
var self__ = this;
var _16957__$1 = this;
return (new cljs.core.async.t_cljs$core$async16955(self__.filter_GT_,self__.p,self__.ch,meta16956__$1));
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16957){
var self__ = this;
var _16957__$1 = this;
return self__.meta16956;
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16955.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16955.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16956","meta16956",1592207441,null)], null);
});

cljs.core.async.t_cljs$core$async16955.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16955.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16955";

cljs.core.async.t_cljs$core$async16955.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16955");
});

cljs.core.async.__GT_t_cljs$core$async16955 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16955(filter_GT___$1,p__$1,ch__$1,meta16956){
return (new cljs.core.async.t_cljs$core$async16955(filter_GT___$1,p__$1,ch__$1,meta16956));
});

}

return (new cljs.core.async.t_cljs$core$async16955(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16965 = [];
var len__7107__auto___17018 = arguments.length;
var i__7108__auto___17019 = (0);
while(true){
if((i__7108__auto___17019 < len__7107__auto___17018)){
args16965.push((arguments[i__7108__auto___17019]));

var G__17020 = (i__7108__auto___17019 + (1));
i__7108__auto___17019 = G__17020;
continue;
} else {
}
break;
}

var G__16967 = args16965.length;
switch (G__16967) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16965.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14371__auto___17022 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___17022,out){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___17022,out){
return (function (state_16993){
var state_val_16994 = (state_16993[(1)]);
if((state_val_16994 === (7))){
var inst_16989 = (state_16993[(2)]);
var state_16993__$1 = state_16993;
var statearr_16998_17023 = state_16993__$1;
(statearr_16998_17023[(2)] = inst_16989);

(statearr_16998_17023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (1))){
var state_16993__$1 = state_16993;
var statearr_16999_17024 = state_16993__$1;
(statearr_16999_17024[(2)] = null);

(statearr_16999_17024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (4))){
var inst_16975 = (state_16993[(7)]);
var inst_16975__$1 = (state_16993[(2)]);
var inst_16976 = (inst_16975__$1 == null);
var state_16993__$1 = (function (){var statearr_17000 = state_16993;
(statearr_17000[(7)] = inst_16975__$1);

return statearr_17000;
})();
if(cljs.core.truth_(inst_16976)){
var statearr_17001_17025 = state_16993__$1;
(statearr_17001_17025[(1)] = (5));

} else {
var statearr_17002_17026 = state_16993__$1;
(statearr_17002_17026[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (6))){
var inst_16975 = (state_16993[(7)]);
var inst_16980 = p.call(null,inst_16975);
var state_16993__$1 = state_16993;
if(cljs.core.truth_(inst_16980)){
var statearr_17003_17027 = state_16993__$1;
(statearr_17003_17027[(1)] = (8));

} else {
var statearr_17004_17028 = state_16993__$1;
(statearr_17004_17028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (3))){
var inst_16991 = (state_16993[(2)]);
var state_16993__$1 = state_16993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16993__$1,inst_16991);
} else {
if((state_val_16994 === (2))){
var state_16993__$1 = state_16993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16993__$1,(4),ch);
} else {
if((state_val_16994 === (11))){
var inst_16983 = (state_16993[(2)]);
var state_16993__$1 = state_16993;
var statearr_17005_17029 = state_16993__$1;
(statearr_17005_17029[(2)] = inst_16983);

(statearr_17005_17029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (9))){
var state_16993__$1 = state_16993;
var statearr_17007_17030 = state_16993__$1;
(statearr_17007_17030[(2)] = null);

(statearr_17007_17030[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (5))){
var inst_16978 = cljs.core.async.close_BANG_.call(null,out);
var state_16993__$1 = state_16993;
var statearr_17008_17031 = state_16993__$1;
(statearr_17008_17031[(2)] = inst_16978);

(statearr_17008_17031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (10))){
var inst_16986 = (state_16993[(2)]);
var state_16993__$1 = (function (){var statearr_17009 = state_16993;
(statearr_17009[(8)] = inst_16986);

return statearr_17009;
})();
var statearr_17010_17032 = state_16993__$1;
(statearr_17010_17032[(2)] = null);

(statearr_17010_17032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (8))){
var inst_16975 = (state_16993[(7)]);
var state_16993__$1 = state_16993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16993__$1,(11),out,inst_16975);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___17022,out))
;
return ((function (switch__14236__auto__,c__14371__auto___17022,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17014 = [null,null,null,null,null,null,null,null,null];
(statearr_17014[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17014[(1)] = (1));

return statearr_17014;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16993){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17015){if((e17015 instanceof Object)){
var ex__14240__auto__ = e17015;
var statearr_17016_17037 = state_16993;
(statearr_17016_17037[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17038 = state_16993;
state_16993 = G__17038;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16993){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___17022,out))
})();
var state__14373__auto__ = (function (){var statearr_17017 = f__14372__auto__.call(null);
(statearr_17017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___17022);

return statearr_17017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___17022,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17041 = [];
var len__7107__auto___17049 = arguments.length;
var i__7108__auto___17050 = (0);
while(true){
if((i__7108__auto___17050 < len__7107__auto___17049)){
args17041.push((arguments[i__7108__auto___17050]));

var G__17052 = (i__7108__auto___17050 + (1));
i__7108__auto___17050 = G__17052;
continue;
} else {
}
break;
}

var G__17047 = args17041.length;
switch (G__17047) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17041.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14371__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto__){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto__){
return (function (state_17223){
var state_val_17224 = (state_17223[(1)]);
if((state_val_17224 === (7))){
var inst_17219 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17225_17274 = state_17223__$1;
(statearr_17225_17274[(2)] = inst_17219);

(statearr_17225_17274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (20))){
var inst_17189 = (state_17223[(7)]);
var inst_17200 = (state_17223[(2)]);
var inst_17201 = cljs.core.next.call(null,inst_17189);
var inst_17175 = inst_17201;
var inst_17176 = null;
var inst_17177 = (0);
var inst_17178 = (0);
var state_17223__$1 = (function (){var statearr_17226 = state_17223;
(statearr_17226[(8)] = inst_17175);

(statearr_17226[(9)] = inst_17176);

(statearr_17226[(10)] = inst_17200);

(statearr_17226[(11)] = inst_17177);

(statearr_17226[(12)] = inst_17178);

return statearr_17226;
})();
var statearr_17227_17275 = state_17223__$1;
(statearr_17227_17275[(2)] = null);

(statearr_17227_17275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (1))){
var state_17223__$1 = state_17223;
var statearr_17228_17279 = state_17223__$1;
(statearr_17228_17279[(2)] = null);

(statearr_17228_17279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (4))){
var inst_17164 = (state_17223[(13)]);
var inst_17164__$1 = (state_17223[(2)]);
var inst_17165 = (inst_17164__$1 == null);
var state_17223__$1 = (function (){var statearr_17229 = state_17223;
(statearr_17229[(13)] = inst_17164__$1);

return statearr_17229;
})();
if(cljs.core.truth_(inst_17165)){
var statearr_17230_17280 = state_17223__$1;
(statearr_17230_17280[(1)] = (5));

} else {
var statearr_17231_17281 = state_17223__$1;
(statearr_17231_17281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (15))){
var state_17223__$1 = state_17223;
var statearr_17235_17282 = state_17223__$1;
(statearr_17235_17282[(2)] = null);

(statearr_17235_17282[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (21))){
var state_17223__$1 = state_17223;
var statearr_17237_17283 = state_17223__$1;
(statearr_17237_17283[(2)] = null);

(statearr_17237_17283[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (13))){
var inst_17175 = (state_17223[(8)]);
var inst_17176 = (state_17223[(9)]);
var inst_17177 = (state_17223[(11)]);
var inst_17178 = (state_17223[(12)]);
var inst_17185 = (state_17223[(2)]);
var inst_17186 = (inst_17178 + (1));
var tmp17232 = inst_17175;
var tmp17233 = inst_17176;
var tmp17234 = inst_17177;
var inst_17175__$1 = tmp17232;
var inst_17176__$1 = tmp17233;
var inst_17177__$1 = tmp17234;
var inst_17178__$1 = inst_17186;
var state_17223__$1 = (function (){var statearr_17239 = state_17223;
(statearr_17239[(8)] = inst_17175__$1);

(statearr_17239[(14)] = inst_17185);

(statearr_17239[(9)] = inst_17176__$1);

(statearr_17239[(11)] = inst_17177__$1);

(statearr_17239[(12)] = inst_17178__$1);

return statearr_17239;
})();
var statearr_17240_17285 = state_17223__$1;
(statearr_17240_17285[(2)] = null);

(statearr_17240_17285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (22))){
var state_17223__$1 = state_17223;
var statearr_17241_17286 = state_17223__$1;
(statearr_17241_17286[(2)] = null);

(statearr_17241_17286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (6))){
var inst_17164 = (state_17223[(13)]);
var inst_17173 = f.call(null,inst_17164);
var inst_17174 = cljs.core.seq.call(null,inst_17173);
var inst_17175 = inst_17174;
var inst_17176 = null;
var inst_17177 = (0);
var inst_17178 = (0);
var state_17223__$1 = (function (){var statearr_17242 = state_17223;
(statearr_17242[(8)] = inst_17175);

(statearr_17242[(9)] = inst_17176);

(statearr_17242[(11)] = inst_17177);

(statearr_17242[(12)] = inst_17178);

return statearr_17242;
})();
var statearr_17243_17287 = state_17223__$1;
(statearr_17243_17287[(2)] = null);

(statearr_17243_17287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (17))){
var inst_17189 = (state_17223[(7)]);
var inst_17193 = cljs.core.chunk_first.call(null,inst_17189);
var inst_17194 = cljs.core.chunk_rest.call(null,inst_17189);
var inst_17195 = cljs.core.count.call(null,inst_17193);
var inst_17175 = inst_17194;
var inst_17176 = inst_17193;
var inst_17177 = inst_17195;
var inst_17178 = (0);
var state_17223__$1 = (function (){var statearr_17244 = state_17223;
(statearr_17244[(8)] = inst_17175);

(statearr_17244[(9)] = inst_17176);

(statearr_17244[(11)] = inst_17177);

(statearr_17244[(12)] = inst_17178);

return statearr_17244;
})();
var statearr_17245_17288 = state_17223__$1;
(statearr_17245_17288[(2)] = null);

(statearr_17245_17288[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (3))){
var inst_17221 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17223__$1,inst_17221);
} else {
if((state_val_17224 === (12))){
var inst_17209 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17246_17289 = state_17223__$1;
(statearr_17246_17289[(2)] = inst_17209);

(statearr_17246_17289[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (2))){
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17223__$1,(4),in$);
} else {
if((state_val_17224 === (23))){
var inst_17217 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17247_17290 = state_17223__$1;
(statearr_17247_17290[(2)] = inst_17217);

(statearr_17247_17290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (19))){
var inst_17204 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17248_17291 = state_17223__$1;
(statearr_17248_17291[(2)] = inst_17204);

(statearr_17248_17291[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (11))){
var inst_17175 = (state_17223[(8)]);
var inst_17189 = (state_17223[(7)]);
var inst_17189__$1 = cljs.core.seq.call(null,inst_17175);
var state_17223__$1 = (function (){var statearr_17250 = state_17223;
(statearr_17250[(7)] = inst_17189__$1);

return statearr_17250;
})();
if(inst_17189__$1){
var statearr_17251_17292 = state_17223__$1;
(statearr_17251_17292[(1)] = (14));

} else {
var statearr_17253_17293 = state_17223__$1;
(statearr_17253_17293[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (9))){
var inst_17211 = (state_17223[(2)]);
var inst_17212 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17223__$1 = (function (){var statearr_17254 = state_17223;
(statearr_17254[(15)] = inst_17211);

return statearr_17254;
})();
if(cljs.core.truth_(inst_17212)){
var statearr_17255_17294 = state_17223__$1;
(statearr_17255_17294[(1)] = (21));

} else {
var statearr_17256_17295 = state_17223__$1;
(statearr_17256_17295[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (5))){
var inst_17167 = cljs.core.async.close_BANG_.call(null,out);
var state_17223__$1 = state_17223;
var statearr_17257_17296 = state_17223__$1;
(statearr_17257_17296[(2)] = inst_17167);

(statearr_17257_17296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (14))){
var inst_17189 = (state_17223[(7)]);
var inst_17191 = cljs.core.chunked_seq_QMARK_.call(null,inst_17189);
var state_17223__$1 = state_17223;
if(inst_17191){
var statearr_17258_17297 = state_17223__$1;
(statearr_17258_17297[(1)] = (17));

} else {
var statearr_17259_17298 = state_17223__$1;
(statearr_17259_17298[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (16))){
var inst_17207 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17260_17299 = state_17223__$1;
(statearr_17260_17299[(2)] = inst_17207);

(statearr_17260_17299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (10))){
var inst_17176 = (state_17223[(9)]);
var inst_17178 = (state_17223[(12)]);
var inst_17183 = cljs.core._nth.call(null,inst_17176,inst_17178);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17223__$1,(13),out,inst_17183);
} else {
if((state_val_17224 === (18))){
var inst_17189 = (state_17223[(7)]);
var inst_17198 = cljs.core.first.call(null,inst_17189);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17223__$1,(20),out,inst_17198);
} else {
if((state_val_17224 === (8))){
var inst_17177 = (state_17223[(11)]);
var inst_17178 = (state_17223[(12)]);
var inst_17180 = (inst_17178 < inst_17177);
var inst_17181 = inst_17180;
var state_17223__$1 = state_17223;
if(cljs.core.truth_(inst_17181)){
var statearr_17261_17304 = state_17223__$1;
(statearr_17261_17304[(1)] = (10));

} else {
var statearr_17262_17305 = state_17223__$1;
(statearr_17262_17305[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto__))
;
return ((function (switch__14236__auto__,c__14371__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17268[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17268[(1)] = (1));

return statearr_17268;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17223){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17269){if((e17269 instanceof Object)){
var ex__14240__auto__ = e17269;
var statearr_17270_17309 = state_17223;
(statearr_17270_17309[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17269;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17310 = state_17223;
state_17223 = G__17310;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17223){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto__))
})();
var state__14373__auto__ = (function (){var statearr_17272 = f__14372__auto__.call(null);
(statearr_17272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto__);

return statearr_17272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto__))
);

return c__14371__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17311 = [];
var len__7107__auto___17315 = arguments.length;
var i__7108__auto___17316 = (0);
while(true){
if((i__7108__auto___17316 < len__7107__auto___17315)){
args17311.push((arguments[i__7108__auto___17316]));

var G__17317 = (i__7108__auto___17316 + (1));
i__7108__auto___17316 = G__17317;
continue;
} else {
}
break;
}

var G__17314 = args17311.length;
switch (G__17314) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17311.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17319 = [];
var len__7107__auto___17322 = arguments.length;
var i__7108__auto___17323 = (0);
while(true){
if((i__7108__auto___17323 < len__7107__auto___17322)){
args17319.push((arguments[i__7108__auto___17323]));

var G__17324 = (i__7108__auto___17323 + (1));
i__7108__auto___17323 = G__17324;
continue;
} else {
}
break;
}

var G__17321 = args17319.length;
switch (G__17321) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17319.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17326 = [];
var len__7107__auto___17381 = arguments.length;
var i__7108__auto___17382 = (0);
while(true){
if((i__7108__auto___17382 < len__7107__auto___17381)){
args17326.push((arguments[i__7108__auto___17382]));

var G__17383 = (i__7108__auto___17382 + (1));
i__7108__auto___17382 = G__17383;
continue;
} else {
}
break;
}

var G__17328 = args17326.length;
switch (G__17328) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17326.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14371__auto___17385 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___17385,out){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___17385,out){
return (function (state_17352){
var state_val_17353 = (state_17352[(1)]);
if((state_val_17353 === (7))){
var inst_17347 = (state_17352[(2)]);
var state_17352__$1 = state_17352;
var statearr_17354_17389 = state_17352__$1;
(statearr_17354_17389[(2)] = inst_17347);

(statearr_17354_17389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (1))){
var inst_17329 = null;
var state_17352__$1 = (function (){var statearr_17355 = state_17352;
(statearr_17355[(7)] = inst_17329);

return statearr_17355;
})();
var statearr_17356_17390 = state_17352__$1;
(statearr_17356_17390[(2)] = null);

(statearr_17356_17390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (4))){
var inst_17332 = (state_17352[(8)]);
var inst_17332__$1 = (state_17352[(2)]);
var inst_17333 = (inst_17332__$1 == null);
var inst_17334 = cljs.core.not.call(null,inst_17333);
var state_17352__$1 = (function (){var statearr_17357 = state_17352;
(statearr_17357[(8)] = inst_17332__$1);

return statearr_17357;
})();
if(inst_17334){
var statearr_17358_17391 = state_17352__$1;
(statearr_17358_17391[(1)] = (5));

} else {
var statearr_17359_17393 = state_17352__$1;
(statearr_17359_17393[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (6))){
var state_17352__$1 = state_17352;
var statearr_17360_17394 = state_17352__$1;
(statearr_17360_17394[(2)] = null);

(statearr_17360_17394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (3))){
var inst_17349 = (state_17352[(2)]);
var inst_17350 = cljs.core.async.close_BANG_.call(null,out);
var state_17352__$1 = (function (){var statearr_17361 = state_17352;
(statearr_17361[(9)] = inst_17349);

return statearr_17361;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17352__$1,inst_17350);
} else {
if((state_val_17353 === (2))){
var state_17352__$1 = state_17352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17352__$1,(4),ch);
} else {
if((state_val_17353 === (11))){
var inst_17332 = (state_17352[(8)]);
var inst_17341 = (state_17352[(2)]);
var inst_17329 = inst_17332;
var state_17352__$1 = (function (){var statearr_17362 = state_17352;
(statearr_17362[(7)] = inst_17329);

(statearr_17362[(10)] = inst_17341);

return statearr_17362;
})();
var statearr_17363_17395 = state_17352__$1;
(statearr_17363_17395[(2)] = null);

(statearr_17363_17395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (9))){
var inst_17332 = (state_17352[(8)]);
var state_17352__$1 = state_17352;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17352__$1,(11),out,inst_17332);
} else {
if((state_val_17353 === (5))){
var inst_17329 = (state_17352[(7)]);
var inst_17332 = (state_17352[(8)]);
var inst_17336 = cljs.core._EQ_.call(null,inst_17332,inst_17329);
var state_17352__$1 = state_17352;
if(inst_17336){
var statearr_17365_17396 = state_17352__$1;
(statearr_17365_17396[(1)] = (8));

} else {
var statearr_17368_17397 = state_17352__$1;
(statearr_17368_17397[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (10))){
var inst_17344 = (state_17352[(2)]);
var state_17352__$1 = state_17352;
var statearr_17369_17398 = state_17352__$1;
(statearr_17369_17398[(2)] = inst_17344);

(statearr_17369_17398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (8))){
var inst_17329 = (state_17352[(7)]);
var tmp17364 = inst_17329;
var inst_17329__$1 = tmp17364;
var state_17352__$1 = (function (){var statearr_17370 = state_17352;
(statearr_17370[(7)] = inst_17329__$1);

return statearr_17370;
})();
var statearr_17371_17399 = state_17352__$1;
(statearr_17371_17399[(2)] = null);

(statearr_17371_17399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___17385,out))
;
return ((function (switch__14236__auto__,c__14371__auto___17385,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17376 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17376[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17376[(1)] = (1));

return statearr_17376;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17352){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17377){if((e17377 instanceof Object)){
var ex__14240__auto__ = e17377;
var statearr_17379_17400 = state_17352;
(statearr_17379_17400[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17352);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17377;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17401 = state_17352;
state_17352 = G__17401;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17352){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___17385,out))
})();
var state__14373__auto__ = (function (){var statearr_17380 = f__14372__auto__.call(null);
(statearr_17380[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___17385);

return statearr_17380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___17385,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17402 = [];
var len__7107__auto___17483 = arguments.length;
var i__7108__auto___17484 = (0);
while(true){
if((i__7108__auto___17484 < len__7107__auto___17483)){
args17402.push((arguments[i__7108__auto___17484]));

var G__17485 = (i__7108__auto___17484 + (1));
i__7108__auto___17484 = G__17485;
continue;
} else {
}
break;
}

var G__17404 = args17402.length;
switch (G__17404) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17402.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14371__auto___17487 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___17487,out){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___17487,out){
return (function (state_17442){
var state_val_17443 = (state_17442[(1)]);
if((state_val_17443 === (7))){
var inst_17438 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
var statearr_17444_17489 = state_17442__$1;
(statearr_17444_17489[(2)] = inst_17438);

(statearr_17444_17489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (1))){
var inst_17405 = (new Array(n));
var inst_17406 = inst_17405;
var inst_17407 = (0);
var state_17442__$1 = (function (){var statearr_17447 = state_17442;
(statearr_17447[(7)] = inst_17407);

(statearr_17447[(8)] = inst_17406);

return statearr_17447;
})();
var statearr_17448_17490 = state_17442__$1;
(statearr_17448_17490[(2)] = null);

(statearr_17448_17490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (4))){
var inst_17410 = (state_17442[(9)]);
var inst_17410__$1 = (state_17442[(2)]);
var inst_17411 = (inst_17410__$1 == null);
var inst_17412 = cljs.core.not.call(null,inst_17411);
var state_17442__$1 = (function (){var statearr_17449 = state_17442;
(statearr_17449[(9)] = inst_17410__$1);

return statearr_17449;
})();
if(inst_17412){
var statearr_17451_17491 = state_17442__$1;
(statearr_17451_17491[(1)] = (5));

} else {
var statearr_17452_17492 = state_17442__$1;
(statearr_17452_17492[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (15))){
var inst_17432 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
var statearr_17453_17493 = state_17442__$1;
(statearr_17453_17493[(2)] = inst_17432);

(statearr_17453_17493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (13))){
var state_17442__$1 = state_17442;
var statearr_17454_17494 = state_17442__$1;
(statearr_17454_17494[(2)] = null);

(statearr_17454_17494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (6))){
var inst_17407 = (state_17442[(7)]);
var inst_17428 = (inst_17407 > (0));
var state_17442__$1 = state_17442;
if(cljs.core.truth_(inst_17428)){
var statearr_17455_17495 = state_17442__$1;
(statearr_17455_17495[(1)] = (12));

} else {
var statearr_17456_17496 = state_17442__$1;
(statearr_17456_17496[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (3))){
var inst_17440 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17442__$1,inst_17440);
} else {
if((state_val_17443 === (12))){
var inst_17406 = (state_17442[(8)]);
var inst_17430 = cljs.core.vec.call(null,inst_17406);
var state_17442__$1 = state_17442;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17442__$1,(15),out,inst_17430);
} else {
if((state_val_17443 === (2))){
var state_17442__$1 = state_17442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17442__$1,(4),ch);
} else {
if((state_val_17443 === (11))){
var inst_17422 = (state_17442[(2)]);
var inst_17423 = (new Array(n));
var inst_17406 = inst_17423;
var inst_17407 = (0);
var state_17442__$1 = (function (){var statearr_17458 = state_17442;
(statearr_17458[(7)] = inst_17407);

(statearr_17458[(8)] = inst_17406);

(statearr_17458[(10)] = inst_17422);

return statearr_17458;
})();
var statearr_17459_17497 = state_17442__$1;
(statearr_17459_17497[(2)] = null);

(statearr_17459_17497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (9))){
var inst_17406 = (state_17442[(8)]);
var inst_17420 = cljs.core.vec.call(null,inst_17406);
var state_17442__$1 = state_17442;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17442__$1,(11),out,inst_17420);
} else {
if((state_val_17443 === (5))){
var inst_17407 = (state_17442[(7)]);
var inst_17415 = (state_17442[(11)]);
var inst_17410 = (state_17442[(9)]);
var inst_17406 = (state_17442[(8)]);
var inst_17414 = (inst_17406[inst_17407] = inst_17410);
var inst_17415__$1 = (inst_17407 + (1));
var inst_17416 = (inst_17415__$1 < n);
var state_17442__$1 = (function (){var statearr_17460 = state_17442;
(statearr_17460[(11)] = inst_17415__$1);

(statearr_17460[(12)] = inst_17414);

return statearr_17460;
})();
if(cljs.core.truth_(inst_17416)){
var statearr_17461_17498 = state_17442__$1;
(statearr_17461_17498[(1)] = (8));

} else {
var statearr_17462_17499 = state_17442__$1;
(statearr_17462_17499[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (14))){
var inst_17435 = (state_17442[(2)]);
var inst_17436 = cljs.core.async.close_BANG_.call(null,out);
var state_17442__$1 = (function (){var statearr_17464 = state_17442;
(statearr_17464[(13)] = inst_17435);

return statearr_17464;
})();
var statearr_17465_17500 = state_17442__$1;
(statearr_17465_17500[(2)] = inst_17436);

(statearr_17465_17500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (10))){
var inst_17426 = (state_17442[(2)]);
var state_17442__$1 = state_17442;
var statearr_17466_17501 = state_17442__$1;
(statearr_17466_17501[(2)] = inst_17426);

(statearr_17466_17501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17443 === (8))){
var inst_17415 = (state_17442[(11)]);
var inst_17406 = (state_17442[(8)]);
var tmp17463 = inst_17406;
var inst_17406__$1 = tmp17463;
var inst_17407 = inst_17415;
var state_17442__$1 = (function (){var statearr_17467 = state_17442;
(statearr_17467[(7)] = inst_17407);

(statearr_17467[(8)] = inst_17406__$1);

return statearr_17467;
})();
var statearr_17471_17502 = state_17442__$1;
(statearr_17471_17502[(2)] = null);

(statearr_17471_17502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___17487,out))
;
return ((function (switch__14236__auto__,c__14371__auto___17487,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17475 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17475[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17475[(1)] = (1));

return statearr_17475;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17442){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17476){if((e17476 instanceof Object)){
var ex__14240__auto__ = e17476;
var statearr_17477_17503 = state_17442;
(statearr_17477_17503[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17442);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17476;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17504 = state_17442;
state_17442 = G__17504;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17442){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___17487,out))
})();
var state__14373__auto__ = (function (){var statearr_17482 = f__14372__auto__.call(null);
(statearr_17482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___17487);

return statearr_17482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___17487,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17505 = [];
var len__7107__auto___17588 = arguments.length;
var i__7108__auto___17589 = (0);
while(true){
if((i__7108__auto___17589 < len__7107__auto___17588)){
args17505.push((arguments[i__7108__auto___17589]));

var G__17590 = (i__7108__auto___17589 + (1));
i__7108__auto___17589 = G__17590;
continue;
} else {
}
break;
}

var G__17507 = args17505.length;
switch (G__17507) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17505.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14371__auto___17598 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14371__auto___17598,out){
return (function (){
var f__14372__auto__ = (function (){var switch__14236__auto__ = ((function (c__14371__auto___17598,out){
return (function (state_17549){
var state_val_17550 = (state_17549[(1)]);
if((state_val_17550 === (7))){
var inst_17545 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
var statearr_17551_17600 = state_17549__$1;
(statearr_17551_17600[(2)] = inst_17545);

(statearr_17551_17600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (1))){
var inst_17508 = [];
var inst_17509 = inst_17508;
var inst_17510 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17549__$1 = (function (){var statearr_17552 = state_17549;
(statearr_17552[(7)] = inst_17510);

(statearr_17552[(8)] = inst_17509);

return statearr_17552;
})();
var statearr_17553_17602 = state_17549__$1;
(statearr_17553_17602[(2)] = null);

(statearr_17553_17602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (4))){
var inst_17513 = (state_17549[(9)]);
var inst_17513__$1 = (state_17549[(2)]);
var inst_17514 = (inst_17513__$1 == null);
var inst_17515 = cljs.core.not.call(null,inst_17514);
var state_17549__$1 = (function (){var statearr_17554 = state_17549;
(statearr_17554[(9)] = inst_17513__$1);

return statearr_17554;
})();
if(inst_17515){
var statearr_17555_17604 = state_17549__$1;
(statearr_17555_17604[(1)] = (5));

} else {
var statearr_17556_17605 = state_17549__$1;
(statearr_17556_17605[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (15))){
var inst_17539 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
var statearr_17557_17606 = state_17549__$1;
(statearr_17557_17606[(2)] = inst_17539);

(statearr_17557_17606[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (13))){
var state_17549__$1 = state_17549;
var statearr_17558_17607 = state_17549__$1;
(statearr_17558_17607[(2)] = null);

(statearr_17558_17607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (6))){
var inst_17509 = (state_17549[(8)]);
var inst_17534 = inst_17509.length;
var inst_17535 = (inst_17534 > (0));
var state_17549__$1 = state_17549;
if(cljs.core.truth_(inst_17535)){
var statearr_17559_17608 = state_17549__$1;
(statearr_17559_17608[(1)] = (12));

} else {
var statearr_17560_17609 = state_17549__$1;
(statearr_17560_17609[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (3))){
var inst_17547 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17549__$1,inst_17547);
} else {
if((state_val_17550 === (12))){
var inst_17509 = (state_17549[(8)]);
var inst_17537 = cljs.core.vec.call(null,inst_17509);
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17549__$1,(15),out,inst_17537);
} else {
if((state_val_17550 === (2))){
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17549__$1,(4),ch);
} else {
if((state_val_17550 === (11))){
var inst_17517 = (state_17549[(10)]);
var inst_17513 = (state_17549[(9)]);
var inst_17527 = (state_17549[(2)]);
var inst_17528 = [];
var inst_17529 = inst_17528.push(inst_17513);
var inst_17509 = inst_17528;
var inst_17510 = inst_17517;
var state_17549__$1 = (function (){var statearr_17562 = state_17549;
(statearr_17562[(11)] = inst_17529);

(statearr_17562[(7)] = inst_17510);

(statearr_17562[(12)] = inst_17527);

(statearr_17562[(8)] = inst_17509);

return statearr_17562;
})();
var statearr_17563_17611 = state_17549__$1;
(statearr_17563_17611[(2)] = null);

(statearr_17563_17611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (9))){
var inst_17509 = (state_17549[(8)]);
var inst_17525 = cljs.core.vec.call(null,inst_17509);
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17549__$1,(11),out,inst_17525);
} else {
if((state_val_17550 === (5))){
var inst_17517 = (state_17549[(10)]);
var inst_17510 = (state_17549[(7)]);
var inst_17513 = (state_17549[(9)]);
var inst_17517__$1 = f.call(null,inst_17513);
var inst_17518 = cljs.core._EQ_.call(null,inst_17517__$1,inst_17510);
var inst_17519 = cljs.core.keyword_identical_QMARK_.call(null,inst_17510,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17520 = (inst_17518) || (inst_17519);
var state_17549__$1 = (function (){var statearr_17568 = state_17549;
(statearr_17568[(10)] = inst_17517__$1);

return statearr_17568;
})();
if(cljs.core.truth_(inst_17520)){
var statearr_17569_17612 = state_17549__$1;
(statearr_17569_17612[(1)] = (8));

} else {
var statearr_17570_17613 = state_17549__$1;
(statearr_17570_17613[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (14))){
var inst_17542 = (state_17549[(2)]);
var inst_17543 = cljs.core.async.close_BANG_.call(null,out);
var state_17549__$1 = (function (){var statearr_17573 = state_17549;
(statearr_17573[(13)] = inst_17542);

return statearr_17573;
})();
var statearr_17574_17618 = state_17549__$1;
(statearr_17574_17618[(2)] = inst_17543);

(statearr_17574_17618[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (10))){
var inst_17532 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
var statearr_17575_17620 = state_17549__$1;
(statearr_17575_17620[(2)] = inst_17532);

(statearr_17575_17620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (8))){
var inst_17517 = (state_17549[(10)]);
var inst_17509 = (state_17549[(8)]);
var inst_17513 = (state_17549[(9)]);
var inst_17522 = inst_17509.push(inst_17513);
var tmp17572 = inst_17509;
var inst_17509__$1 = tmp17572;
var inst_17510 = inst_17517;
var state_17549__$1 = (function (){var statearr_17576 = state_17549;
(statearr_17576[(7)] = inst_17510);

(statearr_17576[(8)] = inst_17509__$1);

(statearr_17576[(14)] = inst_17522);

return statearr_17576;
})();
var statearr_17578_17629 = state_17549__$1;
(statearr_17578_17629[(2)] = null);

(statearr_17578_17629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14371__auto___17598,out))
;
return ((function (switch__14236__auto__,c__14371__auto___17598,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17582[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17582[(1)] = (1));

return statearr_17582;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17549){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17584){if((e17584 instanceof Object)){
var ex__14240__auto__ = e17584;
var statearr_17585_17633 = state_17549;
(statearr_17585_17633[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17584;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17634 = state_17549;
state_17549 = G__17634;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17549){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14371__auto___17598,out))
})();
var state__14373__auto__ = (function (){var statearr_17586 = f__14372__auto__.call(null);
(statearr_17586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14371__auto___17598);

return statearr_17586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14373__auto__);
});})(c__14371__auto___17598,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472570263164