// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__6037__auto__ = v;
if(cljs.core.truth_(and__6037__auto__)){
return (v > (0));
} else {
return and__6037__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__17884_SHARP_,p2__17883_SHARP_){
var vec__17886 = clojure.string.split.call(null,p2__17883_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__17886,(0),null);
var v = cljs.core.nth.call(null,vec__17886,(1),null);
return cljs.core.assoc.call(null,p1__17884_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode.call(null,[cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__17906_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__17906_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__17915){
var vec__17917 = p__17915;
var k = cljs.core.nth.call(null,vec__17917,(0),null);
var v = cljs.core.nth.call(null,vec__17917,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__17918_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__17918_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__6037__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__6037__auto__){
var and__6037__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__6037__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__17940_SHARP_){
return cljs_http.client.decode_body.call(null,p1__17940_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__7114__auto__ = [];
var len__7107__auto___17955 = arguments.length;
var i__7108__auto___17956 = (0);
while(true){
if((i__7108__auto___17956 < len__7107__auto___17955)){
args__7114__auto__.push((arguments[i__7108__auto___17956]));

var G__17958 = (i__7108__auto___17956 + (1));
i__7108__auto___17956 = G__17958;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__17950){
var vec__17951 = p__17950;
var default_headers = cljs.core.nth.call(null,vec__17951,(0),null);
return ((function (vec__17951,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__6049__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__17951,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq17945){
var G__17946 = cljs.core.first.call(null,seq17945);
var seq17945__$1 = cljs.core.next.call(null,seq17945);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__17946,seq17945__$1);
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__7114__auto__ = [];
var len__7107__auto___17972 = arguments.length;
var i__7108__auto___17973 = (0);
while(true){
if((i__7108__auto___17973 < len__7107__auto___17972)){
args__7114__auto__.push((arguments[i__7108__auto___17973]));

var G__17974 = (i__7108__auto___17973 + (1));
i__7108__auto___17973 = G__17974;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__17967){
var vec__17968 = p__17967;
var accept = cljs.core.nth.call(null,vec__17968,(0),null);
return ((function (vec__17968,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__6049__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(or__6049__auto__){
return or__6049__auto__;
} else {
return accept;
}
})();
if(temp__4655__auto__){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__17968,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq17963){
var G__17964 = cljs.core.first.call(null,seq17963);
var seq17963__$1 = cljs.core.next.call(null,seq17963);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__17964,seq17963__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__7114__auto__ = [];
var len__7107__auto___17985 = arguments.length;
var i__7108__auto___17986 = (0);
while(true){
if((i__7108__auto___17986 < len__7107__auto___17985)){
args__7114__auto__.push((arguments[i__7108__auto___17986]));

var G__17987 = (i__7108__auto___17986 + (1));
i__7108__auto___17986 = G__17987;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__17983){
var vec__17984 = p__17983;
var content_type = cljs.core.nth.call(null,vec__17984,(0),null);
return ((function (vec__17984,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__6049__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__17984,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq17975){
var G__17976 = cljs.core.first.call(null,seq17975);
var seq17975__$1 = cljs.core.next.call(null,seq17975);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__17976,seq17975__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__18004 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__18004__$1 = ((((!((map__18004 == null)))?((((map__18004.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18004.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18004):map__18004);
var encoding = cljs.core.get.call(null,map__18004__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__18004__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__18044 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__18044__$1 = ((((!((map__18044 == null)))?((((map__18044.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18044.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18044):map__18044);
var decoding = cljs.core.get.call(null,map__18044__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__18044__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__18044,map__18044__$1,decoding,decoding_opts){
return (function (p1__18039_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__18039_SHARP_,decoding,decoding_opts);
});})(map__18044,map__18044__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__18044,map__18044__$1,decoding,decoding_opts,transit_decode){
return (function (p1__18040_SHARP_){
return cljs_http.client.decode_body.call(null,p1__18040_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__18044,map__18044__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__18054_SHARP_){
return cljs_http.client.decode_body.call(null,p1__18054_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__18058){
var map__18059 = p__18058;
var map__18059__$1 = ((((!((map__18059 == null)))?((((map__18059.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18059.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18059):map__18059);
var req = map__18059__$1;
var query_params = cljs.core.get.call(null,map__18059__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__18069){
var map__18070 = p__18069;
var map__18070__$1 = ((((!((map__18070 == null)))?((((map__18070.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18070.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18070):map__18070);
var request = map__18070__$1;
var form_params = cljs.core.get.call(null,map__18070__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__18070__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__18070__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__6037__auto__ = form_params;
if(cljs.core.truth_(and__6037__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__6037__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__18087_18097 = cljs.core.seq.call(null,params);
var chunk__18088_18098 = null;
var count__18089_18099 = (0);
var i__18090_18100 = (0);
while(true){
if((i__18090_18100 < count__18089_18099)){
var vec__18091_18102 = cljs.core._nth.call(null,chunk__18088_18098,i__18090_18100);
var k_18103 = cljs.core.nth.call(null,vec__18091_18102,(0),null);
var v_18104 = cljs.core.nth.call(null,vec__18091_18102,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_18104)){
form_data.append(cljs.core.name.call(null,k_18103),cljs.core.first.call(null,v_18104),cljs.core.second.call(null,v_18104));
} else {
form_data.append(cljs.core.name.call(null,k_18103),v_18104);
}

var G__18106 = seq__18087_18097;
var G__18107 = chunk__18088_18098;
var G__18108 = count__18089_18099;
var G__18109 = (i__18090_18100 + (1));
seq__18087_18097 = G__18106;
chunk__18088_18098 = G__18107;
count__18089_18099 = G__18108;
i__18090_18100 = G__18109;
continue;
} else {
var temp__4657__auto___18113 = cljs.core.seq.call(null,seq__18087_18097);
if(temp__4657__auto___18113){
var seq__18087_18114__$1 = temp__4657__auto___18113;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18087_18114__$1)){
var c__6852__auto___18115 = cljs.core.chunk_first.call(null,seq__18087_18114__$1);
var G__18117 = cljs.core.chunk_rest.call(null,seq__18087_18114__$1);
var G__18118 = c__6852__auto___18115;
var G__18119 = cljs.core.count.call(null,c__6852__auto___18115);
var G__18120 = (0);
seq__18087_18097 = G__18117;
chunk__18088_18098 = G__18118;
count__18089_18099 = G__18119;
i__18090_18100 = G__18120;
continue;
} else {
var vec__18096_18122 = cljs.core.first.call(null,seq__18087_18114__$1);
var k_18123 = cljs.core.nth.call(null,vec__18096_18122,(0),null);
var v_18124 = cljs.core.nth.call(null,vec__18096_18122,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_18124)){
form_data.append(cljs.core.name.call(null,k_18123),cljs.core.first.call(null,v_18124),cljs.core.second.call(null,v_18124));
} else {
form_data.append(cljs.core.name.call(null,k_18123),v_18124);
}

var G__18128 = cljs.core.next.call(null,seq__18087_18114__$1);
var G__18129 = null;
var G__18130 = (0);
var G__18131 = (0);
seq__18087_18097 = G__18128;
chunk__18088_18098 = G__18129;
count__18089_18099 = G__18130;
i__18090_18100 = G__18131;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__18137){
var map__18138 = p__18137;
var map__18138__$1 = ((((!((map__18138 == null)))?((((map__18138.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18138.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18138):map__18138);
var request = map__18138__$1;
var multipart_params = cljs.core.get.call(null,map__18138__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__18138__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__6037__auto__ = multipart_params;
if(cljs.core.truth_(and__6037__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__6037__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__18146_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__18146_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__18157){
var map__18158 = p__18157;
var map__18158__$1 = ((((!((map__18158 == null)))?((((map__18158.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18158.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18158):map__18158);
var req = map__18158__$1;
var query_params = cljs.core.get.call(null,map__18158__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__18158,map__18158__$1,req,query_params){
return (function (p1__18151_SHARP_){
return cljs.core.merge.call(null,p1__18151_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__18158,map__18158__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18172 = arguments.length;
var i__7108__auto___18174 = (0);
while(true){
if((i__7108__auto___18174 < len__7107__auto___18172)){
args__7114__auto__.push((arguments[i__7108__auto___18174]));

var G__18176 = (i__7108__auto___18174 + (1));
i__7108__auto___18174 = G__18176;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18170){
var vec__18171 = p__18170;
var credentials = cljs.core.nth.call(null,vec__18171,(0),null);
return ((function (vec__18171,credentials){
return (function (req){
var credentials__$1 = (function (){var or__6049__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__18171,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq18167){
var G__18168 = cljs.core.first.call(null,seq18167);
var seq18167__$1 = cljs.core.next.call(null,seq18167);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__18168,seq18167__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18228 = arguments.length;
var i__7108__auto___18229 = (0);
while(true){
if((i__7108__auto___18229 < len__7107__auto___18228)){
args__7114__auto__.push((arguments[i__7108__auto___18229]));

var G__18231 = (i__7108__auto___18229 + (1));
i__7108__auto___18229 = G__18231;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18222){
var vec__18223 = p__18222;
var req = cljs.core.nth.call(null,vec__18223,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq18219){
var G__18220 = cljs.core.first.call(null,seq18219);
var seq18219__$1 = cljs.core.next.call(null,seq18219);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__18220,seq18219__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18258 = arguments.length;
var i__7108__auto___18259 = (0);
while(true){
if((i__7108__auto___18259 < len__7107__auto___18258)){
args__7114__auto__.push((arguments[i__7108__auto___18259]));

var G__18261 = (i__7108__auto___18259 + (1));
i__7108__auto___18259 = G__18261;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18252){
var vec__18253 = p__18252;
var req = cljs.core.nth.call(null,vec__18253,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq18243){
var G__18245 = cljs.core.first.call(null,seq18243);
var seq18243__$1 = cljs.core.next.call(null,seq18243);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__18245,seq18243__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18282 = arguments.length;
var i__7108__auto___18283 = (0);
while(true){
if((i__7108__auto___18283 < len__7107__auto___18282)){
args__7114__auto__.push((arguments[i__7108__auto___18283]));

var G__18286 = (i__7108__auto___18283 + (1));
i__7108__auto___18283 = G__18286;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18278){
var vec__18279 = p__18278;
var req = cljs.core.nth.call(null,vec__18279,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq18271){
var G__18272 = cljs.core.first.call(null,seq18271);
var seq18271__$1 = cljs.core.next.call(null,seq18271);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__18272,seq18271__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18295 = arguments.length;
var i__7108__auto___18296 = (0);
while(true){
if((i__7108__auto___18296 < len__7107__auto___18295)){
args__7114__auto__.push((arguments[i__7108__auto___18296]));

var G__18297 = (i__7108__auto___18296 + (1));
i__7108__auto___18296 = G__18297;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18293){
var vec__18294 = p__18293;
var req = cljs.core.nth.call(null,vec__18294,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq18291){
var G__18292 = cljs.core.first.call(null,seq18291);
var seq18291__$1 = cljs.core.next.call(null,seq18291);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__18292,seq18291__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18304 = arguments.length;
var i__7108__auto___18305 = (0);
while(true){
if((i__7108__auto___18305 < len__7107__auto___18304)){
args__7114__auto__.push((arguments[i__7108__auto___18305]));

var G__18306 = (i__7108__auto___18305 + (1));
i__7108__auto___18305 = G__18306;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18302){
var vec__18303 = p__18302;
var req = cljs.core.nth.call(null,vec__18303,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq18298){
var G__18299 = cljs.core.first.call(null,seq18298);
var seq18298__$1 = cljs.core.next.call(null,seq18298);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__18299,seq18298__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18323 = arguments.length;
var i__7108__auto___18325 = (0);
while(true){
if((i__7108__auto___18325 < len__7107__auto___18323)){
args__7114__auto__.push((arguments[i__7108__auto___18325]));

var G__18327 = (i__7108__auto___18325 + (1));
i__7108__auto___18325 = G__18327;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18317){
var vec__18318 = p__18317;
var req = cljs.core.nth.call(null,vec__18318,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq18313){
var G__18314 = cljs.core.first.call(null,seq18313);
var seq18313__$1 = cljs.core.next.call(null,seq18313);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__18314,seq18313__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18343 = arguments.length;
var i__7108__auto___18344 = (0);
while(true){
if((i__7108__auto___18344 < len__7107__auto___18343)){
args__7114__auto__.push((arguments[i__7108__auto___18344]));

var G__18347 = (i__7108__auto___18344 + (1));
i__7108__auto___18344 = G__18347;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18338){
var vec__18339 = p__18338;
var req = cljs.core.nth.call(null,vec__18339,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq18333){
var G__18334 = cljs.core.first.call(null,seq18333);
var seq18333__$1 = cljs.core.next.call(null,seq18333);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__18334,seq18333__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18369 = arguments.length;
var i__7108__auto___18370 = (0);
while(true){
if((i__7108__auto___18370 < len__7107__auto___18369)){
args__7114__auto__.push((arguments[i__7108__auto___18370]));

var G__18373 = (i__7108__auto___18370 + (1));
i__7108__auto___18370 = G__18373;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18364){
var vec__18366 = p__18364;
var req = cljs.core.nth.call(null,vec__18366,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq18354){
var G__18355 = cljs.core.first.call(null,seq18354);
var seq18354__$1 = cljs.core.next.call(null,seq18354);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__18355,seq18354__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__7114__auto__ = [];
var len__7107__auto___18406 = arguments.length;
var i__7108__auto___18407 = (0);
while(true){
if((i__7108__auto___18407 < len__7107__auto___18406)){
args__7114__auto__.push((arguments[i__7108__auto___18407]));

var G__18408 = (i__7108__auto___18407 + (1));
i__7108__auto___18407 = G__18408;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__18402){
var vec__18403 = p__18402;
var req = cljs.core.nth.call(null,vec__18403,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq18398){
var G__18399 = cljs.core.first.call(null,seq18398);
var seq18398__$1 = cljs.core.next.call(null,seq18398);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__18399,seq18398__$1);
});

//# sourceMappingURL=client.js.map?rel=1462537984545