/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ETFloorFn
extends ETScalarFn {
    private final int m_resultType;

    public ETFloorFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == list.size() && 1 == list2.size());
        short s = iColumn.getTypeMetadata().getType();
        assert (TypeUtilities.isNumberType(s));
        assert (list2.get(0).getTypeMetadata().getType() == s);
        this.m_resultType = s;
    }

    @Override
    public String getLogString() {
        return "ETFloorFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            switch (this.m_resultType) {
                case -6: {
                    eTDataRequest.getData().setTinyInt(iSqlDataWrapper.getTinyInt());
                    break;
                }
                case 5: {
                    eTDataRequest.getData().setSmallInt(iSqlDataWrapper.getSmallInt());
                    break;
                }
                case 4: {
                    eTDataRequest.getData().setInteger(iSqlDataWrapper.getInteger());
                    break;
                }
                case -5: {
                    eTDataRequest.getData().setBigInt(iSqlDataWrapper.getBigInt());
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = iSqlDataWrapper.getExactNumber();
                    eTDataRequest.getData().setExactNumber(bigDecimal.setScale(0, 3));
                    break;
                }
                case 7: {
                    eTDataRequest.getData().setReal((float)Math.floor(iSqlDataWrapper.getReal()));
                    break;
                }
                default: {
                    eTDataRequest.getData().setDouble(Math.floor(iSqlDataWrapper.getDouble()));
                }
            }
        }
        return false;
    }
}

