/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree;

import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.IETResource;
import com.amazon.support.ILogger;
import com.amazon.support.exceptions.ErrorException;
import java.io.File;

public class ETTempFolderResource
implements IETResource {
    private static final String PACKAGE_NAME = "com.amazon.sqlengine.executor.etree";
    private static final String CLASS_NAME = "ETTempFolderResource";
    private File m_folder;
    private ILogger m_logger;

    public ETTempFolderResource(File file, ILogger iLogger) {
        this.m_folder = file;
        this.m_logger = iLogger;
    }

    public void allocate() throws ErrorException {
        if (!this.m_folder.exists()) {
            this.m_folder.mkdir();
        }
        if (!(this.m_folder.exists() && this.m_folder.isDirectory() && this.m_folder.canRead() && this.m_folder.canWrite())) {
            throw SQLEngineExceptionFactory.failedToCreateFile(this.m_folder.getAbsolutePath());
        }
    }

    public void free() throws ErrorException {
        if (!this.m_folder.exists()) {
            return;
        }
        if (!this.m_folder.isDirectory()) {
            throw SQLEngineExceptionFactory.failedToDeleteFile(this.m_folder.getAbsolutePath());
        }
        File[] fileArray = this.m_folder.listFiles();
        if (fileArray == null) {
            throw SQLEngineExceptionFactory.failedToDeleteFile(this.m_folder.getAbsolutePath());
        }
        assert (fileArray.length == 0);
        if (fileArray.length != 0 && this.m_logger != null) {
            this.m_logger.logWarning(PACKAGE_NAME, CLASS_NAME, "free", "Temporary files are not cleaned up after execution.");
        }
        for (File file : fileArray) {
            if (!file.isDirectory() && file.delete()) continue;
            throw SQLEngineExceptionFactory.failedToDeleteFile(this.m_folder.getAbsolutePath());
        }
        if (!this.m_folder.delete()) {
            throw SQLEngineExceptionFactory.failedToDeleteFile(this.m_folder.getAbsolutePath());
        }
    }
}

