/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.api.PGArrayColumnMetaData;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.api.PGTimestamp;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.OperationMetadataImpl;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.core.PGArray;
import com.amazon.redshift.core.PGArrayParser;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.GeneralException;
import com.amazon.utilities.TypeNames;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;

public class PGResultSet
implements IResultSet,
PGConstants,
SocketCloseListener {
    private ArrayList<ColumnMetadata> m_columnMetadata;
    private final int m_batchIndex;
    private OperationMetadataImpl m_operationMetadata;
    private PGMessagingContext m_currentMessagingContext = null;
    protected ILogger m_log;
    private int m_fetchSize;
    private long m_currentRow = 0L;
    private boolean m_hasStartedFetch = false;
    private IWarningListener m_warningListener = null;
    private ErrorException m_fatalException = null;

    public PGResultSet(PGMessagingContext pGMessagingContext, int n, ILogger iLogger) {
        this.m_batchIndex = n;
        this.m_currentMessagingContext = pGMessagingContext;
        this.m_log = iLogger;
        this.m_currentMessagingContext.addSocketCloseListener(this);
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            if (n < this.m_currentMessagingContext.m_currentDataRow.getNumberOfColumns()) {
                ColumnMetadata columnMetadata = this.getSelectColumns().get(n);
                byte[] byArray = this.m_currentMessagingContext.m_currentDataRow.getData();
                int n2 = this.m_currentMessagingContext.m_currentDataRow.getColumnBeginIndex(n);
                int n3 = this.m_currentMessagingContext.m_currentDataRow.getColumnEndIndex(n);
                int n4 = n3 - n2 + 1;
                if (-1 == n3) {
                    dataWrapper.setNull(columnMetadata.getTypeMetadata().getType());
                    return false;
                }
                switch (columnMetadata.getTypeMetadata().getType()) {
                    case 2003: {
                        if (columnMetadata instanceof PGArrayColumnMetaData) {
                            Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                            if (null != object && object instanceof PGArray) {
                                dataWrapper.setArray((PGArray)object);
                            } else {
                                PGArrayColumnMetaData pGArrayColumnMetaData = (PGArrayColumnMetaData)columnMetadata;
                                int n5 = pGArrayColumnMetaData.getBaseType();
                                IColumn iColumn = pGArrayColumnMetaData.getBaseColumnMetadata();
                                Object object2 = PGArrayParser.parseArray(byArray, n5, n2, n4);
                                PGArray pGArray = new PGArray(object2, columnMetadata, iColumn);
                                this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, pGArray);
                                dataWrapper.setArray(pGArray);
                            }
                            return false;
                        }
                        throw new GeneralException(1, JDBCMessageKey.INVALID_COLUMN_TYPE.name(), new String[]{String.valueOf(n), TypeNames.getTypeName(2003)});
                    }
                    case 1: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setChar(this.convertStringToUTF8((String)object));
                        } else {
                            String string = new String(byArray, n2, n4, "UTF-8");
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setChar(string);
                        }
                        return false;
                    }
                    case 12: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setVarChar(this.convertStringToUTF8((String)object));
                        } else {
                            String string = new String(byArray, n2, n4, "UTF-8");
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setVarChar(string);
                        }
                        return false;
                    }
                    case -1: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setLongVarChar(this.convertStringToUTF8((String)object));
                        } else {
                            String string = new String(byArray, n2, n4, "UTF-8");
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setLongVarChar(string);
                        }
                        return false;
                    }
                    case -4: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof byte[]) {
                            dataWrapper.setLongVarBinary((byte[])object);
                        } else {
                            byte[] byArray2 = PGDataTypeUtilities.transformByteFormat(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, byArray2);
                            dataWrapper.setLongVarBinary(byArray2);
                        }
                        return false;
                    }
                    case -7: 
                    case 16: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof String) {
                            dataWrapper.setVarChar((String)object);
                        } else {
                            String string = null;
                            string = PGDataTypeUtilities.toBit(byArray, n2) != false ? "true" : "false";
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, string);
                            dataWrapper.setVarChar(string);
                        }
                        return false;
                    }
                    case 5: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Integer) {
                            dataWrapper.setSmallInt((Integer)object);
                        } else {
                            Integer n6 = new Integer(PGDataTypeUtilities.toShort(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, n6);
                            dataWrapper.setSmallInt(n6);
                        }
                        return false;
                    }
                    case 4: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Long) {
                            dataWrapper.setInteger((Long)object);
                        } else {
                            Long l3 = new Long(PGDataTypeUtilities.toInteger(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, l3);
                            dataWrapper.setInteger(l3);
                        }
                        return false;
                    }
                    case -5: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Long) {
                            dataWrapper.setBigInt((Long)object);
                        } else {
                            Long l4 = new Long(PGDataTypeUtilities.toLong(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, l4);
                            dataWrapper.setBigInt(l4);
                        }
                        return false;
                    }
                    case 7: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Float) {
                            dataWrapper.setReal((Float)object);
                        } else {
                            Float f = new Float(PGDataTypeUtilities.toFloat(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, f);
                            dataWrapper.setReal(f);
                        }
                        return false;
                    }
                    case 8: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Double) {
                            dataWrapper.setDouble((Double)object);
                        } else {
                            Double d = new Double(PGDataTypeUtilities.toDouble(byArray, n2, n4));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, d);
                            dataWrapper.setDouble(d);
                        }
                        return false;
                    }
                    case 91: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof Date) {
                            dataWrapper.setDate((Date)object);
                        } else {
                            int[] nArray = PGDataTypeUtilities.toDate(byArray, n2, n4);
                            Date date = PGDataTypeUtilities.toSqlDate(nArray);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, date);
                            dataWrapper.setDate(date);
                        }
                        return false;
                    }
                    case 92: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof int[]) {
                            int[] nArray = (int[])object;
                            dataWrapper.setTime(nArray[0], nArray[1], nArray[2], nArray[3]);
                        } else {
                            int[] nArray = PGDataTypeUtilities.toTime(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, nArray);
                            dataWrapper.setTime(nArray[0], nArray[1], nArray[2], nArray[3]);
                        }
                        return false;
                    }
                    case 93: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof PGTimestamp) {
                            dataWrapper.setTimestamp((PGTimestamp)object);
                        } else if (null != object && object instanceof int[]) {
                            int[] nArray = (int[])object;
                            Timestamp timestamp = PGDataTypeUtilities.toSqlTimestamp(nArray);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, timestamp);
                            dataWrapper.setTimestamp(timestamp);
                        } else {
                            String string = new String(byArray, n2, n4);
                            if ((string = string.toLowerCase()).contains("infinity")) {
                                if (string.startsWith("-")) {
                                    dataWrapper.setTimestamp(new PGTimestamp(Long.MIN_VALUE));
                                } else {
                                    dataWrapper.setTimestamp(new PGTimestamp(Long.MAX_VALUE));
                                }
                            } else {
                                int[] nArray = PGDataTypeUtilities.toTimestamp(byArray, n2, n4);
                                Timestamp timestamp = PGDataTypeUtilities.toSqlTimestamp(nArray);
                                dataWrapper.setTimestamp(timestamp);
                            }
                        }
                        return false;
                    }
                    case 2: 
                    case 3: {
                        Object object = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(n);
                        if (null != object && object instanceof BigDecimal) {
                            dataWrapper.setNumeric((BigDecimal)object);
                        } else {
                            BigDecimal bigDecimal = PGDataTypeUtilities.toBigDecimal(byArray, n2, n4);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(n, bigDecimal);
                            dataWrapper.setNumeric(bigDecimal);
                        }
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
        return false;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            this.getOperationMetadata();
            return this.m_operationMetadata.m_dataRowCount;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
    }

    public ArrayList<ColumnMetadata> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            if (null == this.m_columnMetadata) {
                this.m_columnMetadata = new ArrayList();
                RowDescription rowDescription = this.m_currentMessagingContext.getRowDescription(this.m_batchIndex);
                if (null != rowDescription) {
                    for (int i = 0; i < rowDescription.getFieldDescriptions().length; ++i) {
                        this.m_columnMetadata.add(PGDataTypeUtilities.createColumn(null, null, null, new String(rowDescription.getFieldDescriptions()[i].getFieldName()), rowDescription.getFieldDescriptions()[i]));
                    }
                }
            }
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
        return this.m_columnMetadata;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        this.getOperationMetadata();
        if (null == this.m_operationMetadata) {
            return false;
        }
        try {
            if (this.m_operationMetadata.m_openOperation.get()) {
                return true;
            }
            return this.getRowCount() > this.getCurrentRow();
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
    }

    public void getOperationMetadata() {
        try {
            if (null == this.m_operationMetadata) {
                this.m_operationMetadata = (OperationMetadataImpl)this.m_currentMessagingContext.getOperationMetadata(this.m_batchIndex);
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logError(errorException, this.m_log);
        }
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.getOperationMetadata();
        return !this.m_operationMetadata.m_openOperation.get();
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_currentMessagingContext.closeBatch(this.m_batchIndex);
        this.m_currentMessagingContext.removeSocketCloseListener(this);
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0L;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_currentMessagingContext.closeBatch(this.m_batchIndex);
        this.m_currentMessagingContext.removeSocketCloseListener(this);
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0L;
        } else {
            ++this.m_currentRow;
        }
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            if (this.hasMoreRows()) {
                return this.m_currentMessagingContext.doMoveToNextRow(this.m_batchIndex);
            }
            return false;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
        this.m_fetchSize = n;
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    protected long getCurrentRow() {
        return this.m_currentRow;
    }

    @Override
    public void socketClosed(ErrorException errorException) {
        this.m_fatalException = errorException;
    }

    @Override
    public boolean supportsHasMoreRows() {
        return true;
    }

    private ErrorException buildError(Exception exception) {
        if (null != this.m_fatalException) {
            return this.m_fatalException;
        }
        if (exception instanceof ErrorException) {
            return (ErrorException)exception;
        }
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        errorException.initCause(exception);
        return errorException;
    }

    private String convertStringToUTF8(String string) {
        try {
            string = new String(string.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }
}

