/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIDataEngine;
import com.amazon.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.amazon.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.dataengine.utilities.OrderType;
import com.amazon.dsi.exceptions.ParsingException;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCallableStatementParser;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGBatchQueryExecutor;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.PGIQueryExecutor;
import com.amazon.redshift.dataengine.metadata.PGJDBCTypeInfoMetadataSource;
import com.amazon.redshift.dataengine.metadata.PGMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGProcedureColumnsMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGTablePrivilegesMetadatSourceFromQuery;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PGJDBCIDataEngine
extends DSIDataEngine {
    private PGClient m_client;
    private PGJDBCStatement m_statement;
    private ILogger m_log;
    private boolean m_isDirectExecution;
    private int m_socketTimeoutMS;

    public PGJDBCIDataEngine(PGJDBCStatement pGJDBCStatement, PGClient pGClient, ILogger iLogger, int n) {
        super(pGJDBCStatement);
        this.m_statement = pGJDBCStatement;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_isDirectExecution = false;
        this.m_socketTimeoutMS = n;
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, list);
        return new PGBatchQueryExecutor(list, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        Object object;
        if (this.m_statement.isCallableStatement()) {
            try {
                object = new PGCallableStatementParser();
                ((PGCallableStatementParser)object).Translate(string);
                this.m_statement.sethasReturnQuestionMark(((PGCallableStatementParser)object).isReturnParameter());
                string = ((PGCallableStatementParser)object).getResult();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            object = ParseQueryUtils.splitQueries(string);
        }
        catch (com.amazon.jdbc.utils.ParsingException parsingException) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Parsing failed", string}, (Throwable)parsingException);
            throw errorException;
        }
        if (1 == object.size()) {
            return new PGIQueryExecutor(string, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
        }
        return this.prepareBatch((List<String>)object);
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecution = true;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (MetadataSourceID.PRIMARY_KEYS == metadataSourceID) {
            return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, OrderType.NONE);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new PGJDBCTypeInfoMetadataSource(this.getLog());
            }
            case TABLETYPE_ONLY: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("TABLE");
                arrayList.add("VIEW");
                arrayList.add("SEQUENCE");
                arrayList.add("INDEX");
                arrayList.add("SYSTEM TABLE");
                arrayList.add("SYSTEM TOAST TABLE");
                arrayList.add("TEMPORARY TABLE");
                arrayList.add("SYSTEM VIEW");
                arrayList.add("TEMPORARY VIEW");
                arrayList.add("SYSTEM INDEX");
                arrayList.add("SYSTEM TOAST INDEX");
                arrayList.add("TEMPORARY INDEX");
                arrayList.add("TEMPORARY SEQUENCE");
                arrayList.add("TYPE");
                return new DSITableTypeOnlyMetadataSource(this.getLog(), arrayList);
            }
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: 
            case TABLES: 
            case COLUMNS: 
            case FOREIGN_KEYS: 
            case PRIMARY_KEYS: {
                String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string3, 0, null).get(0);
                return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
            }
            case TABLE_PRIVILEGES: {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string4, 0, null).get(0);
                return new PGTablePrivilegesMetadatSourceFromQuery(pGMessagingContext, 0, this.m_log);
            }
            case PROCEDURES: {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string5, 0, null).get(0);
                return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
            }
            case PROCEDURE_COLUMNS: {
                String string6 = PGCoreUtils.SERVER_VERSION;
                int n = Integer.parseInt(string6.split("\\.")[0]);
                int n2 = Integer.parseInt(string6.split("\\.")[1]);
                if (n >= 8 && n2 >= 4) {
                    String string7 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map);
                    PGMessagingContext pGMessagingContext = this.m_client.directExecute(string7, 0, null).get(0);
                    return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
                }
                String string8 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string8, 0, null).get(0);
                return new PGProcedureColumnsMetadatSourceFromQuery(pGMessagingContext, 0, this.m_log);
            }
            case FUNCTIONS_JDBC4: {
                if (!PGCoreUtils.REDSHIFT_SERVER) {
                    String string9 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map);
                    PGMessagingContext pGMessagingContext = this.m_client.directExecute(string9, 0, null).get(0);
                    return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
                }
                return new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }
}

