/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class ReadyForQuery
extends AbstractInboundMessage
implements PGConstants {
    private static final char STATUS_IDLE = 'I';
    private static final char STATUS_TRANSACTION_BLOCK = 'T';
    private static final char STATUS_FAILED_TRANSACTION_BLOCK = 'E';
    private final char m_status;

    public ReadyForQuery(ByteBuffer byteBuffer, IPGLogger iPGLogger) {
        this.m_status = (char)byteBuffer.get();
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public boolean isIdle() {
        return 'I' == this.m_status;
    }

    public boolean isTransactionBlock() {
        return 'T' == this.m_status;
    }

    public boolean isFailedTransactionBlock() {
        return 'E' == this.m_status;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "<=BE ReadyForQuery(" + this.m_status + ")";
        iPGLogger.logDebugExternal(string);
    }

    public String toString() {
        return "\nReadyForQuery: isIdle - " + this.isIdle() + "\nisTransactionBlock - " + this.isTransactionBlock() + "\nisFailedTransactionBlock - " + this.isFailedTransactionBlock();
    }
}

