/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class CopyInResponse
extends AbstractInboundMessage {
    private boolean m_overallFormat;
    private short m_numOfColumns;
    private boolean[] m_columnFormat;

    public CopyInResponse(ByteBuffer byteBuffer, IPGLogger iPGLogger) {
        this.m_overallFormat = byteBuffer.get() != 0;
        this.m_numOfColumns = byteBuffer.getShort();
        this.m_columnFormat = new boolean[this.m_numOfColumns];
        for (int i = 0; i < this.m_numOfColumns; ++i) {
            this.m_columnFormat[i] = byteBuffer.getChar() != '\u0000';
        }
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public boolean getOverallFormat() {
        return this.m_overallFormat;
    }

    public int getNumOfColumns() {
        return this.m_numOfColumns;
    }

    public boolean[] getColumnFormat() {
        return this.m_columnFormat;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "<=BE CopyInResponse (" + this.m_overallFormat + "," + this.m_numOfColumns + "," + Arrays.toString(this.m_columnFormat) + ")";
        iPGLogger.logDebugExternal(string);
    }
}

