/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications;

import com.amazon.jdbc.communications.InboundMessagesContainer;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.Closable;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.jdbc.communications.interfaces.IOperationMetadata;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.jdbc.communications.interfaces.SocketCloseObservable;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class InboundMessagesPipeline
implements Closable,
SocketCloseObservable {
    private static final int BLOCKING_QUEUE_CAPACITY = 1;
    protected static final int TIMEOUT_MS_WAIT = 20;
    public static final int TIMEOUT_MS_BLOCKING_QUEUE = 20;
    public static final int NO_REQUESTED_TIMEOUT = 0;
    private static final int NEXT_PEEK_TIMEOUT_MS = 50;
    private static final int MESSAGE_GRAB_TIMEOUT_MS = 200;
    public BlockingQueue<InboundMessagesContainer> m_messageContainers;
    public InboundMessagesContainer m_currentMessagesContainer;
    public IWarningListener m_warningListener;
    private AtomicBoolean m_hasOpenOperation = new AtomicBoolean(false);
    protected int m_nRowMode;
    public int m_currentMessageIndex;
    public int m_totalMessageCount;
    protected ILogger m_log;
    protected boolean m_close = false;
    private ArrayList<IOperationMetadata> m_operationMetadata;
    private AtomicBoolean m_waitingOperationMetadata;
    public String m_query;
    public IInboundMessage m_peekedMessage = null;
    private List<SocketCloseListener> listeners = new ArrayList<SocketCloseListener>();
    private ErrorException m_fatalException = null;

    public InboundMessagesPipeline(int n, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_waitingOperationMetadata = new AtomicBoolean(false);
        this.m_warningListener = iWarningListener;
        this.m_log = iLogger;
        this.m_operationMetadata = new ArrayList();
        this.m_nRowMode = n;
        this.m_currentMessageIndex = 0;
        if (n > 0) {
            this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
            this.m_currentMessagesContainer.setInQueue();
        } else {
            this.m_messageContainers = new ArrayBlockingQueue<InboundMessagesContainer>(1, true);
        }
    }

    protected abstract boolean handleMessage(IInboundMessage var1) throws ErrorException;

    protected boolean getNextMessageOfClass(Class clazz, int n) throws ErrorException {
        boolean bl = false;
        if (n == 0) {
            n = 50;
        } else {
            bl = true;
        }
        while (!this.m_close && (this.m_hasOpenOperation.get() || this.m_currentMessageIndex < this.m_totalMessageCount)) {
            if (null != this.m_peekedMessage || this.validateCurrentContainer()) {
                IInboundMessage iInboundMessage = null;
                if (null != this.m_peekedMessage) {
                    iInboundMessage = this.m_peekedMessage;
                    this.m_peekedMessage = null;
                } else {
                    iInboundMessage = this.m_currentMessagesContainer.next(n);
                }
                if (null != iInboundMessage) {
                    ++this.m_currentMessageIndex;
                    if (!this.handleMessage(iInboundMessage)) {
                        return false;
                    }
                    if (clazz == null || clazz.isInstance(iInboundMessage)) {
                        return true;
                    }
                } else {
                    LogUtilities.logDebug("No message found", this.m_log);
                }
            }
            if (!bl) continue;
            return false;
        }
        return false;
    }

    public IInboundMessage peekNextMessage(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, n);
        if (null != this.m_peekedMessage) {
            return this.m_peekedMessage;
        }
        while (!this.m_close) {
            if (!this.validateCurrentContainer()) continue;
            this.m_peekedMessage = this.m_currentMessagesContainer.next(n);
            if (null != this.m_peekedMessage) {
                return this.m_peekedMessage;
            }
            if (n <= 0) continue;
            return null;
        }
        return null;
    }

    public boolean validateCurrentContainer() {
        if (this.m_nRowMode > 0) {
            return null != this.m_currentMessagesContainer;
        }
        if (null != this.m_currentMessagesContainer && this.m_currentMessagesContainer.hasNext()) {
            return true;
        }
        this.m_currentMessagesContainer = null;
        while (!(this.m_close || null != this.m_currentMessagesContainer || this.m_messageContainers.isEmpty() && this.m_messageContainers.isEmpty() && !this.m_hasOpenOperation.get())) {
            try {
                this.m_currentMessagesContainer = this.m_messageContainers.poll(20L, TimeUnit.MILLISECONDS);
                if (null != this.m_currentMessagesContainer) {
                    return true;
                }
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("InboundMessagePipeline waited", this.m_log);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public void openCurrentOperation() {
        this.m_hasOpenOperation.set(true);
    }

    public void closeCurrentOperation() {
        this.m_hasOpenOperation.set(false);
    }

    public boolean hasOpenOperation() {
        return this.m_hasOpenOperation.get();
    }

    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperationMetadata(IOperationMetadata iOperationMetadata) {
        if (!this.m_operationMetadata.contains(iOperationMetadata)) {
            this.m_operationMetadata.add(iOperationMetadata);
        }
        if (this.m_waitingOperationMetadata.get()) {
            InboundMessagesPipeline inboundMessagesPipeline = this;
            synchronized (inboundMessagesPipeline) {
                this.notify();
            }
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("InboundMessagesPipeline waited", this.m_log);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOperationMetadata getOperationMetadata(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, n, this.m_operationMetadata.size());
        if (n >= this.m_operationMetadata.size()) {
            this.m_waitingOperationMetadata.set(true);
            InboundMessagesPipeline inboundMessagesPipeline = this;
            synchronized (inboundMessagesPipeline) {
                while (n >= this.m_operationMetadata.size() && !this.m_close) {
                    try {
                        this.wait(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.m_waitingOperationMetadata.set(false);
        }
        if (this.m_operationMetadata.size() > n) {
            return this.m_operationMetadata.get(n);
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logError("GetOperationMetadata: index " + n + ", m_operationMetadata.size() = " + this.m_operationMetadata.size() + ", hasOpenOperation=" + this.hasOpenOperation(), this.m_log);
        }
        return null;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_close = true;
        if (null != this.m_currentMessagesContainer) {
            this.m_currentMessagesContainer.close();
            this.m_currentMessagesContainer = null;
        }
        while (this.validateCurrentContainer()) {
            if (null == this.m_currentMessagesContainer) continue;
            this.m_currentMessagesContainer.close();
            this.m_currentMessagesContainer = null;
        }
    }

    public int getOperationMetadataSize() {
        return this.m_operationMetadata.size();
    }

    @Override
    public void addSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.listeners.add(socketCloseListener);
    }

    @Override
    public void removeSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.listeners.remove(socketCloseListener);
    }

    public void close(ErrorException errorException) {
        for (SocketCloseListener socketCloseListener : this.listeners) {
            socketCloseListener.socketClosed(errorException);
        }
        this.m_fatalException = errorException;
        this.close();
    }

    public int getNRowMode() {
        return this.m_nRowMode;
    }

    public void setNRowMode(int n) throws InboundErrorMessage {
        InboundMessagesContainer inboundMessagesContainer;
        this.m_nRowMode = n;
        if (null == this.m_currentMessagesContainer) {
            this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
            this.m_currentMessagesContainer.setInQueue();
        } else {
            inboundMessagesContainer = this.m_currentMessagesContainer;
            this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
            while (inboundMessagesContainer.hasNext()) {
                this.m_currentMessagesContainer.add(inboundMessagesContainer.next(200));
            }
            this.m_currentMessagesContainer.setInQueue();
        }
        if (null != this.m_messageContainers) {
            inboundMessagesContainer = null;
            try {
                inboundMessagesContainer = this.m_messageContainers.poll(200L, TimeUnit.MILLISECONDS);
                while (null != inboundMessagesContainer && inboundMessagesContainer.hasNext()) {
                    this.m_currentMessagesContainer.add(inboundMessagesContainer.next(200));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ErrorException receivedFatalExeption() {
        return this.m_fatalException;
    }
}

