(ns http.core
  (:require [constants.core :as constants]
            [org.httpkit.client :as http-client]
            [clojure.tools.logging :as log]
            [clojure.data.json :as json]))

(defn get-auth
  []
  (let [request {:url "https://perf-sso.tent.trt.csaa.pri/as/token.oauth2"
                 :method :post
                 :headers {"Content-Type" "application/x-www-form-urlencoded"
                           "Authorization" "Basic Y2NfaWV3bXM6ZEJWc2owTVRvREc4S0NJUFdlSzE4aUkzQ1hrWTZER3hDalJ0cktVMUFyZklzS25rYVh4dE15THhMczh0eUNaRg=="}
                 :body "grant_type=client_credentials&scope="
                 :insecure? true}
        response @(http-client/request request)]
    (:access_token (json/read-str (:body response) :key-fn keyword))))

(defn- make-auth-headers
  [headers]
  (merge headers {"Authorization" (str "Bearer " (get-auth)) "X-ApplicationContext" (json/write-str {:application "IEWMS"})}))

(defn get-forward-for
  []
  constants/forwarded-for-ip)

(defn- make-call
  [url body method]
  (let [proxy-url (if (= url constants/search-url) constants/search-port-url constants/soa-base-url)
        headers (if-let [forwarded (get-forward-for)]
                  {"x-proxy-url" proxy-url "Content-Type" "application/json" "x-forwarded-for" forwarded}
                  {"x-proxy-url" proxy-url "Content-Type" "application/json"})
        headers-with-auth (make-auth-headers headers)]
    {:url url
     :body body
     :headers headers-with-auth
     :method method
     :insecure? true}))

(defn http-call
  [url body method]
  (let [options (make-call url body method)
        {:keys [body error]} @(http-client/request options)]
    (if error
      (log/error error)
      body)))







