(ns billing-detail.core
  (:require [clostache.parser :as clostache]
            [constants.core :as constants]
            [soa.core :as soa]
            [clojure.tools.logging :as log]))

(def template "templates/RetrievePolicyBillingSummary.xml")

(def url constants/billing-detail-url)

(defn model-mapper
  [policy model]
  {:policyNumber (:number policy) :billingDetail (:policy (:policyBillingSummary (:billingSummaries (:retrievePolicyBillingSummariesResponse model))))})

(defn billing-detail-model
  [customer]
  (soa/model customer url template model-mapper))





















