(ns cacheing.core
  (:require [taoensso.carmine :as car  :refer (wcar)]
            [environ.core :refer [env]]))

(def redis-conn {:pool {}
                 :spec {:uri (or (env :redis-db) "redis://:fca49a17-6f26-4afe-b853-b7ef53faca3a@10.91.5.4:6379")}})

(def cache-enabled
  (let [cache (or (env :cache-enabled) "false")]
    (not= "false" cache)))

(defn get-cache
  [key]
  (when cache-enabled
    (car/wcar redis-conn (car/get key))))

(defn set-cache
  [key data]
  (when cache-enabled
    (car/wcar redis-conn (car/setex key 1200 data))))
