(ns claims.core
  (:require [soa.core :as soa]
            [clojure.tools.logging :as log]
            [clostache.parser :as template]
            [constants.core :as constants]))

(def template "templates/RetrieveClaimSummaries.xml")

(def url constants/claims-url)

(defn model-mapper
  [policy model]
  {:policyNumber (:number policy) :claims (map :claim (:claims (:retrieveClaimSummariesResponse model)))})

(defn claims-model
  [customer]
  (soa/model customer url template model-mapper))
