(ns billing-history.core
  (:require [clostache.parser :as clostache]
            [soa.core :as soa]
            [constants.core :as constants]
            [clojure.tools.logging :as log]))

(def template "templates/RetrievePolicyBillingHistory.xml")

(def url constants/billing-history-url)

(defn model-mapper
  [policy model]
  {:policyNumber (:number policy) :transactions (map :accountTransaction (:accountTransactions (:retrievePolicyBillingHistoryResponse model)))})

(defn billing-history-model
  [customer]
  (soa/model customer url template model-mapper))















