(ns reporting.segment
  (:require [circleci.analytics-clj.core :refer [track initialize identify] :as circleci]))

(def write-key (or (System/getenv "SEGMENT_WRITE_KEY") "no-key"))
(defn initialize-circleci [] (circleci/initialize write-key))
(def analytics (memoize initialize-circleci))

(defn log
  ([user message]
   (circleci/track (analytics) user message))
  ([user message event-props]
   (circleci/track (analytics) user message event-props)))

(defn identify-user
  ([user]
   (circleci/identify (analytics) user))
  ([user user-props]
   (circleci/identify (analytics) user user-props)))
