(ns identity-middleware.saml-filter
  (:require [wms-customer-info.core :as wms]
            [auth-utils.core :as auth]
            [ring.util.request :as request]
            [mdm-translation.core :as mdm-translate]))

(defn- error-check
  [response]
  (if (and (instance? clojure.lang.IFn response) (contains? response :error))
    nil
    response))

(defn- get-mdm-id-from-saml
  [attrs]
  (if-let [cust-key (first (.get attrs "customerRegistrationID"))]
    (error-check (mdm-translate/custkey->mdm cust-key))))

(defn- get-user-by-saml
  [request saml]
  (let [url (request/request-url request)
        attrs (#'auth/get-saml-attrs saml url)
        mdm-id (get-mdm-id-from-saml attrs)]
    (when mdm-id
      (wms/wms-saml mdm-id attrs))))

(defn- saml-request
  [params request]
  (if-let [saml (:SAMLResponse params)]
    (get-user-by-saml request saml)
    false))
;
;(defn saml-filter
;  [params request]
;  (if-let [user (saml-request params request)]
;    (process-successful-request request user "Filtered user by SAML.")
;    request))
