(ns pcf-utils.core
  (:require [clojure.data.json :as json]))

(defn vcap [] (System/getenv "VCAP_APPLICATION"))
(defn vcsv [] (System/getenv "VCAP_SERVICES"))

(defn bound-services
  []
  (try
    (let [json (json/read-str (vcsv) :key-fn keyword)]
      json)
    (catch Exception e nil)))

(defn app-settings
  []
  (try
    (let [json (json/read-str (vcap) :key-fn keyword)]
      json)
    (catch Exception e nil)))

(defn app-name
  []
  (or (:name (app-settings)) "no-app-name"))

(defn app-id
  []
  (or (:application_id (app-settings)) "no-app-id"))