(ns mdm-translation.core
  (:require [clojure.java.jdbc :as j]
            [clojure.tools.logging :as log]
            [clostache.parser :as template]
            [soa.core :as soa]
            [environ.core :refer [env]]
            [constants.core :as constants]))

(def ^:private sql-db {:dbtype "mssql"
                       :host (or (env :directaccess-db-host) "N01DSW247i.tent.trt.csaa.pri")
                       :port "1433"
                       :dbname (str ";databaseName=" (or (env :directaccess-db-name) "MyPolicy_Dev"))
                       :user "MyPolicy_user"
                       :password (or (env :directaccess-db-password) "$Milion2016")})

(defn- query-direct-access
  [da-id]
  (let [mdm-id (j/query sql-db ["SELECT mdm_id FROM members WHERE da_id = ?" da-id] {:result-set-fn first})]
    (:mdm_id mdm-id)))

(defn customer-soa-error
  "Provides an error response so dev can better trouble shoot issue:\n
  ```{:customerKey custkey :error 'Customer not found from RetrieveCustomerDetails.'
   :envoyUrl <the envoy url>
   :soaUrl 'SOA url where failure occured'}```"
  [custkey]
  (log/error "Failed to find customer from SOA." custkey)
  (log/error (str "SOA URL " constants/customer-url))
  {:customerKey custkey
   :error "Customer not found from RetrieveCustomerDetails."
   :soaUrl constants/customer-url})

(defn custkey->mdm
  "Method that takes customer key calls RCD to return the associated MDM ID."
  [custkey]
  (let [rcd-request (template/render-resource "templates/RetrieveCustomerDetails.xml" {:customer {:id custkey}})
        xml (soa/soa-call constants/customer-url rcd-request)
        xml-doc (soa/parse-xml xml)]
    (if (or (soa/xml-is-fault xml) (nil? xml-doc))
      (customer-soa-error custkey)
      (:enterpriseCustomerID (:enterpriseCustomer (:retrieveCustomerDetailsResponse (soa/keywordize-xml xml-doc)))))))

(defn direct-access->mdm
  "Queries Direct Access DB with given DA-ID and returns MDM ID if found."
  [da-id]
  (query-direct-access da-id))
