(ns identity-middleware.jwt-filter
  (:require [ring.middleware.cookies :as cookies]
            [auth-utils.core :as auth]))

(defn has-auth?
  [request]
  (let [in-header (contains? (:headers request) "x-digital-auth")
        in-cookie (get (:cookies (cookies/cookies-request request)) "x-digital-auth")]
    (or in-header in-cookie)))

(defn get-jwt-from-request
  [request]
  (let [cookies (cookies/cookies-request request)
        cookie-auth (:value (get (:cookies cookies) "x-digital-auth"))
        header-auth (get (:headers request) "x-digital-auth")]
    (or cookie-auth header-auth)))

(defn get-user-by-digital-jwt
  [request]
  (let [attrs (#'auth/get-jwt-attrs (get-jwt-from-request request))]
    (when (:sub attrs) attrs)))