# Digital Services: Connect Framework

[![Clojars Project](https://img.shields.io/clojars/v/csaa-digital/connect-framework.svg)](https://clojars.org/csaa-digital/connect-framework)

This is the Digital Services framework for developing data APIs,
with authentication and security built-in. It is a micro-service architecture and
provides a clean/clear path to all of the SOA services through easy to declare
data keys.

## Videos
[Connect Framework Installation Tutorial](https://vimeo.com/201934877)

## Usage

#### Launch the environment that will host the Authentication server
    $ ./bin/launch-env.sh
    $ ./bin/crash-env.sh # this shuts it down

#### Create a Connect Service
    $ ./bin/create-service.sh

### Environment Variables this framework will use
For every service built using this framework the following environment variables will be used.
- JWT_SECRET `This is the secret used to sign and validate all JWTS`
- ROLLBAR_KEY `This is the key to connect the app to Rollbar (the app specific key, there is no Connect key)`
- SEGMENT_WRITE_KEY `This is the key to connect the app to Segment (the app specific key, there is no Connect key)`
- VCAP_APPLICATION `This is automatically provided through PCF deployments`
    - This particular variable will be used to find the `application-name` and `application-id` of the running app.
- VCAP_SERVICES `This is automatically provided through PCF deployments`
    - This particular variable is used to determine Redis cache connections.

### Runtime Usage (making HTTP calls to Services)

For every request to a Connect Service you will be required to supply a Digital Auth JWT. 

- The JWT can be placed in a Header or a Cookie. 
- The name is always `x-digital-auth`.
- The JWT is required to have a `sub` field describing the context (user/app) making the request.
- The JWT is required to have at least one of the following:
    - An `app` describing the 3rd party app making the request
    - A `user` describing the user making the request
    - Each of these will be required to have an `id` value
    - Each of these can add any extra info to help further describe the request
- If the JWT is missing the Service will return a 401 status.
- If the JWT is improperly formed the Service will return a 401 status.
- The JWT will be checked for a signature from the Connect Framework.
    
The `sub` value will be used by Identity Middleware to identify the request, not necessarily the user or the app making
the request. The `user` and `app` will supply Identity Middleware with the information to identify the specific user/app
for the request.

**Note: `sub` could be the same value as `app.id` and `user.id`. They are separated in the schema to allow for possibly
identifying differences in service calls from the callers perspective.**

The structure of the JWT payload is as follows:

**With an App ID**
```json
{
  "sub": "identity-of-user-or-app",
  "app": {
    "id": "id-of-app-making-the-request"
  }
}
```

**With a User ID**
```json
{
  "sub": "identity-of-user-or-app",
  "user": {
    "id": "id-of-user-making-the-request"
  }
}
```

**Examples to describe difference of `sub` and `user.id` or `app.id`**

Making a call from the front-end Login app:
```json
{
  "sub": "mypolicy-login",
  "user": {
    "id": "{mdm-id}"
  }
}
```

The JWT above tells Identity Middleware that the "subject" of the request is MyPolicy Login, with a user's MDM ID.


Making a call from one Connect Service to another (server-2-server):
```json
{
  "sub": "mypolicy-identity",
  "user": {
    "id": "{mdm-id}"
  }
}
```

The JWT above tells Identity Middleware that the "subject" of the request is MyPolicy Identity Service, with a user's MDM ID. This
leads to an option of passing along `app` and a `user` info.

Making a call from one Connect Service to another (server-2-server):
```json
{
  "sub": "mypolicy-identity",
  "user": {
    "id": "{mdm-id}"
  },
  "app": {
    "id": "mypolicy-identity-server-id"
  }
}
```


**Example Curl requests with Connect JWT:**

```bash
curl -X GET -H "x-digital-auth: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwiYXBwIjp7ImlkIjoiOTg3NjU0MyJ9fQ.Dag6XtIgBILtetyTUsoiIdDx9-7FHPh6BmMDYUi3FK8" \
"http://example.apps.prod.pdc.digital.csaa-insurance.aaa.com/"
```

```bash
curl -X GET -H "Cookie: x-digital-auth=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwiYXBwIjp7ImlkIjoiOTg3NjU0MyJ9fQ.Dag6XtIgBILtetyTUsoiIdDx9-7FHPh6BmMDYUi3FK8;" \
 "http://example.apps.prod.pdc.digital.csaa-insurance.aaa.com/"
```

## Conceptual Architecture
![Conceptual Architecture Diagram](architecture-diagrams/assets/conceptual.png)