(ns http.core
  (:require [constants.core :as constants]
            [org.httpkit.client :as http-client]
            [clojure.tools.logging :as log]
            [clojure.data.json :as json]))

(defn get-auth
  []
  (let [request {:url constants/auth-url
                 :method :post
                 :headers {"Content-Type" "application/x-www-form-urlencoded"
                           "Authorization" (str "Basic " constants/auth-access-token)}
                 :body "grant_type=client_credentials&scope="
                 :insecure? true}
        response @(http-client/request request)]
    (:access_token (json/read-str (:body response) :key-fn keyword))))
; TODO: are we still using this?
(defn get-auth-datapower
  []
  (let [request {:url constants/auth-url-datapower
                 :method :post
                 :headers {"Content-Type" "application/x-www-form-urlencoded"
                           "Authorization" (str "Basic " constants/auth-access-token-datapower)}
                 :body "grant_type=client_credentials&scope="
                 :insecure? true}
        response @(http-client/request request)]
    (:access_token (json/read-str (:body response) :key-fn keyword))))

(defn- make-auth-headers
  [headers]
  (merge headers {"Authorization" (str "Bearer " (get-auth)) "X-ApplicationContext" (json/write-str {:application "IEWMS"})}))

(defn- make-call
  [url body method]
  (let [headers-with-auth (make-auth-headers {"Content-Type" "application/json"})]
    {:url url
     :body body
     :headers headers-with-auth
     :method method
     :insecure? true}))

(defn http-call
  "Abstraction of call to SOA so we can catch errors and log them to better trouble shoot when issues arive. Takes the endpoint, the body and the method for desired call and either returns a valid response or logs the error."
  [url body method]
  (let [options (make-call url body method)
        {:keys [body error]} @(http-client/request options)]
    (log/debug (str "An HTTP call was made for: " options))
    (if error
      (log/error error)
      (do (log/debug (str "The response was: " body)) body))))
